/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.codeInsight.attributes;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.angular2.codeInsight.attributes.Angular2AttributeDescriptor;
import org.angular2.codeInsight.attributes.Angular2AttributeDescriptorsProvider;
import org.angular2.codeInsight.attributes.Angular2AttributesProvider;
import org.angular2.lang.html.parser.Angular2AttributeNameParser;
import org.angular2.lang.html.parser.Angular2AttributeType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2ExtendedKeyEventAttributesProvider
implements Angular2AttributesProvider {
    @NonNls
    private static final String KEYDOWN_EVENT_BASE_PREFIX = "keydown.";
    @NonNls
    private static final String KEYUP_EVENT_BASE_PREFIX = "keyup.";
    private static final String CANONICAL_PREFIX_BASE;
    private static final List<String> KEYDOWN_PREFIXES;
    private static final List<String> KEYUP_PREFIXES;
    private static final List<String> ALL_PREFIXES;
    @NonNls
    private static final List<String> MODIFIER_KEYS;
    @NonNls
    private static final List<String> SPECIAL_KEY_NAMES;
    private static final List<String> STD_KEY_NAMES;

    private static List<String> buildPrefixes(String prefix, boolean includeCanonical) {
        if (includeCanonical) {
            return Arrays.asList("(" + prefix, CANONICAL_PREFIX_BASE + prefix, "on" + prefix, prefix);
        }
        return Arrays.asList("(" + prefix, "on" + prefix, prefix);
    }

    @Override
    public void contributeCompletionResults(@NotNull Angular2AttributesProvider.CompletionResultsConsumer result, @NotNull XmlTag tag, @NotNull String attributeName) {
        if (result == null) {
            Angular2ExtendedKeyEventAttributesProvider.$$$reportNull$$$0(0);
        }
        if (tag == null) {
            Angular2ExtendedKeyEventAttributesProvider.$$$reportNull$$$0(1);
        }
        if (attributeName == null) {
            Angular2ExtendedKeyEventAttributesProvider.$$$reportNull$$$0(2);
        }
        String currentPrefix = (String)ContainerUtil.find(ALL_PREFIXES, attributeName::startsWith);
        if (currentPrefix != null) {
            boolean keydown;
            String itemBase;
            boolean isCanonical = currentPrefix.startsWith(CANONICAL_PREFIX_BASE);
            List keySpec = StringUtil.split((String)attributeName.substring(currentPrefix.length()), (String)".", (boolean)true, (boolean)false);
            if (keySpec.size() > 0) {
                keySpec.remove(keySpec.size() - 1);
            }
            if (!(itemBase = ((keydown = currentPrefix.endsWith(KEYDOWN_EVENT_BASE_PREFIX)) ? KEYDOWN_EVENT_BASE_PREFIX : KEYUP_EVENT_BASE_PREFIX) + StringUtil.join((Collection)keySpec, (String)".")).endsWith(".")) {
                itemBase = itemBase + ".";
            }
            if (!MODIFIER_KEYS.containsAll(keySpec)) {
                return;
            }
            for (String modifier : MODIFIER_KEYS) {
                if (keySpec.contains(modifier)) continue;
                String itemWithModifier = itemBase + modifier + ".";
                if (isCanonical) {
                    result.addAbbreviation(CANONICAL_PREFIX_BASE + itemWithModifier, Angular2AttributeDescriptor.AttributePriority.HIGH, CANONICAL_PREFIX_BASE + itemBase, null);
                    continue;
                }
                result.addAbbreviation(Angular2ExtendedKeyEventAttributesProvider.buildPrefixes(itemWithModifier, false), Angular2AttributeDescriptor.AttributePriority.HIGH, "(" + itemBase, ")");
            }
            XmlAttributeDescriptor descriptor = Angular2ExtendedKeyEventAttributesProvider.getEventDescriptor(tag, keydown);
            for (String keyName : SPECIAL_KEY_NAMES) {
                result.addDescriptor(new Angular2ExtendedKeyEventDescriptor(tag, descriptor, itemBase, keyName, Angular2AttributeDescriptor.AttributePriority.NORMAL, isCanonical));
            }
            for (String keyName : STD_KEY_NAMES) {
                result.addDescriptor(new Angular2ExtendedKeyEventDescriptor(tag, descriptor, itemBase, keyName, Angular2AttributeDescriptor.AttributePriority.LOW, isCanonical));
            }
        } else if (attributeName.startsWith(CANONICAL_PREFIX_BASE)) {
            result.addAbbreviation(CANONICAL_PREFIX_BASE + KEYDOWN_EVENT_BASE_PREFIX, Angular2AttributeDescriptor.AttributePriority.LOW, CANONICAL_PREFIX_BASE, null);
            result.addAbbreviation(CANONICAL_PREFIX_BASE + KEYUP_EVENT_BASE_PREFIX, Angular2AttributeDescriptor.AttributePriority.LOW, CANONICAL_PREFIX_BASE, null);
        } else {
            result.addAbbreviation(KEYDOWN_PREFIXES, Angular2AttributeDescriptor.AttributePriority.LOW, null, ")");
            result.addAbbreviation(KEYUP_PREFIXES, Angular2AttributeDescriptor.AttributePriority.LOW, null, ")");
        }
    }

    @Override
    @Nullable
    public Angular2AttributeDescriptor getDescriptor(@NotNull XmlTag tag, @NotNull String attributeName, @NotNull Angular2AttributeNameParser.AttributeInfo info) {
        if (tag == null) {
            Angular2ExtendedKeyEventAttributesProvider.$$$reportNull$$$0(3);
        }
        if (attributeName == null) {
            Angular2ExtendedKeyEventAttributesProvider.$$$reportNull$$$0(4);
        }
        if (info == null) {
            Angular2ExtendedKeyEventAttributesProvider.$$$reportNull$$$0(5);
        }
        if (info.type == Angular2AttributeType.EVENT && (info.name.startsWith(KEYDOWN_EVENT_BASE_PREFIX) || info.name.startsWith(KEYUP_EVENT_BASE_PREFIX))) {
            return new Angular2ExtendedKeyEventDescriptor(tag, Angular2ExtendedKeyEventAttributesProvider.getEventDescriptor(tag, info.name.startsWith(KEYDOWN_EVENT_BASE_PREFIX)), null, info.name, Angular2AttributeDescriptor.AttributePriority.NORMAL, info.isCanonical);
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<String> getRelatedAttributes(@NotNull XmlAttributeDescriptor descriptor) {
        if (descriptor == null) {
            Angular2ExtendedKeyEventAttributesProvider.$$$reportNull$$$0(6);
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            Angular2ExtendedKeyEventAttributesProvider.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static XmlAttributeDescriptor getEventDescriptor(@NotNull XmlTag tag, boolean keydown) {
        if (tag == null) {
            Angular2ExtendedKeyEventAttributesProvider.$$$reportNull$$$0(8);
        }
        String attrName = "on" + StringUtil.trimEnd((String)(keydown ? KEYDOWN_EVENT_BASE_PREFIX : KEYUP_EVENT_BASE_PREFIX), (char)'.');
        return (XmlAttributeDescriptor)ContainerUtil.find((Object[])Angular2AttributeDescriptorsProvider.getDefaultAttributeDescriptors(tag), attr -> attrName.equalsIgnoreCase(attr.getName()));
    }

    static {
        char ch;
        CANONICAL_PREFIX_BASE = Angular2AttributeType.EVENT.getCanonicalPrefix();
        KEYDOWN_PREFIXES = Angular2ExtendedKeyEventAttributesProvider.buildPrefixes(KEYDOWN_EVENT_BASE_PREFIX, false);
        KEYUP_PREFIXES = Angular2ExtendedKeyEventAttributesProvider.buildPrefixes(KEYUP_EVENT_BASE_PREFIX, false);
        ALL_PREFIXES = ContainerUtil.concat(Angular2ExtendedKeyEventAttributesProvider.buildPrefixes(KEYDOWN_EVENT_BASE_PREFIX, true), Angular2ExtendedKeyEventAttributesProvider.buildPrefixes(KEYUP_EVENT_BASE_PREFIX, true));
        MODIFIER_KEYS = ContainerUtil.newArrayList((Object[])new String[]{"alt", "control", "meta", "shift"});
        SPECIAL_KEY_NAMES = ContainerUtil.newArrayList((Object[])new String[]{"space", "dot", "escape", "enter", "tab", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "end", "home", "pageDown", "pageUp", "backspace", "delete", "insert", "contextMenu", "help", "printScreen"});
        STD_KEY_NAMES = new ArrayList<String>();
        for (int i = 1; i <= 20; ++i) {
            SPECIAL_KEY_NAMES.add("f" + i);
        }
        for (ch = 'a'; ch <= 'z'; ch = (char)(ch + '\u0001')) {
            STD_KEY_NAMES.add(Character.toString(ch));
        }
        for (ch = '0'; ch <= '9'; ch = (char)(ch + '\u0001')) {
            STD_KEY_NAMES.add(Character.toString(ch));
        }
        for (char ch2 : "`~!@#$%^&*()_+-[]{}|;:,?".toCharArray()) {
            STD_KEY_NAMES.add(Character.toString(ch2));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/codeInsight/attributes/Angular2ExtendedKeyEventAttributesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/codeInsight/attributes/Angular2ExtendedKeyEventAttributesProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "contributeCompletionResults";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedAttributes";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getEventDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Angular2ExtendedKeyEventDescriptor
    extends Angular2AttributeDescriptor {
        private final String myBaseName;

        protected Angular2ExtendedKeyEventDescriptor(@NotNull XmlTag xmlTag, @Nullable XmlAttributeDescriptor originalDescriptor, @Nullable String baseName, @NotNull String keyName, @NotNull Angular2AttributeDescriptor.AttributePriority priority, boolean canonical) {
            if (xmlTag == null) {
                Angular2ExtendedKeyEventDescriptor.$$$reportNull$$$0(0);
            }
            if (keyName == null) {
                Angular2ExtendedKeyEventDescriptor.$$$reportNull$$$0(1);
            }
            if (priority == null) {
                Angular2ExtendedKeyEventDescriptor.$$$reportNull$$$0(2);
            }
            super(xmlTag, Objects.requireNonNull(Angular2AttributeType.EVENT.buildName(StringUtil.notNullize((String)baseName) + keyName, canonical)), priority, originalDescriptor == null ? Collections.emptySet() : originalDescriptor.getDeclarations(), true);
            this.myBaseName = baseName;
        }

        @Override
        protected Angular2AttributeDescriptor.LookupElementInfo buildElementInfo(@NotNull PrefixMatcher prefixMatcher) {
            if (prefixMatcher == null) {
                Angular2ExtendedKeyEventDescriptor.$$$reportNull$$$0(3);
            }
            if (this.myBaseName != null) {
                return new Angular2AttributeDescriptor.LookupElementInfo(this.getName(), Arrays.asList(Pair.pair((Object)(CANONICAL_PREFIX_BASE + this.myBaseName), (Object)""), Pair.pair((Object)("(" + this.myBaseName), (Object)")")), null);
            }
            return super.buildElementInfo(prefixMatcher);
        }

        @Override
        public XmlAttributeDescriptor cloneWithName(String attributeName) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected boolean shouldInsertHandlerRemoveLeftover() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "xmlTag";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "priority";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefixMatcher";
                    break;
                }
            }
            objectArray2[1] = "org/angular2/codeInsight/attributes/Angular2ExtendedKeyEventAttributesProvider$Angular2ExtendedKeyEventDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildElementInfo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

