/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteDriver;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.database.remote.jdbc.impl.SerializableDriverPropertyInfo;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteDriverImpl
extends JdbcRemoteObject
implements RemoteDriver {
    private final Driver myDelegate;

    protected RemoteDriverImpl(Driver delegate) {
        this.myDelegate = delegate;
    }

    public static RemoteDriverImpl wrap(Driver delegate) {
        return delegate == null ? null : new RemoteDriverImpl(delegate);
    }

    public String getCastToClassName() {
        return Driver.class.getName();
    }

    @Override
    public RemoteConnection connect(String p1, @Nullable Properties p2, @NotNull Map<String, Serializable> extra) throws RemoteException, SQLException {
        if (extra == null) {
            RemoteDriverImpl.$$$reportNull$$$0(0);
        }
        try {
            JdbcHelperImpl connectHelper;
            Connection connection;
            if (p2 == null) {
                p2 = new Properties();
            }
            if ((connection = (connectHelper = JdbcNativeUtil.detect(this.myDelegate, p1)).connect(this.myDelegate, p1, p2, extra)) == null) {
                return null;
            }
            if (connection.isClosed()) {
                throw new SQLException("Connection is closed");
            }
            JdbcHelperImpl helper = JdbcNativeUtil.detect(connection);
            return (RemoteConnection)((Object)this.export((Remote)((Object)helper.wrap(connection))));
        }
        catch (Exception e) {
            this.rethrowException(e);
            throw new AssertionError();
        }
    }

    @Override
    public String getConnectHelperClass(String url) throws RemoteException {
        return JdbcNativeUtil.detect(this.myDelegate, url).getClass().getName();
    }

    @Override
    public boolean acceptsURL(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.acceptsURL(p1);
        }
        catch (Exception e) {
            this.rethrowException(e);
            throw new AssertionError();
        }
    }

    @Override
    public int getMajorVersion() throws RemoteException {
        try {
            return this.myDelegate.getMajorVersion();
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    @Override
    public int getMinorVersion() throws RemoteException {
        try {
            return this.myDelegate.getMinorVersion();
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String p1, Properties p2) throws RemoteException, SQLException {
        try {
            DriverPropertyInfo[] value;
            try {
                value = this.myDelegate.getPropertyInfo(p1, p2);
            }
            catch (RuntimeException e) {
                JdbcNativeUtil.logWarn(null, e);
                value = null;
            }
            DriverPropertyInfo[] result = new DriverPropertyInfo[value == null ? 0 : value.length];
            for (int i = 0; i < result.length; ++i) {
                DriverPropertyInfo p = value[i];
                result[i] = p == null ? new SerializableDriverPropertyInfo() : new SerializableDriverPropertyInfo(p);
            }
            return result;
        }
        catch (Exception e) {
            this.rethrowException(e);
            throw new AssertionError();
        }
    }

    @Override
    public boolean jdbcCompliant() throws RemoteException {
        try {
            return this.myDelegate.jdbcCompliant();
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public void unreferenced() {
        System.exit(0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extra", "com/intellij/database/remote/jdbc/impl/RemoteDriverImpl", "connect"));
    }
}

