/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.database.remote.dbimport.CommitOnExecuteStatement;
import com.intellij.database.remote.dbimport.DefaultBatchPreparedStatement;
import com.intellij.database.remote.jdba.RemoteFacade;
import com.intellij.database.remote.jdba.impl.RemoteFacadeImpl;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdbc.RemoteBatchPreparedStatement;
import com.intellij.database.remote.jdbc.RemoteCallableStatement;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteSavepoint;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObjectWithHelper;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.database.remote.jdbc.impl.RemoteBatchPreparedStatementImpl;
import com.intellij.database.remote.jdbc.impl.RemoteCallableStatementImpl;
import com.intellij.database.remote.jdbc.impl.RemoteDatabaseMetaDataImpl;
import com.intellij.database.remote.jdbc.impl.RemotePreparedStatementImpl;
import com.intellij.database.remote.jdbc.impl.RemoteSavepointImpl;
import com.intellij.database.remote.jdbc.impl.RemoteStatementImpl;
import com.intellij.database.remote.jdbc.impl.SingleConnectionDataSource;
import com.intellij.execution.rmi.RemoteObject;
import com.intellij.util.ArrayUtilRt;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class RemoteConnectionImpl
extends JdbcRemoteObjectWithHelper<Connection>
implements RemoteConnection {
    private final AtomicInteger myNextSavepointId = new AtomicInteger();
    private final Map<Integer, WeakReference<Savepoint>> myIdToSavepoint = new ConcurrentHashMap<Integer, WeakReference<Savepoint>>();

    public RemoteConnectionImpl(Connection delegate, JdbcHelperImpl helper) {
        super(delegate, helper == null ? JdbcNativeUtil.detect(delegate) : helper);
    }

    @Override
    public RemoteFacade jpdaFacade() throws RemoteException {
        Connection persistentStateProxy = (Connection)Proxy.newProxyInstance(RemoteConnectionImpl.class.getClassLoader(), new Class[]{Connection.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
                String name = method.getName();
                try {
                    return "setAutoCommit".equals(name) || "commit".equals(name) || "rollback".equals(name) ? null : ("equals".equals(name) && objects != null && objects.length == 1 ? Boolean.valueOf(o == objects[0]) : ("hashCode".equals(name) ? Integer.valueOf(this.hashCode()) : method.invoke(RemoteConnectionImpl.this.myDelegate, objects)));
                }
                catch (InvocationTargetException e) {
                    Throwable target = e.getTargetException();
                    throw target == null ? e : target;
                }
            }
        });
        JdbcIntermediateFacade facade = RemoteConnectionImpl.createFacade(this.myHelper, persistentStateProxy);
        return (RemoteFacade)((Object)this.export((Remote)((Object)new RemoteFacadeImpl(facade, this.myHelper))));
    }

    @NotNull
    public static JdbcIntermediateFacade createFacade(JdbcHelper helper, Connection connection) {
        SingleConnectionDataSource ds = new SingleConnectionDataSource(connection);
        JdbcIntermediateFacade jdbcIntermediateFacade = helper.createFacade(ds);
        if (jdbcIntermediateFacade == null) {
            RemoteConnectionImpl.$$$reportNull$$$0(0);
        }
        return jdbcIntermediateFacade;
    }

    @Override
    public void cancelAll() throws RemoteException {
        for (RemoteObject child : this.getExportedChildren()) {
            if (!(child instanceof RemoteStatement)) continue;
            try {
                ((RemoteStatement)child).cancel();
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public String getDetectedDbmsName() throws RemoteException {
        return this.myHelper.getDbmsName();
    }

    @Override
    public String getDetectedDbmsVersion() throws RemoteException {
        return this.myHelper.getVersion();
    }

    @Override
    public String getDriverVersion() throws RemoteException {
        return this.myHelper.getDriverVersion();
    }

    public String getCastToClassName() {
        return Connection.class.getName();
    }

    @Override
    public void setReadOnly(boolean p1) throws RemoteException, SQLException {
        try {
            ((Connection)this.myDelegate).setReadOnly(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean isReadOnly() throws RemoteException, SQLException {
        try {
            return ((Connection)this.myDelegate).isReadOnly();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void close() throws RemoteException, SQLException {
        try {
            this.unexportChildren();
            ((Connection)this.myDelegate).close();
            this.unreferenced();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean isClosed() throws RemoteException, SQLException {
        try {
            return ((Connection)this.myDelegate).isClosed();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean isValid(int timeout) throws RemoteException, SQLException {
        try {
            return ((Connection)this.myDelegate).isValid(timeout);
        }
        catch (Throwable e) {
            return !((Connection)this.myDelegate).isClosed();
        }
    }

    @Override
    public SQLWarning getWarnings() throws RemoteException, SQLException {
        try {
            return this.wrapSqlWarning(((Connection)this.myDelegate).getWarnings());
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public List<SQLWarning> getAllWarnings() throws RemoteException, SQLException {
        try {
            List<SQLWarning> warnings = this.getAllWarnings(((Connection)this.myDelegate).getWarnings());
            ((Connection)this.myDelegate).clearWarnings();
            return warnings;
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void commit() throws RemoteException, SQLException {
        try {
            ((Connection)this.myDelegate).commit();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void clearWarnings() throws RemoteException, SQLException {
        try {
            ((Connection)this.myDelegate).clearWarnings();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteDatabaseMetaData getMetaData() throws RemoteException, SQLException {
        try {
            return (RemoteDatabaseMetaData)((Object)this.export((Remote)((Object)RemoteDatabaseMetaDataImpl.wrap(((Connection)this.myDelegate).getMetaData(), this.myHelper))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteStatement createStatement(int p1, int p2, int p3) throws RemoteException, SQLException {
        try {
            return (RemoteStatement)((Object)this.export((Remote)((Object)RemoteStatementImpl.wrap(((Connection)this.myDelegate).createStatement(p1, p2, p3), this.myHelper))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteStatement createStatement(int p1, int p2) throws RemoteException, SQLException {
        try {
            return (RemoteStatement)((Object)this.export((Remote)((Object)RemoteStatementImpl.wrap(((Connection)this.myDelegate).createStatement(p1, p2), this.myHelper))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteStatement createStatement() throws RemoteException, SQLException {
        try {
            return (RemoteStatement)((Object)this.export((Remote)((Object)RemoteStatementImpl.wrap(((Connection)this.myDelegate).createStatement(), this.myHelper))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean getAutoCommit() throws RemoteException, SQLException {
        try {
            return this.myHelper.getAutoCommit((Connection)this.myDelegate);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public String getCatalog() throws RemoteException, SQLException {
        try {
            return ((Connection)this.myDelegate).getCatalog();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public int getHoldability() throws RemoteException, SQLException {
        try {
            return ((Connection)this.myDelegate).getHoldability();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public String getSchema() throws RemoteException, SQLException {
        try {
            return (String)ReflectionHelper.tryInvokeMethod(this.myDelegate, "getSchema", ArrayUtilRt.EMPTY_CLASS_ARRAY, ArrayUtilRt.EMPTY_OBJECT_ARRAY);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public int getTransactionIsolation() throws RemoteException, SQLException {
        try {
            return ((Connection)this.myDelegate).getTransactionIsolation();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Map getTypeMap() throws RemoteException, SQLException {
        try {
            return ((Connection)this.myDelegate).getTypeMap();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public String nativeSQL(String p1) throws RemoteException, SQLException {
        try {
            return ((Connection)this.myDelegate).nativeSQL(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteCallableStatement prepareCall(String p1, int p2, int p3, int p4) throws RemoteException, SQLException {
        try {
            return (RemoteCallableStatement)((Object)this.export((Remote)((Object)RemoteCallableStatementImpl.wrap(((Connection)this.myDelegate).prepareCall(p1, p2, p3, p4), this.myHelper))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteCallableStatement prepareCall(String p1, int p2, int p3) throws RemoteException, SQLException {
        try {
            return (RemoteCallableStatement)((Object)this.export((Remote)((Object)RemoteCallableStatementImpl.wrap(((Connection)this.myDelegate).prepareCall(p1, p2, p3), this.myHelper))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteCallableStatement prepareCall(String p1) throws RemoteException, SQLException {
        try {
            return (RemoteCallableStatement)((Object)this.export((Remote)((Object)RemoteCallableStatementImpl.wrap(((Connection)this.myDelegate).prepareCall(p1), this.myHelper))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemotePreparedStatement prepareStatement(String p1, int p2) throws RemoteException, SQLException {
        try {
            return (RemotePreparedStatement)((Object)this.export((Remote)((Object)RemotePreparedStatementImpl.wrap(((Connection)this.myDelegate).prepareStatement(p1, p2), this.myHelper))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemotePreparedStatement prepareStatement(String p1, int[] p2) throws RemoteException, SQLException {
        try {
            return (RemotePreparedStatement)((Object)this.export((Remote)((Object)RemotePreparedStatementImpl.wrap(((Connection)this.myDelegate).prepareStatement(p1, p2), this.myHelper))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemotePreparedStatement prepareStatement(String p1) throws RemoteException, SQLException {
        try {
            return (RemotePreparedStatement)((Object)this.export((Remote)((Object)RemotePreparedStatementImpl.wrap(((Connection)this.myDelegate).prepareStatement(p1), this.myHelper))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemotePreparedStatement prepareStatement(String p1, int p2, int p3, int p4) throws RemoteException, SQLException {
        try {
            return (RemotePreparedStatement)((Object)this.export((Remote)((Object)RemotePreparedStatementImpl.wrap(((Connection)this.myDelegate).prepareStatement(p1, p2, p3, p4), this.myHelper))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemotePreparedStatement prepareStatement(String p1, int p2, int p3) throws RemoteException, SQLException {
        try {
            return (RemotePreparedStatement)((Object)this.export((Remote)((Object)RemotePreparedStatementImpl.wrap(((Connection)this.myDelegate).prepareStatement(p1, p2, p3), this.myHelper))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemotePreparedStatement prepareStatement(String p1, String[] p2) throws RemoteException, SQLException {
        try {
            return (RemotePreparedStatement)((Object)this.export((Remote)((Object)RemotePreparedStatementImpl.wrap(((Connection)this.myDelegate).prepareStatement(p1, p2), this.myHelper))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteBatchPreparedStatement prepareBatchStatement(RemoteBatchPreparedStatementImpl.Configuration configuration) throws RemoteException, SQLException {
        try {
            PreparedStatement delegate = ((Connection)this.myDelegate).prepareStatement(configuration.sql);
            PreparedStatement oneLineDelegate = ((Connection)this.myDelegate).prepareStatement(configuration.oneLineSql);
            RemoteBatchPreparedStatementImpl statement = this.getStatement(configuration, delegate, oneLineDelegate);
            return (RemoteBatchPreparedStatement)((Object)this.export((Remote)((Object)statement)));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @NotNull
    private RemoteBatchPreparedStatementImpl getStatement(@NotNull RemoteBatchPreparedStatementImpl.Configuration configuration, @NotNull PreparedStatement delegate, @NotNull PreparedStatement oneLineDelegate) {
        if (configuration == null) {
            RemoteConnectionImpl.$$$reportNull$$$0(1);
        }
        if (delegate == null) {
            RemoteConnectionImpl.$$$reportNull$$$0(2);
        }
        if (oneLineDelegate == null) {
            RemoteConnectionImpl.$$$reportNull$$$0(3);
        }
        return configuration.useSavepoints ? new DefaultBatchPreparedStatement(configuration, delegate, oneLineDelegate, (Connection)this.myDelegate, this.myHelper) : new CommitOnExecuteStatement(configuration, delegate, oneLineDelegate, (Connection)this.myDelegate, this.myHelper);
    }

    @Override
    public void releaseSavepoint(RemoteSavepoint p1) throws RemoteException, SQLException {
        try {
            ((Connection)this.myDelegate).releaseSavepoint(this.getOriginalSavepoint(p1));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void rollback() throws RemoteException, SQLException {
        try {
            ((Connection)this.myDelegate).rollback();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void rollback(RemoteSavepoint p1) throws RemoteException, SQLException {
        try {
            ((Connection)this.myDelegate).rollback(this.getOriginalSavepoint(p1));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void setAutoCommit(boolean p1) throws RemoteException, SQLException {
        try {
            ((Connection)this.myDelegate).setAutoCommit(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void setCatalog(String p1) throws RemoteException, SQLException {
        try {
            ((Connection)this.myDelegate).setCatalog(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void setHoldability(int p1) throws RemoteException, SQLException {
        try {
            ((Connection)this.myDelegate).setHoldability(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void setSchema(String p1) throws RemoteException, SQLException {
        try {
            ReflectionHelper.tryInvokeMethod(this.myDelegate, "setSchema", new Class[]{String.class}, new Object[]{p1});
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteSavepoint setSavepoint() throws RemoteException, SQLException {
        try {
            return (RemoteSavepoint)((Object)this.export((Remote)((Object)this.wrapSavepoint(((Connection)this.myDelegate).setSavepoint()))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteSavepoint setSavepoint(String p1) throws RemoteException, SQLException {
        try {
            return (RemoteSavepoint)((Object)this.export((Remote)((Object)this.wrapSavepoint(((Connection)this.myDelegate).setSavepoint(p1)))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void setTransactionIsolation(int p1) throws RemoteException, SQLException {
        try {
            ((Connection)this.myDelegate).setTransactionIsolation(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> p1) throws RemoteException, SQLException {
        try {
            ((Connection)this.myDelegate).setTypeMap(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws RemoteException, SQLException {
        try {
            ((Connection)this.myDelegate).setClientInfo(name, value);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public String getClientInfo(String name) throws RemoteException, SQLException {
        try {
            return ((Connection)this.myDelegate).getClientInfo(name);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public String getHelperClass() throws RemoteException {
        return this.myHelper.getClass().getName();
    }

    private Savepoint getOriginalSavepoint(RemoteSavepoint remoteSavepoint) throws RemoteException {
        WeakReference<Savepoint> reference = this.myIdToSavepoint.get(remoteSavepoint.getRemoteSavepointId());
        return reference != null ? (Savepoint)reference.get() : null;
    }

    private RemoteSavepoint wrapSavepoint(Savepoint savepoint) {
        int remoteSavepointId = this.myNextSavepointId.getAndIncrement();
        RemoteSavepointImpl wrapped = RemoteSavepointImpl.wrap(savepoint, remoteSavepointId);
        this.myIdToSavepoint.put(remoteSavepointId, new WeakReference<Savepoint>(savepoint));
        return wrapped;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/impl/RemoteConnectionImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oneLineDelegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createFacade";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/impl/RemoteConnectionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

