/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Service;

public abstract class Providers {
    @NotNull
    public static <P> P loadProvider(@NotNull Class<P> providerClass) throws NoSuchProviderException {
        Iterator providersIterator;
        if (providerClass == null) {
            Providers.$$$reportNull$$$0(0);
        }
        if (!(providersIterator = Service.providers(providerClass)).hasNext()) {
            throw new NoSuchProviderException("A provider named " + providerClass.getName() + " not found.");
        }
        Object provider = providersIterator.next();
        if (providerClass.isAssignableFrom(provider.getClass())) {
            Object e = provider;
            if (e == null) {
                Providers.$$$reportNull$$$0(1);
            }
            return (P)e;
        }
        String msg = String.format("The provider named %s is an instance of %s (not the requested class)", providerClass.getName(), provider.getClass().getName());
        throw new NoSuchProviderException(msg);
    }

    public static <P> Collection<P> loadAllProviders(@NotNull Class<P> serviceClass, @Nullable ClassLoader classLoader) {
        if (serviceClass == null) {
            Providers.$$$reportNull$$$0(2);
        }
        ClassLoader theClassLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
        Iterator providersIterator = Service.providers(serviceClass, (ClassLoader)theClassLoader);
        LinkedList providers = new LinkedList();
        while (providersIterator.hasNext()) {
            Object p = providersIterator.next();
            if (!serviceClass.isAssignableFrom(p.getClass())) continue;
            providers.add(p);
        }
        return providers;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/util/Providers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/util/Providers";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadProvider";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadAllProviders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NoSuchProviderException
    extends RuntimeException {
        private NoSuchProviderException(String message) {
            super(message);
        }
    }
}

