/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.ConditionalUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSplitElseIfIntention
extends JSIntention {
    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new SplitElseIfPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSSplitElseIfIntention.$$$reportNull$$$0(0);
        }
        JSIfStatement parentStatement = (JSIfStatement)element.getParent();
        assert (parentStatement != null);
        JSStatement elseBranch = parentStatement.getElse();
        String newStatement = '{' + elseBranch.getText() + '}';
        JSRefactoringUtil.replaceStatementAndReformat((JSStatement)elseBranch, (String)newStatement);
    }

    @Override
    protected boolean stopTraversingUp(@Nullable PsiElement element) {
        return super.stopTraversingUp(element) || element instanceof JSExpression && !ConditionalUtils.isInIfCondition((JSExpression)element);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSSplitElseIfIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JSSplitElseIfIntention.$$$reportNull$$$0(2);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        JSIfStatement parentIf = (JSIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSIfStatement.class);
        return parentIf == null || !PsiTreeUtil.isAncestor((PsiElement)parentIf.getElse(), (PsiElement)element, (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/intellij/idea/lang/javascript/intention/trivialif/JSSplitElseIfIntention";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processIntention";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SplitElseIfPredicate
    implements JSElementPredicate {
        private SplitElseIfPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            PsiElement parent;
            if (element == null) {
                SplitElseIfPredicate.$$$reportNull$$$0(0);
            }
            if (!((parent = element.getParent()) instanceof JSIfStatement)) {
                return false;
            }
            JSIfStatement ifStatement = (JSIfStatement)parent;
            if (PsiUtilCore.hasErrorElementChild((PsiElement)ifStatement)) {
                return false;
            }
            JSStatement thenBranch = ifStatement.getThen();
            JSStatement elseBranch = ifStatement.getElse();
            return thenBranch != null && elseBranch instanceof JSIfStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSSplitElseIfIntention$SplitElseIfPredicate", "satisfiedBy"));
        }
    }
}

