/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.braces;

import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.Set;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.psiutil.ConditionalUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRemoveBracesIntention
extends JSMutablyNamedIntention {
    @NonNls
    private static final String IF_KEYWORD = "if";
    @NonNls
    private static final String ELSE_KEYWORD = "else";

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        return new RemoveBracesPredicate();
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        String keyword;
        JSElement parent = (JSElement)element.getParent();
        assert (parent != null);
        if (parent instanceof JSIfStatement) {
            JSIfStatement ifStatement = (JSIfStatement)parent;
            JSStatement elseBranch = ifStatement.getElse();
            keyword = element.equals(elseBranch) ? ELSE_KEYWORD : IF_KEYWORD;
        } else {
            PsiElement keywordChild = parent.getFirstChild();
            assert (keywordChild != null);
            keyword = keywordChild.getText();
        }
        return this.getText(keyword);
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSRemoveBracesIntention.$$$reportNull$$$0(0);
        }
        JSBlockStatement blockStatement = (JSBlockStatement)element;
        JSSourceElement[] statements = blockStatement.getStatementListItems();
        JSSourceElement statement = statements[0];
        Set<PsiElement> blockParent = Collections.singleton(blockStatement.getParent());
        new CommentsMover(statement).move(blockParent, blockParent);
        JSRefactoringUtil.replaceStatementAndReformat((JSStatement)blockStatement, (String)statement.getText());
    }

    @Override
    protected boolean stopTraversingUp(@Nullable PsiElement element) {
        return super.stopTraversingUp(element) || element instanceof JSExpression && !ConditionalUtils.isInIfCondition((JSExpression)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/braces/JSRemoveBracesIntention", "processIntention"));
    }

    public static class RemoveBracesPredicate
    implements JSElementPredicate {
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                RemoveBracesPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSBlockStatement)) {
                return false;
            }
            JSBlockStatement blockStatement = (JSBlockStatement)element;
            PsiElement parent = blockStatement.getParent();
            if (!(parent instanceof JSIfStatement) && !(parent instanceof JSLoopStatement)) {
                return false;
            }
            JSSourceElement[] statements = blockStatement.getStatementListItems();
            return statements.length == 1 && statements[0] instanceof JSStatement && !(statements[0] instanceof JSVarStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/braces/JSRemoveBracesIntention$RemoveBracesPredicate", "satisfiedBy"));
        }
    }
}

