/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.utils;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRegexpAwareRule;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.WhiteListGroupContextData;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.EnumWhiteListRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RegexpWhiteListRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.UtilExpressionWhiteListRule;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhiteListSimpleRuleFactory {
    private static final String RULE_PREFIX = "rule:";
    private static final String ENUM_PREFIX = "enum:";
    private static final String REGEXP_PREFIX = "regexp:";
    private static final String ENUM_REF_PREFIX = "enum#";
    private static final String REGEXP_REF_PREFIX = "regexp#";
    private static final String UTIL_PREFIX = "util#";
    private static final String ENUM_SEPARATOR = "|";
    private static final String START = "{";
    private static final String END = "}";
    private static final FUSRule UNPARSED_EXPRESSION = (s, c) -> ValidationResultType.INCORRECT_RULE;

    @NotNull
    public static FUSRule createRule(@NotNull String rule) {
        if (rule == null) {
            WhiteListSimpleRuleFactory.$$$reportNull$$$0(0);
        }
        return WhiteListSimpleRuleFactory.createRule(rule, WhiteListGroupContextData.EMPTY);
    }

    @NotNull
    public static FUSRule createRule(@NotNull String rule, @NotNull WhiteListGroupContextData contextData) {
        FUSRule wlr;
        if (rule == null) {
            WhiteListSimpleRuleFactory.$$$reportNull$$$0(1);
        }
        if (contextData == null) {
            WhiteListSimpleRuleFactory.$$$reportNull$$$0(2);
        }
        return (wlr = WhiteListSimpleRuleFactory.createSimpleRule(rule.trim(), contextData)) != null ? wlr : WhiteListSimpleRuleFactory.createExpressionRule(rule.trim(), contextData);
    }

    @Nullable
    private static FUSRule createSimpleRule(@NotNull String rule, @NotNull WhiteListGroupContextData contextData) {
        if (rule == null) {
            WhiteListSimpleRuleFactory.$$$reportNull$$$0(3);
        }
        if (contextData == null) {
            WhiteListSimpleRuleFactory.$$$reportNull$$$0(4);
        }
        return WhiteListSimpleRuleFactory.createSimpleRule(rule, Pair.create((Object)RULE_PREFIX, s -> WhiteListSimpleRuleFactory.getBooleanRule(s)), Pair.create((Object)UTIL_PREFIX, s -> WhiteListSimpleRuleFactory.getCustomUtilRule(s)), Pair.create((Object)ENUM_PREFIX, s -> new EnumWhiteListRule(StringUtil.split((String)s, (String)ENUM_SEPARATOR, (boolean)true, (boolean)false))), Pair.create((Object)ENUM_REF_PREFIX, s -> new EnumWhiteListRule(contextData.getEnum((String)s))), Pair.create((Object)REGEXP_PREFIX, s -> new RegexpWhiteListRule((String)s)), Pair.create((Object)REGEXP_REF_PREFIX, s -> new RegexpWhiteListRule(contextData.getRegexp((String)s))));
    }

    @Nullable
    private static CustomWhiteListRule getCustomUtilRule(String s) {
        for (CustomWhiteListRule extension : (CustomWhiteListRule[])CustomWhiteListRule.EP_NAME.getExtensions()) {
            if (!WhiteListSimpleRuleFactory.isDevelopedByJetBrains(extension) || !extension.acceptRuleId(s)) continue;
            return extension;
        }
        return null;
    }

    private static boolean isDevelopedByJetBrains(CustomWhiteListRule extension) {
        return ApplicationManager.getApplication().isUnitTestMode() || PluginInfoDetectorKt.getPluginInfo(extension.getClass()).isDevelopedByJetBrains();
    }

    @Nullable
    private static FUSRule getBooleanRule(@Nullable String value) {
        if ("TRUE".equals(value)) {
            return FUSRule.TRUE;
        }
        if ("FALSE".equals(value)) {
            return FUSRule.FALSE;
        }
        return null;
    }

    @Nullable
    private static FUSRule createSimpleRule(@NotNull String rule, Pair<String, Function<String, FUSRule>> ... rules) {
        if (rule == null) {
            WhiteListSimpleRuleFactory.$$$reportNull$$$0(5);
        }
        for (Pair<String, Function<String, FUSRule>> pair : rules) {
            String value;
            if (!rule.startsWith((String)pair.first) || !StringUtil.isNotEmpty((String)(value = rule.substring(((String)pair.first).length())))) continue;
            return (FUSRule)((Function)pair.second).fun((Object)value);
        }
        return null;
    }

    @NotNull
    private static FUSRule createExpressionRule(@NotNull String rule, @NotNull WhiteListGroupContextData contextData) {
        FUSRule simpleRule;
        String n;
        List<String> nodes;
        if (rule == null) {
            WhiteListSimpleRuleFactory.$$$reportNull$$$0(6);
        }
        if (contextData == null) {
            WhiteListSimpleRuleFactory.$$$reportNull$$$0(7);
        }
        if ((nodes = WhiteListSimpleRuleFactory.parseSimpleExpression(rule)).size() == 1 && (n = nodes.get(0)).contains(START) && (simpleRule = WhiteListSimpleRuleFactory.createSimpleRule(WhiteListSimpleRuleFactory.unwrapRuleNode(n), contextData)) != null) {
            FUSRule fUSRule = simpleRule;
            if (fUSRule == null) {
                WhiteListSimpleRuleFactory.$$$reportNull$$$0(8);
            }
            return fUSRule;
        }
        if (rule.contains(UTIL_PREFIX)) {
            FUSRule fUSRule = WhiteListSimpleRuleFactory.createExpressionUtilRule(nodes);
            if (fUSRule == null) {
                WhiteListSimpleRuleFactory.$$$reportNull$$$0(9);
            }
            return fUSRule;
        }
        return WhiteListSimpleRuleFactory.createExpressionWhiteListRule(rule, contextData);
    }

    @NotNull
    private static FUSRule createExpressionWhiteListRule(@NotNull String rule, @NotNull WhiteListGroupContextData contextData) {
        if (rule == null) {
            WhiteListSimpleRuleFactory.$$$reportNull$$$0(10);
        }
        if (contextData == null) {
            WhiteListSimpleRuleFactory.$$$reportNull$$$0(11);
        }
        StringBuilder sb = new StringBuilder();
        for (String node : WhiteListSimpleRuleFactory.parseSimpleExpression(rule)) {
            if (WhiteListSimpleRuleFactory.isExpressionNode(node)) {
                FUSRule fusRule = WhiteListSimpleRuleFactory.createRule(WhiteListSimpleRuleFactory.unwrapRuleNode(node), contextData);
                if (fusRule instanceof FUSRegexpAwareRule) {
                    sb.append("(");
                    sb.append(((FUSRegexpAwareRule)fusRule).asRegexp());
                    sb.append(")");
                    continue;
                }
                FUSRule fUSRule = UNPARSED_EXPRESSION;
                if (fUSRule == null) {
                    WhiteListSimpleRuleFactory.$$$reportNull$$$0(12);
                }
                return fUSRule;
            }
            sb.append(RegexpWhiteListRule.escapeText(node));
        }
        return new RegexpWhiteListRule(sb.toString());
    }

    private static FUSRule createExpressionUtilRule(@NotNull List<String> nodes) {
        if (nodes == null) {
            WhiteListSimpleRuleFactory.$$$reportNull$$$0(13);
        }
        CustomWhiteListRule fusRule = null;
        String suffix = "";
        String prefix = "";
        boolean utilNodeFound = false;
        for (String string : nodes) {
            if (WhiteListSimpleRuleFactory.isExpressionNode(string)) {
                if (!string.contains(UTIL_PREFIX)) {
                    return UNPARSED_EXPRESSION;
                }
                FUSRule simpleRule = WhiteListSimpleRuleFactory.createRule(WhiteListSimpleRuleFactory.unwrapRuleNode(string));
                if (!(simpleRule instanceof CustomWhiteListRule)) {
                    return UNPARSED_EXPRESSION;
                }
                fusRule = (CustomWhiteListRule)simpleRule;
                utilNodeFound = true;
                continue;
            }
            if (utilNodeFound) {
                suffix = string;
                continue;
            }
            prefix = string;
        }
        if (fusRule == null) {
            return UNPARSED_EXPRESSION;
        }
        return new UtilExpressionWhiteListRule(fusRule, prefix, suffix);
    }

    @NotNull
    public static List<String> parseSimpleExpression(@NotNull String s) {
        if (s == null) {
            WhiteListSimpleRuleFactory.$$$reportNull$$$0(14);
        }
        int currentRuleStart = s.indexOf(START);
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                WhiteListSimpleRuleFactory.$$$reportNull$$$0(15);
            }
            return list;
        }
        if (currentRuleStart == -1) {
            List<String> list = Collections.singletonList(s);
            if (list == null) {
                WhiteListSimpleRuleFactory.$$$reportNull$$$0(16);
            }
            return list;
        }
        int lastRuleEnd = -1;
        SmartList nodes = new SmartList();
        if (currentRuleStart > 0) {
            WhiteListSimpleRuleFactory.addNonEmpty((List<? super String>)nodes, s.substring(0, currentRuleStart));
        }
        while (currentRuleStart >= 0) {
            int currentRuleEnd = s.indexOf(END, currentRuleStart);
            if (currentRuleEnd == -1) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    WhiteListSimpleRuleFactory.$$$reportNull$$$0(17);
                }
                return list;
            }
            lastRuleEnd = currentRuleEnd + END.length();
            int nextRule = s.indexOf(START, currentRuleStart + START.length());
            if (nextRule > 0 && nextRule < lastRuleEnd) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    WhiteListSimpleRuleFactory.$$$reportNull$$$0(18);
                }
                return list;
            }
            WhiteListSimpleRuleFactory.addNonEmpty((List<? super String>)nodes, s.substring(currentRuleStart, lastRuleEnd));
            currentRuleStart = s.indexOf(START, lastRuleEnd);
            if (currentRuleStart <= 0) continue;
            WhiteListSimpleRuleFactory.addNonEmpty((List<? super String>)nodes, s.substring(lastRuleEnd, currentRuleStart));
        }
        if (lastRuleEnd > 0) {
            WhiteListSimpleRuleFactory.addNonEmpty((List<? super String>)nodes, s.substring(lastRuleEnd));
        }
        SmartList smartList = nodes;
        if (smartList == null) {
            WhiteListSimpleRuleFactory.$$$reportNull$$$0(19);
        }
        return smartList;
    }

    private static void addNonEmpty(@NotNull List<? super String> nodes, @Nullable String s) {
        if (nodes == null) {
            WhiteListSimpleRuleFactory.$$$reportNull$$$0(20);
        }
        if (StringUtil.isNotEmpty((String)s)) {
            nodes.add(s);
        }
    }

    private static boolean isExpressionNode(@NotNull String node) {
        if (node == null) {
            WhiteListSimpleRuleFactory.$$$reportNull$$$0(21);
        }
        return node.startsWith(START) && node.endsWith(END);
    }

    @NotNull
    private static String unwrapRuleNode(@NotNull String rule) {
        if (rule == null) {
            WhiteListSimpleRuleFactory.$$$reportNull$$$0(22);
        }
        String string = WhiteListSimpleRuleFactory.isExpressionNode(rule) ? rule.substring(START.length(), rule.length() - END.length()) : rule;
        if (string == null) {
            WhiteListSimpleRuleFactory.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextData";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/rules/utils/WhiteListSimpleRuleFactory";
                break;
            }
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/rules/utils/WhiteListSimpleRuleFactory";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpressionRule";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpressionWhiteListRule";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSimpleExpression";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapRuleNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRule";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleRule";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionRule";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionWhiteListRule";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionUtilRule";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseSimpleExpression";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addNonEmpty";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isExpressionNode";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "unwrapRuleNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

