/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.jobs;

import com.intellij.openapi.vcs.VcsException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.idea.perforce.perforce.jobs.ParserLogger;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJobField;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJobFieldType;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJobPersistenceType;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJobSpecification;

public class SpecificationParser {
    private static final String PARSE_ERROR = "Perforce Job Specification parse error.";
    private static final ParserLogger LOG = new ParserLogger("#org.jetbrains.idea.perforce.perforce.jobs.SpecificationParser", "Perforce Job Specification parse error.");
    private final List<String> myLines;
    private static final FieldParser[] ourFieldParsers = new FieldParser[]{new FieldParser("code"){

        @Override
        protected void parseAndFill(String s, PerforceJobField field) throws VcsException {
            int value = -1;
            try {
                value = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                LOG.generateParseException("Code could not be parsed: " + s);
            }
            if (value <= 100 || value > 199) {
                LOG.generateParseException("Code is out of [101,199] interval: " + value);
            }
            field.setCode(value);
        }
    }, new FieldParser("name"){

        @Override
        protected void parseAndFill(String s, PerforceJobField field) throws VcsException {
            field.setName(s);
        }
    }, new FieldParser("datatype"){

        @Override
        protected void parseAndFill(String s, PerforceJobField field) throws VcsException {
            PerforceJobFieldType type = PerforceJobFieldType.valueOf(s);
            if (type == null) {
                LOG.generateParseException("Cannot parse field type: " + s);
            }
            field.setType(type);
        }
    }, new FieldParser("length"){

        @Override
        protected void parseAndFill(String s, PerforceJobField field) {
        }
    }, new FieldParser("persistence"){

        @Override
        protected void parseAndFill(String s, PerforceJobField field) throws VcsException {
            PerforceJobPersistenceType persistenceType = PerforceJobPersistenceType.parse(s);
            if (persistenceType == null) {
                LOG.generateParseException("Cannot parse persistence: " + s);
            }
            field.setPersistence(persistenceType);
        }
    }};

    public SpecificationParser(List<String> lines) {
        this.myLines = lines;
    }

    public PerforceJobSpecification parse() throws VcsException {
        ArrayList<PerforceJobField> fields = new ArrayList<PerforceJobField>();
        boolean inFields = false;
        for (String line : this.myLines) {
            if (inFields) {
                if (SpecificationParser.fieldsFinished(line)) break;
                PerforceJobField field = SpecificationParser.parseField(line);
                if (field == null) continue;
                fields.add(field);
                continue;
            }
            inFields = SpecificationParser.fieldsStarted(line);
        }
        return new PerforceJobSpecification(fields);
    }

    private static boolean fieldsFinished(String line) {
        String trimmed = line.trim();
        return trimmed.startsWith("Values:") || trimmed.startsWith("Comments:") || trimmed.startsWith("Presets:");
    }

    private static boolean fieldsStarted(String line) {
        return line.trim().startsWith("Fields:");
    }

    private static PerforceJobField parseField(String line) throws VcsException {
        PerforceJobField result = new PerforceJobField();
        String trimmed = line.trim();
        String[] words = trimmed.split(" ");
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            ourFieldParsers[i].parseAndFill(word, result);
        }
        if (!result.filled()) {
            LOG.generateParseException("Not all fields specified");
        }
        return result;
    }

    private static abstract class FieldParser {
        private final String myName;

        protected FieldParser(String name) {
            this.myName = name;
        }

        protected abstract void parseAndFill(String var1, PerforceJobField var2) throws VcsException;

        public String toString() {
            return this.myName;
        }
    }
}

