/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui.cloneDialog;

import com.intellij.dvcs.DvcsRememberedInputs;
import com.intellij.dvcs.repo.ClonePathProvider;
import com.intellij.dvcs.ui.CloneDvcsValidationUtils;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.dvcs.ui.SelectChildTextFieldWithBrowseButton;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.rd.DisposableExKt;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogComponentStateListener;
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogExtensionComponent;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.InnerCell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.progress.ProgressVisibilityManager;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.cloneDialog.AccountMenuItem;
import com.intellij.util.ui.cloneDialog.AccountMenuPopupStep;
import com.intellij.util.ui.cloneDialog.AccountsMenuListPopup;
import com.intellij.util.ui.cloneDialog.ListWithSearchComponent;
import com.intellij.util.ui.components.BorderLayoutPanel;
import git4idea.checkout.GitCheckoutProvider;
import git4idea.commands.Git;
import git4idea.remote.GitRememberedInputs;
import icons.GithubIcons;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.api.data.GithubOrg;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.data.GithubUser;
import org.jetbrains.plugins.github.api.data.request.Affiliation;
import org.jetbrains.plugins.github.api.data.request.GithubRequestPagination;
import org.jetbrains.plugins.github.api.util.GithubApiPagesLoader;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.AccountRemovedListener;
import org.jetbrains.plugins.github.authentication.accounts.AccountTokenChangedListener;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountInformationProvider;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;
import org.jetbrains.plugins.github.authentication.ui.GithubLoginPanel;
import org.jetbrains.plugins.github.exceptions.GithubMissingTokenException;
import org.jetbrains.plugins.github.pullrequest.avatars.CachingGithubAvatarIconsProvider;
import org.jetbrains.plugins.github.ui.cloneDialog.GHCloneDialogExtensionComponent;
import org.jetbrains.plugins.github.ui.cloneDialog.GHCloneDialogExtensionComponent$buildGitHubLoginPanel$;
import org.jetbrains.plugins.github.ui.cloneDialog.GHRepositoryListCellRenderer;
import org.jetbrains.plugins.github.ui.cloneDialog.GHRepositoryListItem;
import org.jetbrains.plugins.github.ui.cloneDialog.GHRepositoryMouseAdapter;
import org.jetbrains.plugins.github.util.CachingGithubUserAvatarLoader;
import org.jetbrains.plugins.github.util.GithubAsyncUtilKt;
import org.jetbrains.plugins.github.util.GithubGitHelper;
import org.jetbrains.plugins.github.util.GithubImageResizer;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0085\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006*\u0001,\b\u0000\u0018\u00002\u00020\u0001:\u0001jB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u0015H\u0002J\u001a\u0010J\u001a\u00020K2\b\u0010I\u001a\u0004\u0018\u00010\u00152\u0006\u0010L\u001a\u00020\u0019H\u0002J\u0010\u0010M\u001a\u00020H2\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010N\u001a\u00020H2\u0006\u0010O\u001a\u00020PH\u0016J\u000e\u0010Q\u001a\b\u0012\u0004\u0012\u00020S0RH\u0016J\u0010\u0010T\u001a\u0004\u0018\u00010U2\u0006\u0010V\u001a\u00020;J\n\u0010W\u001a\u0004\u0018\u00010XH\u0016J\b\u0010Y\u001a\u00020FH\u0016J\u0018\u0010Z\u001a\u00020H2\u0006\u0010I\u001a\u00020\u00152\u0006\u0010[\u001a\u00020\\H\u0002J\u0018\u0010]\u001a\u00020H2\u0006\u0010I\u001a\u00020\u00152\u0006\u0010[\u001a\u00020\\H\u0002J\b\u0010^\u001a\u00020HH\u0016J\b\u0010_\u001a\u00020HH\u0002J\b\u0010`\u001a\u00020HH\u0002J\u0010\u0010a\u001a\u00020H2\u0006\u0010I\u001a\u00020\u0015H\u0002J\u0018\u0010b\u001a\u00020\u001d2\u0006\u0010c\u001a\u00020\u001d2\u0006\u0010d\u001a\u00020eH\u0002J\b\u0010f\u001a\u00020HH\u0002J\u0014\u0010g\u001a\u00020H2\n\b\u0002\u0010I\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010h\u001a\u00020HH\u0002J\b\u0010i\u001a\u00020HH\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014j\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001d0\u0014j\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001d`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\"\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020#0\u0014j\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020#`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010-R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RJ\u00100\u001a>\u0012\u0004\u0012\u00020\u0015\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020201j\b\u0012\u0004\u0012\u000202`30\u0014j\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020201j\b\u0012\u0004\u0012\u000202`3`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00106\u001a\b\u0012\u0004\u0012\u00020*07X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010<\u001a\u0004\u0018\u00010;2\b\u0010:\u001a\u0004\u0018\u00010;8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\bA\u0010B\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R*\u0010C\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020D0\u0014j\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020D`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006k"}, d2={"Lorg/jetbrains/plugins/github/ui/cloneDialog/GHCloneDialogExtensionComponent;", "Lcom/intellij/openapi/vcs/ui/cloneDialog/VcsCloneDialogExtensionComponent;", "project", "Lcom/intellij/openapi/project/Project;", "authenticationManager", "Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "executorManager", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutorManager;", "apiExecutorFactory", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "accountInformationProvider", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountInformationProvider;", "avatarLoader", "Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;", "imageResizer", "Lorg/jetbrains/plugins/github/util/GithubImageResizer;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutorManager;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountInformationProvider;Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;Lorg/jetbrains/plugins/github/util/GithubImageResizer;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "accountComponents", "Ljava/util/HashMap;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "Ljavax/swing/JLabel;", "Lkotlin/collections/HashMap;", "accountsPanel", "Ljavax/swing/JPanel;", "avatarSizeUiInt", "Lcom/intellij/util/ui/JBValue$UIInteger;", "avatarsByAccount", "Ljavax/swing/Icon;", "defaultAvatar", "defaultPopupAvatar", "directoryField", "Lcom/intellij/dvcs/ui/SelectChildTextFieldWithBrowseButton;", "errorsByAccount", "Lorg/jetbrains/plugins/github/ui/cloneDialog/GHRepositoryListItem$Error;", "githubGitHelper", "Lorg/jetbrains/plugins/github/util/GithubGitHelper;", "inLoginState", "", "originListModel", "Lcom/intellij/ui/CollectionListModel;", "Lorg/jetbrains/plugins/github/ui/cloneDialog/GHRepositoryListItem;", "popupMenuMouseAdapter", "org/jetbrains/plugins/github/ui/cloneDialog/GHCloneDialogExtensionComponent$popupMenuMouseAdapter$1", "Lorg/jetbrains/plugins/github/ui/cloneDialog/GHCloneDialogExtensionComponent$popupMenuMouseAdapter$1;", "progressManager", "Lcom/intellij/util/progress/ProgressVisibilityManager;", "repositoriesByAccount", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/plugins/github/api/data/GithubRepo;", "Lkotlin/collections/LinkedHashSet;", "repositoriesPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "repositoryList", "Lcom/intellij/ui/components/JBList;", "searchField", "Lcom/intellij/ui/SearchTextField;", "<set-?>", "", "selectedUrl", "getSelectedUrl", "()Ljava/lang/String;", "setSelectedUrl", "(Ljava/lang/String;)V", "selectedUrl$delegate", "Lkotlin/properties/ReadWriteProperty;", "userDetailsByAccount", "Lorg/jetbrains/plugins/github/api/data/GithubAuthenticatedUser;", "wrapper", "Lcom/intellij/ui/components/panels/Wrapper;", "addAccount", "", "account", "buildGitHubLoginPanel", "Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginPanel;", "errorPanel", "createFocusFilterFieldAction", "doClone", "checkoutListener", "Lcom/intellij/openapi/vcs/CheckoutProvider$Listener;", "doValidateAll", "", "Lcom/intellij/openapi/ui/ValidationInfo;", "getGithubRepoPath", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "searchText", "getPreferredFocusedComponent", "Ljavax/swing/JComponent;", "getView", "loadRepositories", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$WithTokenAuth;", "loadUserDetails", "onComponentSelected", "onSelectedUrlChanged", "refillRepositories", "removeAccount", "resizeIcon", "icon", "size", "", "showPopupMenu", "switchToLogin", "switchToRepositories", "updateSelectedUrl", "UpdateOrderLinkedHashSet", "intellij.vcs.github"})
public final class GHCloneDialogExtensionComponent
extends VcsCloneDialogExtensionComponent {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Logger LOG;
    private final ProgressVisibilityManager progressManager;
    private final GithubGitHelper githubGitHelper;
    private final Icon defaultAvatar;
    private final Icon defaultPopupAvatar;
    private final JBValue.UIInteger avatarSizeUiInt;
    private final Wrapper wrapper;
    private final DialogPanel repositoriesPanel;
    private final JBList<GHRepositoryListItem> repositoryList;
    private final popupMenuMouseAdapter.1 popupMenuMouseAdapter;
    private final JPanel accountsPanel;
    private final SearchTextField searchField;
    private final SelectChildTextFieldWithBrowseButton directoryField;
    private final HashMap<GithubAccount, GithubAuthenticatedUser> userDetailsByAccount;
    private final HashMap<GithubAccount, LinkedHashSet<GithubRepo>> repositoriesByAccount;
    private final HashMap<GithubAccount, GHRepositoryListItem.Error> errorsByAccount;
    private final CollectionListModel<GHRepositoryListItem> originListModel;
    private boolean inLoginState;
    private final ReadWriteProperty selectedUrl$delegate;
    private final HashMap<GithubAccount, JLabel> accountComponents;
    private final HashMap<GithubAccount, Icon> avatarsByAccount;
    private final Project project;
    private final GithubAuthenticationManager authenticationManager;
    private final GithubApiRequestExecutorManager executorManager;
    private final GithubApiRequestExecutor.Factory apiExecutorFactory;
    private final GithubAccountInformationProvider accountInformationProvider;
    private final CachingGithubUserAvatarLoader avatarLoader;
    private final GithubImageResizer imageResizer;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(GHCloneDialogExtensionComponent.class), "selectedUrl", "getSelectedUrl()Ljava/lang/String;"))};
    }

    private final String getSelectedUrl() {
        return (String)this.selectedUrl$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setSelectedUrl(String string) {
        this.selectedUrl$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
    }

    private final void switchToLogin(GithubAccount account) {
        JPanel errorPanel = new JPanel((LayoutManager)new VerticalLayout(10));
        GithubLoginPanel githubLoginPanel = this.buildGitHubLoginPanel(account, errorPanel);
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel().addToTop((Component)((Object)githubLoginPanel)).addToCenter((Component)errorPanel);
        Intrinsics.checkExpressionValueIsNotNull((Object)borderLayoutPanel, (String)"JBUI.Panels.simplePanel(\u2026 .addToCenter(errorPanel)");
        BorderLayoutPanel loginPanel = borderLayoutPanel;
        this.wrapper.setContent((JComponent)loginPanel);
        this.wrapper.repaint();
        this.inLoginState = true;
        this.updateSelectedUrl();
    }

    static /* synthetic */ void switchToLogin$default(GHCloneDialogExtensionComponent gHCloneDialogExtensionComponent, GithubAccount githubAccount, int n, Object object) {
        if ((n & 1) != 0) {
            githubAccount = null;
        }
        gHCloneDialogExtensionComponent.switchToLogin(githubAccount);
    }

    private final void switchToRepositories() {
        this.wrapper.setContent((JComponent)this.repositoriesPanel);
        this.wrapper.repaint();
        this.inLoginState = false;
        this.updateSelectedUrl();
    }

    private final void addAccount(GithubAccount account) {
        Object object;
        this.repositoriesByAccount.remove(account);
        Map $this$getOrPut$iv = this.accountComponents;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(account);
        if (value$iv == null) {
            boolean bl = false;
            JLabel jLabel = new JLabel();
            boolean bl2 = false;
            boolean bl3 = false;
            JLabel $this$apply = jLabel;
            boolean bl4 = false;
            $this$apply.setIcon(this.defaultAvatar);
            $this$apply.setToolTipText(account.getName());
            $this$apply.setOpaque(false);
            $this$apply.addMouseListener(this.popupMenuMouseAdapter);
            JLabel answer$iv = jLabel;
            $this$getOrPut$iv.put(account, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        JLabel label = (JLabel)object;
        this.accountsPanel.add(label);
        try {
            GithubApiRequestExecutor.WithTokenAuth executor = this.executorManager.getExecutor(account);
            this.loadUserDetails(account, executor);
            this.loadRepositories(account, executor);
        }
        catch (GithubMissingTokenException e) {
            ((Map)this.errorsByAccount).put(account, new GHRepositoryListItem.Error(account, "Missing access token", "Log in", new Runnable(this, account){
                final /* synthetic */ GHCloneDialogExtensionComponent this$0;
                final /* synthetic */ GithubAccount $account;

                public final void run() {
                    GHCloneDialogExtensionComponent.access$switchToLogin(this.this$0, this.$account);
                }
                {
                    this.this$0 = gHCloneDialogExtensionComponent;
                    this.$account = githubAccount;
                }
            }));
            this.refillRepositories();
        }
    }

    private final void removeAccount(GithubAccount account) {
        this.repositoriesByAccount.remove(account);
        JLabel jLabel = this.accountComponents.remove(account);
        boolean bl = false;
        boolean bl2 = false;
        JLabel it = jLabel;
        boolean bl3 = false;
        this.accountsPanel.remove(it);
        this.accountsPanel.revalidate();
        this.accountsPanel.repaint();
        this.refillRepositories();
        if (!this.authenticationManager.hasAccounts()) {
            GHCloneDialogExtensionComponent.switchToLogin$default(this, null, 1, null);
        }
    }

    private final void loadUserDetails(GithubAccount account, GithubApiRequestExecutor.WithTokenAuth executor) {
        this.progressManager.run(new Task.Backgroundable(this, executor, account, this.project, "Not Visible"){
            @NotNull
            public GithubAuthenticatedUser user;
            @NotNull
            public CachingGithubAvatarIconsProvider iconProvider;
            final /* synthetic */ GHCloneDialogExtensionComponent this$0;
            final /* synthetic */ GithubApiRequestExecutor.WithTokenAuth $executor;
            final /* synthetic */ GithubAccount $account;

            @NotNull
            public final GithubAuthenticatedUser getUser() {
                GithubAuthenticatedUser githubAuthenticatedUser = this.user;
                if (githubAuthenticatedUser == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"user");
                }
                return githubAuthenticatedUser;
            }

            public final void setUser(@NotNull GithubAuthenticatedUser githubAuthenticatedUser) {
                Intrinsics.checkParameterIsNotNull((Object)githubAuthenticatedUser, (String)"<set-?>");
                this.user = githubAuthenticatedUser;
            }

            @NotNull
            public final CachingGithubAvatarIconsProvider getIconProvider() {
                CachingGithubAvatarIconsProvider cachingGithubAvatarIconsProvider = this.iconProvider;
                if (cachingGithubAvatarIconsProvider == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"iconProvider");
                }
                return cachingGithubAvatarIconsProvider;
            }

            public final void setIconProvider(@NotNull CachingGithubAvatarIconsProvider cachingGithubAvatarIconsProvider) {
                Intrinsics.checkParameterIsNotNull((Object)cachingGithubAvatarIconsProvider, (String)"<set-?>");
                this.iconProvider = cachingGithubAvatarIconsProvider;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                this.user = GHCloneDialogExtensionComponent.access$getAccountInformationProvider$p(this.this$0).getInformation(this.$executor, indicator, this.$account);
                this.iconProvider = new CachingGithubAvatarIconsProvider.Factory(GHCloneDialogExtensionComponent.access$getAvatarLoader$p(this.this$0), GHCloneDialogExtensionComponent.access$getImageResizer$p(this.this$0), this.$executor).create((JBValue)GHCloneDialogExtensionComponent.access$getAvatarSizeUiInt$p(this.this$0), GHCloneDialogExtensionComponent.access$getAccountsPanel$p(this.this$0));
            }

            public void onSuccess() {
                Map map2 = GHCloneDialogExtensionComponent.access$getUserDetailsByAccount$p(this.this$0);
                GithubAuthenticatedUser githubAuthenticatedUser = this.user;
                if (githubAuthenticatedUser == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"user");
                }
                map2.put(this.$account, githubAuthenticatedUser);
                CachingGithubAvatarIconsProvider cachingGithubAvatarIconsProvider = this.iconProvider;
                if (cachingGithubAvatarIconsProvider == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"iconProvider");
                }
                GithubAuthenticatedUser githubAuthenticatedUser2 = this.user;
                if (githubAuthenticatedUser2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"user");
                }
                Icon avatar = cachingGithubAvatarIconsProvider.getIcon(githubAuthenticatedUser2.getAvatarUrl());
                ((Map)GHCloneDialogExtensionComponent.access$getAvatarsByAccount$p(this.this$0)).put(this.$account, avatar);
                JLabel jLabel = (JLabel)GHCloneDialogExtensionComponent.access$getAccountComponents$p(this.this$0).get(this.$account);
                if (jLabel != null) {
                    jLabel.setIcon(GHCloneDialogExtensionComponent.access$resizeIcon(this.this$0, avatar, 24));
                }
                GHCloneDialogExtensionComponent.access$refillRepositories(this.this$0);
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                GHCloneDialogExtensionComponent.access$getLOG$p(this.this$0).error(error);
                ((Map)GHCloneDialogExtensionComponent.access$getErrorsByAccount$p(this.this$0)).put(this.$account, new GHRepositoryListItem.Error(this.$account, "Unable to load repositories", "Retry", new Runnable(this){
                    final /* synthetic */ loadUserDetails.1 this$0;

                    public final void run() {
                        GHCloneDialogExtensionComponent.access$addAccount(this.this$0.this$0, this.this$0.$account);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
            }
            {
                this.this$0 = $outer;
                this.$executor = $captured_local_variable$1;
                this.$account = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        });
    }

    private final void loadRepositories(GithubAccount account, GithubApiRequestExecutor.WithTokenAuth executor) {
        this.repositoriesByAccount.remove(account);
        this.errorsByAccount.remove(account);
        this.progressManager.run(new Task.Backgroundable(this, account, executor, this.project, "Not Visible"){
            final /* synthetic */ GHCloneDialogExtensionComponent this$0;
            final /* synthetic */ GithubAccount $account;
            final /* synthetic */ GithubApiRequestExecutor.WithTokenAuth $executor;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                GithubServerPath githubServerPath = this.$account.getServer();
                Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"account.server");
                GithubApiPagesLoader.Request repoPagesRequest = GithubApiRequests.CurrentUser.Repos.pages$default(githubServerPath, null, null, Affiliation.Companion.combine(Affiliation.Companion.getOWNER(), Affiliation.Companion.getCOLLABORATOR()), GithubRequestPagination.Companion.getDEFAULT(), 6, null);
                Function1 pageItemsConsumer2 = (Function1)new Function1<List<? extends GithubRepo>, Unit>(this){
                    final /* synthetic */ loadRepositories.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull List<? extends GithubRepo> it) {
                        Application app$iv;
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        ModalityState modalityState$iv = null;
                        boolean $i$f$runInEdt = false;
                        Application application = app$iv = ApplicationManager.getApplication();
                        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
                        if (application.isDispatchThread()) {
                            Object object;
                            void $this$getOrPut$iv;
                            boolean bl = false;
                            Map map2 = GHCloneDialogExtensionComponent.access$getRepositoriesByAccount$p(this.this$0.this$0);
                            GithubAccount key$iv = this.this$0.$account;
                            boolean $i$f$getOrPut = false;
                            V value$iv = $this$getOrPut$iv.get(key$iv);
                            if (value$iv == null) {
                                boolean bl2 = false;
                                UpdateOrderLinkedHashSet<T> answer$iv = new UpdateOrderLinkedHashSet<T>();
                                $this$getOrPut$iv.put(key$iv, answer$iv);
                                object = answer$iv;
                            } else {
                                object = value$iv;
                            }
                            ((LinkedHashSet)object).addAll((Collection)it);
                            GHCloneDialogExtensionComponent.access$refillRepositories(this.this$0.this$0);
                        } else {
                            boolean $i$f$invokeLater = false;
                            ApplicationManager.getApplication().invokeLater(new Runnable(this, it){
                                final /* synthetic */ loadRepositories.run.pageItemsConsumer.1 this$0;
                                final /* synthetic */ List $it$inlined;
                                {
                                    this.this$0 = var1_1;
                                    this.$it$inlined = list2;
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final void run() {
                                    Object object;
                                    void $this$getOrPut$iv;
                                    boolean bl = false;
                                    Map map2 = GHCloneDialogExtensionComponent.access$getRepositoriesByAccount$p(this.this$0.this$0.this$0);
                                    GithubAccount key$iv = this.this$0.this$0.$account;
                                    boolean $i$f$getOrPut = false;
                                    V value$iv = $this$getOrPut$iv.get(key$iv);
                                    if (value$iv == null) {
                                        boolean bl2 = false;
                                        UpdateOrderLinkedHashSet<T> answer$iv = new UpdateOrderLinkedHashSet<T>();
                                        $this$getOrPut$iv.put(key$iv, answer$iv);
                                        object = answer$iv;
                                    } else {
                                        object = value$iv;
                                    }
                                    ((LinkedHashSet)object).addAll(this.$it$inlined);
                                    GHCloneDialogExtensionComponent.access$refillRepositories(this.this$0.this$0.this$0);
                                }
                            }, ModalityState.defaultModalityState());
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                };
                GithubApiPagesLoader.loadAll(this.$executor, indicator, repoPagesRequest, pageItemsConsumer2);
                GithubServerPath githubServerPath2 = this.$account.getServer();
                Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath2, (String)"account.server");
                GithubApiPagesLoader.Request orgsRequest = GithubApiRequests.CurrentUser.Orgs.pages$default(githubServerPath2, null, 2, null);
                Iterable $this$sortedBy$iv = GithubApiPagesLoader.loadAll(this.$executor, indicator, orgsRequest);
                boolean $i$f$sortedBy = false;
                Iterable iterable = $this$sortedBy$iv;
                boolean bl = false;
                Comparator comparator = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        GithubOrg it = (GithubOrg)a;
                        boolean bl2 = false;
                        Comparable comparable = (Comparable)((Object)it.getLogin());
                        it = (GithubOrg)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        String string = it.getLogin();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                    }
                };
                List userOrganizations = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
                for (GithubOrg org : userOrganizations) {
                    GithubServerPath githubServerPath3 = this.$account.getServer();
                    Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath3, (String)"account.server");
                    String string = org.getLogin();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"org.login");
                    GithubApiPagesLoader.Request<GithubRepo> orgRepoRequest = GithubApiRequests.Organisations.Repos.pages(githubServerPath3, string, GithubRequestPagination.Companion.getDEFAULT());
                    GithubApiPagesLoader.loadAll(this.$executor, indicator, orgRepoRequest, pageItemsConsumer2);
                }
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                GHCloneDialogExtensionComponent.access$getLOG$p(this.this$0).error(error);
                ((Map)GHCloneDialogExtensionComponent.access$getErrorsByAccount$p(this.this$0)).put(this.$account, new GHRepositoryListItem.Error(this.$account, "Unable to load repositories", "Retry", new Runnable(this){
                    final /* synthetic */ loadRepositories.1 this$0;

                    public final void run() {
                        GHCloneDialogExtensionComponent.access$loadRepositories(this.this$0.this$0, this.this$0.$account, this.this$0.$executor);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
            }
            {
                this.this$0 = $outer;
                this.$account = $captured_local_variable$1;
                this.$executor = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        });
    }

    private final void refillRepositories() {
        GHRepositoryListItem selectedValue = (GHRepositoryListItem)this.repositoryList.getSelectedValue();
        this.originListModel.removeAll();
        for (GithubAccount account : this.authenticationManager.getAccounts()) {
            LinkedHashSet<GithubRepo> repos;
            GithubAuthenticatedUser user;
            if (this.errorsByAccount.get(account) != null) {
                this.originListModel.add((Object)this.errorsByAccount.get(account));
            }
            if (this.userDetailsByAccount.get(account) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)user, (String)"userDetailsByAccount[account] ?: continue");
            if (this.repositoriesByAccount.get(account) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull(repos, (String)"repositoriesByAccount[account] ?: continue");
            for (GithubRepo repo : repos) {
                GithubUser githubUser = user;
                GithubRepo githubRepo = repo;
                Intrinsics.checkExpressionValueIsNotNull((Object)githubRepo, (String)"repo");
                this.originListModel.add((Object)new GHRepositoryListItem.Repo(account, githubUser, githubRepo));
            }
        }
        this.repositoryList.setSelectedValue((Object)selectedValue, false);
        ScrollingUtil.ensureSelectionExists((JList)((JList)this.repositoryList));
    }

    @NotNull
    public Wrapper getView() {
        return this.wrapper;
    }

    @NotNull
    public List<ValidationInfo> doValidateAll() {
        ArrayList list2 = new ArrayList();
        ContainerUtil.addIfNotNull((Collection)list2, (Object)CloneDvcsValidationUtils.checkDirectory((String)this.directoryField.getText(), (JTextField)this.directoryField.getTextField()));
        return list2;
    }

    public void doClone(@NotNull CheckoutProvider.Listener checkoutListener) {
        Intrinsics.checkParameterIsNotNull((Object)checkoutListener, (String)"checkoutListener");
        Path path = Paths.get(this.directoryField.getText(), new String[0]).toAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(directoryField.text).toAbsolutePath()");
        Path parent = path.getParent();
        ValidationInfo destinationValidation = CloneDvcsValidationUtils.createDestination((String)((Object)parent).toString());
        if (destinationValidation != null) {
            this.LOG.error("Unable to create destination directory", new String[]{destinationValidation.message});
            GithubNotifications.showError(this.project, "Clone failed", "Unable to create destination directory");
            return;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile destinationParent = lfs.findFileByIoFile(parent.toFile());
        if (destinationParent == null) {
            destinationParent = lfs.refreshAndFindFileByIoFile(parent.toFile());
        }
        if (destinationParent == null) {
            this.LOG.error("Clone Failed. Destination doesn't exist");
            GithubNotifications.showError(this.project, "Clone failed", "Unable to find destination");
            return;
        }
        Path path2 = Paths.get(this.directoryField.getText(), new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(directoryField.text)");
        String directoryName = ((Object)path2.getFileName()).toString();
        String parentDirectory = ((Object)parent.toAbsolutePath()).toString();
        GitCheckoutProvider.clone((Project)this.project, (Git)Git.getInstance(), (CheckoutProvider.Listener)checkoutListener, (VirtualFile)destinationParent, (String)this.getSelectedUrl(), (String)directoryName, (String)parentDirectory);
    }

    public void onComponentSelected() {
        block0: {
            this.getDialogStateListener().onOkActionNameChanged("Clone");
            this.updateSelectedUrl();
            IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.project);
            JComponent jComponent = this.getPreferredFocusedComponent();
            if (jComponent == null) break block0;
            JComponent jComponent2 = jComponent;
            boolean bl = false;
            boolean bl2 = false;
            JComponent it = jComponent2;
            boolean bl3 = false;
            focusManager.requestFocus((Component)it, true);
        }
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.searchField;
    }

    private final GithubLoginPanel buildGitHubLoginPanel(GithubAccount account, JPanel errorPanel) {
        Function2 alwaysUnique2 = buildGitHubLoginPanel.alwaysUnique.1.INSTANCE;
        GithubLoginPanel githubLoginPanel = new GithubLoginPanel(this.apiExecutorFactory, (Function2<? super String, ? super GithubServerPath, Boolean>)(account == null ? (Function2)new Function2<String, GithubServerPath, Boolean>(this.authenticationManager){

            public final boolean invoke(@NotNull String p1, @NotNull GithubServerPath p2) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                return ((GithubAuthenticationManager)this.receiver).isAccountUnique$intellij_vcs_github(p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(GithubAuthenticationManager.class);
            }

            public final String getName() {
                return "isAccountUnique";
            }

            public final String getSignature() {
                return "isAccountUnique$intellij_vcs_github(Ljava/lang/String;Lorg/jetbrains/plugins/github/api/GithubServerPath;)Z";
            }
        } : alwaysUnique2), this.project, false);
        boolean bl = false;
        boolean bl2 = false;
        GithubLoginPanel $this$apply = githubLoginPanel;
        boolean bl3 = false;
        if (account != null) {
            $this$apply.setCredentials(account.getName(), null, false);
            String string = account.getServer().toUrl();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"account.server.toUrl()");
            $this$apply.setServer(string, false);
        }
        $this$apply.setLoginListener(new ActionListener($this$apply, this, account, errorPanel){
            final /* synthetic */ GithubLoginPanel $this_apply;
            final /* synthetic */ GHCloneDialogExtensionComponent this$0;
            final /* synthetic */ GithubAccount $account$inlined;
            final /* synthetic */ JPanel $errorPanel$inlined;
            {
                this.$this_apply = githubLoginPanel;
                this.this$0 = gHCloneDialogExtensionComponent;
                this.$account$inlined = githubAccount;
                this.$errorPanel$inlined = jPanel;
            }

            public final void actionPerformed(ActionEvent it) {
                GithubAsyncUtilKt.handleOnEdt(this.$this_apply.acquireLoginAndToken((ProgressIndicator)new EmptyProgressIndicator(ModalityState.stateForComponent((Component)((Component)((Object)this.$this_apply))))), (Function2)new Function2<Pair<? extends String, ? extends String>, Throwable, Unit>(this){
                    final /* synthetic */ buildGitHubLoginPanel$$inlined$apply$lambda$1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }

                    public final void invoke(@Nullable Pair<String, String> loginToken, @Nullable Throwable throwable) {
                        this.this$0.$errorPanel$inlined.removeAll();
                        if (throwable != null) {
                            for (ValidationInfo validationInfo : this.this$0.$this_apply.doValidateAll()) {
                                SimpleColoredComponent component2 = new SimpleColoredComponent();
                                component2.append(validationInfo.message, SimpleTextAttributes.ERROR_ATTRIBUTES);
                                this.this$0.$errorPanel$inlined.add((Component)component2);
                                this.this$0.$errorPanel$inlined.revalidate();
                            }
                            this.this$0.$errorPanel$inlined.repaint();
                        }
                        if (loginToken != null) {
                            String login = (String)loginToken.getFirst();
                            String token = (String)loginToken.getSecond();
                            if (this.this$0.$account$inlined != null) {
                                GHCloneDialogExtensionComponent.access$getAuthenticationManager$p(this.this$0.this$0).updateAccountToken$intellij_vcs_github(this.this$0.$account$inlined, token);
                            } else {
                                GithubAuthenticationManager githubAuthenticationManager = GHCloneDialogExtensionComponent.access$getAuthenticationManager$p(this.this$0.this$0);
                                String string = this.this$0.$this_apply.getServer().getHost();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getServer().host");
                                githubAuthenticationManager.registerAccount$intellij_vcs_github(login, string, token);
                            }
                        }
                    }
                });
            }
        });
        $this$apply.setCancelListener(new ActionListener(this, account, errorPanel){
            final /* synthetic */ GHCloneDialogExtensionComponent this$0;
            final /* synthetic */ GithubAccount $account$inlined;
            final /* synthetic */ JPanel $errorPanel$inlined;
            {
                this.this$0 = gHCloneDialogExtensionComponent;
                this.$account$inlined = githubAccount;
                this.$errorPanel$inlined = jPanel;
            }

            public final void actionPerformed(ActionEvent it) {
                GHCloneDialogExtensionComponent.access$switchToRepositories(this.this$0);
            }
        });
        $this$apply.setLoginButtonVisible(true);
        $this$apply.setCancelButtonVisible(this.authenticationManager.hasAccounts());
        return githubLoginPanel;
    }

    private final void updateSelectedUrl() {
        this.repositoryList.getEmptyText().clear();
        if (this.inLoginState) {
            this.setSelectedUrl(null);
            return;
        }
        String string = this.searchField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"searchField.text");
        GHRepositoryCoordinates githubRepoPath = this.getGithubRepoPath(string);
        if (githubRepoPath != null) {
            this.setSelectedUrl(this.githubGitHelper.getRemoteUrl(githubRepoPath.getServerPath$intellij_vcs_github(), githubRepoPath.getRepositoryPath$intellij_vcs_github().getOwner(), githubRepoPath.getRepositoryPath$intellij_vcs_github().getRepository()));
            this.repositoryList.getEmptyText().appendText("Clone '" + this.getSelectedUrl() + '\'');
            return;
        }
        GHRepositoryListItem selectedValue = (GHRepositoryListItem)this.repositoryList.getSelectedValue();
        if (selectedValue instanceof GHRepositoryListItem.Repo) {
            GithubServerPath githubServerPath = selectedValue.getAccount().getServer();
            Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"selectedValue.account.server");
            String string2 = ((GHRepositoryListItem.Repo)selectedValue).getRepo().getUserName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"selectedValue.repo.userName");
            String string3 = ((GHRepositoryListItem.Repo)selectedValue).getRepo().getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"selectedValue.repo.name");
            this.setSelectedUrl(this.githubGitHelper.getRemoteUrl(githubServerPath, string2, string3));
            return;
        }
        this.setSelectedUrl(null);
    }

    @Nullable
    public final GHRepositoryCoordinates getGithubRepoPath(@NotNull String searchText) {
        Intrinsics.checkParameterIsNotNull((Object)searchText, (String)"searchText");
        String string = searchText;
        boolean bl = false;
        string = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (CharSequence)"git clone"), (CharSequence)".git");
        bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String url = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        try {
            GithubServerPath githubServerPath = GithubServerPath.from(url);
            Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"GithubServerPath.from(url)");
            GithubServerPath serverPath = githubServerPath;
            String string3 = serverPath.toUrl();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"serverPath.toUrl()");
            String string4 = serverPath.getSuffix();
            GithubServerPath githubServerPath2 = GithubServerPath.from(StringsKt.removeSuffix((String)string3, (CharSequence)(string4 != null ? (CharSequence)string4 : (CharSequence)"")));
            Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath2, (String)"GithubServerPath.from(se\u2026serverPath.suffix ?: \"\"))");
            serverPath = githubServerPath2;
            GHRepositoryPath gHRepositoryPath = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(url);
            if (gHRepositoryPath == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)gHRepositoryPath, (String)"GithubUrlUtil.getUserAnd\u2026teUrl(url) ?: return null");
            GHRepositoryPath githubFullPath = gHRepositoryPath;
            return new GHRepositoryCoordinates(serverPath, githubFullPath);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private final void onSelectedUrlChanged() {
        boolean urlSelected = this.getSelectedUrl() != null;
        this.getDialogStateListener().onOkActionEnabled(urlSelected);
        if (urlSelected) {
            String string = this.getSelectedUrl();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String string2 = StringUtil.trimEnd((String)ClonePathProvider.relativeDirectoryPathForVcsUrl((Project)this.project, (String)string), (String)".git");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringUtil.trimEnd(Clone\u2026dUrl!!), GitUtil.DOT_GIT)");
            String path = string2;
            this.directoryField.trySetChildPath(path);
        }
    }

    private final Icon resizeIcon(Icon icon, int size) {
        float scale = (float)JBUI.scale((int)size) / (float)icon.getIconWidth();
        Icon icon2 = IconUtil.scale((Icon)icon, null, (float)scale);
        Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"IconUtil.scale(icon, null, scale)");
        return icon2;
    }

    /*
     * WARNING - void declaration
     */
    private final void showPopupMenu() {
        boolean bl = false;
        List menuItems = new ArrayList();
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
        Project project = projectManager.getDefaultProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"ProjectManager.getInstance().defaultProject");
        Project project2 = project;
        boolean bl2 = false;
        for (GithubAccount account : (Iterable)this.authenticationManager.getAccounts()) {
            boolean bl3;
            AccountMenuItem.Action action2;
            Collection collection;
            void index;
            boolean showSeparatorAbove;
            GithubAuthenticatedUser user = this.userDetailsByAccount.get(account);
            Object object = user;
            if (object == null || (object = ((GithubUser)object).getLogin()) == null) {
                object = account.getName();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"user?.login ?: account.name");
            Object accountTitle = object;
            String string = account.getServer().toUrl();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"account.server.toUrl()");
            String serverInfo = StringsKt.removePrefix((String)StringsKt.removePrefix((String)string, (CharSequence)"http://"), (CharSequence)"https://");
            Icon icon = this.avatarsByAccount.get(account);
            if (icon == null) {
                icon = this.defaultPopupAvatar;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"avatarsByAccount[account] ?: defaultPopupAvatar");
            Icon avatar = icon;
            boolean bl4 = false;
            List accountActions = new ArrayList();
            boolean bl5 = showSeparatorAbove = index != false;
            if (user == null) {
                collection = accountActions;
                action2 = new AccountMenuItem.Action("Log in\u2026", (Function0)new Function0<Unit>(this, account){
                    final /* synthetic */ GHCloneDialogExtensionComponent this$0;
                    final /* synthetic */ GithubAccount $account;

                    public final void invoke() {
                        GHCloneDialogExtensionComponent.access$switchToLogin(this.this$0, this.$account);
                    }
                    {
                        this.this$0 = gHCloneDialogExtensionComponent;
                        this.$account = githubAccount;
                        super(0);
                    }
                }, null, false, 12, null);
                bl3 = false;
                collection.add(action2);
                collection = accountActions;
                action2 = new AccountMenuItem.Action("Remove account", (Function0)new Function0<Unit>(this, account){
                    final /* synthetic */ GHCloneDialogExtensionComponent this$0;
                    final /* synthetic */ GithubAccount $account;

                    public final void invoke() {
                        GHCloneDialogExtensionComponent.access$getAuthenticationManager$p(this.this$0).removeAccount$intellij_vcs_github(this.$account);
                    }
                    {
                        this.this$0 = gHCloneDialogExtensionComponent;
                        this.$account = githubAccount;
                        super(0);
                    }
                }, null, true, 4, null);
                bl3 = false;
                collection.add(action2);
            } else {
                if (Intrinsics.areEqual((Object)account, (Object)this.authenticationManager.getDefaultAccount(project2)) ^ true) {
                    collection = accountActions;
                    action2 = new AccountMenuItem.Action("Set as Default", (Function0)new Function0<Unit>(this, project2, account){
                        final /* synthetic */ GHCloneDialogExtensionComponent this$0;
                        final /* synthetic */ Project $project;
                        final /* synthetic */ GithubAccount $account;

                        public final void invoke() {
                            GHCloneDialogExtensionComponent.access$getAuthenticationManager$p(this.this$0).setDefaultAccount(this.$project, this.$account);
                        }
                        {
                            this.this$0 = gHCloneDialogExtensionComponent;
                            this.$project = project;
                            this.$account = githubAccount;
                            super(0);
                        }
                    }, null, false, 12, null);
                    bl3 = false;
                    collection.add(action2);
                }
                collection = accountActions;
                Function0 function0 = (Function0)new Function0<Unit>(user){
                    final /* synthetic */ GithubAuthenticatedUser $user;

                    public final void invoke() {
                        BrowserUtil.browse((String)this.$user.getHtmlUrl());
                    }
                    {
                        this.$user = githubAuthenticatedUser;
                        super(0);
                    }
                };
                Icon icon2 = AllIcons.Ide.External_link_arrow;
                Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Ide.External_link_arrow");
                action2 = new AccountMenuItem.Action("Open on GitHub", function0, icon2, false, 8, null);
                bl3 = false;
                collection.add(action2);
                collection = accountActions;
                action2 = new AccountMenuItem.Action("Log Out\u2026", (Function0)new Function0<Unit>(this, account){
                    final /* synthetic */ GHCloneDialogExtensionComponent this$0;
                    final /* synthetic */ GithubAccount $account;

                    public final void invoke() {
                        GHCloneDialogExtensionComponent.access$getAuthenticationManager$p(this.this$0).removeAccount$intellij_vcs_github(this.$account);
                    }
                    {
                        this.this$0 = gHCloneDialogExtensionComponent;
                        this.$account = githubAccount;
                        super(0);
                    }
                }, null, true, 4, null);
                bl3 = false;
                collection.add(action2);
            }
            collection = menuItems;
            action2 = new AccountMenuItem.Account((String)accountTitle, serverInfo, avatar, accountActions, showSeparatorAbove);
            bl3 = false;
            collection.add(action2);
            ++index;
        }
        Collection collection = menuItems;
        AccountMenuItem.Action action3 = new AccountMenuItem.Action("Add Account\u2026", (Function0)new Function0<Unit>(this){
            final /* synthetic */ GHCloneDialogExtensionComponent this$0;

            public final void invoke() {
                GHCloneDialogExtensionComponent.switchToLogin$default(this.this$0, null, 1, null);
            }
            {
                this.this$0 = gHCloneDialogExtensionComponent;
                super(0);
            }
        }, null, true, 4, null);
        boolean bl6 = false;
        collection.add(action3);
        new AccountsMenuListPopup(null, new AccountMenuPopupStep(menuItems), null, null, 12, null).showUnderneathOf((Component)this.accountsPanel);
    }

    private final void createFocusFilterFieldAction(SearchTextField searchField2) {
        DumbAwareAction dumbAwareAction = DumbAwareAction.create((Consumer)((Consumer)new Consumer<AnActionEvent>(this, searchField2){
            final /* synthetic */ GHCloneDialogExtensionComponent this$0;
            final /* synthetic */ SearchTextField $searchField;

            public final void consume(AnActionEvent it) {
                IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)GHCloneDialogExtensionComponent.access$getProject$p(this.this$0));
                if (focusManager.getFocusedDescendantFor((Component)GHCloneDialogExtensionComponent.access$getRepositoriesPanel$p(this.this$0)) != null) {
                    focusManager.requestFocus((Component)this.$searchField, true);
                }
            }
            {
                this.this$0 = gHCloneDialogExtensionComponent;
                this.$searchField = searchTextField;
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull((Object)dumbAwareAction, (String)"DumbAwareAction.create {\u2026ield, true)\n      }\n    }");
        DumbAwareAction action2 = dumbAwareAction;
        ShortcutSet shortcutSet = KeymapUtil.getActiveKeymapShortcuts((String)"Find");
        Intrinsics.checkExpressionValueIsNotNull((Object)shortcutSet, (String)"KeymapUtil.getActiveKeym\u2026s(IdeActions.ACTION_FIND)");
        ShortcutSet shortcuts = shortcutSet;
        action2.registerCustomShortcutSet(shortcuts, (JComponent)this.repositoriesPanel, (Disposable)this);
    }

    /*
     * WARNING - void declaration
     */
    public GHCloneDialogExtensionComponent(@NotNull Project project, @NotNull GithubAuthenticationManager authenticationManager, @NotNull GithubApiRequestExecutorManager executorManager, @NotNull GithubApiRequestExecutor.Factory apiExecutorFactory, @NotNull GithubAccountInformationProvider accountInformationProvider, @NotNull CachingGithubUserAvatarLoader avatarLoader, @NotNull GithubImageResizer imageResizer) {
        void constraints$iv;
        LayoutBuilder builder$iv;
        void initialValue$iv;
        FileChooserDescriptor fcd;
        Serializable serializable;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)authenticationManager, (String)"authenticationManager");
        Intrinsics.checkParameterIsNotNull((Object)executorManager, (String)"executorManager");
        Intrinsics.checkParameterIsNotNull((Object)apiExecutorFactory, (String)"apiExecutorFactory");
        Intrinsics.checkParameterIsNotNull((Object)accountInformationProvider, (String)"accountInformationProvider");
        Intrinsics.checkParameterIsNotNull((Object)avatarLoader, (String)"avatarLoader");
        Intrinsics.checkParameterIsNotNull((Object)imageResizer, (String)"imageResizer");
        this.project = project;
        this.authenticationManager = authenticationManager;
        this.executorManager = executorManager;
        this.apiExecutorFactory = apiExecutorFactory;
        this.accountInformationProvider = accountInformationProvider;
        this.avatarLoader = avatarLoader;
        this.imageResizer = imageResizer;
        this.LOG = GithubUtil.LOG;
        this.githubGitHelper = GithubGitHelper.Companion.getInstance();
        Icon icon = GithubIcons.DefaultAvatar;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"GithubIcons.DefaultAvatar");
        this.defaultAvatar = this.resizeIcon(icon, 24);
        Icon icon2 = GithubIcons.DefaultAvatar;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"GithubIcons.DefaultAvatar");
        this.defaultPopupAvatar = this.resizeIcon(icon2, 40);
        this.avatarSizeUiInt = new JBValue.UIInteger("GHCloneDialogExtensionComponent.popupAvatarSize", 40);
        this.wrapper = new Wrapper();
        this.popupMenuMouseAdapter = new MouseAdapter(this){
            final /* synthetic */ GHCloneDialogExtensionComponent this$0;

            public void mouseClicked(@Nullable MouseEvent e) {
                GHCloneDialogExtensionComponent.access$showPopupMenu(this.this$0);
            }
            {
                this.this$0 = $outer;
            }
        };
        JPanel jPanel = new JPanel(new FlowLayout(3, JBUI.scale((int)1), 0));
        GHCloneDialogExtensionComponent gHCloneDialogExtensionComponent = this;
        boolean bl = false;
        boolean bl2 = false;
        JPanel $this$apply = jPanel;
        boolean bl3 = false;
        $this$apply.addMouseListener(this.popupMenuMouseAdapter);
        gHCloneDialogExtensionComponent.accountsPanel = serializable = jPanel;
        String string = ClonePathProvider.defaultParentDirectoryPath((Project)this.project, (DvcsRememberedInputs)GitRememberedInputs.getInstance());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ClonePathProvider.defaul\u2026eredInputs.getInstance())");
        jPanel = new SelectChildTextFieldWithBrowseButton(string);
        gHCloneDialogExtensionComponent = this;
        bl = false;
        bl2 = false;
        $this$apply = jPanel;
        boolean bl4 = false;
        FileChooserDescriptor fileChooserDescriptor = fcd = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileChooserDescriptor, (String)"fcd");
        fileChooserDescriptor.setShowFileSystemRoots(true);
        fcd.setHideIgnored(false);
        $this$apply.addBrowseFolderListener(DvcsBundle.getString((String)"clone.destination.directory.browser.title"), DvcsBundle.getString((String)"clone.destination.directory.browser.description"), this.project, fcd);
        serializable = jPanel;
        gHCloneDialogExtensionComponent.directoryField = serializable;
        gHCloneDialogExtensionComponent = this;
        boolean bl5 = false;
        serializable = new HashMap();
        gHCloneDialogExtensionComponent.userDetailsByAccount = serializable;
        gHCloneDialogExtensionComponent = this;
        bl5 = false;
        serializable = new HashMap();
        gHCloneDialogExtensionComponent.repositoriesByAccount = serializable;
        gHCloneDialogExtensionComponent = this;
        bl5 = false;
        serializable = new HashMap();
        gHCloneDialogExtensionComponent.errorsByAccount = serializable;
        this.originListModel = new CollectionListModel((Object[])new GHRepositoryListItem[0]);
        Delegates delegates = Delegates.INSTANCE;
        Object var9_15 = null;
        gHCloneDialogExtensionComponent = this;
        boolean $i$f$observable22 = false;
        serializable = (ReadWriteProperty)new ObservableProperty<String>((Object)initialValue$iv, (Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ GHCloneDialogExtensionComponent this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = gHCloneDialogExtensionComponent;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
                String string = (String)newValue;
                String string2 = (String)oldValue;
                KProperty $noName_0 = property;
                boolean bl = false;
                GHCloneDialogExtensionComponent.access$onSelectedUrlChanged(this.this$0);
            }
        };
        gHCloneDialogExtensionComponent.selectedUrl$delegate = serializable;
        gHCloneDialogExtensionComponent = this;
        boolean this_$iv = false;
        serializable = new HashMap();
        gHCloneDialogExtensionComponent.accountComponents = serializable;
        gHCloneDialogExtensionComponent = this;
        this_$iv = false;
        serializable = new HashMap();
        gHCloneDialogExtensionComponent.avatarsByAccount = serializable;
        ListWithSearchComponent listWithSearchBundle = new ListWithSearchComponent((ListModel)this.originListModel, (ListCellRenderer)((Object)new GHRepositoryListCellRenderer(this.authenticationManager)));
        this.repositoryList = listWithSearchBundle.getList();
        GHRepositoryMouseAdapter mouseAdapter = new GHRepositoryMouseAdapter((JList)this.repositoryList);
        this.repositoryList.addMouseListener((MouseListener)mouseAdapter);
        this.repositoryList.addMouseMotionListener((MouseMotionListener)mouseAdapter);
        this.repositoryList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(ListSelectionEvent it) {
                ListSelectionEvent listSelectionEvent = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)listSelectionEvent, (String)"it");
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                this.updateSelectedUrl();
            }
        });
        this.searchField = listWithSearchBundle.getSearchField();
        this.searchField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.updateSelectedUrl();
            }
        });
        this.createFocusFilterFieldAction(this.searchField);
        this.progressManager = new ProgressVisibilityManager(){

            protected void setProgressVisible(boolean visible) {
                repositoryList.setPaintBusy(visible);
            }

            @NotNull
            protected ModalityState getModalityState() {
                ModalityState modalityState = ModalityState.any();
                Intrinsics.checkExpressionValueIsNotNull((Object)modalityState, (String)"ModalityState.any()");
                return modalityState;
            }
        };
        DisposableExKt.attachChild((Disposable)((Disposable)this), (Disposable)((Disposable)this.progressManager));
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        MessageBusConnection $i$f$observable22 = application.getMessageBus().connect((Disposable)this);
        boolean $this$apply32 = false;
        bl4 = false;
        MessageBusConnection $this$apply2 = $i$f$observable22;
        boolean bl6 = false;
        $this$apply2.subscribe(GithubAccountManager.Companion.getACCOUNT_REMOVED_TOPIC(), (Object)new AccountRemovedListener(this){
            final /* synthetic */ GHCloneDialogExtensionComponent this$0;
            {
                this.this$0 = gHCloneDialogExtensionComponent;
            }

            public void accountRemoved(@NotNull GithubAccount removedAccount) {
                Intrinsics.checkParameterIsNotNull((Object)removedAccount, (String)"removedAccount");
                GHCloneDialogExtensionComponent.access$removeAccount(this.this$0, removedAccount);
                GHCloneDialogExtensionComponent.access$getDialogStateListener$p(this.this$0).onListItemChanged();
            }
        });
        $this$apply2.subscribe(GithubAccountManager.Companion.getACCOUNT_TOKEN_CHANGED_TOPIC(), (Object)new AccountTokenChangedListener(this){
            final /* synthetic */ GHCloneDialogExtensionComponent this$0;
            {
                this.this$0 = gHCloneDialogExtensionComponent;
            }

            public void tokenChanged(@NotNull GithubAccount account) {
                Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
                if (GHCloneDialogExtensionComponent.access$getRepositoriesByAccount$p(this.this$0).get(account) != null) {
                    return;
                }
                GHCloneDialogExtensionComponent.access$getDialogStateListener$p(this.this$0).onListItemChanged();
                GHCloneDialogExtensionComponent.access$addAccount(this.this$0, account);
                GHCloneDialogExtensionComponent.access$switchToRepositories(this.this$0);
            }
        });
        LCFlags[] $this$apply32 = new LCFlags[]{};
        gHCloneDialogExtensionComponent = this;
        Object title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
        boolean bl7 = false;
        int gapLeft = JBUI.scale((int)10);
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(gapLeft, this){
            final /* synthetic */ int $gapLeft;
            final /* synthetic */ GHCloneDialogExtensionComponent this$0;
            {
                this.$gapLeft = n;
                this.this$0 = gHCloneDialogExtensionComponent;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Row $this$row) {
                void this_$iv;
                Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                Row row = $this$row;
                boolean isFullWidth$iv = true;
                boolean isVerticalFlow$iv = false;
                boolean $i$f$cell = false;
                this_$iv.setCellMode(true, isVerticalFlow$iv, isFullWidth$iv);
                InnerCell $this$cell = new InnerCell((Cell)this_$iv);
                boolean bl = false;
                Cell.invoke$default((Cell)$this$cell, (JComponent)((JComponent)GHCloneDialogExtensionComponent.access$getSearchField$p(this.this$0).getTextEditor()), (CCFlags[])new CCFlags[]{$this$cell.getPushX(), $this$cell.getGrowX()}, null, null, (int)6, null);
                Cell.invoke$default((Cell)$this$cell, (JComponent)new JSeparator(1), (CCFlags[])new CCFlags[]{$this$cell.getGrowY()}, null, null, (int)6, null).withLeftGap(this.$gapLeft);
                Cell.invoke$default((Cell)$this$cell, (JComponent)GHCloneDialogExtensionComponent.access$getAccountsPanel$p(this.this$0), (CCFlags[])new CCFlags[0], null, null, (int)6, null).withLeftGap(this.$gapLeft);
                this_$iv.setCellMode(false, isVerticalFlow$iv, isFullWidth$iv);
            }
        }), (int)3, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ GHCloneDialogExtensionComponent this$0;
            {
                this.this$0 = gHCloneDialogExtensionComponent;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                Cell.invoke$default((Cell)$this$row, (JComponent)ScrollPaneFactory.createScrollPane((Component)((Component)GHCloneDialogExtensionComponent.access$getRepositoryList$p(this.this$0))), (CCFlags[])new CCFlags[]{$this$row.getPush(), $this$row.getGrow()}, null, null, (int)6, null);
            }
        }), (int)3, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, (String)"Directory:", (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ GHCloneDialogExtensionComponent this$0;
            {
                this.this$0 = gHCloneDialogExtensionComponent;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                Cell.invoke$default((Cell)$this$row, (JComponent)((JComponent)GHCloneDialogExtensionComponent.access$getDirectoryField$p(this.this$0)), (CCFlags[])new CCFlags[]{$this$row.getGrowX(), $this$row.getPushX()}, null, null, (int)6, null);
            }
        }), (int)2, null);
        DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, (LCFlags[])constraints$iv);
        LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
        serializable = panel$iv;
        gHCloneDialogExtensionComponent.repositoriesPanel = serializable;
        this.repositoriesPanel.setBorder((Border)new JBEmptyBorder((Insets)UIUtil.getRegularPanelInsets()));
        if (this.authenticationManager.hasAccounts()) {
            void $this$forEach$iv;
            this.switchToRepositories();
            title$iv = this.authenticationManager.getAccounts();
            GHCloneDialogExtensionComponent gHCloneDialogExtensionComponent2 = this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GithubAccount p1 = (GithubAccount)element$iv;
                boolean bl8 = false;
                gHCloneDialogExtensionComponent2.addAccount(p1);
            }
        } else {
            GHCloneDialogExtensionComponent.switchToLogin$default(this, null, 1, null);
        }
    }

    public static final /* synthetic */ void access$switchToLogin(GHCloneDialogExtensionComponent $this, GithubAccount account) {
        $this.switchToLogin(account);
    }

    public static final /* synthetic */ GithubAccountInformationProvider access$getAccountInformationProvider$p(GHCloneDialogExtensionComponent $this) {
        return $this.accountInformationProvider;
    }

    public static final /* synthetic */ CachingGithubUserAvatarLoader access$getAvatarLoader$p(GHCloneDialogExtensionComponent $this) {
        return $this.avatarLoader;
    }

    public static final /* synthetic */ GithubImageResizer access$getImageResizer$p(GHCloneDialogExtensionComponent $this) {
        return $this.imageResizer;
    }

    public static final /* synthetic */ JBValue.UIInteger access$getAvatarSizeUiInt$p(GHCloneDialogExtensionComponent $this) {
        return $this.avatarSizeUiInt;
    }

    public static final /* synthetic */ JPanel access$getAccountsPanel$p(GHCloneDialogExtensionComponent $this) {
        return $this.accountsPanel;
    }

    public static final /* synthetic */ HashMap access$getUserDetailsByAccount$p(GHCloneDialogExtensionComponent $this) {
        return $this.userDetailsByAccount;
    }

    public static final /* synthetic */ HashMap access$getAvatarsByAccount$p(GHCloneDialogExtensionComponent $this) {
        return $this.avatarsByAccount;
    }

    public static final /* synthetic */ Icon access$resizeIcon(GHCloneDialogExtensionComponent $this, Icon icon, int size) {
        return $this.resizeIcon(icon, size);
    }

    public static final /* synthetic */ HashMap access$getAccountComponents$p(GHCloneDialogExtensionComponent $this) {
        return $this.accountComponents;
    }

    public static final /* synthetic */ void access$refillRepositories(GHCloneDialogExtensionComponent $this) {
        $this.refillRepositories();
    }

    public static final /* synthetic */ Logger access$getLOG$p(GHCloneDialogExtensionComponent $this) {
        return $this.LOG;
    }

    public static final /* synthetic */ HashMap access$getErrorsByAccount$p(GHCloneDialogExtensionComponent $this) {
        return $this.errorsByAccount;
    }

    public static final /* synthetic */ void access$addAccount(GHCloneDialogExtensionComponent $this, GithubAccount account) {
        $this.addAccount(account);
    }

    public static final /* synthetic */ HashMap access$getRepositoriesByAccount$p(GHCloneDialogExtensionComponent $this) {
        return $this.repositoriesByAccount;
    }

    public static final /* synthetic */ void access$loadRepositories(GHCloneDialogExtensionComponent $this, GithubAccount account, GithubApiRequestExecutor.WithTokenAuth executor) {
        $this.loadRepositories(account, executor);
    }

    public static final /* synthetic */ GithubAuthenticationManager access$getAuthenticationManager$p(GHCloneDialogExtensionComponent $this) {
        return $this.authenticationManager;
    }

    public static final /* synthetic */ void access$switchToRepositories(GHCloneDialogExtensionComponent $this) {
        $this.switchToRepositories();
    }

    public static final /* synthetic */ Project access$getProject$p(GHCloneDialogExtensionComponent $this) {
        return $this.project;
    }

    public static final /* synthetic */ DialogPanel access$getRepositoriesPanel$p(GHCloneDialogExtensionComponent $this) {
        return $this.repositoriesPanel;
    }

    public static final /* synthetic */ void access$showPopupMenu(GHCloneDialogExtensionComponent $this) {
        $this.showPopupMenu();
    }

    public static final /* synthetic */ void access$onSelectedUrlChanged(GHCloneDialogExtensionComponent $this) {
        $this.onSelectedUrlChanged();
    }

    public static final /* synthetic */ void access$removeAccount(GHCloneDialogExtensionComponent $this, GithubAccount account) {
        $this.removeAccount(account);
    }

    public static final /* synthetic */ VcsCloneDialogComponentStateListener access$getDialogStateListener$p(GHCloneDialogExtensionComponent $this) {
        return $this.getDialogStateListener();
    }

    public static final /* synthetic */ SearchTextField access$getSearchField$p(GHCloneDialogExtensionComponent $this) {
        return $this.searchField;
    }

    public static final /* synthetic */ SelectChildTextFieldWithBrowseButton access$getDirectoryField$p(GHCloneDialogExtensionComponent $this) {
        return $this.directoryField;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0012\u0012\u0004\u0012\u0002H\u00010\u0002j\b\u0012\u0004\u0012\u0002H\u0001`\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/ui/cloneDialog/GHCloneDialogExtensionComponent$UpdateOrderLinkedHashSet;", "T", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "()V", "add", "", "element", "(Ljava/lang/Object;)Z", "intellij.vcs.github"})
    private static final class UpdateOrderLinkedHashSet<T>
    extends LinkedHashSet<T> {
        @Override
        public boolean add(T element) {
            boolean wasThere = this.remove(element);
            super.add(element);
            return !wasThere;
        }
    }
}

