/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui;

import com.intellij.ide.CopyProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListUiUtil;
import com.intellij.util.ui.UIUtil;
import icons.GithubIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.pullrequest.action.GHPRActionKeys;
import org.jetbrains.plugins.github.pullrequest.avatars.CachingGithubAvatarIconsProvider;
import org.jetbrains.plugins.github.pullrequest.ui.GHPRList$PullRequestsListCellRenderer$WhenMappings;
import org.jetbrains.plugins.github.util.GithubUIUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u0005:\u0002\u001e\u001fB#\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GHPRList;", "Lcom/intellij/ui/components/JBList;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "Lcom/intellij/ide/CopyProvider;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/openapi/Disposable;", "copyPasteManager", "Lcom/intellij/openapi/ide/CopyPasteManager;", "avatarIconsProviderFactory", "Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$Factory;", "model", "Ljavax/swing/ListModel;", "(Lcom/intellij/openapi/ide/CopyPasteManager;Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$Factory;Ljavax/swing/ListModel;)V", "avatarIconsProvider", "Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider;", "dispose", "", "getData", "", "dataId", "", "getToolTipText", "event", "Ljava/awt/event/MouseEvent;", "isCopyEnabled", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isCopyVisible", "performCopy", "PullRequestsListCellRenderer", "RightClickSelectionListener", "intellij.vcs.github"})
public final class GHPRList
extends JBList<GHPullRequestShort>
implements CopyProvider,
DataProvider,
Disposable {
    private final CachingGithubAvatarIconsProvider avatarIconsProvider;
    private final CopyPasteManager copyPasteManager;

    @Nullable
    public String getToolTipText(@NotNull MouseEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Component childComponent = ListUtil.getDeepestRendererChildComponentAt((JList)((JList)((Object)this)), (Point)event.getPoint());
        if (!(childComponent instanceof JComponent)) {
            return null;
        }
        return ((JComponent)childComponent).getToolTipText();
    }

    public void performCopy(@NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        if (this.getSelectedIndex() < 0) {
            return;
        }
        GHPullRequestShort selection = (GHPullRequestShort)this.getModel().getElementAt(this.getSelectedIndex());
        this.copyPasteManager.setContents((Transferable)new StringSelection("" + '#' + selection.getNumber() + ' ' + selection.getTitle()));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        return !this.isSelectionEmpty();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        return false;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkParameterIsNotNull((Object)dataId, (String)"dataId");
        return PlatformDataKeys.COPY_PROVIDER.is(dataId) ? this : (GHPRActionKeys.getSELECTED_PULL_REQUEST$intellij_vcs_github().is(dataId) ? this.getSelectedValue() : null);
    }

    public void dispose() {
    }

    public GHPRList(@NotNull CopyPasteManager copyPasteManager, @NotNull CachingGithubAvatarIconsProvider.Factory avatarIconsProviderFactory, @NotNull ListModel<GHPullRequestShort> model2) {
        Intrinsics.checkParameterIsNotNull((Object)copyPasteManager, (String)"copyPasteManager");
        Intrinsics.checkParameterIsNotNull((Object)avatarIconsProviderFactory, (String)"avatarIconsProviderFactory");
        Intrinsics.checkParameterIsNotNull(model2, (String)"model");
        super(model2);
        this.copyPasteManager = copyPasteManager;
        this.avatarIconsProvider = avatarIconsProviderFactory.create(GithubUIUtil.INSTANCE.getAvatarSize(), (Component)((Object)this));
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)listSelectionModel, (String)"selectionModel");
        listSelectionModel.setSelectionMode(0);
        this.addMouseListener(new RightClickSelectionListener());
        PullRequestsListCellRenderer renderer = new PullRequestsListCellRenderer();
        this.setCellRenderer(renderer);
        UIUtil.putClientProperty((JComponent)((JComponent)((Object)this)), (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, (Object)CollectionsKt.listOf((Object)renderer));
        ScrollingUtil.installActions((JList)((JList)((Object)this)));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J8\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GHPRList$PullRequestsListCellRenderer;", "Ljavax/swing/ListCellRenderer;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "Ljavax/swing/JPanel;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/GHPRList;)V", "assignees", "info", "Ljavax/swing/JLabel;", "labels", "stateIcon", "title", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "intellij.vcs.github"})
    private final class PullRequestsListCellRenderer
    extends JPanel
    implements ListCellRenderer<GHPullRequestShort> {
        private final JLabel stateIcon = new JLabel();
        private final JLabel title = new JLabel();
        private final JLabel info = new JLabel();
        private final JPanel labels;
        private final JPanel assignees;

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList<? extends GHPullRequestShort> list2, @NotNull GHPullRequestShort value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon;
            Intrinsics.checkParameterIsNotNull(list2, (String)"list");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            UIUtil.setBackgroundRecursively((Component)this, (Color)ListUiUtil.WithTallRow.INSTANCE.background(list2, isSelected, list2.hasFocus()));
            Color primaryTextColor = ListUiUtil.WithTallRow.INSTANCE.foreground(isSelected, list2.hasFocus());
            Color secondaryTextColor = ListUiUtil.WithTallRow.INSTANCE.secondaryForeground(list2, isSelected);
            JComponent jComponent = this.stateIcon;
            boolean bl = false;
            boolean bl2 = false;
            JLabel $this$apply = jComponent;
            boolean bl3 = false;
            switch (GHPRList$PullRequestsListCellRenderer$WhenMappings.$EnumSwitchMapping$0[value.getState().ordinal()]) {
                case 1: {
                    icon = GithubIcons.PullRequestClosed;
                    break;
                }
                case 2: {
                    icon = GithubIcons.PullRequestMerged;
                    break;
                }
                case 3: {
                    icon = GithubIcons.PullRequestOpen;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            $this$apply.setIcon(icon);
            Iterator<GHUser> iterator = value.getState().toString();
            JLabel jLabel = $this$apply;
            boolean bl4 = false;
            String string = iterator;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = string.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
            Object object = string2;
            jLabel.setToolTipText(StringsKt.capitalize((String)object));
            jComponent = this.title;
            bl = false;
            bl2 = false;
            $this$apply = jComponent;
            boolean bl5 = false;
            $this$apply.setText(value.getTitle());
            $this$apply.setForeground(primaryTextColor);
            jComponent = this.info;
            bl = false;
            bl2 = false;
            $this$apply = jComponent;
            boolean bl6 = false;
            GHActor gHActor = value.getAuthor();
            $this$apply.setText("" + '#' + value.getNumber() + ' ' + (gHActor != null ? gHActor.getLogin() : null) + " on " + DateFormatUtil.formatDate((Date)value.getCreatedAt()));
            $this$apply.setForeground(secondaryTextColor);
            jComponent = this.labels;
            bl = false;
            bl2 = false;
            $this$apply = jComponent;
            boolean bl7 = false;
            $this$apply.removeAll();
            for (GHLabel label : value.getLabels()) {
                $this$apply.add((Component)GithubUIUtil.INSTANCE.createIssueLabelLabel(label));
                $this$apply.add(Box.createRigidArea((Dimension)new JBDimension(4, 0)));
            }
            jComponent = this.assignees;
            bl = false;
            bl2 = false;
            $this$apply = jComponent;
            boolean bl8 = false;
            $this$apply.removeAll();
            for (GHUser assignee2 : value.getAssignees()) {
                if ($this$apply.getComponentCount() != 0) {
                    $this$apply.add(Box.createRigidArea((Dimension)new JBDimension(10, 0)));
                }
                JLabel jLabel2 = new JLabel();
                object = $this$apply;
                boolean bl9 = false;
                boolean bl10 = false;
                JLabel $this$apply2 = jLabel2;
                boolean bl11 = false;
                $this$apply2.setIcon(GHPRList.this.avatarIconsProvider.getIcon(assignee2.getAvatarUrl()));
                $this$apply2.setToolTipText(assignee2.getLogin());
                JLabel jLabel3 = jLabel2;
                ((Container)object).add(jLabel3);
            }
            return this;
        }

        public PullRequestsListCellRenderer() {
            JPanel jPanel;
            JPanel jPanel2 = new JPanel();
            PullRequestsListCellRenderer pullRequestsListCellRenderer = this;
            boolean bl = false;
            boolean bl2 = false;
            JPanel $this$apply = jPanel2;
            boolean bl3 = false;
            $this$apply.setLayout(new BoxLayout($this$apply, 0));
            pullRequestsListCellRenderer.labels = jPanel = jPanel2;
            jPanel2 = new JPanel();
            pullRequestsListCellRenderer = this;
            bl = false;
            bl2 = false;
            $this$apply = jPanel2;
            boolean bl4 = false;
            $this$apply.setLayout(new BoxLayout($this$apply, 0));
            pullRequestsListCellRenderer.assignees = jPanel = jPanel2;
            this.setBorder((Border)JBUI.Borders.empty((int)5, (int)8));
            this.setLayout((LayoutManager)new MigLayout(new LC().gridGap("0", "0").insets("0", "0", "0", "0").fillX()));
            String gapAfter = JBUI.scale((int)5) + "px";
            this.add((Component)this.stateIcon, new CC().gapAfter(gapAfter));
            this.add((Component)this.title, new CC().minWidth("pref/2px").gapAfter(gapAfter));
            this.add((Component)this.labels, new CC().growX().pushX().minWidth("0px").gapAfter(gapAfter));
            this.add((Component)this.assignees, new CC().spanY(2).wrap());
            this.add((Component)this.info, new CC().minWidth("0px").skip(1).spanX(2));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GHPRList$RightClickSelectionListener;", "Ljava/awt/event/MouseAdapter;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/GHPRList;)V", "mousePressed", "", "e", "Ljava/awt/event/MouseEvent;", "intellij.vcs.github"})
    private final class RightClickSelectionListener
    extends MouseAdapter {
        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            int row;
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            if (SwingUtilities.isRightMouseButton(e) && (row = GHPRList.this.locationToIndex(e.getPoint())) != -1) {
                GHPRList.this.getSelectionModel().setSelectionInterval(row, row);
            }
        }
    }
}

