/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.AccountTokenChangedListener;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;
import org.jetbrains.plugins.github.authentication.ui.GithubChooseAccountDialog;
import org.jetbrains.plugins.github.pullrequest.GHPRAccountsComponent;
import org.jetbrains.plugins.github.pullrequest.GHPRRequestExecutorComponent;
import org.jetbrains.plugins.github.ui.util.DisposingWrapper;
import org.jetbrains.plugins.github.util.GitRemoteUrlCoordinates;
import org.jetbrains.plugins.github.util.GithubUIUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J\u0016\u0010\u001a\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H\u0002J\b\u0010\u001b\u001a\u00020\u0014H\u0002J\b\u0010\u001c\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRAccountsComponent;", "Lorg/jetbrains/plugins/github/ui/util/DisposingWrapper;", "authManager", "Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "project", "Lcom/intellij/openapi/project/Project;", "remoteUrl", "Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;Lcom/intellij/openapi/Disposable;)V", "requestExecutorManager", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutorManager;", "getRequestExecutorManager", "()Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutorManager;", "requestExecutorManager$delegate", "Lkotlin/Lazy;", "selectedAccount", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "chooseAccount", "", "accounts", "", "requestNewAccount", "setActualContent", "account", "showChooseAccountPanel", "showLoginPanel", "update", "intellij.vcs.github"})
public final class GHPRAccountsComponent
extends DisposingWrapper {
    private final Lazy requestExecutorManager$delegate;
    private GithubAccount selectedAccount;
    private final GithubAuthenticationManager authManager;
    private final Project project;
    private final GitRemoteUrlCoordinates remoteUrl;

    private final GithubApiRequestExecutorManager getRequestExecutorManager() {
        Lazy lazy = this.requestExecutorManager$delegate;
        GHPRAccountsComponent gHPRAccountsComponent = this;
        Object var3_3 = null;
        boolean bl = false;
        return (GithubApiRequestExecutorManager)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void update() {
        Object v0;
        boolean bl;
        Iterable iterable;
        List accounts;
        block7: {
            GithubAccount it;
            void $this$filterTo$iv$iv;
            if (this.selectedAccount != null) {
                return;
            }
            Iterable $this$filter$iv = this.authManager.getAccounts();
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (GithubAccount)element$iv$iv;
                boolean bl2 = false;
                if (!it.getServer().matches(this.remoteUrl.getUrl())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            accounts = (List)destination$iv$iv;
            if (accounts.size() == 1) {
                this.setActualContent((GithubAccount)CollectionsKt.single((List)accounts));
                return;
            }
            iterable = accounts;
            bl = false;
            Iterable iterable3 = iterable;
            boolean bl3 = false;
            for (Object t : iterable3) {
                it = (GithubAccount)t;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)this.authManager.getDefaultAccount(this.project))) continue;
                v0 = t;
                break block7;
            }
            v0 = null;
        }
        GithubAccount defaultAccount = v0;
        if (defaultAccount != null) {
            this.setActualContent(defaultAccount);
            return;
        }
        iterable = accounts;
        bl = false;
        if (!iterable.isEmpty()) {
            this.showChooseAccountPanel(accounts);
        } else {
            this.showLoginPanel();
        }
    }

    private final void showLoginPanel() {
        SimpleColoredComponent simpleColoredComponent = GithubUIUtil.INSTANCE.createNoteWithAction((Function0<Unit>)((Function0)new Function0<Unit>(this){

            public final void invoke() {
                GHPRAccountsComponent.access$requestNewAccount((GHPRAccountsComponent)((Object)this.receiver));
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(GHPRAccountsComponent.class);
            }

            public final String getName() {
                return "requestNewAccount";
            }

            public final String getSignature() {
                return "requestNewAccount()V";
            }
        }));
        GHPRAccountsComponent gHPRAccountsComponent = this;
        boolean bl = false;
        boolean bl2 = false;
        SimpleColoredComponent $this$apply = simpleColoredComponent;
        boolean bl3 = false;
        $this$apply.append("Log in", SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, (Object)new Runnable(this){
            final /* synthetic */ GHPRAccountsComponent this$0;
            {
                this.this$0 = gHPRAccountsComponent;
            }

            public final void run() {
                GHPRAccountsComponent.access$requestNewAccount(this.this$0);
            }
        });
        $this$apply.append(" to GitHub to view pull requests", SimpleTextAttributes.GRAYED_ATTRIBUTES);
        SimpleColoredComponent simpleColoredComponent2 = simpleColoredComponent;
        gHPRAccountsComponent.setCenteredContent((JComponent)simpleColoredComponent2);
    }

    private final void requestNewAccount() {
        GithubAuthenticationManager.requestNewAccount$default(this.authManager, this.project, null, 2, null);
        IdeFocusManager.getInstance((Project)this.project).requestFocusInProject((Component)((Object)this), this.project);
    }

    private final void showChooseAccountPanel(List<? extends GithubAccount> accounts) {
        SimpleColoredComponent simpleColoredComponent = GithubUIUtil.INSTANCE.createNoteWithAction((Function0<Unit>)((Function0)new Function0<Unit>(this, accounts){
            final /* synthetic */ GHPRAccountsComponent this$0;
            final /* synthetic */ List $accounts;

            public final void invoke() {
                GHPRAccountsComponent.access$chooseAccount(this.this$0, this.$accounts);
            }
            {
                this.this$0 = gHPRAccountsComponent;
                this.$accounts = list2;
                super(0);
            }
        }));
        GHPRAccountsComponent gHPRAccountsComponent = this;
        boolean bl = false;
        boolean bl2 = false;
        SimpleColoredComponent $this$apply = simpleColoredComponent;
        boolean bl3 = false;
        $this$apply.append("Select", SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, (Object)new Runnable(this, accounts){
            final /* synthetic */ GHPRAccountsComponent this$0;
            final /* synthetic */ List $accounts$inlined;
            {
                this.this$0 = gHPRAccountsComponent;
                this.$accounts$inlined = list2;
            }

            public final void run() {
                GHPRAccountsComponent.access$chooseAccount(this.this$0, this.$accounts$inlined);
            }
        });
        $this$apply.append(" GitHub account to view pull requests", SimpleTextAttributes.GRAYED_ATTRIBUTES);
        SimpleColoredComponent simpleColoredComponent2 = simpleColoredComponent;
        gHPRAccountsComponent.setCenteredContent((JComponent)simpleColoredComponent2);
    }

    private final void chooseAccount(List<? extends GithubAccount> accounts) {
        GithubChooseAccountDialog dialog2 = new GithubChooseAccountDialog(this.project, null, accounts, null, true, true, null, null, 192, null);
        if (dialog2.showAndGet()) {
            this.setActualContent(dialog2.getAccount());
            IdeFocusManager.getInstance((Project)this.project).requestFocusInProject((Component)((Object)this), this.project);
        }
    }

    private final void setActualContent(GithubAccount account) {
        this.selectedAccount = account;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkExpressionValueIsNotNull((Object)disposable, (String)"Disposer.newDisposable()");
        Disposable disposable2 = disposable;
        this.setContent((JComponent)((Object)new GHPRRequestExecutorComponent(this.getRequestExecutorManager(), this.project, this.remoteUrl, account, disposable2)), disposable2);
    }

    public GHPRAccountsComponent(@NotNull GithubAuthenticationManager authManager, @NotNull Project project, @NotNull GitRemoteUrlCoordinates remoteUrl, @NotNull Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)authManager, (String)"authManager");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)remoteUrl, (String)"remoteUrl");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        super(parentDisposable);
        this.authManager = authManager;
        this.project = project;
        this.remoteUrl = remoteUrl;
        this.requestExecutorManager$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)requestExecutorManager.2.INSTANCE);
        this.setBackground(UIUtil.getListBackground());
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect(parentDisposable).subscribe(GithubAccountManager.Companion.getACCOUNT_TOKEN_CHANGED_TOPIC(), (Object)new AccountTokenChangedListener(){

            @Override
            public void tokenChanged(@NotNull GithubAccount account) {
                Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
                this.update();
            }
        });
        this.update();
    }

    public static final /* synthetic */ void access$requestNewAccount(GHPRAccountsComponent $this) {
        $this.requestNewAccount();
    }

    public static final /* synthetic */ void access$chooseAccount(GHPRAccountsComponent $this, List accounts) {
        $this.chooseAccount(accounts);
    }
}

