/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.util.indexing.IdFilter;
import gnu.trove.TIntArrayList;
import org.jetbrains.annotations.NotNull;

public final class ProjectIndexableFilesFilter
extends IdFilter {
    private static final int SHIFT = 6;
    private static final int MASK = 63;
    private final long[] myBitMask;
    private final int myModificationCount;
    private final int myMinId;
    private final int myMaxId;

    ProjectIndexableFilesFilter(@NotNull TIntArrayList set, int modificationCount) {
        if (set == null) {
            ProjectIndexableFilesFilter.$$$reportNull$$$0(0);
        }
        this.myModificationCount = modificationCount;
        int[] minMax = new int[2];
        if (!set.isEmpty()) {
            minMax[0] = minMax[1] = set.get(0);
        }
        set.forEach(value2 -> {
            minMax[0] = Math.min(minMax[0], value2);
            minMax[1] = Math.max(minMax[1], value2);
            return true;
        });
        this.myMaxId = minMax[1];
        this.myMinId = minMax[0];
        this.myBitMask = new long[(this.myMaxId - this.myMinId >> 6) + 1];
        set.forEach(value2 -> {
            int n = (value2 -= this.myMinId) >> 6;
            this.myBitMask[n] = this.myBitMask[n] | 1L << (value2 & 0x3F);
            return true;
        });
    }

    public boolean containsFileId(int id2) {
        if (id2 < this.myMinId) {
            return false;
        }
        if (id2 > this.myMaxId) {
            return false;
        }
        return (this.myBitMask[(id2 -= this.myMinId) >> 6] & 1L << (id2 & 0x3F)) != 0L;
    }

    public int getModificationCount() {
        return this.myModificationCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/util/indexing/ProjectIndexableFilesFilter", "<init>"));
    }
}

