/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.projectModel.ProjectModelBundle;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ModuleLibraryTable
implements LibraryTable,
LibraryTable.ModifiableModel {
    @NotNull
    private final RootModelImpl myRootModel;
    @NotNull
    private final ProjectRootManagerImpl myProjectRootManager;
    public static final LibraryTablePresentation MODULE_LIBRARY_TABLE_PRESENTATION = new LibraryTablePresentation(){

        @NotNull
        public String getDisplayName(boolean plural) {
            String string = ProjectModelBundle.message((String)"module.library.display.name", (Object[])new Object[]{plural ? 2 : 1});
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getDescription() {
            String string = ProjectModelBundle.message((String)"libraries.node.text.module", (Object[])new Object[0]);
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getLibraryTableEditorTitle() {
            String string = ProjectModelBundle.message((String)"library.configure.module.title", (Object[])new Object[0]);
            if (string == null) {
                1.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/roots/impl/ModuleLibraryTable$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryTableEditorTitle";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };

    ModuleLibraryTable(@NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        if (rootModel == null) {
            ModuleLibraryTable.$$$reportNull$$$0(0);
        }
        if (projectRootManager == null) {
            ModuleLibraryTable.$$$reportNull$$$0(1);
        }
        this.myRootModel = rootModel;
        this.myProjectRootManager = projectRootManager;
    }

    public Library @NotNull [] getLibraries() {
        ArrayList result2 = new ArrayList();
        Iterator<Library> libraryIterator = this.getLibraryIterator();
        ContainerUtil.addAll(result2, libraryIterator);
        Library[] libraryArray = result2.toArray(Library.EMPTY_ARRAY);
        if (libraryArray == null) {
            ModuleLibraryTable.$$$reportNull$$$0(2);
        }
        return libraryArray;
    }

    @NotNull
    public Library createLibrary() {
        Library library = this.createLibrary(null);
        if (library == null) {
            ModuleLibraryTable.$$$reportNull$$$0(3);
        }
        return library;
    }

    @NotNull
    public Library createLibrary(String name) {
        Library library = this.createLibrary(name, null);
        if (library == null) {
            ModuleLibraryTable.$$$reportNull$$$0(4);
        }
        return library;
    }

    @NotNull
    public Library createLibrary(String name, @Nullable PersistentLibraryKind type) {
        Library library = this.createLibrary(name, type, null);
        if (library == null) {
            ModuleLibraryTable.$$$reportNull$$$0(5);
        }
        return library;
    }

    @NotNull
    public Library createLibrary(String name, @Nullable PersistentLibraryKind kind, @Nullable ProjectModelExternalSource externalSource) {
        ModuleLibraryOrderEntryImpl orderEntry = new ModuleLibraryOrderEntryImpl(name, kind, this.myRootModel, this.myProjectRootManager, externalSource);
        this.myRootModel.addOrderEntry(orderEntry);
        Library library = orderEntry.getLibrary();
        if (library == null) {
            ModuleLibraryTable.$$$reportNull$$$0(6);
        }
        return library;
    }

    public void removeLibrary(@NotNull Library library) {
        if (library == null) {
            ModuleLibraryTable.$$$reportNull$$$0(7);
        }
        Iterator<OrderEntry> orderIterator = this.myRootModel.getOrderIterator();
        while (orderIterator.hasNext()) {
            LibraryOrderEntry libraryOrderEntry;
            OrderEntry orderEntry = orderIterator.next();
            if (!(orderEntry instanceof LibraryOrderEntry) || !(libraryOrderEntry = (LibraryOrderEntry)orderEntry).isModuleLevel() || !library.equals(libraryOrderEntry.getLibrary())) continue;
            this.myRootModel.removeOrderEntry(orderEntry);
            return;
        }
    }

    @NotNull
    public Iterator<Library> getLibraryIterator() {
        FilteringIterator filteringIterator = new FilteringIterator(this.myRootModel.getOrderIterator(), entry -> entry instanceof LibraryOrderEntry && ((LibraryOrderEntry)entry).isModuleLevel() && ((LibraryOrderEntry)entry).getLibrary() != null);
        Iterator iterator2 = ContainerUtil.mapIterator((Iterator)filteringIterator, LibraryOrderEntry::getLibrary);
        if (iterator2 == null) {
            ModuleLibraryTable.$$$reportNull$$$0(8);
        }
        return iterator2;
    }

    @NotNull
    public String getTableLevel() {
        return "module";
    }

    @NotNull
    public LibraryTablePresentation getPresentation() {
        LibraryTablePresentation libraryTablePresentation = MODULE_LIBRARY_TABLE_PRESENTATION;
        if (libraryTablePresentation == null) {
            ModuleLibraryTable.$$$reportNull$$$0(9);
        }
        return libraryTablePresentation;
    }

    @Nullable
    public Library getLibraryByName(@NotNull String name) {
        if (name == null) {
            ModuleLibraryTable.$$$reportNull$$$0(10);
        }
        Iterator<Library> libraryIterator = this.getLibraryIterator();
        while (libraryIterator.hasNext()) {
            Library library = libraryIterator.next();
            if (!name.equals(library.getName())) continue;
            return library;
        }
        return null;
    }

    public void addListener(@NotNull LibraryTable.Listener listener2) {
        if (listener2 == null) {
            ModuleLibraryTable.$$$reportNull$$$0(11);
        }
        throw new UnsupportedOperationException();
    }

    public void addListener(@NotNull LibraryTable.Listener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            ModuleLibraryTable.$$$reportNull$$$0(12);
        }
        if (parentDisposable == null) {
            ModuleLibraryTable.$$$reportNull$$$0(13);
        }
        throw new UnsupportedOperationException("Method addListener is not yet implemented in " + this.getClass().getName());
    }

    public void removeListener(@NotNull LibraryTable.Listener listener2) {
        if (listener2 == null) {
            ModuleLibraryTable.$$$reportNull$$$0(14);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Module getModule() {
        Module module = this.myRootModel.getModule();
        if (module == null) {
            ModuleLibraryTable.$$$reportNull$$$0(15);
        }
        return module;
    }

    public void commit() {
    }

    public void dispose() {
    }

    public boolean isChanged() {
        return this.myRootModel.isChanged();
    }

    @NotNull
    public LibraryTable.ModifiableModel getModifiableModel() {
        ModuleLibraryTable moduleLibraryTable = this;
        if (moduleLibraryTable == null) {
            ModuleLibraryTable.$$$reportNull$$$0(16);
        }
        return moduleLibraryTable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ModuleLibraryTable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ModuleLibraryTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibrary";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryIterator";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeLibrary";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryByName";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

