/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.text.TextEditorComponent;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class AsyncEditorLoader {
    private static final ExecutorService ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"AsyncEditorLoader Pool", (int)2);
    private static final Key<AsyncEditorLoader> ASYNC_LOADER = Key.create((String)"ASYNC_LOADER");
    private static final int SYNCHRONOUS_LOADING_WAITING_TIME_MS = 200;
    private static final int DOCUMENT_COMMIT_WAITING_TIME_MS = 5000;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final Project myProject;
    @NotNull
    private final TextEditorImpl myTextEditor;
    @NotNull
    private final TextEditorComponent myEditorComponent;
    @NotNull
    private final TextEditorProvider myProvider;
    private final List<Runnable> myDelayedActions;
    private TextEditorState myDelayedState;
    private final AtomicBoolean myLoadingFinished;

    AsyncEditorLoader(@NotNull TextEditorImpl textEditor, @NotNull TextEditorComponent component2, @NotNull TextEditorProvider provider) {
        if (textEditor == null) {
            AsyncEditorLoader.$$$reportNull$$$0(0);
        }
        if (component2 == null) {
            AsyncEditorLoader.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            AsyncEditorLoader.$$$reportNull$$$0(2);
        }
        this.myDelayedActions = new ArrayList<Runnable>();
        this.myLoadingFinished = new AtomicBoolean();
        this.myProvider = provider;
        this.myTextEditor = textEditor;
        this.myProject = textEditor.myProject;
        this.myEditorComponent = component2;
        this.myEditor = textEditor.getEditor();
        this.myEditor.putUserData(ASYNC_LOADER, (Object)this);
        this.myEditorComponent.getContentPanel().setVisible(false);
    }

    void start() {
        Runnable continuation;
        ApplicationManager.getApplication().assertIsDispatchThread();
        Future<Runnable> asyncLoading = this.scheduleLoading();
        boolean showProgress = true;
        if (this.worthWaiting() && (continuation = AsyncEditorLoader.resultInTimeOrNull(asyncLoading)) != null) {
            showProgress = false;
            this.loadingFinished(continuation);
        }
        if (showProgress) {
            this.myEditorComponent.startLoading();
        }
    }

    private Future<Runnable> scheduleLoading() {
        long commitDeadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(5000L);
        CompletableFuture<Runnable> future2 = new CompletableFuture<Runnable>();
        ReadAction.nonBlocking(() -> {
            this.waitForCommit(commitDeadline);
            Runnable runnable2 = (Runnable)ProgressManager.getInstance().computePrioritized(() -> {
                try {
                    return this.myTextEditor.loadEditorInBackground();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    Logger.getInstance(AsyncEditorLoader.class).error("Error during async editor loading", (Throwable)e);
                    return null;
                }
            });
            future2.complete(runnable2);
            return runnable2;
        }).expireWith((Disposable)this.myEditorComponent).expireWith((Disposable)this.myProject).finishOnUiThread(ModalityState.any(), result2 -> this.loadingFinished((Runnable)result2)).submit((Executor)ourExecutor);
        return future2;
    }

    private void waitForCommit(long commitDeadlineNs) {
        Document document = this.myEditor.getDocument();
        PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)this.myProject);
        if (!pdm.isCommitted(document) && System.nanoTime() < commitDeadlineNs) {
            Semaphore semaphore = new Semaphore(1);
            pdm.performForCommittedDocument(document, () -> ((Semaphore)semaphore).up());
            while (System.nanoTime() < commitDeadlineNs && !semaphore.waitFor(10L)) {
                ProgressManager.checkCanceled();
            }
        }
    }

    private boolean isDone() {
        return this.myLoadingFinished.get();
    }

    private boolean worthWaiting() {
        return !PsiDocumentManager.getInstance((Project)this.myProject).hasUncommitedDocuments() && !ApplicationManager.getApplication().isWriteAccessAllowed() && !EditorsSplitters.isOpenedInBulk(this.myTextEditor.myFile);
    }

    private static <T> T resultInTimeOrNull(@NotNull Future<T> future2) {
        if (future2 == null) {
            AsyncEditorLoader.$$$reportNull$$$0(3);
        }
        try {
            return future2.get(200L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException exception) {
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private void loadingFinished(Runnable continuation) {
        if (!this.myLoadingFinished.compareAndSet(false, true)) {
            return;
        }
        this.myEditor.putUserData(ASYNC_LOADER, null);
        if (this.myEditorComponent.isDisposed()) {
            return;
        }
        if (continuation != null) {
            continuation.run();
        }
        this.myEditorComponent.loadingFinished();
        if (this.myDelayedState != null && PsiDocumentManager.getInstance((Project)this.myProject).isCommitted(this.myEditor.getDocument())) {
            TextEditorState state = new TextEditorState();
            state.RELATIVE_CARET_POSITION = Integer.MAX_VALUE;
            state.setFoldingState(this.myDelayedState.getFoldingState());
            this.myProvider.setStateImpl(this.myProject, this.myEditor, state, true);
            this.myDelayedState = null;
        }
        for (Runnable runnable2 : this.myDelayedActions) {
            this.myEditor.getScrollingModel().disableAnimation();
            runnable2.run();
        }
        this.myDelayedActions.clear();
        this.myEditor.getScrollingModel().enableAnimation();
        if (FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor() == this.myEditor) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocusInProject((Component)this.myTextEditor.getPreferredFocusedComponent(), this.myProject);
        }
        EditorNotifications.getInstance((Project)this.myProject).updateNotifications(this.myTextEditor.myFile);
    }

    public static void performWhenLoaded(@NotNull Editor editor, @NotNull Runnable runnable2) {
        if (editor == null) {
            AsyncEditorLoader.$$$reportNull$$$0(4);
        }
        if (runnable2 == null) {
            AsyncEditorLoader.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        AsyncEditorLoader loader = (AsyncEditorLoader)editor.getUserData(ASYNC_LOADER);
        if (loader == null) {
            runnable2.run();
        } else {
            loader.myDelayedActions.add(runnable2);
        }
    }

    @NotNull
    TextEditorState getEditorState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            AsyncEditorLoader.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        TextEditorState state = this.myProvider.getStateImpl(this.myProject, this.myEditor, level);
        if (!this.isDone() && this.myDelayedState != null) {
            state.setDelayedFoldState(this.myDelayedState::getFoldingState);
        }
        TextEditorState textEditorState = state;
        if (textEditorState == null) {
            AsyncEditorLoader.$$$reportNull$$$0(7);
        }
        return textEditorState;
    }

    void setEditorState(@NotNull TextEditorState state, boolean exactState) {
        if (state == null) {
            AsyncEditorLoader.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.isDone()) {
            this.myDelayedState = state;
        }
        this.myProvider.setStateImpl(this.myProject, this.myEditor, state, exactState);
    }

    public static boolean isEditorLoaded(@NotNull Editor editor) {
        if (editor == null) {
            AsyncEditorLoader.$$$reportNull$$$0(9);
        }
        return editor.getUserData(ASYNC_LOADER) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resultInTimeOrNull";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performWhenLoaded";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEditorState";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setEditorState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEditorLoaded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

