/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.richcopy.SyntaxInfoBuilder;
import com.intellij.openapi.editor.richcopy.model.SyntaxInfo;
import com.intellij.openapi.editor.richcopy.view.HtmlSyntaxInfoReader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HtmlSyntaxInfoUtil {
    @Nullable
    public static CharSequence getHtmlContent(@NotNull PsiFile file2, @NotNull CharSequence text2, @Nullable SyntaxInfoBuilder.RangeIterator ownRangeIterator, @NotNull EditorColorsScheme schemeToUse, int startOffset, int endOffset) {
        if (file2 == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(1);
        }
        if (schemeToUse == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(2);
        }
        EditorHighlighter highlighter = HighlighterFactory.createHighlighter((VirtualFile)file2.getViewProvider().getVirtualFile(), (EditorColorsScheme)schemeToUse, (Project)file2.getProject());
        highlighter.setText(text2);
        SyntaxInfoBuilder.HighlighterRangeIterator highlighterRangeIterator = new SyntaxInfoBuilder.HighlighterRangeIterator(highlighter, startOffset, endOffset);
        ownRangeIterator = ownRangeIterator == null ? highlighterRangeIterator : new SyntaxInfoBuilder.CompositeRangeIterator(schemeToUse, highlighterRangeIterator, ownRangeIterator);
        return HtmlSyntaxInfoUtil.getHtmlContent(text2, ownRangeIterator, schemeToUse, endOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static CharSequence getHtmlContent(@NotNull CharSequence text2, @NotNull SyntaxInfoBuilder.RangeIterator ownRangeIterator, @NotNull EditorColorsScheme schemeToUse, int stopOffset) {
        if (text2 == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(3);
        }
        if (ownRangeIterator == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(4);
        }
        if (schemeToUse == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(5);
        }
        SyntaxInfoBuilder.Context context = new SyntaxInfoBuilder.Context(text2, schemeToUse, 0);
        SyntaxInfoBuilder.MyMarkupIterator iterator2 = new SyntaxInfoBuilder.MyMarkupIterator(text2, ownRangeIterator, schemeToUse);
        try {
            context.iterate(iterator2, stopOffset);
        }
        finally {
            iterator2.dispose();
        }
        SyntaxInfo info = context.finish();
        try (SimpleHtmlSyntaxInfoReader data2 = new SimpleHtmlSyntaxInfoReader(info);){
            data2.setRawText(text2.toString());
            CharSequence charSequence = data2.getBuffer();
            return charSequence;
        }
        catch (IOException e) {
            Logger.getInstance(HtmlSyntaxInfoUtil.class).error((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "schemeToUse";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "ownRangeIterator";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/editor/richcopy/HtmlSyntaxInfoUtil";
        objectArray[2] = "getHtmlContent";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class SimpleHtmlSyntaxInfoReader
    extends HtmlSyntaxInfoReader {
        public SimpleHtmlSyntaxInfoReader(SyntaxInfo info) {
            super(info, 2);
        }

        @Override
        protected void appendCloseTags() {
        }

        @Override
        protected void appendStartTags() {
        }

        @Override
        protected void defineBackground(int id2, @NotNull StringBuilder styleBuffer) {
            if (styleBuffer == null) {
                SimpleHtmlSyntaxInfoReader.$$$reportNull$$$0(0);
            }
        }

        @Override
        protected void appendFontFamilyRule(@NotNull StringBuilder styleBuffer, int fontFamilyId) {
            if (styleBuffer == null) {
                SimpleHtmlSyntaxInfoReader.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "styleBuffer";
            objectArray2[1] = "com/intellij/openapi/editor/richcopy/HtmlSyntaxInfoUtil$SimpleHtmlSyntaxInfoReader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "defineBackground";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendFontFamilyRule";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

