/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir;

import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffModel;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.ide.diff.VirtualFileDiffElement;
import com.intellij.openapi.diff.DirDiffManager;
import com.intellij.openapi.diff.impl.dir.DirDiffDialog;
import com.intellij.openapi.diff.impl.dir.DirDiffFrame;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirDiffManagerImpl
extends DirDiffManager {
    private final Project myProject;

    public DirDiffManagerImpl(Project project) {
        this.myProject = project;
    }

    public void showDiff(@NotNull DiffElement dir1, @NotNull DiffElement dir2, DirDiffSettings settings, @Nullable Runnable onWindowClosing) {
        if (dir1 == null) {
            DirDiffManagerImpl.$$$reportNull$$$0(0);
        }
        if (dir2 == null) {
            DirDiffManagerImpl.$$$reportNull$$$0(1);
        }
        DirDiffTableModel model = new DirDiffTableModel(this.myProject, dir1, dir2, settings);
        if (settings.showInFrame) {
            DirDiffFrame frame = new DirDiffFrame(this.myProject, model);
            this.setWindowListener(onWindowClosing, frame.getFrame());
            frame.show();
        } else {
            DirDiffDialog dirDiffDialog = new DirDiffDialog(this.myProject, model);
            if (this.myProject == null || this.myProject.isDefault()) {
                dirDiffDialog.setModal(true);
            }
            this.setWindowListener(onWindowClosing, dirDiffDialog.getOwner());
            dirDiffDialog.show();
        }
    }

    public static boolean isFromModalDialog(Project project) {
        Component owner = IdeFocusManager.getInstance((Project)project).getFocusOwner();
        if (owner != null) {
            DialogWrapper instance = DialogWrapper.findInstance((Component)owner);
            return instance != null && instance.isModal();
        }
        return false;
    }

    private void setWindowListener(final Runnable onWindowClosing, final Window window) {
        if (onWindowClosing != null) {
            window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    onWindowClosing.run();
                    window.removeWindowListener(this);
                }
            });
        }
    }

    public void showDiff(@NotNull DiffElement dir1, @NotNull DiffElement dir2, DirDiffSettings settings) {
        if (dir1 == null) {
            DirDiffManagerImpl.$$$reportNull$$$0(2);
        }
        if (dir2 == null) {
            DirDiffManagerImpl.$$$reportNull$$$0(3);
        }
        this.showDiff(dir1, dir2, settings, null);
    }

    public void showDiff(@NotNull DiffElement dir1, @NotNull DiffElement dir2) {
        if (dir1 == null) {
            DirDiffManagerImpl.$$$reportNull$$$0(4);
        }
        if (dir2 == null) {
            DirDiffManagerImpl.$$$reportNull$$$0(5);
        }
        this.showDiff(dir1, dir2, new DirDiffSettings());
    }

    public boolean canShow(@NotNull DiffElement dir1, @NotNull DiffElement dir2) {
        if (dir1 == null) {
            DirDiffManagerImpl.$$$reportNull$$$0(6);
        }
        if (dir2 == null) {
            DirDiffManagerImpl.$$$reportNull$$$0(7);
        }
        return dir1.isContainer() && dir2.isContainer();
    }

    public DiffElement createDiffElement(Object obj) {
        if (obj instanceof VirtualFile) {
            return VirtualFileDiffElement.createElement((VirtualFile)obj);
        }
        return null;
    }

    public DirDiffModel createDiffModel(DiffElement e1, DiffElement e2, DirDiffSettings settings) {
        DirDiffTableModel newModel = new DirDiffTableModel(this.myProject, e1, e2, settings);
        newModel.reloadModelSynchronously();
        return newModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir1";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/diff/impl/dir/DirDiffManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showDiff";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "canShow";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

