/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.ModelScopeItemView;
import com.intellij.analysis.dialog.CustomScopeItem;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.analysis.dialog.ModelScopeItemPresenter;
import com.intellij.analysis.dialog.ModuleScopeItem;
import com.intellij.analysis.dialog.OtherScopeItem;
import com.intellij.analysis.dialog.ProjectScopeItem;
import com.intellij.analysis.dialog.VcsScopeItem;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.find.FindSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.util.RadioUpDownListener;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseAnalysisActionDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(BaseAnalysisActionDialog.class);
    @NotNull
    private final AnalysisUIOptions myOptions;
    private final boolean myRememberScope;
    private final boolean myShowInspectTestSource;
    private final String myAnalysisNoon;
    private final Project myProject;
    private final ButtonGroup myGroup;
    private final JCheckBox myInspectTestSource;
    private final List<ModelScopeItemView> myViewItems;

    @Deprecated
    public BaseAnalysisActionDialog(@NotNull String title, @NotNull String analysisNoon, @NotNull Project project, @NotNull AnalysisScope scope, String moduleName, boolean rememberScope, @NotNull AnalysisUIOptions analysisUIOptions, @Nullable PsiElement context) {
        if (title == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(0);
        }
        if (analysisNoon == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(1);
        }
        if (project == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(3);
        }
        if (analysisUIOptions == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(4);
        }
        this(title, analysisNoon, project, BaseAnalysisActionDialog.standardItems(project, scope, moduleName != null ? ModuleManager.getInstance((Project)project).findModuleByName(moduleName) : null, context), analysisUIOptions, rememberScope);
    }

    @NotNull
    public static List<ModelScopeItem> standardItems(@NotNull Project project, @NotNull AnalysisScope scope, @Nullable Module module, @Nullable PsiElement context) {
        if (project == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(6);
        }
        List<ModelScopeItem> list2 = Stream.of(new ProjectScopeItem(project), new CustomScopeItem(project, context), VcsScopeItem.createIfHasVCS(project), ModuleScopeItem.tryCreate(module), OtherScopeItem.tryCreate(scope)).filter(x -> x != null).collect(Collectors.toList());
        if (list2 == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(7);
        }
        return list2;
    }

    public BaseAnalysisActionDialog(@NotNull String title, @NotNull String analysisNoon, @NotNull Project project, @NotNull List<? extends ModelScopeItem> items, @NotNull AnalysisUIOptions options, boolean rememberScope) {
        if (title == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(8);
        }
        if (analysisNoon == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(9);
        }
        if (project == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(10);
        }
        if (items == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(11);
        }
        if (options == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(12);
        }
        this(title, analysisNoon, project, items, options, rememberScope, ModuleUtil.hasTestSourceRoots((Project)project));
    }

    public BaseAnalysisActionDialog(@NotNull String title, @NotNull String analysisNoon, @NotNull Project project, @NotNull List<? extends ModelScopeItem> items, @NotNull AnalysisUIOptions options, boolean rememberScope, boolean showInspectTestSource) {
        if (title == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(13);
        }
        if (analysisNoon == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(14);
        }
        if (project == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(15);
        }
        if (items == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(16);
        }
        if (options == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(17);
        }
        super(true);
        this.myGroup = new ButtonGroup();
        this.myInspectTestSource = new JCheckBox();
        this.myAnalysisNoon = analysisNoon;
        this.myProject = project;
        this.myViewItems = ModelScopeItemPresenter.createOrderedViews(items);
        this.myOptions = options;
        this.myRememberScope = rememberScope;
        this.myShowInspectTestSource = showInspectTestSource;
        this.init();
        this.setTitle(title);
    }

    protected JComponent createCenterPanel() {
        BorderLayoutPanel panel2 = new BorderLayoutPanel();
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(this.myAnalysisNoon);
        panel2.addToTop((Component)titledSeparator);
        JPanel scopesPanel = new JPanel(new GridBagLayout());
        panel2.addToCenter((Component)scopesPanel);
        int maxColumns = this.myViewItems.stream().mapToInt(x -> x.additionalComponents.size()).max().orElse(0) + 1;
        int gridY = 0;
        JRadioButton[] buttons = new JRadioButton[this.myViewItems.size()];
        GridBagConstraints gbc = new GridBagConstraints();
        for (ModelScopeItemView x2 : this.myViewItems) {
            JRadioButton button2 = x2.button;
            List<JComponent> components = x2.additionalComponents;
            int gridX = 0;
            buttons[gridY] = button2;
            this.myGroup.add(button2);
            int countExtraColumns = components.size();
            gbc.gridy = gridY;
            gbc.gridx = gridX;
            gbc.gridwidth = countExtraColumns == 0 ? maxColumns : 1;
            gbc.weightx = 0.0;
            gbc.fill = 0;
            gbc.anchor = 17;
            gbc.insets = JBUI.insetsLeft((int)10);
            scopesPanel.add((Component)button2, gbc);
            ++gridX;
            for (JComponent c : components) {
                if (c instanceof Disposable) {
                    Disposer.register((Disposable)this.myDisposable, (Disposable)((Disposable)c));
                }
                gbc.gridy = gridY;
                gbc.gridx = gridX++;
                gbc.gridwidth = 1;
                gbc.weightx = 1.0;
                gbc.fill = 2;
                gbc.anchor = 13;
                gbc.insets = JBUI.insetsLeft((int)5);
                scopesPanel.add((Component)c, gbc);
            }
            ++gridY;
        }
        this.myInspectTestSource.setText(CodeInsightBundle.message((String)"scope.option.include.test.sources", (Object[])new Object[0]));
        this.myInspectTestSource.setSelected(this.myOptions.ANALYZE_TEST_SOURCES);
        this.myInspectTestSource.setVisible(this.myShowInspectTestSource);
        gbc.gridy = gridY;
        gbc.gridx = 0;
        gbc.gridwidth = maxColumns;
        gbc.weightx = 1.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = JBUI.insetsLeft((int)10);
        scopesPanel.add((Component)this.myInspectTestSource, gbc);
        this.preselectButton();
        BorderLayoutPanel wholePanel = new BorderLayoutPanel();
        wholePanel.addToTop((Component)panel2);
        JComponent additionalPanel = this.getAdditionalActionSettings(this.myProject);
        if (additionalPanel != null) {
            wholePanel.addToCenter((Component)additionalPanel);
        }
        new RadioUpDownListener(buttons);
        return wholePanel;
    }

    private void preselectButton() {
        int type;
        List preselectedScopes;
        if (this.myRememberScope && (preselectedScopes = ContainerUtil.filter(this.myViewItems, arg_0 -> BaseAnalysisActionDialog.lambda$preselectButton$2(type = this.myOptions.SCOPE_TYPE, arg_0))).size() >= 1) {
            LOG.assertTrue(preselectedScopes.size() == 1, (Object)"preselectedScopes.size() == 1");
            ((ModelScopeItemView)preselectedScopes.get((int)0)).button.setSelected(true);
            return;
        }
        ArrayList<ModelScopeItemView> candidates = new ArrayList<ModelScopeItemView>();
        for (ModelScopeItemView view : this.myViewItems) {
            candidates.add(view);
            if (view.scopeId != 3) continue;
            break;
        }
        Collections.reverse(candidates);
        for (ModelScopeItemView x : candidates) {
            int scopeType = x.scopeId;
            if (scopeType == 8 || scopeType == 10) continue;
            x.button.setSelected(true);
            break;
        }
    }

    public JComponent getPreferredFocusedComponent() {
        Enumeration<AbstractButton> enumeration = this.myGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton button2 = enumeration.nextElement();
            if (!button2.isSelected()) continue;
            return button2;
        }
        return super.getPreferredFocusedComponent();
    }

    @Deprecated
    public AnalysisScope getScope(@NotNull AnalysisUIOptions uiOptions, @NotNull AnalysisScope defaultScope, @NotNull Project project, Module module) {
        if (uiOptions == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(18);
        }
        if (defaultScope == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(19);
        }
        if (project == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(20);
        }
        return this.getScope(defaultScope);
    }

    public boolean isProjectScopeSelected() {
        return this.myViewItems.stream().filter(x -> x.scopeId == 1).findFirst().map(x -> x.button.isSelected()).orElse(false);
    }

    public boolean isModuleScopeSelected() {
        return this.myViewItems.stream().filter(x -> x.scopeId == 4).findFirst().map(x -> x.button.isSelected()).orElse(false);
    }

    public boolean isUncommittedFilesSelected() {
        return this.myViewItems.stream().filter(x -> x.scopeId == 10).findFirst().map(x -> x.button.isSelected()).orElse(false);
    }

    @Nullable
    public SearchScope getCustomScope() {
        return this.myViewItems.stream().filter(x -> x.scopeId == 8 && x.button.isSelected()).findFirst().map(x -> x.model.getScope().toSearchScope()).orElse(null);
    }

    public boolean isInspectTestSources() {
        return this.myInspectTestSource.isSelected();
    }

    public AnalysisScope getScope(@NotNull AnalysisScope defaultScope) {
        if (defaultScope == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(21);
        }
        AnalysisScope scope = null;
        for (ModelScopeItemView x : this.myViewItems) {
            if (!x.button.isSelected()) continue;
            int type = x.scopeId;
            scope = x.model.getScope();
            if (!this.myRememberScope) continue;
            this.myOptions.SCOPE_TYPE = type;
            if (type != 8) continue;
            this.myOptions.CUSTOM_SCOPE_NAME = scope.toSearchScope().getDisplayName();
        }
        if (scope == null) {
            scope = defaultScope;
            if (this.myRememberScope) {
                this.myOptions.SCOPE_TYPE = scope.getScopeType();
            }
        }
        if (this.myInspectTestSource.isVisible()) {
            if (this.myRememberScope) {
                this.myOptions.ANALYZE_TEST_SOURCES = this.isInspectTestSources();
            }
            scope.setIncludeTestSource(this.isInspectTestSources());
        }
        FindSettings.getInstance().setDefaultScopeName(scope.getDisplayName());
        return scope;
    }

    @Nullable
    protected JComponent getAdditionalActionSettings(Project project) {
        return null;
    }

    private static /* synthetic */ boolean lambda$preselectButton$2(int type, ModelScopeItemView x) {
        return x.scopeId == type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisNoon";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisUIOptions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/analysis/BaseAnalysisActionDialog";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiOptions";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/analysis/BaseAnalysisActionDialog";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "standardItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "standardItems";
                break;
            }
            case 7: {
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

