/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.vertica.model;

import com.intellij.database.dialects.vertica.model.VertDatabase;
import com.intellij.database.dialects.vertica.model.VertLikeSchema;
import com.intellij.database.dialects.vertica.model.VertRoutine;
import com.intellij.database.dialects.vertica.model.VertSequence;
import com.intellij.database.dialects.vertica.model.VertTable;
import com.intellij.database.dialects.vertica.model.VertView;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.PropertyConverter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface VertSchema
extends VertLikeSchema {
    public static final BasicMetaProperty<Boolean> SYSTEM = BasicMetaProperty.create((String)"System", (BasicMetaType)BasicMetaType.Types.BOOLEAN, (Object)false, VertSchema.class, (boolean)true);
    public static final BasicMetaProperty<String> OWNER = BasicMetaProperty.create((String)"Owner", (BasicMetaType)BasicMetaType.Types.STRING, null, VertSchema.class, (boolean)false);
    public static final BasicMetaProperty<Boolean> INHERIT_PRIVILEGES = BasicMetaProperty.create((String)"InheritPrivileges", (BasicMetaType)BasicMetaType.Types.BOOLEAN, (Object)false, VertSchema.class, (boolean)false);

    @Nullable
    default public VertDatabase getDatabase() {
        return this.getParent();
    }

    @Nullable
    public VertDatabase getParent();

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends VertSchema> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends VertTable> getTables();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends VertView> getViews();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends VertRoutine> getRoutines();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends VertSequence> getSequences();

    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.TABLE, ObjectKind.VIEW, ObjectKind.ROUTINE, ObjectKind.SEQUENCE);
        if (list == null) {
            VertSchema.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getTables(), this.getViews(), this.getRoutines(), this.getSequences());
        if (list == null) {
            VertSchema.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public String getComment();

    public boolean isSystem();

    @Nullable
    public String getOwner();

    public boolean isInheritPrivileges();

    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean inheritPrivileges;
        String owner;
        boolean system;
        boolean current;
        Date introspectionTimestamp;
        boolean outdated;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name2;
        long objectId;
        if (consumer == null) {
            VertSchema.$$$reportNull$$$0(2);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer.accept("ObjectId", (Object)PropertyConverter.export((long)objectId));
        }
        if ((name2 = this.getName()) != null && name2 != ModelConsts.NO_NAME) {
            consumer.accept("Name", (Object)PropertyConverter.export((String)name2));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", (Object)PropertyConverter.export((boolean)nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", (Object)PropertyConverter.export((boolean)nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", (Object)PropertyConverter.export((boolean)nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", (Object)PropertyConverter.export((String)comment));
        }
        if (outdated = this.isOutdated()) {
            consumer.accept("Outdated", (Object)PropertyConverter.export((boolean)outdated));
        }
        if ((introspectionTimestamp = this.getIntrospectionTimestamp()) != null) {
            consumer.accept("IntrospectionTimestamp", (Object)PropertyConverter.export((Date)introspectionTimestamp));
        }
        if (current = this.isCurrent()) {
            consumer.accept("Current", (Object)PropertyConverter.export((boolean)current));
        }
        if (system = this.isSystem()) {
            consumer.accept("System", (Object)PropertyConverter.export((boolean)system));
        }
        if ((owner = this.getOwner()) != null) {
            consumer.accept("Owner", (Object)PropertyConverter.export((String)owner));
        }
        if (inheritPrivileges = this.isInheritPrivileges()) {
            consumer.accept("InheritPrivileges", (Object)PropertyConverter.export((boolean)inheritPrivileges));
        }
    }

    public void setSystem(boolean var1);

    public void setOwner(@Nullable String var1);

    public void setInheritPrivileges(boolean var1);

    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            VertSchema.$$$reportNull$$$0(3);
        }
        String objectId = _properties.get("ObjectId");
        String name2 = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String outdated = _properties.get("Outdated");
        String introspectionTimestamp = _properties.get("IntrospectionTimestamp");
        String current = _properties.get("Current");
        String system = _properties.get("System");
        String owner = _properties.get("Owner");
        String inheritPrivileges = _properties.get("InheritPrivileges");
        this.setObjectId(objectId != null ? PropertyConverter.importLong((String)objectId) : Long.MIN_VALUE);
        this.setName(name2 != null ? PropertyConverter.importString((String)name2) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean((String)nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean((String)nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean((String)nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString((String)comment) : null);
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean((String)outdated) : false);
        this.setIntrospectionTimestamp(introspectionTimestamp != null ? PropertyConverter.importDate((String)introspectionTimestamp) : null);
        this.setCurrent(current != null ? PropertyConverter.importBoolean((String)current) : false);
        this.setSystem(system != null ? PropertyConverter.importBoolean((String)system) : false);
        this.setOwner(owner != null ? PropertyConverter.importString((String)owner) : null);
        this.setInheritPrivileges(inheritPrivileges != null ? PropertyConverter.importBoolean((String)inheritPrivileges) : false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/vertica/model/VertSchema";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/vertica/model/VertSchema";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

