/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.snowflake.model;

import com.intellij.database.dialects.snowflake.model.SFlakeDatabase;
import com.intellij.database.dialects.snowflake.model.SFlakeRoot;
import com.intellij.database.dialects.snowflake.model.SFlakeSchema;
import com.intellij.database.dialects.snowflake.model.SFlakeTask;
import com.intellij.database.dialects.snowflake.model.SFlakeWarehouse;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public interface SFlakeMixinTask {
    default public SFlakeTask getPredecessor() {
        SFlakeDatabase db;
        SFlakeTask self = (SFlakeTask)this;
        String pred = self.getPredecessorRef();
        if (pred == null) {
            return null;
        }
        List split = StringUtil.split((String)pred, (String)".");
        Collections.reverse(split);
        SFlakeSchema sc2 = self.getSchema();
        SFlakeDatabase sFlakeDatabase = db = sc2 == null ? null : sc2.getDatabase();
        if (db == null) {
            return null;
        }
        if (split.size() > 2 && !((String)split.get(2)).equals(db.getName())) {
            db = (SFlakeDatabase)Objects.requireNonNull(db.getParentFamily()).get((String)split.get(2));
            sc2 = null;
        }
        if (!(split.size() <= 1 || sc2 != null && ((String)split.get(1)).equals(sc2.getName()))) {
            sc2 = db == null ? null : (SFlakeSchema)db.getSchemas().get((String)split.get(1));
        }
        return sc2 == null || split.isEmpty() ? null : (SFlakeTask)sc2.getTasks().get((String)split.get(0));
    }

    default public SFlakeWarehouse getWarehouse() {
        SFlakeTask self = (SFlakeTask)this;
        String warehouse = self.getWarehouseRef();
        if (warehouse == null) {
            return null;
        }
        SFlakeSchema sc2 = self.getSchema();
        SFlakeDatabase db = sc2 == null ? null : sc2.getDatabase();
        SFlakeRoot root2 = db == null ? null : db.getRoot();
        return root2 == null ? null : (SFlakeWarehouse)root2.getWarehouses().get(warehouse);
    }
}

