/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.model;

import com.intellij.database.dialects.postgres.model.PgAccessMethod;
import com.intellij.database.dialects.postgres.model.PgExtension;
import com.intellij.database.dialects.postgres.model.PgForeignDataWrapper;
import com.intellij.database.dialects.postgres.model.PgLanguage;
import com.intellij.database.dialects.postgres.model.PgRoot;
import com.intellij.database.dialects.postgres.model.PgSchema;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDatabase;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.properties.PgRelation;
import com.intellij.database.model.properties.PropertyConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PgDatabase
extends PgGPlumBaseDatabase {
    @Override
    @Nullable
    default public PgRoot getRoot() {
        return this.getParent();
    }

    @Override
    @Nullable
    public PgRoot getParent();

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends PgDatabase> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends PgSchema> getSchemas();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends PgForeignDataWrapper> getForeignDataWrappers();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends PgAccessMethod> getAccessMethods();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends PgExtension> getExtensions();

    @NotNull
    public @NotNull ModNamingFamily<@NotNull ? extends PgLanguage> getLanguages();

    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.SCHEMA, ObjectKind.FOREIGN_DATA_WRAPPER, ObjectKind.ACCESS_METHOD, ObjectKind.EXTENSION, ObjectKind.LANGUAGE);
        if (list == null) {
            PgDatabase.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getSchemas(), this.getForeignDataWrappers(), this.getAccessMethods(), this.getExtensions(), this.getLanguages());
        if (list == null) {
            PgDatabase.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public Set<PgRelation> getRelations();

    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        Set<PgRelation> relations;
        boolean current;
        long introspectionStateNumber;
        boolean faceless;
        String owner;
        boolean outdated;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name2;
        long objectId;
        if (consumer == null) {
            PgDatabase.$$$reportNull$$$0(2);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer.accept("ObjectId", (Object)PropertyConverter.export((long)objectId));
        }
        if ((name2 = this.getName()) != null && name2 != ModelConsts.NO_NAME) {
            consumer.accept("Name", (Object)PropertyConverter.export((String)name2));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", (Object)PropertyConverter.export((boolean)nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", (Object)PropertyConverter.export((boolean)nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", (Object)PropertyConverter.export((boolean)nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", (Object)PropertyConverter.export((String)comment));
        }
        if (outdated = this.isOutdated()) {
            consumer.accept("Outdated", (Object)PropertyConverter.export((boolean)outdated));
        }
        if ((owner = this.getOwner()) != null) {
            consumer.accept("Owner", (Object)PropertyConverter.export((String)owner));
        }
        if (faceless = this.isFaceless()) {
            consumer.accept("Faceless", (Object)PropertyConverter.export((boolean)faceless));
        }
        if ((introspectionStateNumber = this.getIntrospectionStateNumber()) != 0L) {
            consumer.accept("IntrospectionStateNumber", (Object)PropertyConverter.export((long)introspectionStateNumber));
        }
        if (current = this.isCurrent()) {
            consumer.accept("Current", (Object)PropertyConverter.export((boolean)current));
        }
        if (!(relations = this.getRelations()).isEmpty()) {
            consumer.accept("Relations", (Object)PropertyConverter.exportSetOfPgRelation(relations));
        }
    }

    @Override
    public void setRelations(@NotNull Set<PgRelation> var1);

    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            PgDatabase.$$$reportNull$$$0(3);
        }
        String objectId = _properties.get("ObjectId");
        String name2 = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String outdated = _properties.get("Outdated");
        String owner = _properties.get("Owner");
        String faceless = _properties.get("Faceless");
        String introspectionStateNumber = _properties.get("IntrospectionStateNumber");
        String current = _properties.get("Current");
        String relations = _properties.get("Relations");
        this.setObjectId(objectId != null ? PropertyConverter.importLong((String)objectId) : Long.MIN_VALUE);
        this.setName(name2 != null ? PropertyConverter.importString((String)name2) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean((String)nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean((String)nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean((String)nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString((String)comment) : null);
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean((String)outdated) : false);
        this.setOwner(owner != null ? PropertyConverter.importString((String)owner) : null);
        this.setFaceless(faceless != null ? PropertyConverter.importBoolean((String)faceless) : false);
        this.setIntrospectionStateNumber(introspectionStateNumber != null ? PropertyConverter.importLong((String)introspectionStateNumber) : 0L);
        this.setCurrent(current != null ? PropertyConverter.importBoolean((String)current) : false);
        this.setRelations(relations != null ? PropertyConverter.importSetOfPgRelation((String)relations) : Collections.emptySet());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgres/model/PgDatabase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgres/model/PgDatabase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

