/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hsql;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;

public class HsqlDomains
extends DomainRegistry {
    private static final int MAX_VARCHAR = 8000;
    private static final int MAX_FRACTION = 6;
    private static final int MAX_CHAR = 255;

    public HsqlDomains() {
        this.add((Domain)new Number2Domain("numeric", ConversionPoint.BIG_DECIMAL, Integer.MAX_VALUE, Integer.MAX_VALUE, true));
        this.add((Domain)new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, Integer.MAX_VALUE, Integer.MAX_VALUE, true));
        this.add((Domain)new BinaryDomain("binary", ConversionPoint.BINARY, 8000L, -1L, true));
        this.add((Domain)new BinaryDomain("blob", ConversionPoint.BLOB, Integer.MAX_VALUE));
        this.add((Domain)new BinaryDomain("varbinary", ConversionPoint.VARBINARY, 8000L, TextDomain.Length.mandatory((long)8000L)));
        this.add((Domain)new BooleanDomain("bit", ConversionPoint.BOOLEAN));
        this.add((Domain)new BooleanDomain("boolean", ConversionPoint.BOOLEAN));
        this.add((Domain)new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add((Domain)new IntegerDomain("tinyint", ConversionPoint.NUMBER, -128.0, 127.0));
        this.add((Domain)new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38));
        this.add((Domain)new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add((Domain)new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add((Domain)new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE));
        this.add((Domain)new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 6, -1, true));
        this.add((Domain)new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 6, -1, true));
        this.add((Domain)new TextDomain("clob", ConversionPoint.CLOB, Integer.MAX_VALUE, -1L, true));
        this.add((Domain)new TextDomain("longvarchar", ConversionPoint.TEXT, Integer.MAX_VALUE, -1L, true));
        this.add((Domain)new TextDomain("char", ConversionPoint.CHAR, 255L, 1L, true));
        this.add((Domain)new TextDomain("character", ConversionPoint.CHAR, 255L, 1L, true));
        this.add((Domain)new TextDomain("varchar", ConversionPoint.VARCHAR, 32767L, TextDomain.Length.mandatory((long)32767L)));
        this.add((Domain)new TextDomain("character varying", ConversionPoint.VARCHAR, 32767L, -1L, true));
    }
}

