/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hive.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.SimpleSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.jdbc.JdbcIntrospector;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.hive.introspector.HiveIntrospector;
import com.intellij.database.dialects.hive.introspector.HiveIntrospector$HiveSchemaRetriever$retrieveIndices$;
import com.intellij.database.dialects.hive.introspector.HiveIntrospector$HiveSchemaRetriever$retrieveTablesDetailedInfo$;
import com.intellij.database.dialects.hive.introspector.HiveIntrospector$retrieveFunctions$1$1$$special$;
import com.intellij.database.dialects.hive.introspector.HiveIntrospector$retrieveRoles$1$$special$;
import com.intellij.database.dialects.hive.model.HiveForeignKey;
import com.intellij.database.dialects.hive.model.HiveFunction;
import com.intellij.database.dialects.hive.model.HiveFunctionBase;
import com.intellij.database.dialects.hive.model.HiveIndex;
import com.intellij.database.dialects.hive.model.HiveLikeTable;
import com.intellij.database.dialects.hive.model.HiveMacro;
import com.intellij.database.dialects.hive.model.HiveMatView;
import com.intellij.database.dialects.hive.model.HivePersistentFunction;
import com.intellij.database.dialects.hive.model.HiveRole;
import com.intellij.database.dialects.hive.model.HiveRoot;
import com.intellij.database.dialects.hive.model.HiveSchema;
import com.intellij.database.dialects.hive.model.HiveTable;
import com.intellij.database.dialects.hive.model.HiveTableColumn;
import com.intellij.database.dialects.hive.model.HiveView;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.properties.HiveTableColumnSortingOrder;
import com.intellij.database.model.properties.HiveTableColumnType;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.sql.database.SqlObjectBuilder;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 J2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0003JKLB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J4\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u00020\u0016R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0014J\u001c\u0010\u001b\u001a\u00060\u001cR\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0003H\u0014J,\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u00132\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\f0!H\u0002J\"\u0010\"\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u0013H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J1\u0010&\u001a\u0004\u0018\u0001H'\"\b\b\u0000\u0010'*\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u00132\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H'0+H\u0002\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020\fH\u0014JH\u0010.\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000e2\u000e\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u000201002\u000e\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u000203002\u0006\u00104\u001a\u00020\u00132\u0006\u00105\u001a\u00020\u00132\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\f2\u0006\u00109\u001a\u00020\u0019H\u0014J\u0018\u0010:\u001a\u00020\f2\u0006\u00109\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u001e\u0010;\u001a\u00020\f2\u0006\u00109\u001a\u00020\u00192\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00030=H\u0014J\b\u0010>\u001a\u00020\fH\u0016J\u0010\u0010?\u001a\u0002072\u0006\u00104\u001a\u00020\u0013H\u0002J\u0012\u0010@\u001a\u0004\u0018\u00010\u00132\u0006\u0010A\u001a\u00020BH\u0002J\b\u0010C\u001a\u00020\fH\u0016J\u001e\u0010D\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000e2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00130=H\u0002J&\u0010F\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010G\u001a\u00020\u00022\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00030=H\u0002J\b\u0010H\u001a\u00020\fH\u0002J\u0010\u0010I\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/intellij/database/dialects/hive/introspector/HiveIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/hive/model/HiveRoot;", "Lcom/intellij/database/dialects/hive/model/HiveSchema;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/ModelFactory;)V", "genericIntrospector", "Lcom/intellij/database/dialects/base/introspector/jdbc/JdbcIntrospector;", "attachToDB", "", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "buildObject", "obj", "Lcom/intellij/database/model/DasObject;", "type", "", "dbConnection", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/hive/introspector/HiveIntrospector$HiveSchemaRetriever;", "schema", "forEachNotNullLine", "statement", "processor", "Lkotlin/Function1;", "getDdl", "name", "getMetadata", "Lcom/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper;", "getStatement", "T", "Lcom/intellij/sql/psi/SqlStatement;", "sql", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Lcom/intellij/sql/psi/SqlStatement;", "initModelRelatedState", "introspectFunction", "funcFamily", "Lcom/intellij/database/model/families/ModNamingFamily;", "Lcom/intellij/database/dialects/hive/model/HiveFunctionBase;", "macroFamily", "Lcom/intellij/database/dialects/hive/model/HiveMacro;", "funcName", "qualifiedFuncName", "isBuiltin", "", "introspectNamespacesInTran", "tran", "introspectOneSchema", "introspectSchemasAuto", "schemas", "", "introspectServerObjects", "isSystemFunction", "joinRows", "resultSet", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "retrieveAndApplySchemas", "retrieveFunctions", "schemaNames", "retrieveFunctionsInner", "root", "retrieveRoles", "retrieveSchemasDetailedInfo", "Companion", "Factory", "HiveSchemaRetriever", "intellij.database.dialects.hive"})
public final class HiveIntrospector
extends BaseSingleDatabaseIntrospector<HiveRoot, HiveSchema> {
    private final JdbcIntrospector genericIntrospector;
    private static final String FUNCTION_CLASS = "Function class:";
    private static final Set<String> IGNORED_FUNCTIONS;
    @NotNull
    private static final Set<String> IGNORED_PROPERTIES;
    private static final Map<String, Function4<HiveLikeTable, String, String, String, Unit>> viewProcessors;
    private static final Map<String, Function4<HiveTable, String, String, String, Unit>> tableProcessors;
    public static final Companion Companion;

    @Override
    protected void initModelRelatedState() {
        this.genericIntrospector.init(this.getModel());
    }

    @Override
    public void attachToDB(@NotNull DatabaseConnection connection) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        super.attachToDB(connection);
        this.genericIntrospector.attachToDB(connection);
    }

    @Override
    public void retrieveAndApplySchemas() {
        block0: {
            this.genericIntrospector.introspectDatabaseSchemas(new BasicDatabase[0]);
            DatabaseConnection databaseConnection = this.getDbConnection();
            if (databaseConnection == null) break block0;
            DatabaseConnection databaseConnection2 = databaseConnection;
            boolean bl = false;
            boolean bl2 = false;
            DatabaseConnection it = databaseConnection2;
            boolean bl3 = false;
            this.retrieveSchemasDetailedInfo(it);
        }
    }

    private final DatabaseMetaDataWrapper getMetadata(DatabaseConnection dbConnection) {
        RemoteConnection remoteConnection = dbConnection.getRemoteConnection();
        Intrinsics.checkExpressionValueIsNotNull((Object)remoteConnection, (String)"dbConnection.remoteConnection");
        RemoteDatabaseMetaData metaData = remoteConnection.getMetaData();
        DatabaseMetaDataWrapper databaseMetaDataWrapper = DatabaseMetaDataWrapper.create(dbConnection, metaData).withErrorSink(this.getErrorSink());
        Intrinsics.checkExpressionValueIsNotNull((Object)databaseMetaDataWrapper, (String)"DatabaseMetaDataWrapper.\u2026.withErrorSink(errorSink)");
        return databaseMetaDataWrapper;
    }

    private final void retrieveSchemasDetailedInfo(DatabaseConnection dbConnection) {
        this.inModel((Function1)new Function1<HiveRoot, Unit>(this, dbConnection){
            final /* synthetic */ HiveIntrospector this$0;
            final /* synthetic */ DatabaseConnection $dbConnection;

            public final void invoke(@NotNull HiveRoot root2) {
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                for (HiveSchema schema : root2.getSchemas()) {
                    SimpleSmartStatement simpleSmartStatement = SmartStatements.Companion.poweredBy(this.$dbConnection).simple(Configuration.Companion.sourced(SmartStatements.Source.SYSTEM));
                    StringBuilder stringBuilder = new StringBuilder().append("describe schema extended `");
                    HiveSchema hiveSchema = schema;
                    Intrinsics.checkExpressionValueIsNotNull((Object)hiveSchema, (String)"schema");
                    simpleSmartStatement.execute((Object)stringBuilder.append(hiveSchema.getName()).append('`').toString(), StandardResultsProcessors.resultsTransformer((Function1)((Function1)new Function1<RemoteResultSet, Unit>(schema){
                        final /* synthetic */ HiveSchema $schema;

                        public final void invoke(@NotNull RemoteResultSet rs) {
                            Intrinsics.checkParameterIsNotNull((Object)rs, (String)"rs");
                            if (!rs.next()) {
                                return;
                            }
                            HiveSchema hiveSchema = this.$schema;
                            Intrinsics.checkExpressionValueIsNotNull((Object)hiveSchema, (String)"schema");
                            hiveSchema.setComment(rs.getString(2));
                            HiveSchema hiveSchema2 = this.$schema;
                            Intrinsics.checkExpressionValueIsNotNull((Object)hiveSchema2, (String)"schema");
                            hiveSchema2.setLocation(rs.getString(3));
                        }
                        {
                            this.$schema = hiveSchema;
                            super(1);
                        }
                    })));
                    HiveIntrospector.access$buildObject(this.this$0, (DasObject)schema, "schema", this.$dbConnection);
                }
            }
            {
                this.this$0 = hiveIntrospector;
                this.$dbConnection = databaseConnection;
                super(1);
            }
        });
    }

    private final void buildObject(DasObject obj2, String type, DatabaseConnection dbConnection) {
        String string = obj2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"obj.name");
        String ddl = this.getDdl(dbConnection, type, string);
        SqlCreateStatement sqlCreateStatement = this.getStatement(ddl, SqlCreateStatement.class);
        if (sqlCreateStatement == null) {
            return;
        }
        SqlCreateStatement statement = sqlCreateStatement;
        this.getSqlHelper().getBuilder().build(obj2, (DasObject)statement, SqlObjectBuilder.Context.INTROSPECTOR);
    }

    private final String getDdl(DatabaseConnection dbConnection, String type, String name2) {
        return (String)SmartStatements.Companion.poweredBy(dbConnection).simple(Configuration.Companion.sourced(SmartStatements.Source.SYSTEM)).execute((Object)("show create " + type + " `" + name2 + '`'), StandardResultsProcessors.resultsTransformer((Function1)((Function1)new Function1<RemoteResultSet, String>(this){
            final /* synthetic */ HiveIntrospector this$0;

            @Nullable
            public final String invoke(@NotNull RemoteResultSet resultSet) {
                Intrinsics.checkParameterIsNotNull((Object)resultSet, (String)"resultSet");
                return HiveIntrospector.access$joinRows(this.this$0, resultSet);
            }
            {
                this.this$0 = hiveIntrospector;
                super(1);
            }
        }))).rightOr(null);
    }

    private final <T extends SqlStatement> T getStatement(String sql, Class<T> clazz) {
        if (sql == null) {
            return null;
        }
        try {
            return (T)((SqlStatement)this.getSqlHelper().statements(sql, clazz).first());
        }
        catch (Exception e) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isUnitTestMode()) {
                this.getLog().error((Throwable)e);
            }
            this.getLog().warn("Failed to parse sources", (Throwable)e);
            return null;
        }
    }

    private final String joinRows(RemoteResultSet resultSet) {
        StringBuilder sb = new StringBuilder();
        while (resultSet.next()) {
            sb.append(resultSet.getString(1)).append("\n");
        }
        resultSet.close();
        CharSequence charSequence = sb;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends HiveSchema> schemas2) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull(schemas2, (String)"schemas");
        for (HiveSchema hiveSchema : schemas2) {
            this.introspectOneSchema(tran, hiveSchema);
        }
        DatabaseConnection databaseConnection = this.getDbConnection();
        if (databaseConnection == null) {
            return;
        }
        DatabaseConnection databaseConnection2 = databaseConnection;
        Iterable iterable = schemas2;
        DatabaseConnection databaseConnection3 = databaseConnection2;
        HiveIntrospector hiveIntrospector = this;
        boolean $i$f$map = false;
        void var6_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HiveSchema hiveSchema = (HiveSchema)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        hiveIntrospector.retrieveFunctions(databaseConnection3, (List<String>)collection);
    }

    /*
     * WARNING - void declaration
     */
    private final void retrieveFunctions(DatabaseConnection dbConnection, List<String> schemaNames2) {
        void this_$iv;
        BaseIntrospector baseIntrospector = this;
        String operationName$iv = "Introspecting functions";
        boolean $i$f$handleErrors = false;
        try {
            boolean bl = false;
            this.inModel((Function1)new Function1<HiveRoot, Unit>(this, schemaNames2, dbConnection){
                final /* synthetic */ HiveIntrospector this$0;
                final /* synthetic */ List $schemaNames$inlined;
                final /* synthetic */ DatabaseConnection $dbConnection$inlined;
                {
                    this.this$0 = hiveIntrospector;
                    this.$schemaNames$inlined = list;
                    this.$dbConnection$inlined = databaseConnection;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull HiveRoot root2) {
                    HiveSchema schema;
                    void $this$mapNotNullTo$iv$iv;
                    Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                    Iterable $this$mapNotNull$iv = this.$schemaNames$inlined;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        HiveSchema hiveSchema;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        String it = (String)element$iv$iv;
                        boolean bl2 = false;
                        if ((HiveSchema)root2.getSchemas().get(it) == null) continue;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        HiveSchema it$iv$iv = hiveSchema;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List schemas2 = (List)destination$iv$iv;
                    boolean $i$f$cleanupFamilies = false;
                    Function1 it = retrieveFunctions$1$1$$special$$inlined$cleanupFamilies$1.INSTANCE;
                    boolean bl = false;
                    ModNamingFamily<? extends HiveFunction> modNamingFamily = root2.getFunctions();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"root.functions");
                    it.invoke(modNamingFamily);
                    ModNamingFamily<? extends HiveMacro> modNamingFamily2 = root2.getMacros();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingFamily2, (String)"root.macros");
                    it.invoke(modNamingFamily2);
                    Iterable $this$forEach$iv = schemas2;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv : $this$forEach$iv) {
                        schema = (HiveSchema)element$iv;
                        boolean bl6 = false;
                        ModNamingFamily<? extends HivePersistentFunction> modNamingFamily3 = schema.getFunctions();
                        Intrinsics.checkExpressionValueIsNotNull(modNamingFamily3, (String)"schema.functions");
                        it.invoke(modNamingFamily3);
                    }
                    boolean bl7 = false;
                    HiveIntrospector.access$retrieveFunctionsInner(this.this$0, this.$dbConnection$inlined, root2, schemas2);
                    it = retrieveFunctions$1$1$$special$$inlined$cleanupFamilies$2.INSTANCE;
                    bl = false;
                    ModNamingFamily<? extends HiveFunction> modNamingFamily4 = root2.getFunctions();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingFamily4, (String)"root.functions");
                    it.invoke(modNamingFamily4);
                    ModNamingFamily<? extends HiveMacro> modNamingFamily5 = root2.getMacros();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingFamily5, (String)"root.macros");
                    it.invoke(modNamingFamily5);
                    $this$forEach$iv = schemas2;
                    $i$f$forEach2 = false;
                    for (T element$iv : $this$forEach$iv) {
                        schema = (HiveSchema)element$iv;
                        boolean bl8 = false;
                        ModNamingFamily<? extends HivePersistentFunction> modNamingFamily6 = schema.getFunctions();
                        Intrinsics.checkExpressionValueIsNotNull(modNamingFamily6, (String)"schema.functions");
                        it.invoke(modNamingFamily6);
                    }
                }
            });
        }
        catch (InterruptedException ie$iv) {
            throw (Throwable)ie$iv;
        }
        catch (DBException d$iv) {
            String message$iv = "Error encountered when performing " + operationName$iv + ": " + d$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)d$iv);
        }
        catch (NullPointerException npe$iv) {
            String message$iv = "NPE encountered when performing " + operationName$iv;
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)npe$iv);
            BaseIntrospector.access$getLog$p((BaseIntrospector)this_$iv).error(message$iv, (Throwable)npe$iv);
        }
        catch (Exception e$iv) {
            String message$iv = "Unexpected error (" + e$iv.getClass().getSimpleName() + ") encountered when performing " + operationName$iv + ": " + e$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)e$iv);
        }
    }

    private final void retrieveFunctionsInner(DatabaseConnection dbConnection, HiveRoot root2, List<? extends HiveSchema> schemas2) {
        boolean bl = false;
        Map nameToSchema = new LinkedHashMap();
        Iterable $this$forEach$iv = schemas2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HiveSchema it = (HiveSchema)element$iv;
            boolean bl2 = false;
            String string = it.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
            nameToSchema.put(string, it);
        }
        this.forEachNotNullLine(dbConnection, "show functions", (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this, nameToSchema, dbConnection, root2){
            final /* synthetic */ HiveIntrospector this$0;
            final /* synthetic */ Map $nameToSchema;
            final /* synthetic */ DatabaseConnection $dbConnection;
            final /* synthetic */ HiveRoot $root;

            public final void invoke(@NotNull String qualifiedFuncName) {
                Intrinsics.checkParameterIsNotNull((Object)qualifiedFuncName, (String)"qualifiedFuncName");
                if (HiveIntrospector.access$getIGNORED_FUNCTIONS$cp().contains(qualifiedFuncName)) {
                    return;
                }
                int dot = StringsKt.indexOf$default((CharSequence)qualifiedFuncName, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (dot != -1) {
                    String string = qualifiedFuncName;
                    int n = 0;
                    Map map2 = this.$nameToSchema;
                    int n2 = 0;
                    String string2 = string.substring(n, dot);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string3 = string2;
                    HiveSchema hiveSchema = (HiveSchema)map2.get(string3);
                    if (hiveSchema == null) {
                        return;
                    }
                    HiveSchema schema = hiveSchema;
                    String string4 = qualifiedFuncName;
                    n2 = dot + 1;
                    boolean bl = false;
                    String string5 = string4.substring(n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                    String funcName = string5;
                    ModNamingFamily<? extends HivePersistentFunction> modNamingFamily = schema.getFunctions();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"schema.functions");
                    ModNamingFamily<? extends HiveMacro> modNamingFamily2 = this.$root.getMacros();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingFamily2, (String)"root.macros");
                    HiveIntrospector.access$introspectFunction(this.this$0, this.$dbConnection, modNamingFamily, modNamingFamily2, funcName, qualifiedFuncName, false);
                } else {
                    HiveFunction function;
                    boolean isBuiltin = HiveIntrospector.access$isSystemFunction(this.this$0, qualifiedFuncName);
                    if (isBuiltin && (function = (HiveFunction)this.$root.getFunctions().get(qualifiedFuncName)) != null) {
                        function.setAutoCreated(true);
                        function.resetSyncPending();
                        return;
                    }
                    ModNamingFamily<? extends HiveFunction> modNamingFamily = this.$root.getFunctions();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"root.functions");
                    ModNamingFamily<? extends HiveMacro> modNamingFamily3 = this.$root.getMacros();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingFamily3, (String)"root.macros");
                    HiveIntrospector.access$introspectFunction(this.this$0, this.$dbConnection, modNamingFamily, modNamingFamily3, qualifiedFuncName, qualifiedFuncName, isBuiltin);
                }
            }
            {
                this.this$0 = hiveIntrospector;
                this.$nameToSchema = map2;
                this.$dbConnection = databaseConnection;
                this.$root = hiveRoot;
                super(1);
            }
        }));
    }

    private final boolean isSystemFunction(String funcName) {
        SqlLanguageDialect sqlLanguageDialect = this.getSqlHelper().getLanguage();
        if (sqlLanguageDialect == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.dialects.SqlLanguageDialectEx");
        }
        return ((SqlLanguageDialectEx)sqlLanguageDialect).getSupportedFunctions().contains(funcName);
    }

    private final void introspectFunction(DatabaseConnection dbConnection, ModNamingFamily<? extends HiveFunctionBase> funcFamily, ModNamingFamily<? extends HiveMacro> macroFamily, String funcName, String qualifiedFuncName, boolean isBuiltin) {
        HiveFunctionBase function;
        boolean bl = false;
        List description = new ArrayList();
        this.forEachNotNullLine(dbConnection, "describe function extended `" + qualifiedFuncName + '`', (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(description){
            final /* synthetic */ List $description;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$description.add(it);
            }
            {
                this.$description = list;
                super(1);
            }
        }));
        if (description.size() < 3) {
            return;
        }
        String classNameLine = (String)description.get(description.size() - 2);
        if (!StringsKt.startsWith$default((String)classNameLine, (String)FUNCTION_CLASS, (boolean)false, (int)2, null)) {
            return;
        }
        String string = classNameLine;
        int n = FUNCTION_CLASS.length();
        boolean bl2 = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String className = string3;
        if (StringsKt.endsWith$default((String)className, (String)"GenericUDFMacro", (boolean)false, (int)2, null)) {
            macroFamily.createOrGet(qualifiedFuncName);
            return;
        }
        HiveFunctionBase hiveFunctionBase = function = (HiveFunctionBase)funcFamily.createOrGet(funcName);
        Intrinsics.checkExpressionValueIsNotNull((Object)hiveFunctionBase, (String)"function");
        hiveFunctionBase.setClassName(className);
        HiveFunctionBase hiveFunctionBase2 = function;
        if (!(hiveFunctionBase2 instanceof HiveFunction)) {
            hiveFunctionBase2 = null;
        }
        HiveFunction hiveFunction = (HiveFunction)hiveFunctionBase2;
        if (hiveFunction != null) {
            HiveFunction hiveFunction2 = hiveFunction;
            bl2 = false;
            boolean bl3 = false;
            HiveFunction $this$apply = hiveFunction2;
            boolean bl4 = false;
            $this$apply.setTemporary(StringsKt.endsWith$default((String)((String)description.get(description.size() - 1)), (String)"TEMPORARY", (boolean)false, (int)2, null));
            $this$apply.setAutoCreated(isBuiltin);
        }
        String string4 = (String)description.get(0);
        HiveFunctionBase hiveFunctionBase3 = function;
        bl2 = false;
        String string5 = string4;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string6 = ((Object)StringsKt.trim((CharSequence)string5)).toString();
        hiveFunctionBase3.setComment(string6);
    }

    private final void forEachNotNullLine(DatabaseConnection dbConnection, String statement, Function1<? super String, Unit> processor) {
        SmartStatements.Companion.poweredBy(dbConnection).simple(Configuration.Companion.sourced(SmartStatements.Source.SYSTEM)).execute((Object)statement, StandardResultsProcessors.resultsTransformer((Function1)((Function1)new Function1<RemoteResultSet, Unit>(processor){
            final /* synthetic */ Function1 $processor;

            public final void invoke(@NotNull RemoteResultSet rs) {
                Intrinsics.checkParameterIsNotNull((Object)rs, (String)"rs");
                while (rs.next()) {
                    String string;
                    if (rs.getString(1) == null) continue;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string;
                    boolean bl3 = false;
                    this.$processor.invoke((Object)it);
                }
            }
            {
                this.$processor = function1;
                super(1);
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    private final void introspectOneSchema(DBTransaction tran, HiveSchema schema) {
        void this_$iv;
        BaseIntrospector baseIntrospector = this;
        String operationName$iv = "Introspect schema " + schema.getName();
        boolean $i$f$handleErrors = false;
        try {
            boolean bl = false;
            HiveSchemaRetriever retriever = this.createSchemaRetriever(tran, schema);
            retriever.process();
        }
        catch (InterruptedException ie$iv) {
            throw (Throwable)ie$iv;
        }
        catch (DBException d$iv) {
            String message$iv = "Error encountered when performing " + operationName$iv + ": " + d$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)d$iv);
        }
        catch (NullPointerException npe$iv) {
            String message$iv = "NPE encountered when performing " + operationName$iv;
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)npe$iv);
            BaseIntrospector.access$getLog$p((BaseIntrospector)this_$iv).error(message$iv, (Throwable)npe$iv);
        }
        catch (Exception e$iv) {
            String message$iv = "Unexpected error (" + e$iv.getClass().getSimpleName() + ") encountered when performing " + operationName$iv + ": " + e$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)e$iv);
        }
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        this.retrieveAndApplySchemas();
    }

    @Override
    @NotNull
    protected BaseIntrospector.AbstractDatabaseRetriever<HiveRoot> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull HiveRoot database) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        throw (Throwable)new UnsupportedOperationException();
    }

    @Override
    public void introspectServerObjects() {
        this.retrieveRoles();
    }

    private final void retrieveRoles() {
        this.inModel((Function1)new Function1<HiveRoot, Unit>(this){
            final /* synthetic */ HiveIntrospector this$0;

            public final void invoke(@NotNull HiveRoot root2) {
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                boolean $i$f$cleanupFamilies = false;
                Function1 it = retrieveRoles$1$$special$$inlined$cleanupFamilies$1.INSTANCE;
                boolean bl = false;
                ModNamingFamily<? extends HiveRole> modNamingFamily = root2.getRoles();
                Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"root.roles");
                it.invoke(modNamingFamily);
                boolean bl2 = false;
                DatabaseConnection databaseConnection = this.this$0.getDbConnection();
                if (databaseConnection == null) {
                } else {
                    DatabaseConnection dbConnection = databaseConnection;
                    SmartStatements statements2 = SmartStatements.Companion.poweredBy(dbConnection);
                    List roles = (List)statements2.simple(Configuration.Companion.sourced(SmartStatements.Source.SYSTEM)).execute((Object)"show roles", StandardResultsProcessors.listOfStrings((int)1)).rightOr((Object)CollectionsKt.emptyList());
                    for (String role : roles) {
                        root2.getRoles().createOrGet(role);
                    }
                    statements2.simple(Configuration.Companion.sourced(SmartStatements.Source.SYSTEM)).execute((Object)"show principals admin", StandardResultsProcessors.resultsTransformer((Function1)((Function1)new Function1<RemoteResultSet, Unit>(this, root2){
                        final /* synthetic */ retrieveRoles.1 this$0;
                        final /* synthetic */ HiveRoot $root$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$root$inlined = hiveRoot;
                            super(1);
                        }

                        public final void invoke(@NotNull RemoteResultSet resultSet) {
                            Intrinsics.checkParameterIsNotNull((Object)resultSet, (String)"resultSet");
                            while (resultSet.next()) {
                                String userName = resultSet.getString(1);
                                String principalType = resultSet.getString(2);
                                if (Intrinsics.areEqual((Object)principalType, (Object)"USER") ^ true) continue;
                                BasicModNamedElement basicModNamedElement = this.$root$inlined.getRoles().createOrGet(userName);
                                boolean bl = false;
                                boolean bl2 = false;
                                HiveRole $this$apply = (HiveRole)basicModNamedElement;
                                boolean bl3 = false;
                                $this$apply.setCanLogin(true);
                                $this$apply.setSuperRole(true);
                            }
                        }
                    })));
                }
                it = retrieveRoles$1$$special$$inlined$cleanupFamilies$2.INSTANCE;
                bl = false;
                ModNamingFamily<? extends HiveRole> modNamingFamily2 = root2.getRoles();
                Intrinsics.checkExpressionValueIsNotNull(modNamingFamily2, (String)"root.roles");
                it.invoke(modNamingFamily2);
            }
            {
                this.this$0 = hiveIntrospector;
                super(1);
            }
        });
    }

    @NotNull
    protected HiveSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull HiveSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return new HiveSchemaRetriever(transaction, schema);
    }

    public HiveIntrospector(@NotNull Project project, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
        Dbms dbms = Dbms.HIVE;
        Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"Dbms.HIVE");
        super(dbms, project, modelFactory);
        this.genericIntrospector = new JdbcIntrospector(this.getDbms());
    }

    static {
        Companion = new Companion(null);
        IGNORED_FUNCTIONS = SetsKt.setOf((Object[])new String[]{"!", "!=", "$sum0", "%", "&", "*", "+", "-", "/", "<", "<=", "<=>", "<>", "=", "==", ">", ">=", "^", "and", "between", "case", "div", "in", "like", "or", "regexp", "rlike", "when", "|", "~"});
        IGNORED_PROPERTIES = SetsKt.setOf((Object[])new String[]{"transient_lastDdlTime", "last_modified_by", "last_modified_time", "numFiles", "numRows", "totalSize", "EXTERNAL", "comment", "rawDataSize", "numPartitions", "COLUMN_STATS_ACCURATE"});
        viewProcessors = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"Table Parameters:", (Object)((Object)Companion.viewProcessors.1.INSTANCE)), TuplesKt.to((Object)"View Original Text:", (Object)HiveIntrospector.Companion.snd(Companion.viewProcessors.2.INSTANCE)), TuplesKt.to((Object)"View Expanded Text:", (Object)HiveIntrospector.Companion.snd(Companion.viewProcessors.3.INSTANCE)), TuplesKt.to((Object)"View Rewrite Enabled:", (Object)HiveIntrospector.Companion.noop())});
        tableProcessors = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"Location:", (Object)HiveIntrospector.Companion.snd(Companion.tableProcessors.1.INSTANCE)), TuplesKt.to((Object)"Table Type:", (Object)HiveIntrospector.Companion.snd(Companion.tableProcessors.2.INSTANCE)), TuplesKt.to((Object)"Table Parameters:", (Object)((Object)Companion.tableProcessors.3.INSTANCE)), TuplesKt.to((Object)"# Partition Information", (Object)((Object)Companion.tableProcessors.4.INSTANCE)), TuplesKt.to((Object)"SerDe Library:", (Object)HiveIntrospector.Companion.snd(Companion.tableProcessors.5.INSTANCE)), TuplesKt.to((Object)"InputFormat:", (Object)HiveIntrospector.Companion.snd(Companion.tableProcessors.6.INSTANCE)), TuplesKt.to((Object)"OutputFormat:", (Object)HiveIntrospector.Companion.snd(Companion.tableProcessors.7.INSTANCE)), TuplesKt.to((Object)"Compressed:", (Object)HiveIntrospector.Companion.noop()), TuplesKt.to((Object)"Num Buckets:", (Object)HiveIntrospector.Companion.snd(Companion.tableProcessors.8.INSTANCE)), TuplesKt.to((Object)"Stored As SubDirectories:", (Object)HiveIntrospector.Companion.snd(Companion.tableProcessors.9.INSTANCE)), TuplesKt.to((Object)"Skewed Columns:", (Object)HiveIntrospector.Companion.snd(Companion.tableProcessors.10.INSTANCE)), TuplesKt.to((Object)"Skewed Values:", (Object)HiveIntrospector.Companion.snd(Companion.tableProcessors.11.INSTANCE)), TuplesKt.to((Object)"Bucket Columns:", (Object)HiveIntrospector.Companion.snd(Companion.tableProcessors.12.INSTANCE)), TuplesKt.to((Object)"Sort Columns:", (Object)HiveIntrospector.Companion.snd(Companion.tableProcessors.13.INSTANCE)), TuplesKt.to((Object)"Storage Desc Params:", (Object)((Object)Companion.tableProcessors.14.INSTANCE)), TuplesKt.to((Object)"# Constraints", (Object)HiveIntrospector.Companion.noop()), TuplesKt.to((Object)"# Foreign Keys", (Object)new Function4<HiveTable, String, String, String, Unit>(){
            @Nullable
            private HiveForeignKey currentConstraint;
            @NotNull
            private final Map<String, Integer> columnsPos;
            @NotNull
            private final Map<String, Integer> refColumnsPos;

            @Nullable
            public final HiveForeignKey getCurrentConstraint() {
                return this.currentConstraint;
            }

            public final void setCurrentConstraint(@Nullable HiveForeignKey hiveForeignKey) {
                this.currentConstraint = hiveForeignKey;
            }

            @NotNull
            public final Map<String, Integer> getColumnsPos() {
                return this.columnsPos;
            }

            @NotNull
            public final Map<String, Integer> getRefColumnsPos() {
                return this.refColumnsPos;
            }

            /*
             * Unable to fully structure code
             */
            public void invoke(@NotNull HiveTable t, @NotNull String key, @NotNull String v1, @Nullable String position) {
                block11: {
                    block10: {
                        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                        Intrinsics.checkParameterIsNotNull((Object)v1, (String)"v1");
                        if (!Intrinsics.areEqual((Object)key, (Object)"Constraint Name:")) break block10;
                        this.currentConstraint = (HiveForeignKey)t.getForeignKeys().createOrGet(v1);
                        this.columnsPos.clear();
                        this.refColumnsPos.clear();
                        break block11;
                    }
                    if (!StringsKt.startsWith$default((String)key, (String)"Parent Column Name:", (boolean)false, (int)2, null)) break block11;
                    v0 = this.currentConstraint;
                    if (v0 == null) {
                        return;
                    }
                    fKey = v0;
                    var7_6 = v1;
                    var8_7 = "Column Name:".length();
                    var9_9 = 0;
                    v1 = var7_6.substring(var8_7);
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"(this as java.lang.String).substring(startIndex)");
                    colName = v1;
                    var8_8 = key;
                    var9_9 = "Parent Column Name:".length();
                    var10_13 = 0;
                    v2 = var8_8.substring(var9_9);
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"(this as java.lang.String).substring(startIndex)");
                    var9_10 = refCol = v2;
                    var10_13 = StringsKt.lastIndexOf$default((CharSequence)refCol, (String)".", (int)0, (boolean)false, (int)6, null) + 1;
                    var11_16 = 0;
                    v3 = var9_10;
                    if (v3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    v4 = v3.substring(var10_13);
                    Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"(this as java.lang.String).substring(startIndex)");
                    refColName = v4;
                    v5 = position;
                    if (v5 == null) ** GOTO lbl-1000
                    var10_14 = v5;
                    var11_16 = "Key Sequence:".length();
                    var12_17 = false;
                    v6 = var10_14;
                    if (v6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    v7 = v6.substring(var11_16);
                    Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"(this as java.lang.String).substring(startIndex)");
                    v5 = v7;
                    if (v7 != null) {
                        var10_14 = v5;
                        var11_16 = 0;
                        v8 = Integer.parseInt(var10_14) + -1;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v8 = fKey.getColNames().size();
                    }
                    pos = v8;
                    this.columnsPos.put(colName, pos);
                    this.refColumnsPos.put(refColName, pos);
                    var10_15 = false;
                    var11_16 = 0;
                    $this$with = fKey;
                    $i$a$-with-HiveIntrospector$Companion$tableProcessors$15$invoke$1 = false;
                    var14_20 = refCol;
                    var15_21 = 0;
                    var16_22 = StringsKt.indexOf$default((CharSequence)refCol, (String)".", (int)0, (boolean)false, (int)6, null);
                    var17_23 = $this$with;
                    var18_24 = false;
                    v9 = var14_20;
                    if (v9 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    v10 = v9.substring(var15_21, var16_22);
                    Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    var14_20 = var19_28 = v10;
                    var15_21 = 0;
                    var16_22 = 0;
                    it = var14_20;
                    $i$a$-takeIf-HiveIntrospector$Companion$tableProcessors$15$invoke$1$1 = false;
                    v11 = $this$with.getSchema();
                    if (v11 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"schema!!");
                    var19_28 = (Intrinsics.areEqual((Object)it, (Object)v11.getName()) ^ true) != false ? var14_20 : null;
                    var17_23.setRefSchemaName((String)var19_28);
                    var14_20 = refCol;
                    var15_21 = StringsKt.indexOf$default((CharSequence)refCol, (String)".", (int)0, (boolean)false, (int)6, null) + 1;
                    var16_22 = StringsKt.lastIndexOf$default((CharSequence)refCol, (String)".", (int)0, (boolean)false, (int)6, null);
                    var17_23 = $this$with;
                    it = false;
                    v12 = var14_20;
                    if (v12 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    v13 = v12.substring(var15_21, var16_22);
                    Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    var19_28 = v13;
                    var17_23.setRefTableName((String)var19_28);
                    v14 = $this$with.getRefColNames();
                    Intrinsics.checkExpressionValueIsNotNull(v14, (String)"refColNames");
                    var14_20 = CollectionsKt.toMutableList((Collection)v14);
                    var17_23 = $this$with;
                    var15_21 = 0;
                    var16_22 = 0;
                    $this$apply = var14_20;
                    $i$a$-apply-HiveIntrospector$Companion$tableProcessors$15$invoke$1$2 = false;
                    $this$apply.add(refColName);
                    $this$sortBy$iv = $this$apply;
                    $i$f$sortBy = false;
                    if ($this$sortBy$iv.size() > 1) {
                        var23_32 = $this$sortBy$iv;
                        var24_33 = false;
                        var25_34 = new Comparator<T>(this, refCol, refColName, colName){
                            final /* synthetic */ Companion.tableProcessors.15 this$0;
                            final /* synthetic */ String $refCol$inlined;
                            final /* synthetic */ String $refColName$inlined;
                            final /* synthetic */ String $colName$inlined;
                            {
                                this.this$0 = var1_1;
                                this.$refCol$inlined = string;
                                this.$refColName$inlined = string2;
                                this.$colName$inlined = string3;
                            }

                            public final int compare(T a, T b) {
                                boolean bl = false;
                                String it = (String)a;
                                boolean bl2 = false;
                                Integer n = this.this$0.getRefColumnsPos().get(it);
                                if (n == null) {
                                    Intrinsics.throwNpe();
                                }
                                it = (String)b;
                                Comparable comparable = Integer.valueOf(((Number)n).intValue());
                                bl2 = false;
                                Integer n2 = this.this$0.getRefColumnsPos().get(it);
                                if (n2 == null) {
                                    Intrinsics.throwNpe();
                                }
                                Integer n3 = ((Number)n2).intValue();
                                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n3);
                            }
                        };
                        CollectionsKt.sortWith((List)var23_32, (Comparator)var25_34);
                    }
                    var19_28 = var14_20;
                    var17_23.setRefColNames((List<String>)var19_28);
                    v15 = $this$with.getColNames();
                    Intrinsics.checkExpressionValueIsNotNull(v15, (String)"colNames");
                    var14_20 = CollectionsKt.toMutableList((Collection)v15);
                    var17_23 = $this$with;
                    var15_21 = 0;
                    var16_22 = 0;
                    $this$apply = var14_20;
                    $i$a$-apply-HiveIntrospector$Companion$tableProcessors$15$invoke$1$3 = false;
                    $this$apply.add(colName);
                    $this$sortBy$iv = $this$apply;
                    $i$f$sortBy = false;
                    if ($this$sortBy$iv.size() > 1) {
                        var23_32 = $this$sortBy$iv;
                        var24_33 = false;
                        var25_34 = new Comparator<T>(this, refCol, refColName, colName){
                            final /* synthetic */ Companion.tableProcessors.15 this$0;
                            final /* synthetic */ String $refCol$inlined;
                            final /* synthetic */ String $refColName$inlined;
                            final /* synthetic */ String $colName$inlined;
                            {
                                this.this$0 = var1_1;
                                this.$refCol$inlined = string;
                                this.$refColName$inlined = string2;
                                this.$colName$inlined = string3;
                            }

                            public final int compare(T a, T b) {
                                boolean bl = false;
                                String it = (String)a;
                                boolean bl2 = false;
                                Integer n = this.this$0.getColumnsPos().get(it);
                                if (n == null) {
                                    Intrinsics.throwNpe();
                                }
                                it = (String)b;
                                Comparable comparable = Integer.valueOf(((Number)n).intValue());
                                bl2 = false;
                                Integer n2 = this.this$0.getColumnsPos().get(it);
                                if (n2 == null) {
                                    Intrinsics.throwNpe();
                                }
                                Integer n3 = ((Number)n2).intValue();
                                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n3);
                            }
                        };
                        CollectionsKt.sortWith((List)var23_32, (Comparator)var25_34);
                    }
                    var19_28 = var14_20;
                    var17_23.setColNames((List<String>)var19_28);
                }
            }
            {
                Map map2;
                Companion.tableProcessors.15 var2_1 = this;
                boolean bl = false;
                var2_1.columnsPos = map2 = (Map)new LinkedHashMap<K, V>();
                var2_1 = this;
                bl = false;
                var2_1.refColumnsPos = map2 = (Map)new LinkedHashMap<K, V>();
            }
        })});
    }

    public static final /* synthetic */ JdbcIntrospector access$getGenericIntrospector$p(HiveIntrospector $this) {
        return $this.genericIntrospector;
    }

    public static final /* synthetic */ void access$buildObject(HiveIntrospector $this, DasObject obj2, String type, DatabaseConnection dbConnection) {
        $this.buildObject(obj2, type, dbConnection);
    }

    public static final /* synthetic */ String access$joinRows(HiveIntrospector $this, RemoteResultSet resultSet) {
        return $this.joinRows(resultSet);
    }

    public static final /* synthetic */ void access$retrieveFunctionsInner(HiveIntrospector $this, DatabaseConnection dbConnection, HiveRoot root2, List schemas2) {
        $this.retrieveFunctionsInner(dbConnection, root2, schemas2);
    }

    public static final /* synthetic */ Set access$getIGNORED_FUNCTIONS$cp() {
        return IGNORED_FUNCTIONS;
    }

    public static final /* synthetic */ void access$introspectFunction(HiveIntrospector $this, DatabaseConnection dbConnection, ModNamingFamily funcFamily, ModNamingFamily macroFamily, String funcName, String qualifiedFuncName, boolean isBuiltin) {
        $this.introspectFunction(dbConnection, (ModNamingFamily<? extends HiveFunctionBase>)funcFamily, (ModNamingFamily<? extends HiveMacro>)macroFamily, funcName, qualifiedFuncName, isBuiltin);
    }

    public static final /* synthetic */ boolean access$isSystemFunction(HiveIntrospector $this, String funcName) {
        return $this.isSystemFunction(funcName);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/hive/introspector/HiveIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "dbms", "Lcom/intellij/database/Dbms;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects.hive"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @NotNull
        public DBIntrospector createIntrospector(@NotNull Dbms dbms, @NotNull Project project, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
            return new HiveIntrospector(project, modelFactory);
        }

        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return false;
        }

        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            return true;
        }

        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        public boolean isNative() {
            return DBIntrospector.Factory.DefaultImpls.isNative((DBIntrospector.Factory)this);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/hive/introspector/HiveIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects.hive"})
        public static final class VERSION
        extends PerObjectVersion {
            public static final VERSION INSTANCE;

            private VERSION() {
            }

            static {
                VERSION vERSION;
                INSTANCE = vERSION = new VERSION();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003B\u0017\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J`\u0010\f\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u0002H\u000e27\u0010\u0013\u001a3\u0012\u0004\u0012\u00020\u0015\u0012)\u0012'\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\r0\u0016\u00a2\u0006\u0002\b\u00170\u0014H\u0002\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010 \u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006!"}, d2={"Lcom/intellij/database/dialects/hive/introspector/HiveIntrospector$HiveSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/hive/model/HiveSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "Lcom/intellij/database/dialects/hive/model/HiveRoot;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/hive/introspector/HiveIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/hive/model/HiveSchema;)V", "isPossibleToIntrospectSchemaIncrementally", "", "tran", "parseDescription", "", "T", "Lcom/intellij/database/dialects/hive/model/HiveLikeTable;", "dbConnection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "table", "processors", "", "", "Lkotlin/Function4;", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/dialects/hive/model/HiveLikeTable;Ljava/util/Map;)V", "process", "progress", "what", "retrieveDetailedInfo", "retrieveIndices", "retrieveJdbcMetadata", "retrieveTablesDetailedInfo", "retrieveViewsDetailedInfo", "intellij.database.dialects.hive"})
    protected final class HiveSchemaRetriever
    extends BaseIntrospector.AbstractSchemaRetriever<HiveSchema> {
        @Override
        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull HiveSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            return false;
        }

        private final void progress(String what) {
            String mode = "completely";
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Introspecting schema %s (%s)";
            Object[] objectArray = new Object[]{((HiveSchema)this.getSchema()).getName(), mode};
            HiveIntrospector hiveIntrospector = HiveIntrospector.this;
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            hiveIntrospector.updateStatus(string3, what);
        }

        @Override
        public void process() {
            DatabaseConnection databaseConnection = HiveIntrospector.this.getDbConnection();
            if (databaseConnection == null) {
                return;
            }
            DatabaseConnection dbConnection = databaseConnection;
            this.retrieveJdbcMetadata(dbConnection);
            this.retrieveDetailedInfo(dbConnection);
        }

        private final void retrieveJdbcMetadata(DatabaseConnection dbConnection) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Retrieving jdbc metadata for schema %s";
            Object[] objectArray = new Object[]{((HiveSchema)this.getSchema()).getName()};
            HiveIntrospector hiveIntrospector = HiveIntrospector.this;
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            hiveIntrospector.updateStatus(string3, "jdbc metadata");
            DatabaseMetaDataWrapper metadata = HiveIntrospector.this.getMetadata(dbConnection);
            this.inSchema((Function1)new Function1<HiveSchema, Unit>(this, metadata){
                final /* synthetic */ HiveSchemaRetriever this$0;
                final /* synthetic */ DatabaseMetaDataWrapper $metadata;

                public final void invoke(@NotNull HiveSchema it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    HiveIntrospector.access$getGenericIntrospector$p(this.this$0.HiveIntrospector.this).introspectTablesInSchema(this.$metadata, it);
                }
                {
                    this.this$0 = hiveSchemaRetriever;
                    this.$metadata = databaseMetaDataWrapper;
                    super(1);
                }
            });
            this.inSchema((Function1)new Function1<HiveSchema, Unit>(this, metadata){
                final /* synthetic */ HiveSchemaRetriever this$0;
                final /* synthetic */ DatabaseMetaDataWrapper $metadata;

                public final void invoke(@NotNull HiveSchema it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    HiveIntrospector.access$getGenericIntrospector$p(this.this$0.HiveIntrospector.this).introspectColumnsInSchema(this.$metadata, it);
                }
                {
                    this.this$0 = hiveSchemaRetriever;
                    this.$metadata = databaseMetaDataWrapper;
                    super(1);
                }
            });
            this.inSchema((Function1)new Function1<HiveSchema, Unit>(this, metadata){
                final /* synthetic */ HiveSchemaRetriever this$0;
                final /* synthetic */ DatabaseMetaDataWrapper $metadata;

                public final void invoke(@NotNull HiveSchema it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    ModNamingFamily<? extends HiveTable> modNamingFamily = it.getTables();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"it.tables");
                    Iterable $this$forEach$iv = (Iterable)modNamingFamily;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        HiveTable t = (HiveTable)element$iv;
                        boolean bl = false;
                        HiveIntrospector.access$getGenericIntrospector$p(this.this$0.HiveIntrospector.this).introspectTableKeys(this.$metadata, t, true);
                    }
                }
                {
                    this.this$0 = hiveSchemaRetriever;
                    this.$metadata = databaseMetaDataWrapper;
                    super(1);
                }
            });
            this.inSchema((Function1)new Function1<HiveSchema, Unit>(this, metadata){
                final /* synthetic */ HiveSchemaRetriever this$0;
                final /* synthetic */ DatabaseMetaDataWrapper $metadata;

                public final void invoke(@NotNull HiveSchema it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    ModNamingFamily<? extends HiveTable> modNamingFamily = it.getTables();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"it.tables");
                    Iterable $this$forEach$iv = (Iterable)modNamingFamily;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        HiveTable t = (HiveTable)element$iv;
                        boolean bl = false;
                        HiveIntrospector.access$getGenericIntrospector$p(this.this$0.HiveIntrospector.this).introspectTableForeignKeys(this.$metadata, t);
                    }
                }
                {
                    this.this$0 = hiveSchemaRetriever;
                    this.$metadata = databaseMetaDataWrapper;
                    super(1);
                }
            });
        }

        private final void retrieveDetailedInfo(DatabaseConnection dbConnection) {
            this.inSchema((Function1)new Function1<HiveSchema, Unit>(this, dbConnection){
                final /* synthetic */ HiveSchemaRetriever this$0;
                final /* synthetic */ DatabaseConnection $dbConnection;

                public final void invoke(@NotNull HiveSchema it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    HiveSchemaRetriever.access$retrieveTablesDetailedInfo(this.this$0, it, this.$dbConnection);
                }
                {
                    this.this$0 = hiveSchemaRetriever;
                    this.$dbConnection = databaseConnection;
                    super(1);
                }
            });
            this.inSchema((Function1)new Function1<HiveSchema, Unit>(this, dbConnection){
                final /* synthetic */ HiveSchemaRetriever this$0;
                final /* synthetic */ DatabaseConnection $dbConnection;

                public final void invoke(@NotNull HiveSchema it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    HiveSchemaRetriever.access$retrieveViewsDetailedInfo(this.this$0, it, this.$dbConnection);
                }
                {
                    this.this$0 = hiveSchemaRetriever;
                    this.$dbConnection = databaseConnection;
                    super(1);
                }
            });
            this.inSchema((Function1)new Function1<HiveSchema, Unit>(this, dbConnection){
                final /* synthetic */ HiveSchemaRetriever this$0;
                final /* synthetic */ DatabaseConnection $dbConnection;

                public final void invoke(@NotNull HiveSchema it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    HiveSchemaRetriever.access$retrieveIndices(this.this$0, it, this.$dbConnection);
                }
                {
                    this.this$0 = hiveSchemaRetriever;
                    this.$dbConnection = databaseConnection;
                    super(1);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void retrieveIndices(HiveSchema schema, DatabaseConnection dbConnection) {
            SimpleSmartStatement stmt = SmartStatements.Companion.poweredBy(dbConnection).simple(Configuration.Companion.sourced(SmartStatements.Source.SYSTEM));
            String currentSchema = null;
            try {
                RemoteConnection remoteConnection = dbConnection.getRemoteConnection();
                Intrinsics.checkExpressionValueIsNotNull((Object)remoteConnection, (String)"dbConnection.remoteConnection");
                currentSchema = remoteConnection.getSchema();
            }
            catch (Throwable t) {
                HiveIntrospector.this.getLog().warn(t);
            }
            try {
                boolean bl;
                HiveTable it;
                stmt.execute((Object)("use `" + schema.getName() + '`'), (Function1)retrieveIndices.1.INSTANCE);
                boolean $i$f$cleanupFamilies = false;
                Function1 it2 = HiveSchemaRetriever$retrieveIndices$$inlined$cleanupFamilies$1.INSTANCE;
                boolean bl2 = false;
                ModNamingFamily<? extends HiveTable> modNamingFamily = schema.getTables();
                Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"schema.tables");
                Iterable $this$forEach$iv = (Iterable)modNamingFamily;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (HiveTable)element$iv;
                    bl = false;
                    HiveTable hiveTable = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)hiveTable, (String)"it");
                    ModNamingFamily<? extends HiveIndex> modNamingFamily2 = hiveTable.getIndices();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingFamily2, (String)"it.indices");
                    it2.invoke(modNamingFamily2);
                }
                boolean bl3 = false;
                for (HiveTable table : schema.getTables()) {
                    StringBuilder stringBuilder = new StringBuilder().append("show indexes on `");
                    HiveTable hiveTable = table;
                    Intrinsics.checkExpressionValueIsNotNull((Object)hiveTable, (String)"table");
                    stmt.execute((Object)stringBuilder.append(hiveTable.getName()).append('`').toString(), StandardResultsProcessors.resultsTransformer((Function1)((Function1)new Function1<RemoteResultSet, Unit>(table){
                        final /* synthetic */ HiveTable $table;

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull RemoteResultSet rs) {
                            Intrinsics.checkParameterIsNotNull((Object)rs, (String)"rs");
                            while (rs.next()) {
                                Object object;
                                Object object2;
                                Object object3;
                                boolean bl;
                                HiveIndex hiveIndex;
                                Object object4;
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                String name2;
                                String string;
                                if (rs.getString(1) != null) {
                                    String string2;
                                    boolean bl2 = false;
                                    String string3 = string2;
                                    if (string3 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                    }
                                    string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                                } else {
                                    string = name2 = null;
                                }
                                if (name2 == null || StringsKt.isBlank((CharSequence)name2)) {
                                    return;
                                }
                                HiveTable hiveTable = this.$table;
                                Intrinsics.checkExpressionValueIsNotNull((Object)hiveTable, (String)"table");
                                HiveIndex index2 = (HiveIndex)hiveTable.getIndices().createOrGet(name2);
                                Intrinsics.checkExpressionValueIsNotNull((Object)index2, (String)"index");
                                String string4 = rs.getString(3);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"rs.getString(3)");
                                Object object5 = StringsKt.split$default((CharSequence)string4, (String[])new String[]{", "}, (boolean)false, (int)0, (int)6, null);
                                boolean $i$f$map = false;
                                void var6_7 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    String string5 = (String)item$iv$iv;
                                    object4 = destination$iv$iv;
                                    boolean bl3 = false;
                                    void var13_14 = it;
                                    boolean bl4 = false;
                                    void v4 = var13_14;
                                    if (v4 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                    }
                                    String string6 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v4))).toString();
                                    object4.add(string6);
                                }
                                object4 = (List)destination$iv$iv;
                                hiveIndex.setColNames((List<String>)object4);
                                HiveIndex hiveIndex2 = index2;
                                String string7 = rs.getString(4);
                                if (string7 != null) {
                                    object5 = string7;
                                    hiveIndex = hiveIndex2;
                                    bl = false;
                                    Object object6 = object5;
                                    if (object6 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                    }
                                    object4 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object6))).toString();
                                    hiveIndex2 = hiveIndex;
                                    object3 = object4;
                                } else {
                                    object3 = null;
                                }
                                hiveIndex2.setIndexTableName((String)object3);
                                HiveIndex hiveIndex3 = index2;
                                String string8 = rs.getString(5);
                                if (string8 != null) {
                                    object5 = string8;
                                    hiveIndex = hiveIndex3;
                                    bl = false;
                                    Object object7 = object5;
                                    if (object7 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                    }
                                    object4 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object7))).toString();
                                    hiveIndex3 = hiveIndex;
                                    object2 = object4;
                                } else {
                                    object2 = null;
                                }
                                hiveIndex3.setType((String)object2);
                                HiveIndex hiveIndex4 = index2;
                                String string9 = rs.getString(6);
                                if (string9 != null) {
                                    object5 = string9;
                                    hiveIndex = hiveIndex4;
                                    bl = false;
                                    Object object8 = object5;
                                    if (object8 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                    }
                                    object4 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object8))).toString();
                                    hiveIndex4 = hiveIndex;
                                    object = object4;
                                } else {
                                    object = null;
                                }
                                hiveIndex4.setComment((String)object);
                            }
                        }
                        {
                            this.$table = hiveTable;
                            super(1);
                        }
                    })));
                }
                it = HiveSchemaRetriever$retrieveIndices$$inlined$cleanupFamilies$2.INSTANCE;
                $i$a$-cleanupFamilies-HiveIntrospector$HiveSchemaRetriever$retrieveIndices$2 = false;
                ModNamingFamily<? extends HiveTable> modNamingFamily3 = schema.getTables();
                Intrinsics.checkExpressionValueIsNotNull(modNamingFamily3, (String)"schema.tables");
                $this$forEach$iv = (Iterable)modNamingFamily3;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (HiveTable)element$iv;
                    bl = false;
                    HiveTable hiveTable = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)hiveTable, (String)"it");
                    ModNamingFamily<? extends HiveIndex> modNamingFamily4 = hiveTable.getIndices();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingFamily4, (String)"it.indices");
                    it.invoke(modNamingFamily4);
                }
            }
            finally {
                if (currentSchema != null) {
                    stmt.execute((Object)("use `" + currentSchema + '`'), (Function1)retrieveIndices.4.INSTANCE);
                }
            }
        }

        private final void retrieveTablesDetailedInfo(HiveSchema schema, DatabaseConnection dbConnection) {
            boolean bl;
            HiveTable t;
            this.progress("table");
            boolean $i$f$cleanupFamilies = false;
            Function1 it = HiveSchemaRetriever$retrieveTablesDetailedInfo$$inlined$cleanupFamilies$1.INSTANCE;
            boolean bl2 = false;
            ModNamingFamily<? extends HiveTable> modNamingFamily = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"schema.tables");
            Iterable $this$forEach$iv = (Iterable)modNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (HiveTable)element$iv;
                bl = false;
                HiveTable hiveTable = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)hiveTable, (String)"t");
                ModNamingFamily<? extends HiveForeignKey> modNamingFamily2 = hiveTable.getForeignKeys();
                Intrinsics.checkExpressionValueIsNotNull(modNamingFamily2, (String)"t.foreignKeys");
                it.invoke(modNamingFamily2);
            }
            boolean bl3 = false;
            for (HiveTable table : schema.getTables()) {
                ProgressIndicator progressIndicator = HiveIntrospector.this.getProgressIndicator();
                if (progressIndicator != null) {
                    progressIndicator.checkCanceled();
                }
                HiveTable hiveTable = table;
                Intrinsics.checkExpressionValueIsNotNull((Object)hiveTable, (String)"table");
                hiveTable.setSerdeProperties(CollectionsKt.emptyList());
                table.setProperties(CollectionsKt.emptyList());
                ModPositioningNamingFamily<? extends HiveTableColumn> modPositioningNamingFamily = table.getColumns();
                Intrinsics.checkExpressionValueIsNotNull(modPositioningNamingFamily, (String)"table.columns");
                Iterable $this$forEach$iv2 = (Iterable)modPositioningNamingFamily;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    HiveTableColumn it2 = (HiveTableColumn)element$iv;
                    boolean bl4 = false;
                    HiveTableColumn hiveTableColumn = it2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)hiveTableColumn, (String)"it");
                    hiveTableColumn.setType(HiveTableColumnType.REGULAR);
                }
                ModPositioningNamingFamily<? extends HiveTableColumn> modPositioningNamingFamily2 = table.getColumns();
                Intrinsics.checkExpressionValueIsNotNull(modPositioningNamingFamily2, (String)"table.columns");
                $this$forEach$iv2 = (Iterable)modPositioningNamingFamily2;
                $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    HiveTableColumn it3 = (HiveTableColumn)element$iv;
                    boolean bl5 = false;
                    HiveTableColumn hiveTableColumn = it3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)hiveTableColumn, (String)"it");
                    hiveTableColumn.setSorting(HiveTableColumnSortingOrder.NONE);
                }
                table.setSkewedByColumns(CollectionsKt.emptyList());
                table.setStoredAsDirictories(false);
                table.setTemporary(true);
                this.parseDescription(dbConnection, (HiveLikeTable)table, tableProcessors);
            }
            it = HiveSchemaRetriever$retrieveTablesDetailedInfo$$inlined$cleanupFamilies$2.INSTANCE;
            $i$a$-cleanupFamilies-HiveIntrospector$HiveSchemaRetriever$retrieveTablesDetailedInfo$1 = false;
            ModNamingFamily<? extends HiveTable> modNamingFamily3 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily3, (String)"schema.tables");
            $this$forEach$iv = (Iterable)modNamingFamily3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (HiveTable)element$iv;
                bl = false;
                HiveTable hiveTable = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)hiveTable, (String)"t");
                ModNamingFamily<? extends HiveForeignKey> modNamingFamily4 = hiveTable.getForeignKeys();
                Intrinsics.checkExpressionValueIsNotNull(modNamingFamily4, (String)"t.foreignKeys");
                it.invoke(modNamingFamily4);
            }
        }

        private final void retrieveViewsDetailedInfo(HiveSchema schema, DatabaseConnection dbConnection) {
            this.progress("view");
            for (HiveView view : schema.getViews()) {
                ProgressIndicator progressIndicator = HiveIntrospector.this.getProgressIndicator();
                if (progressIndicator != null) {
                    progressIndicator.checkCanceled();
                }
                HiveView hiveView = view;
                Intrinsics.checkExpressionValueIsNotNull((Object)hiveView, (String)"view");
                hiveView.setProperties(CollectionsKt.emptyList());
                this.parseDescription(dbConnection, (HiveLikeTable)view, viewProcessors);
            }
            for (HiveMatView matView : schema.getMatViews()) {
                ProgressIndicator progressIndicator = HiveIntrospector.this.getProgressIndicator();
                if (progressIndicator != null) {
                    progressIndicator.checkCanceled();
                }
                HiveMatView hiveMatView = matView;
                Intrinsics.checkExpressionValueIsNotNull((Object)hiveMatView, (String)"matView");
                hiveMatView.setProperties(CollectionsKt.emptyList());
                this.parseDescription(dbConnection, (HiveLikeTable)matView, viewProcessors);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final <T extends HiveLikeTable> void parseDescription(DatabaseConnection dbConnection, T table, Map<String, ? extends Function4<? super T, ? super String, ? super String, ? super String, Unit>> processors) {
            void processor;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            SmartStatements.Companion.poweredBy(dbConnection).simple(Configuration.Companion.sourced(SmartStatements.Source.SYSTEM)).execute((Object)("describe formatted `" + table.getName() + '`'), StandardResultsProcessors.resultsTransformer((Function1)((Function1)new Function1<RemoteResultSet, Unit>(processors, (Ref.ObjectRef)processor, table){
                final /* synthetic */ Map $processors;
                final /* synthetic */ Ref.ObjectRef $processor;
                final /* synthetic */ HiveLikeTable $table;

                public final void invoke(@NotNull RemoteResultSet rs) {
                    Intrinsics.checkParameterIsNotNull((Object)rs, (String)"rs");
                    while (rs.next()) {
                        String string;
                        Function4 p;
                        String string2 = rs.getString(1);
                        if (string2 == null) continue;
                        String string3 = string2;
                        boolean bl = false;
                        String string4 = string3;
                        if (string4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        string2 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                        if (string2 == null) {
                            continue;
                        }
                        String headerOrKey = string2;
                        Function4 newProcessor = (Function4)this.$processors.get(headerOrKey);
                        if (newProcessor != null) {
                            this.$processor.element = newProcessor;
                        }
                        if ((p = (Function4)this.$processor.element) == null) continue;
                        String string5 = rs.getString(2);
                        if (string5 == null) continue;
                        String string6 = string5;
                        boolean bl2 = false;
                        String string7 = string6;
                        if (string7 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        string5 = ((Object)StringsKt.trim((CharSequence)string7)).toString();
                        if (string5 == null) {
                            continue;
                        }
                        String v2 = string5;
                        if (rs.getString(3) != null) {
                            String string8;
                            boolean bl3 = false;
                            String string9 = string8;
                            if (string9 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            string = ((Object)StringsKt.trim((CharSequence)string9)).toString();
                        } else {
                            string = null;
                        }
                        String v3 = string;
                        p.invoke((Object)this.$table, (Object)headerOrKey, (Object)v2, (Object)v3);
                    }
                }
                {
                    this.$processors = map2;
                    this.$processor = objectRef;
                    this.$table = hiveLikeTable;
                    super(1);
                }
            })));
        }

        public HiveSchemaRetriever(@NotNull DBTransaction transaction, HiveSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super((BaseIntrospector)HiveIntrospector.this, transaction, (BasicModSchema)schema);
        }

        public static final /* synthetic */ void access$retrieveTablesDetailedInfo(HiveSchemaRetriever $this, HiveSchema schema, DatabaseConnection dbConnection) {
            $this.retrieveTablesDetailedInfo(schema, dbConnection);
        }

        public static final /* synthetic */ void access$retrieveViewsDetailedInfo(HiveSchemaRetriever $this, HiveSchema schema, DatabaseConnection dbConnection) {
            $this.retrieveViewsDetailedInfo(schema, dbConnection);
        }

        public static final /* synthetic */ void access$retrieveIndices(HiveSchemaRetriever $this, HiveSchema schema, DatabaseConnection dbConnection) {
            $this.retrieveIndices(schema, dbConnection);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0012\u001a'\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000f\"\b\b\u0000\u0010\u0013*\u00020\u0011H\u0002JV\u0010\u0014\u001a'\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000f\"\b\b\u0000\u0010\u0013*\u00020\u00112\u001d\u0010\u0015\u001a\u0019\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\u0016\u00a2\u0006\u0002\b\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR?\u0010\n\u001a3\u0012\u0004\u0012\u00020\u0004\u0012)\u0012'\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R?\u0010\u0010\u001a3\u0012\u0004\u0012\u00020\u0004\u0012)\u0012'\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/hive/introspector/HiveIntrospector$Companion;", "", "()V", "FUNCTION_CLASS", "", "IGNORED_FUNCTIONS", "", "IGNORED_PROPERTIES", "getIGNORED_PROPERTIES", "()Ljava/util/Set;", "tableProcessors", "", "Lkotlin/Function4;", "Lcom/intellij/database/dialects/hive/model/HiveTable;", "", "Lkotlin/ExtensionFunctionType;", "viewProcessors", "Lcom/intellij/database/dialects/hive/model/HiveLikeTable;", "noop", "T", "snd", "p", "Lkotlin/Function2;", "intellij.database.dialects.hive"})
    public static final class Companion {
        @NotNull
        public final Set<String> getIGNORED_PROPERTIES() {
            return IGNORED_PROPERTIES;
        }

        private final <T extends HiveLikeTable> Function4<T, String, String, String, Unit> snd(Function2<? super T, ? super String, Unit> p) {
            return new Function4<T, String, String, String, Unit>(p){
                final /* synthetic */ Function2 $p;

                public final void invoke(@NotNull T $receiver, @NotNull String $noName_1, @NotNull String v2, @Nullable String $noName_3) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 0>");
                    Intrinsics.checkParameterIsNotNull((Object)v2, (String)"v");
                    this.$p.invoke($receiver, (Object)v2);
                }
                {
                    this.$p = function2;
                    super(4);
                }
            };
        }

        private final <T extends HiveLikeTable> Function4<T, String, String, String, Unit> noop() {
            return noop.1.INSTANCE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

