/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.derby.plan;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.statements.BarrenStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.base.plan.AbstractExplainPlanProvider;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DerbyExplainPlanProvider
extends AbstractExplainPlanProvider {
    public DerbyExplainPlanProvider() {
        super(Dbms.DERBY);
    }

    @Override
    @Nullable
    public AbstractPlanModelBuilder<?, ?> createBuilder() {
        return null;
    }

    public boolean isSupported(@NotNull Version version, boolean run) {
        if (version == null) {
            DerbyExplainPlanProvider.$$$reportNull$$$0(0);
        }
        return false;
    }

    public DdlBuilder sqlExplainPlan(@NotNull LocalDataSource dataSource, @NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (dataSource == null) {
            DerbyExplainPlanProvider.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            DerbyExplainPlanProvider.$$$reportNull$$$0(2);
        }
        if (statement == null) {
            DerbyExplainPlanProvider.$$$reportNull$$$0(3);
        }
        builder.plain("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)").newStatement();
        if (!analyze) {
            builder.plain("CALL SYSCS_UTIL.SYSCS_SET_XPLAIN_MODE(1)").newStatement();
        }
        builder.plain(statement).newStatement();
        builder.plain("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)").newStatement();
        builder.plain("VALUES SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        return builder;
    }

    @Nullable
    public DataRequest.RawRequest sqlPostExplainPlan(@NotNull DataRequest.OwnerEx owner, final boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (owner == null) {
            DerbyExplainPlanProvider.$$$reportNull$$$0(4);
        }
        return new DataRequest.RawRequest(owner){

            public void processRaw(DataRequest.Context context, DatabaseConnection connection) throws Exception {
                BarrenStatement.QuietBarrenStatement stmt = SmartStatements.poweredBy((DatabaseConnection)connection).simple().barren().quiet();
                stmt.execute((Object)"CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
                if (!analyze) {
                    stmt.execute((Object)"CALL SYSCS_UTIL.SYSCS_SET_XPLAIN_MODE(0)");
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/derby/plan/DerbyExplainPlanProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "sqlExplainPlan";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "sqlPostExplainPlan";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

