/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dialects.base.introspector.BaseIntroQueriesKt;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.NameCache;
import com.intellij.database.dialects.base.introspector.query.CommonPreprocessor;
import com.intellij.database.dialects.cassandra.introspector.CassIntroQueries;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospector;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospector$CassSchemaRetriever$ColumnSorter$WhenMappings;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospector$CassSchemaRetriever$retrieveAggregates$;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospector$CassSchemaRetriever$retrieveColumns$;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospector$CassSchemaRetriever$retrieveDefTypes$;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospector$CassSchemaRetriever$retrieveFunctions$;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospector$CassSchemaRetriever$retrieveIndices2$;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospector$CassSchemaRetriever$retrieveIndices3$;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospector$CassSchemaRetriever$retrieveMatViews$;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospector$CassSchemaRetriever$retrieveTables$;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospector$CassSchemaRetriever$retrieveTriggers$;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospector$retrieveRoles21$1$1$$special$;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospector$retrieveRoles22$1$1$$special$;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospectorHelperKt;
import com.intellij.database.dialects.cassandra.model.CassAggregate;
import com.intellij.database.dialects.cassandra.model.CassArgument;
import com.intellij.database.dialects.cassandra.model.CassDefType;
import com.intellij.database.dialects.cassandra.model.CassDefTypeAttribute;
import com.intellij.database.dialects.cassandra.model.CassFunction;
import com.intellij.database.dialects.cassandra.model.CassIndex;
import com.intellij.database.dialects.cassandra.model.CassKey;
import com.intellij.database.dialects.cassandra.model.CassLikeTable;
import com.intellij.database.dialects.cassandra.model.CassMatView;
import com.intellij.database.dialects.cassandra.model.CassMatViewColumn;
import com.intellij.database.dialects.cassandra.model.CassRole;
import com.intellij.database.dialects.cassandra.model.CassRoot;
import com.intellij.database.dialects.cassandra.model.CassRoutine;
import com.intellij.database.dialects.cassandra.model.CassSchema;
import com.intellij.database.dialects.cassandra.model.CassTable;
import com.intellij.database.dialects.cassandra.model.CassTableColumn;
import com.intellij.database.dialects.cassandra.model.CassTrigger;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBQueryRunner;
import com.intellij.database.layoutedQueries.DBSession;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.NameIndex;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.properties.CassIndexColumn;
import com.intellij.database.model.properties.CassKeyColumn;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.remote.jdba.util.StringOperator;
import com.intellij.database.remote.jdbc.RemoteCassConnection;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.script.CompositeText;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.rmi.NoSuchObjectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.IntRange;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002()B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J4\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u00020\u0014R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0014J\u001c\u0010\u0019\u001a\u00060\u001aR\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0003H\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0017H\u0014J\u0018\u0010!\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u001e\u0010\"\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00172\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH\u0014J\b\u0010$\u001a\u00020\rH\u0016J\b\u0010%\u001a\u00020\rH\u0016J\b\u0010&\u001a\u00020\rH\u0002J\b\u0010'\u001a\u00020\rH\u0002R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/cassandra/model/CassRoot;", "Lcom/intellij/database/dialects/cassandra/model/CassSchema;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/ModelFactory;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "applySchemas", "", "newSchemas", "", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneSchema;", "currentSchema", "", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector$CassSchemaRetriever;", "schema", "hasSelectPrivilege", "", "tableName", "introspectNamespacesInTran", "tran", "introspectOneSchema", "introspectSchemasAuto", "schemas", "introspectServerObjects", "retrieveAndApplySchemas", "retrieveRoles21", "retrieveRoles22", "CassSchemaRetriever", "Factory", "intellij.database.dialects.cassandra"})
public class CassIntrospector
extends BaseSingleDatabaseIntrospector<CassRoot, CassSchema> {
    private final Logger LOG;

    @Override
    @NotNull
    protected BaseIntrospector.AbstractDatabaseRetriever<CassRoot> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull CassRoot database) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    @NotNull
    protected CassSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull CassSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return new CassSchemaRetriever(transaction, schema);
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        List<CassIntroQueries.OneSchema> schemas2;
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        List<CassIntroQueries.OneSchema> list = schemas2 = this.getServerVersion().isOrGreater(new int[]{3, 0}) ? this.performQuery(tran, CassIntroQueries.Companion.getQUERIES().getRetrieveSchemas3()) : this.performQuery(tran, CassIntroQueries.Companion.getQUERIES().getRetrieveSchemas2());
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"schemas");
        this.applySchemas(list, this.getDbConnectionInfo().schemaName);
    }

    @Override
    public void introspectServerObjects() {
        if (this.getServerVersion().isOrGreater(new int[]{2, 2})) {
            if (this.hasSelectPrivilege("system_auth.roles")) {
                this.retrieveRoles22();
            }
        } else if (this.hasSelectPrivilege("system_auth.users")) {
            this.retrieveRoles21();
        }
    }

    private final boolean hasSelectPrivilege(String tableName) {
        DatabaseConnection databaseConnection = this.getDbConnection();
        if (databaseConnection == null) {
            return true;
        }
        DatabaseConnection connection = databaseConnection;
        return (Boolean)SmartStatements.Companion.poweredBy(connection).simple().execute((Object)("select * from " + tableName), (Function1)hasSelectPrivilege.1.INSTANCE).rightOr((Object)false);
    }

    private final void retrieveRoles22() {
        this.inSessionUnit((Function1<DBSession, Unit>)((Function1)new Function1<DBSession, Unit>(this){
            final /* synthetic */ CassIntrospector this$0;

            public final void invoke(@NotNull DBSession session) {
                Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
                CassIntrospector.access$inModel(this.this$0, (Function1)new Function1<CassRoot, Unit>(this, session){
                    final /* synthetic */ retrieveRoles22.1 this$0;
                    final /* synthetic */ DBSession $session;

                    public final void invoke(@NotNull CassRoot root2) {
                        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                        boolean $i$f$cleanupFamilies = false;
                        Function1 it = retrieveRoles22$1$1$$special$$inlined$cleanupFamilies$1.INSTANCE;
                        boolean bl = false;
                        ModNamingFamily<? extends CassRole> modNamingFamily = root2.getRoles();
                        Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"root.roles");
                        it.invoke(modNamingFamily);
                        boolean bl2 = false;
                        DBQueryRunner dBQueryRunner = this.$session.query(CassIntroQueries.Companion.getQUERIES().getRetrieveRoles22().rewrite((StringOperator)CassIntrospector.access$getPreprocessor$p(this.this$0.this$0)));
                        Intrinsics.checkExpressionValueIsNotNull((Object)dBQueryRunner, (String)"session.query(QUERIES.re\u202622.rewrite(preprocessor))");
                        S s = BaseIntroQueriesKt.runAndClose(dBQueryRunner);
                        Intrinsics.checkExpressionValueIsNotNull(s, (String)"session.query(QUERIES.re\u2026processor)).runAndClose()");
                        Iterable $this$forEach$iv = (Iterable)s;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            CassIntroQueries.OneRole r = (CassIntroQueries.OneRole)element$iv;
                            boolean bl3 = false;
                            ModNamingFamily<? extends CassRole> modNamingFamily2 = root2.getRoles();
                            String string = r.name;
                            if (string == null) {
                                Intrinsics.throwNpe();
                            }
                            BasicModNamedElement basicModNamedElement = modNamingFamily2.createOrGet(string);
                            boolean bl4 = false;
                            boolean bl5 = false;
                            CassRole $this$apply = (CassRole)basicModNamedElement;
                            boolean bl6 = false;
                            $this$apply.setSuperRole(r.is_superuser);
                            $this$apply.setCanLogin(r.can_login);
                        }
                        it = retrieveRoles22$1$1$$special$$inlined$cleanupFamilies$2.INSTANCE;
                        $i$a$-cleanupFamilies-CassIntrospector$retrieveRoles22$1$1$1 = false;
                        ModNamingFamily<? extends CassRole> modNamingFamily3 = root2.getRoles();
                        Intrinsics.checkExpressionValueIsNotNull(modNamingFamily3, (String)"root.roles");
                        it.invoke(modNamingFamily3);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$session = dBSession;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = cassIntrospector;
                super(1);
            }
        }));
    }

    private final void retrieveRoles21() {
        this.inSessionUnit((Function1<DBSession, Unit>)((Function1)new Function1<DBSession, Unit>(this){
            final /* synthetic */ CassIntrospector this$0;

            public final void invoke(@NotNull DBSession session) {
                Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
                CassIntrospector.access$inModel(this.this$0, (Function1)new Function1<CassRoot, Unit>(this, session){
                    final /* synthetic */ retrieveRoles21.1 this$0;
                    final /* synthetic */ DBSession $session;

                    public final void invoke(@NotNull CassRoot root2) {
                        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                        boolean $i$f$cleanupFamilies = false;
                        Function1 it = retrieveRoles21$1$1$$special$$inlined$cleanupFamilies$1.INSTANCE;
                        boolean bl = false;
                        ModNamingFamily<? extends CassRole> modNamingFamily = root2.getRoles();
                        Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"root.roles");
                        it.invoke(modNamingFamily);
                        boolean bl2 = false;
                        DBQueryRunner dBQueryRunner = this.$session.query(CassIntroQueries.Companion.getQUERIES().getRetrieveRoles21().rewrite((StringOperator)CassIntrospector.access$getPreprocessor$p(this.this$0.this$0)));
                        Intrinsics.checkExpressionValueIsNotNull((Object)dBQueryRunner, (String)"session.query(QUERIES.re\u202621.rewrite(preprocessor))");
                        S s = BaseIntroQueriesKt.runAndClose(dBQueryRunner);
                        Intrinsics.checkExpressionValueIsNotNull(s, (String)"session.query(QUERIES.re\u2026processor)).runAndClose()");
                        Iterable $this$forEach$iv = (Iterable)s;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            CassIntroQueries.OneRole r = (CassIntroQueries.OneRole)element$iv;
                            boolean bl3 = false;
                            ModNamingFamily<? extends CassRole> modNamingFamily2 = root2.getRoles();
                            String string = r.name;
                            if (string == null) {
                                Intrinsics.throwNpe();
                            }
                            BasicModNamedElement basicModNamedElement = modNamingFamily2.createOrGet(string);
                            boolean bl4 = false;
                            boolean bl5 = false;
                            CassRole $this$apply = (CassRole)basicModNamedElement;
                            boolean bl6 = false;
                            $this$apply.setSuperRole(r.is_superuser);
                            $this$apply.setCanLogin(true);
                        }
                        it = retrieveRoles21$1$1$$special$$inlined$cleanupFamilies$2.INSTANCE;
                        $i$a$-cleanupFamilies-CassIntrospector$retrieveRoles21$1$1$1 = false;
                        ModNamingFamily<? extends CassRole> modNamingFamily3 = root2.getRoles();
                        Intrinsics.checkExpressionValueIsNotNull(modNamingFamily3, (String)"root.roles");
                        it.invoke(modNamingFamily3);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$session = dBSession;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = cassIntrospector;
                super(1);
            }
        }));
    }

    @Override
    public void retrieveAndApplySchemas() {
        List schemas2 = this.getServerVersion().isOrGreater(new int[]{3, 0}) ? (List)this.inTransaction(retrieveAndApplySchemas.schemas.1.INSTANCE) : (List)this.inTransaction(retrieveAndApplySchemas.schemas.2.INSTANCE);
        this.applySchemas(schemas2, this.getDbConnectionInfo().schemaName);
    }

    private final void applySchemas(List<? extends CassIntroQueries.OneSchema> newSchemas, String currentSchema) {
        this.inModel((Function1)new Function1<CassRoot, Unit>(this, newSchemas, currentSchema){
            final /* synthetic */ CassIntrospector this$0;
            final /* synthetic */ List $newSchemas;
            final /* synthetic */ String $currentSchema;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CassRoot root2) {
                void $this$applySchemasNamed$iv;
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                ModNamingFamily<? extends CassSchema> modNamingFamily = root2.getSchemas();
                Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"root.schemas");
                ModNamingFamily<? extends CassSchema> modNamingFamily2 = modNamingFamily;
                List scs$iv = this.$newSchemas;
                boolean $i$f$applySchemasNamed = false;
                NameIndex schemas$iv = new NameIndex((ModNamingFamily)$this$applySchemasNamed$iv);
                void $this$applySchemasImpl$iv$iv = $this$applySchemasNamed$iv;
                boolean $i$f$applySchemasImpl = false;
                $this$applySchemasImpl$iv$iv.markChildrenAsSyncPending();
                Iterable $this$forEach$iv$iv$iv = scs$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String string;
                    void s;
                    void receiver;
                    void sc$iv;
                    T element$iv$iv$iv;
                    T sc$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    T t = sc$iv$iv;
                    void $this$applySchemasImpl$iv = $this$applySchemasImpl$iv$iv;
                    boolean bl2 = false;
                    void var17_17 = sc$iv;
                    NameIndex nameIndex = schemas$iv;
                    boolean $i$a$-unknown-Object22 = false;
                    String string2 = ((CassIntroQueries.OneSchema)receiver).getName();
                    BasicModNamedElement basicModNamedElement = nameIndex.createOrGet(string2);
                    boolean bl3 = false;
                    boolean bl4 = false;
                    BasicModMateNamespace $this$apply$iv = (BasicModMateNamespace)basicModNamedElement;
                    boolean bl5 = false;
                    CassIntroQueries.OneSchema $i$a$-unknown-Object22 = (CassIntroQueries.OneSchema)sc$iv;
                    CassSchema $this$applySchemasNamed = (CassSchema)$this$apply$iv;
                    boolean bl6 = false;
                    $this$applySchemasNamed.setDurableWrites(s.getDurableWrites());
                    CassSchema cassSchema = $this$applySchemasNamed;
                    void var25_26 = s;
                    if (var25_26 instanceof CassIntroQueries.OneSchema2) {
                        string = CassIntrospectorHelperKt.concatClassAndOptions(((CassIntroQueries.OneSchema2)s).strategy_class, ((CassIntroQueries.OneSchema2)s).strategy_options, CassIntrospector.access$getLOG$p(this.this$0));
                    } else if (var25_26 instanceof CassIntroQueries.OneSchema3) {
                        if (((CassIntroQueries.OneSchema3)s).replication != null) {
                            String string3;
                            CassSchema cassSchema2 = cassSchema;
                            boolean bl7 = false;
                            boolean bl8 = false;
                            String it = string3;
                            boolean bl9 = false;
                            String string4 = CassIntrospectorHelperKt.jsonToCassandraMapLiteral$default(it, CassIntrospector.access$getLOG$p(this.this$0), null, 4, null);
                            cassSchema = cassSchema2;
                            string = string4;
                        } else {
                            string = null;
                        }
                    } else {
                        string = null;
                    }
                    cassSchema.setReplication(string);
                    $this$applySchemasNamed.setCurrent(Intrinsics.areEqual((Object)s.getName(), (Object)this.$currentSchema));
                    BasicModMateNamespace cfr_ignored_0 = (BasicModMateNamespace)basicModNamedElement;
                }
                $this$applySchemasImpl$iv$iv.removeSyncPendingChildren();
                $this$applySchemasImpl$iv$iv.sort();
            }
            {
                this.this$0 = cassIntrospector;
                this.$newSchemas = list;
                this.$currentSchema = string;
                super(1);
            }
        });
    }

    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends CassSchema> schemas2) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull(schemas2, (String)"schemas");
        for (CassSchema cassSchema : schemas2) {
            this.introspectOneSchema(tran, cassSchema);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void introspectOneSchema(DBTransaction tran, CassSchema schema) {
        void this_$iv;
        BaseIntrospector baseIntrospector = this;
        String operationName$iv = "Introspect schema " + schema.getName();
        boolean $i$f$handleErrors = false;
        try {
            boolean bl = false;
            CassSchemaRetriever retriever = this.createSchemaRetriever(tran, schema);
            retriever.process();
        }
        catch (InterruptedException ie$iv) {
            throw (Throwable)ie$iv;
        }
        catch (DBException d$iv) {
            String message$iv = "Error encountered when performing " + operationName$iv + ": " + d$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)d$iv);
        }
        catch (NullPointerException npe$iv) {
            String message$iv = "NPE encountered when performing " + operationName$iv;
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)npe$iv);
            BaseIntrospector.access$getLog$p((BaseIntrospector)this_$iv).error(message$iv, (Throwable)npe$iv);
        }
        catch (Exception e$iv) {
            String message$iv = "Unexpected error (" + e$iv.getClass().getSimpleName() + ") encountered when performing " + operationName$iv + ": " + e$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)e$iv);
        }
    }

    public CassIntrospector(@NotNull Project project, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
        Dbms dbms = Dbms.CASSANDRA;
        Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"CASSANDRA");
        super(dbms, project, modelFactory);
        Logger logger = Logger.getInstance(CassIntrospector.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(CassIntrospector::class.java)");
        this.LOG = logger;
    }

    public static final /* synthetic */ void access$inModel(CassIntrospector $this, Function1 modifier) {
        $this.inModel(modifier);
    }

    public static final /* synthetic */ CommonPreprocessor access$getPreprocessor$p(CassIntrospector $this) {
        return $this.preprocessor;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "dbms", "Lcom/intellij/database/Dbms;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects.cassandra"})
    public static final class Factory
    implements DBIntrospector.Factory {
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            return version.isOrGreater(new int[]{2, 0});
        }

        @NotNull
        public DBIntrospector createIntrospector(@NotNull Dbms dbms, @NotNull Project project, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
            return new CassIntrospector(project, modelFactory);
        }

        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return false;
        }

        public boolean isNative() {
            return DBIntrospector.Factory.DefaultImpls.isNative((DBIntrospector.Factory)this);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects.cassandra"})
        public static final class VERSION
        extends PerObjectVersion {
            public static final VERSION INSTANCE;

            private VERSION() {
            }

            static {
                VERSION vERSION;
                INSTANCE = vERSION = new VERSION();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003:\u0001ZB\u0017\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001e\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00122\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\u00020\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u0012H\u0002J\u0018\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J\b\u0010!\u001a\u00020\nH\u0016J.\u0010\"\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0002J\u001e\u0010%\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020&0\u000eH\u0002J\u001e\u0010'\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020(0\u000eH\u0002J\u0018\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J&\u00103\u001a\u00020\n2\u0006\u0010\u000b\u001a\u0002042\u0006\u00105\u001a\u0002062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020&0\u000eH\u0002J\u0018\u00107\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u000208H\u0002J\u0018\u00109\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u00020:H\u0002J\u0018\u0010;\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u00020<H\u0002J\u0010\u0010=\u001a\u00020\n2\u0006\u0010>\u001a\u00020\u0012H\u0002J\u0010\u0010?\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010@\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002JN\u0010A\u001a\u00020\n\"\b\b\u0000\u0010B*\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00022\u0012\u0010C\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB0E0D2\u001e\u0010F\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB0\u000e\u0012\u0004\u0012\u00020\n0GH\u0002J\u0010\u0010H\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010I\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010J\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010K\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010L\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010M\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010N\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010O\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0018\u0010P\u001a\u00020\n2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020\u0015H\u0002J\u001c\u0010T\u001a\u00020\n2\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020W0VH\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010X\u001a\u00020\u0012H\u0002J\u0010\u0010Y\u001a\u00020\u00122\u0006\u0010X\u001a\u00020\u0012H\u0002\u00a8\u0006["}, d2={"Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector$CassSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/cassandra/model/CassSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "Lcom/intellij/database/dialects/cassandra/model/CassRoot;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/cassandra/model/CassSchema;)V", "createKey", "", "table", "Lcom/intellij/database/dialects/cassandra/model/CassLikeTable;", "columns", "", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneColumn;", "getAggregateInitConditions", "", "", "keyspace", "getDataType", "Lcom/intellij/database/model/DataType;", "validator", "unwrapFrozen", "", "getInitCondition", "initConditions", "a", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneAggregate;", "isIndexCustom", "kind", "isPossibleToIntrospectSchemaIncrementally", "tran", "process", "processAggregate", "aggregate", "Lcom/intellij/database/dialects/cassandra/model/CassAggregate;", "processColumns2", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneColumn2;", "processColumns3", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneColumn3;", "processDefType", "t", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneDefType;", "objectType", "Lcom/intellij/database/dialects/cassandra/model/CassDefType;", "processFunction", "f", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneFunction;", "function", "Lcom/intellij/database/dialects/cassandra/model/CassFunction;", "processIndex", "Lcom/intellij/database/dialects/cassandra/model/CassTable;", "index", "Lcom/intellij/database/dialects/cassandra/model/CassIndex;", "processLikeTable", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneLikeTable;", "processLikeTable2", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneLikeTable2;", "processLikeTable3", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneLikeTable3;", "progress", "what", "retrieveAggregates", "retrieveColumns", "retrieveColumnsInner", "T", "query", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "", "action", "Lkotlin/Function2;", "retrieveDefTypes", "retrieveFunctions", "retrieveIndices", "retrieveIndices2", "retrieveIndices3", "retrieveMatViews", "retrieveTables", "retrieveTriggers", "setReturnType", "routine", "Lcom/intellij/database/dialects/cassandra/model/CassRoutine;", "returnDataType", "setVersionParameters", "parameters", "", "", "s", "unwrapReversed", "ColumnSorter", "intellij.database.dialects.cassandra"})
    protected final class CassSchemaRetriever
    extends BaseIntrospector.AbstractSchemaRetriever<CassSchema> {
        @Override
        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull CassSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            return false;
        }

        private final void setVersionParameters(Map<String, Object> parameters2) {
            int n = 0;
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(CassIntrospector.this.getServerVersion(), 3, new IntRange(n, 11), parameters2);
        }

        private final void progress(String what) {
            String mode = "completely";
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Introspecting schema %s (%s)";
            Object[] objectArray = new Object[]{((CassSchema)this.getSchema()).getName(), mode};
            CassIntrospector cassIntrospector = CassIntrospector.this;
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            cassIntrospector.updateStatus(string3, what);
        }

        @Override
        public void process() {
            this.prepareParameters();
            this.inSchema((Function1)new Function1<CassSchema, Unit>(this){
                final /* synthetic */ CassSchemaRetriever this$0;

                public final void invoke(@NotNull CassSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    CassSchemaRetriever.access$retrieveTables(this.this$0, schema);
                }
                {
                    this.this$0 = cassSchemaRetriever;
                    super(1);
                }
            });
            if (CassIntrospector.this.getServerVersion().isOrGreater(new int[]{3})) {
                this.inSchema((Function1)new Function1<CassSchema, Unit>(this){
                    final /* synthetic */ CassSchemaRetriever this$0;

                    public final void invoke(@NotNull CassSchema schema) {
                        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                        CassSchemaRetriever.access$retrieveMatViews(this.this$0, schema);
                    }
                    {
                        this.this$0 = cassSchemaRetriever;
                        super(1);
                    }
                });
            }
            this.inSchema((Function1)new Function1<CassSchema, Unit>(this){
                final /* synthetic */ CassSchemaRetriever this$0;

                public final void invoke(@NotNull CassSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    CassSchemaRetriever.access$retrieveColumns(this.this$0, schema);
                }
                {
                    this.this$0 = cassSchemaRetriever;
                    super(1);
                }
            });
            this.inSchema((Function1)new Function1<CassSchema, Unit>(this){
                final /* synthetic */ CassSchemaRetriever this$0;

                public final void invoke(@NotNull CassSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    CassSchemaRetriever.access$retrieveIndices(this.this$0, schema);
                }
                {
                    this.this$0 = cassSchemaRetriever;
                    super(1);
                }
            });
            this.inSchema((Function1)new Function1<CassSchema, Unit>(this){
                final /* synthetic */ CassSchemaRetriever this$0;

                public final void invoke(@NotNull CassSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    CassSchemaRetriever.access$retrieveTriggers(this.this$0, schema);
                }
                {
                    this.this$0 = cassSchemaRetriever;
                    super(1);
                }
            });
            this.inSchema((Function1)new Function1<CassSchema, Unit>(this){
                final /* synthetic */ CassSchemaRetriever this$0;

                public final void invoke(@NotNull CassSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    CassSchemaRetriever.access$retrieveFunctions(this.this$0, schema);
                }
                {
                    this.this$0 = cassSchemaRetriever;
                    super(1);
                }
            });
            this.inSchema((Function1)new Function1<CassSchema, Unit>(this){
                final /* synthetic */ CassSchemaRetriever this$0;

                public final void invoke(@NotNull CassSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    CassSchemaRetriever.access$retrieveAggregates(this.this$0, schema);
                }
                {
                    this.this$0 = cassSchemaRetriever;
                    super(1);
                }
            });
            this.inSchema((Function1)new Function1<CassSchema, Unit>(this){
                final /* synthetic */ CassSchemaRetriever this$0;

                public final void invoke(@NotNull CassSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    CassSchemaRetriever.access$retrieveDefTypes(this.this$0, schema);
                }
                {
                    this.this$0 = cassSchemaRetriever;
                    super(1);
                }
            });
        }

        private final void retrieveTables(CassSchema schema) {
            this.progress("tables");
            boolean $i$f$cleanupFamilies = false;
            Function1 it = CassSchemaRetriever$retrieveTables$$inlined$cleanupFamilies$1.INSTANCE;
            boolean bl = false;
            ModNamingFamily<? extends CassTable> modNamingFamily = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"schema.tables");
            it.invoke(modNamingFamily);
            boolean bl2 = false;
            this.getPreprocessor().setFreeParameters(schema.getName());
            if (CassIntrospector.this.getServerVersion().isOrGreater(new int[]{3})) {
                List<CassIntroQueries.OneTable3> list = this.performQuery(CassIntroQueries.Companion.getQUERIES().getRetrieveTables3());
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(QUERIES.retrieveTables3)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CassTable table;
                    CassIntroQueries.OneTable3 t = (CassIntroQueries.OneTable3)element$iv;
                    boolean bl3 = false;
                    ModNamingFamily<? extends CassTable> modNamingFamily2 = schema.getTables();
                    String string = t.name;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    CassTable cassTable = table = (CassTable)modNamingFamily2.createOrGet(string);
                    Intrinsics.checkExpressionValueIsNotNull((Object)cassTable, (String)"table");
                    CassLikeTable cassLikeTable = cassTable;
                    CassIntroQueries.OneTable3 oneTable3 = t;
                    Intrinsics.checkExpressionValueIsNotNull((Object)oneTable3, (String)"t");
                    this.processLikeTable3(cassLikeTable, oneTable3);
                }
            } else {
                List<CassIntroQueries.OneTable2> list = this.performQuery(CassIntroQueries.Companion.getQUERIES().getRetrieveTables2());
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(QUERIES.retrieveTables2)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CassTable table;
                    CassIntroQueries.OneTable2 t = (CassIntroQueries.OneTable2)element$iv;
                    boolean bl4 = false;
                    ModNamingFamily<? extends CassTable> modNamingFamily3 = schema.getTables();
                    String string = t.name;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    CassTable cassTable = table = (CassTable)modNamingFamily3.createOrGet(string);
                    Intrinsics.checkExpressionValueIsNotNull((Object)cassTable, (String)"table");
                    CassLikeTable cassLikeTable = cassTable;
                    CassIntroQueries.OneTable2 oneTable2 = t;
                    Intrinsics.checkExpressionValueIsNotNull((Object)oneTable2, (String)"t");
                    this.processLikeTable2(cassLikeTable, oneTable2);
                }
            }
            it = CassSchemaRetriever$retrieveTables$$inlined$cleanupFamilies$2.INSTANCE;
            $i$a$-cleanupFamilies-CassIntrospector$CassSchemaRetriever$retrieveTables$1 = false;
            ModNamingFamily<? extends CassTable> modNamingFamily4 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily4, (String)"schema.tables");
            it.invoke(modNamingFamily4);
        }

        private final void retrieveMatViews(CassSchema schema) {
            this.progress("materialized views");
            boolean $i$f$cleanupFamilies = false;
            Function1 it = CassSchemaRetriever$retrieveMatViews$$inlined$cleanupFamilies$1.INSTANCE;
            boolean bl = false;
            ModNamingFamily<? extends CassMatView> modNamingFamily = schema.getMatViews();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"schema.matViews");
            it.invoke(modNamingFamily);
            boolean bl2 = false;
            this.getPreprocessor().setFreeParameters(schema.getName());
            List<CassIntroQueries.OneMatView3> list = this.performQuery(CassIntroQueries.Companion.getQUERIES().getRetrieveMatViews());
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(QUERIES.retrieveMatViews)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                String string2;
                String string3;
                boolean bl3;
                CharSequence charSequence;
                String it2;
                String string4;
                boolean bl4;
                boolean bl5;
                CassMatView cassMatView;
                CassMatView matView;
                CassIntroQueries.OneMatView3 mv = (CassIntroQueries.OneMatView3)element$iv;
                boolean bl6 = false;
                ModNamingFamily<? extends CassMatView> modNamingFamily2 = schema.getMatViews();
                String string5 = mv.name;
                if (string5 == null) {
                    Intrinsics.throwNpe();
                }
                CassMatView cassMatView2 = matView = (CassMatView)modNamingFamily2.createOrGet(string5);
                Intrinsics.checkExpressionValueIsNotNull((Object)cassMatView2, (String)"matView");
                CassLikeTable cassLikeTable = cassMatView2;
                CassIntroQueries.OneMatView3 oneMatView3 = mv;
                Intrinsics.checkExpressionValueIsNotNull((Object)oneMatView3, (String)"mv");
                this.processLikeTable3(cassLikeTable, oneMatView3);
                CassMatView cassMatView3 = matView;
                if (mv.where_clause != null) {
                    cassMatView = cassMatView3;
                    bl5 = false;
                    bl4 = false;
                    it2 = string4;
                    boolean bl7 = false;
                    charSequence = it2;
                    bl3 = false;
                    string3 = charSequence.length() == 0 ? null : it2;
                    cassMatView3 = cassMatView;
                    string2 = string3;
                } else {
                    string2 = null;
                }
                cassMatView3.setWhereClause(string2);
                CassMatView cassMatView4 = matView;
                if (mv.base_table_name != null) {
                    cassMatView = cassMatView4;
                    bl5 = false;
                    bl4 = false;
                    it2 = string4;
                    boolean bl8 = false;
                    charSequence = it2;
                    bl3 = false;
                    string3 = charSequence.length() == 0 ? null : it2;
                    cassMatView4 = cassMatView;
                    string = string3;
                } else {
                    string = null;
                }
                cassMatView4.setBaseTableName(string);
            }
            it = CassSchemaRetriever$retrieveMatViews$$inlined$cleanupFamilies$2.INSTANCE;
            $i$a$-cleanupFamilies-CassIntrospector$CassSchemaRetriever$retrieveMatViews$1 = false;
            ModNamingFamily<? extends CassMatView> modNamingFamily3 = schema.getMatViews();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily3, (String)"schema.matViews");
            it.invoke(modNamingFamily3);
        }

        private final void processLikeTable(CassLikeTable table, CassIntroQueries.OneLikeTable t) {
            String string;
            String string2;
            String string3;
            String string4;
            String it;
            boolean bl;
            boolean bl2;
            CassLikeTable cassLikeTable;
            String string5;
            CassLikeTable cassLikeTable2 = table;
            String string6 = t.getCachingValue();
            if (string6 != null) {
                string5 = string6;
                cassLikeTable = cassLikeTable2;
                bl2 = false;
                bl = false;
                it = string5;
                boolean bl3 = false;
                string4 = CassIntrospectorHelperKt.jsonToCassandraMapLiteral$default(it, CassIntrospector.this.LOG, null, 4, null);
                cassLikeTable2 = cassLikeTable;
                string3 = string4;
            } else {
                string3 = null;
            }
            cassLikeTable2.setCaching(string3);
            CassLikeTable cassLikeTable3 = table;
            String string7 = t.getComm();
            if (string7 != null) {
                string5 = string7;
                cassLikeTable = cassLikeTable3;
                bl2 = false;
                bl = false;
                it = string5;
                boolean bl4 = false;
                CharSequence charSequence = it;
                boolean bl5 = false;
                string4 = charSequence.length() == 0 ? null : it;
                cassLikeTable3 = cassLikeTable;
                string2 = string4;
            } else {
                string2 = null;
            }
            cassLikeTable3.setComment(string2);
            CassLikeTable cassLikeTable4 = table;
            String string8 = t.getCompressionValue();
            if (string8 != null) {
                string5 = string8;
                cassLikeTable = cassLikeTable4;
                bl2 = false;
                bl = false;
                it = string5;
                boolean bl6 = false;
                string4 = CassIntrospectorHelperKt.jsonToCassandraMapLiteral$default(it, CassIntrospector.this.LOG, null, 4, null);
                cassLikeTable4 = cassLikeTable;
                string = string4;
            } else {
                string = null;
            }
            cassLikeTable4.setCompression(string);
            table.setBloomFilterFpChance(t.getBloomFilterFpChance());
            table.setDefaultTimeToLive(t.getDefaultTimeToLive());
            String string9 = t.getSpeculativeRetry();
            if (string9 != null) {
                string5 = string9;
                bl2 = false;
                bl = false;
                it = string5;
                boolean bl7 = false;
                table.setSpeculativeRetry(it);
            }
            table.setGcGraceSeconds(t.getGcGraceSeconds());
            table.setMaxIndexInterval(t.getMaxIndexInterval());
            table.setMemtableFlushPeriodInMs(t.getMemtableFlushPeriodInMs());
            table.setMinIndexInterval(t.getMinIndexInterval());
            table.setReadRepairChance(t.getReadRepairChance());
        }

        private final void processLikeTable2(CassLikeTable table, CassIntroQueries.OneLikeTable2 t) {
            CassIntroQueries.OneLikeTable2 oneLikeTable2 = t;
            if (oneLikeTable2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.cassandra.introspector.CassIntroQueries.OneLikeTable");
            }
            this.processLikeTable(table, oneLikeTable2);
            table.setCompaction(CassIntrospectorHelperKt.concatClassAndOptions(t.getCompactionStrategyClass(), t.getCompactionStrategyOptions(), CassIntrospector.this.LOG));
        }

        private final void processLikeTable3(CassLikeTable table, CassIntroQueries.OneLikeTable3 t) {
            String string;
            CassIntroQueries.OneLikeTable3 oneLikeTable3 = t;
            if (oneLikeTable3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.cassandra.introspector.CassIntroQueries.OneLikeTable");
            }
            this.processLikeTable(table, oneLikeTable3);
            table.setCdc(t.getCdcValue());
            CassLikeTable cassLikeTable = table;
            String string2 = t.getCompactionValue();
            if (string2 != null) {
                String string3 = string2;
                CassLikeTable cassLikeTable2 = cassLikeTable;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                String string4 = CassIntrospectorHelperKt.jsonToCassandraMapLiteral$default(it, CassIntrospector.this.LOG, null, 4, null);
                cassLikeTable = cassLikeTable2;
                string = string4;
            } else {
                string = null;
            }
            cassLikeTable.setCompaction(string);
            table.setCrcCheckChance(t.getCrcCheckChance());
            table.setDclocalReadRepairChance(t.getDclocalReadRepairChance());
        }

        private final void retrieveColumns(CassSchema schema) {
            boolean bl;
            CassMatView v2;
            boolean bl2;
            CassTable t;
            this.progress("table columns");
            boolean $i$f$cleanupFamilies = false;
            Function1 it = CassSchemaRetriever$retrieveColumns$$inlined$cleanupFamilies$1.INSTANCE;
            boolean bl3 = false;
            ModNamingFamily<? extends CassTable> modNamingFamily = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"schema.tables");
            Iterable $this$forEach$iv = (Iterable)modNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (CassTable)element$iv;
                bl2 = false;
                CassTable cassTable = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassTable, (String)"t");
                ModPositioningNamingFamily<? extends CassTableColumn> modPositioningNamingFamily = cassTable.getColumns();
                Intrinsics.checkExpressionValueIsNotNull(modPositioningNamingFamily, (String)"t.columns");
                it.invoke(modPositioningNamingFamily);
            }
            ModNamingFamily<? extends CassMatView> modNamingFamily2 = schema.getMatViews();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily2, (String)"schema.matViews");
            $this$forEach$iv = (Iterable)modNamingFamily2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                v2 = (CassMatView)element$iv;
                bl = false;
                CassMatView cassMatView = v2;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassMatView, (String)"v");
                ModPositioningNamingFamily<? extends CassMatViewColumn> modPositioningNamingFamily = cassMatView.getColumns();
                Intrinsics.checkExpressionValueIsNotNull(modPositioningNamingFamily, (String)"v.columns");
                it.invoke(modPositioningNamingFamily);
            }
            boolean bl4 = false;
            this.getPreprocessor().setFreeParameters(schema.getName());
            if (CassIntrospector.this.getServerVersion().isOrGreater(new int[]{3, 0})) {
                this.retrieveColumnsInner(schema, CassIntroQueries.Companion.getQUERIES().getRetrieveColumns3(), (Function2)new Function2<CassLikeTable, List<? extends CassIntroQueries.OneColumn3>, Unit>(this){

                    public final void invoke(@NotNull CassLikeTable p1, @NotNull List<CassIntroQueries.OneColumn3> p2) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        Intrinsics.checkParameterIsNotNull(p2, (String)"p2");
                        CassSchemaRetriever.access$processColumns3((CassSchemaRetriever)this.receiver, p1, p2);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(CassSchemaRetriever.class);
                    }

                    public final String getName() {
                        return "processColumns3";
                    }

                    public final String getSignature() {
                        return "processColumns3(Lcom/intellij/database/dialects/cassandra/model/CassLikeTable;Ljava/util/List;)V";
                    }
                });
            } else {
                this.retrieveColumnsInner(schema, CassIntroQueries.Companion.getQUERIES().getRetrieveColumns2(), (Function2)new Function2<CassLikeTable, List<? extends CassIntroQueries.OneColumn2>, Unit>(this){

                    public final void invoke(@NotNull CassLikeTable p1, @NotNull List<CassIntroQueries.OneColumn2> p2) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        Intrinsics.checkParameterIsNotNull(p2, (String)"p2");
                        CassSchemaRetriever.access$processColumns2((CassSchemaRetriever)this.receiver, p1, p2);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(CassSchemaRetriever.class);
                    }

                    public final String getName() {
                        return "processColumns2";
                    }

                    public final String getSignature() {
                        return "processColumns2(Lcom/intellij/database/dialects/cassandra/model/CassLikeTable;Ljava/util/List;)V";
                    }
                });
            }
            it = CassSchemaRetriever$retrieveColumns$$inlined$cleanupFamilies$2.INSTANCE;
            bl3 = false;
            ModNamingFamily<? extends CassTable> modNamingFamily3 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily3, (String)"schema.tables");
            $this$forEach$iv = (Iterable)modNamingFamily3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (CassTable)element$iv;
                bl2 = false;
                CassTable cassTable = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassTable, (String)"t");
                ModPositioningNamingFamily<? extends CassTableColumn> modPositioningNamingFamily = cassTable.getColumns();
                Intrinsics.checkExpressionValueIsNotNull(modPositioningNamingFamily, (String)"t.columns");
                it.invoke(modPositioningNamingFamily);
            }
            ModNamingFamily<? extends CassMatView> modNamingFamily4 = schema.getMatViews();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily4, (String)"schema.matViews");
            $this$forEach$iv = (Iterable)modNamingFamily4;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                v2 = (CassMatView)element$iv;
                bl = false;
                CassMatView cassMatView = v2;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassMatView, (String)"v");
                ModPositioningNamingFamily<? extends CassMatViewColumn> modPositioningNamingFamily = cassMatView.getColumns();
                Intrinsics.checkExpressionValueIsNotNull(modPositioningNamingFamily, (String)"v.columns");
                it.invoke(modPositioningNamingFamily);
            }
        }

        /*
         * Unable to fully structure code
         */
        private final <T extends CassIntroQueries.OneColumn> void retrieveColumnsInner(CassSchema schema, SqlQuery<List<T>> query, Function2<? super CassLikeTable, ? super List<? extends T>, Unit> action) {
            block7: {
                tableCache = new NameCache<T>();
                var6_5 = false;
                columns = new ArrayList<E>();
                $this$forEach$iv = this.performQuery(query);
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    c = (CassIntroQueries.OneColumn)element$iv;
                    $i$a$-forEach-CassIntrospector$CassSchemaRetriever$retrieveColumnsInner$1 = false;
                    var12_15 = tableCache;
                    if (c.getTableName() == null) {
                        Intrinsics.throwNpe();
                    }
                    $i$f$get = false;
                    var15_18 = this_$iv;
                    create$iv$iv = false;
                    $i$f$get = false;
                    if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                    v0 = this_$iv$iv.getV();
                    if (v0 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                        v1 = this_$iv$iv.getV();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var18_21 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, name$iv){
                            final /* synthetic */ boolean $create;
                            final /* synthetic */ String $name;
                            {
                                this.$create = bl;
                                this.$name = string;
                                super(1);
                            }

                            @Nullable
                            public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                Intrinsics.checkParameterIsNotNull($this$invoke, (String)"$this$invoke");
                                return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                            }
                        };
                        var19_22 = this_$iv$iv;
                        var20_23 = this_$iv$iv;
                        $i$a$-get-CassIntrospector$CassSchemaRetriever$retrieveColumnsInner$1$1 = false;
                        if ((CassLikeTable)$this$get.getV() != null) {
                            var23_26 = false;
                            var24_27 = false;
                            v = var22_25;
                            $i$a$-let-CassIntrospector$CassSchemaRetriever$retrieveColumnsInner$1$1$1 = false;
                            action.invoke((Object)v, (Object)columns);
                        }
                        columns.clear();
                        v2 = schema.getTables();
                        Intrinsics.checkExpressionValueIsNotNull(v2, (String)"schema.tables");
                        v3 = (CassLikeTable)it.invoke(v2);
                        if (v3 == null) {
                            v4 = schema.getMatViews();
                            Intrinsics.checkExpressionValueIsNotNull(v4, (String)"schema.matViews");
                            v3 = (CassLikeTable)it.invoke(v4);
                        }
                        var27_30 = v3;
                        var20_23.setV((BasicModNamedElement)var27_30);
                        v1 = this_$iv$iv.getV();
                    }
                    columns.add(c);
                }
                v5 = (CassLikeTable)tableCache.getV();
                if (v5 == null) break block7;
                var6_6 = v5;
                var7_8 = false;
                var8_10 = false;
                table = var6_6;
                $i$a$-let-CassIntrospector$CassSchemaRetriever$retrieveColumnsInner$2 = false;
                action.invoke((Object)table, (Object)columns);
            }
        }

        private final void processColumns3(CassLikeTable table, List<CassIntroQueries.OneColumn3> columns) {
            ColumnSorter columnSorter = new ColumnSorter(columns);
            Iterable $this$forEach$iv = columns;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BasicModTableOrViewColumn column2;
                CassIntroQueries.OneColumn3 c = (CassIntroQueries.OneColumn3)element$iv;
                boolean bl = false;
                ModPositioningNamingFamily modPositioningNamingFamily = table.getColumns();
                short s = columnSorter.idx(c);
                String string = c.name;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                BasicModTableOrViewColumn basicModTableOrViewColumn = column2 = (BasicModTableOrViewColumn)modPositioningNamingFamily.renewAt(s, string);
                Intrinsics.checkExpressionValueIsNotNull((Object)basicModTableOrViewColumn, (String)"column");
                String string2 = c.type;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                basicModTableOrViewColumn.setDataType(DataTypeFactory.of((String)string2));
                if (!(column2 instanceof CassTableColumn)) continue;
                ((CassTableColumn)column2).setStaticColumn(Intrinsics.areEqual((Object)c.kind, (Object)"static"));
            }
            this.createKey(table, columns);
        }

        /*
         * WARNING - void declaration
         */
        private final void createKey(CassLikeTable table, List<? extends CassIntroQueries.OneColumn> columns) {
            void $this$mapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            CassKeyColumn cassKeyColumn;
            Collection collection;
            void $this$mapTo$iv$iv2;
            CassIntroQueries.OneColumn it;
            Iterable $this$filterTo$iv$iv2;
            CassKey k = (CassKey)table.getKeys().createOrGet("primary key");
            Iterable $this$filter$iv = columns;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv22 = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (CassIntroQueries.OneColumn)element$iv$iv;
                boolean bl = false;
                if (!(it.getK() == CassIntroQueries.ColumnKind.PARTITIONING)) continue;
                destination$iv$iv22.add(element$iv$iv);
            }
            Iterable $this$sortedBy$iv = (List)destination$iv$iv22;
            boolean $i$f$sortedBy = false;
            $this$filterTo$iv$iv2 = $this$sortedBy$iv;
            boolean destination$iv$iv22 = false;
            Comparator $i$f$filterTo22 = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    CassIntroQueries.OneColumn it = (CassIntroQueries.OneColumn)a;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getPos());
                    it = (CassIntroQueries.OneColumn)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = it.getPos();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$filterTo$iv$iv2, (Comparator)$i$f$filterTo22);
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (CassIntroQueries.OneColumn)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getColName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                cassKeyColumn = new CassKeyColumn(string, null);
                collection.add(cassKeyColumn);
            }
            List partitioningCols = (List)destination$iv$iv;
            Iterable $this$filter$iv2 = columns;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv32 = new ArrayList();
            boolean $i$f$filterTo32 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CassIntroQueries.OneColumn it2 = (CassIntroQueries.OneColumn)element$iv$iv;
                boolean bl = false;
                if (!(it2.getK() == CassIntroQueries.ColumnKind.CLUSTERING)) continue;
                destination$iv$iv32.add(element$iv$iv);
            }
            Iterable $this$sortedBy$iv2 = (List)destination$iv$iv32;
            boolean $i$f$sortedBy2 = false;
            $this$filterTo$iv$iv = $this$sortedBy$iv2;
            boolean destination$iv$iv32 = false;
            Comparator $i$f$filterTo32 = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    CassIntroQueries.OneColumn it = (CassIntroQueries.OneColumn)a;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getPos());
                    it = (CassIntroQueries.OneColumn)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = it.getPos();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            Iterable $this$map$iv2 = CollectionsKt.sortedWith((Iterable)$this$filterTo$iv$iv, (Comparator)$i$f$filterTo32);
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                CassIntroQueries.OneColumn it2 = (CassIntroQueries.OneColumn)item$iv$iv;
                collection = destination$iv$iv4;
                boolean bl = false;
                String string = it2.getColName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                cassKeyColumn = new CassKeyColumn(string, it2.getOrder());
                collection.add(cassKeyColumn);
            }
            List clusteringCols = (List)destination$iv$iv4;
            CassKey cassKey = k;
            Intrinsics.checkExpressionValueIsNotNull((Object)cassKey, (String)"k");
            cassKey.setColumns(CollectionsKt.plus((Collection)partitioningCols, (Iterable)clusteringCols));
        }

        private final void processColumns2(CassLikeTable table, List<CassIntroQueries.OneColumn2> columns) {
            ColumnSorter columnSorter = new ColumnSorter(columns);
            Iterable $this$forEach$iv = columns;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                BasicModTableOrViewColumn column2;
                CassIntroQueries.OneColumn2 c = (CassIntroQueries.OneColumn2)element$iv;
                boolean bl = false;
                ModPositioningNamingFamily modPositioningNamingFamily = table.getColumns();
                short s = columnSorter.idx(c);
                String string2 = c.name;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                if ((column2 = (BasicModTableOrViewColumn)modPositioningNamingFamily.renewAt(s, string2)) instanceof CassTableColumn) {
                    ((CassTableColumn)column2).setStaticColumn(Intrinsics.areEqual((Object)c.type, (Object)"static"));
                }
                if ((string = c.validator) == null) continue;
                String string3 = string;
                boolean bl2 = false;
                boolean bl3 = false;
                String it = string3;
                boolean bl4 = false;
                string = this.unwrapReversed(it);
                if (string == null) {
                    continue;
                }
                String validator = string;
                DataType dataType = CassSchemaRetriever.getDataType$default(this, validator, false, 2, null);
                if (dataType == null) continue;
                string3 = dataType;
                bl2 = false;
                bl3 = false;
                it = string3;
                boolean bl5 = false;
                BasicModTableOrViewColumn basicModTableOrViewColumn = column2;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicModTableOrViewColumn, (String)"column");
                basicModTableOrViewColumn.setDataType((DataType)it);
            }
            this.createKey(table, columns);
        }

        private final String unwrapReversed(String s) {
            if (StringsKt.startsWith$default((String)s, (String)"org.apache.cassandra.db.marshal.ReversedType", (boolean)false, (int)2, null)) {
                String string = s;
                int n = StringsKt.indexOf$default((CharSequence)s, (char)'(', (int)0, (boolean)false, (int)6, null) + 1;
                int n2 = StringsKt.lastIndexOf$default((CharSequence)s, (char)')', (int)0, (boolean)false, (int)6, null);
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return string3;
            }
            return s;
        }

        private final void retrieveIndices(CassSchema schema) {
            this.progress("indices");
            if (CassIntrospector.this.getServerVersion().isOrGreater(new int[]{3})) {
                this.retrieveIndices3(schema);
            } else {
                this.retrieveIndices2(schema);
            }
        }

        /*
         * Unable to fully structure code
         */
        private final void retrieveIndices2(CassSchema schema) {
            this.getPreprocessor().setFreeParameters(new Object[]{schema.getName()});
            $i$f$cleanupFamilies = false;
            it = CassSchemaRetriever$retrieveIndices2$$inlined$cleanupFamilies$1.INSTANCE;
            $i$a$-cleanupFamilies-CassIntrospector$CassSchemaRetriever$retrieveIndices2$1 = false;
            v0 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(v0, (String)"schema.tables");
            $this$forEach$iv = (Iterable)v0;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                t = (CassTable)element$iv;
                $i$a$-forEach-CassIntrospector$CassSchemaRetriever$retrieveIndices2$1$1 = false;
                v1 = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"t");
                v2 = v1.getIndices();
                Intrinsics.checkExpressionValueIsNotNull(v2, (String)"t.indices");
                it.invoke(v2);
            }
            $i$a$-cleanupFamilies-CassIntrospector$CassSchemaRetriever$retrieveIndices2$2 = false;
            this.getPreprocessor().setFreeParameters(new Object[]{schema.getName()});
            v3 = this.performQuery(CassIntroQueries.Companion.getQUERIES().getRetrieveIndices2());
            Intrinsics.checkExpressionValueIsNotNull(v3, (String)"performQuery(QUERIES.retrieveIndices2)");
            $this$forEach$iv = v3;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                i = (CassIntroQueries.OneIndex2)element$iv;
                $i$a$-forEach-CassIntrospector$CassSchemaRetriever$retrieveIndices2$2$1 = false;
                fullName = i.name;
                if (fullName == null) continue;
                dot = StringsKt.indexOf$default((CharSequence)fullName, (char)'.', (int)0, (boolean)false, (int)6, null);
                var12_32 = fullName;
                var13_34 = 0;
                var14_36 = 0;
                Intrinsics.checkExpressionValueIsNotNull((Object)var12_32.substring(var13_34, dot), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                var13_33 = fullName;
                var14_36 = dot + 1;
                var16_41 = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)var13_33.substring(var14_36), (String)"(this as java.lang.String).substring(startIndex)");
                if ((CassTable)schema.getTables().get(tableName) == null) {
                    continue;
                }
                table.getIndices().createOrGet(indexName);
            }
            it = CassSchemaRetriever$retrieveIndices2$$inlined$cleanupFamilies$2.INSTANCE;
            $i$a$-cleanupFamilies-CassIntrospector$CassSchemaRetriever$retrieveIndices2$1 = false;
            v4 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(v4, (String)"schema.tables");
            $this$forEach$iv = (Iterable)v4;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                t = (CassTable)element$iv;
                $i$a$-forEach-CassIntrospector$CassSchemaRetriever$retrieveIndices2$1$1 = false;
                v5 = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"t");
                v6 = v5.getIndices();
                Intrinsics.checkExpressionValueIsNotNull(v6, (String)"t.indices");
                it.invoke(v6);
            }
            tableCache = new NameCache<T>();
            indexCache = new NameCache<T>();
            $this$forEach$iv = false;
            columns = new ArrayList<E>();
            this.getPreprocessor().setFreeParameters(new Object[]{schema.getName()});
            v7 = this.performQuery(CassIntroQueries.Companion.getQUERIES().getRetrieveColumns2());
            Intrinsics.checkExpressionValueIsNotNull(v7, (String)"performQuery(QUERIES.retrieveColumns2)");
            $this$forEach$iv = v7;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                block14: {
                    block13: {
                        c = (CassIntroQueries.OneColumn2)element$iv;
                        $i$a$-forEach-CassIntrospector$CassSchemaRetriever$retrieveIndices2$3 = false;
                        if (c.index_name == null) continue;
                        dot = indexCache;
                        if (c.index_name == null) {
                            Intrinsics.throwNpe();
                        }
                        $i$f$get = false;
                        var14_38 = this_$iv;
                        create$iv$iv = false;
                        $i$f$get = false;
                        if (this_$iv$iv.getV() == null) break block13;
                        v8 = this_$iv$iv.getV();
                        if (v8 == null) {
                            Intrinsics.throwNpe();
                        }
                        if (!Intrinsics.areEqual((Object)v8.getName(), (Object)name$iv)) break block13;
                        v9 = this_$iv$iv.getV();
                        break block14;
                    }
                    var17_42 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, name$iv){
                        final /* synthetic */ boolean $create;
                        final /* synthetic */ String $name;
                        {
                            this.$create = bl;
                            this.$name = string;
                            super(1);
                        }

                        @Nullable
                        public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                            Intrinsics.checkParameterIsNotNull($this$invoke, (String)"$this$invoke");
                            return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                        }
                    };
                    var18_43 = this_$iv$iv;
                    var19_44 = this_$iv$iv;
                    $i$a$-get-CassIntrospector$CassSchemaRetriever$retrieveIndices2$3$1 = false;
                    table = (CassTable)tableCache.getV();
                    index = (CassIndex)$this$get.getV();
                    if (table != null && index != null) {
                        CassSchemaRetriever.access$processIndex(this, table, index, columns);
                    }
                    columns.clear();
                    var23_48 = tableCache;
                    if (c.getTableName() == null) {
                        Intrinsics.throwNpe();
                    }
                    $i$f$get = false;
                    var26_51 = this_$iv;
                    create$iv$iv = false;
                    $i$f$get = false;
                    if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                    v10 = this_$iv$iv.getV();
                    if (v10 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (Intrinsics.areEqual((Object)v10.getName(), (Object)name$iv)) {
                        v11 = this_$iv$iv.getV();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var29_54 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, name$iv){
                            final /* synthetic */ boolean $create;
                            final /* synthetic */ String $name;
                            {
                                this.$create = bl;
                                this.$name = string;
                                super(1);
                            }

                            @Nullable
                            public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                Intrinsics.checkParameterIsNotNull($this$invoke, (String)"$this$invoke");
                                return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                            }
                        };
                        var30_55 = this_$iv$iv;
                        var31_56 = this_$iv$iv;
                        $i$a$-get-CassIntrospector$CassSchemaRetriever$retrieveIndices2$3$1$1 = false;
                        v12 = schema.getTables();
                        Intrinsics.checkExpressionValueIsNotNull(v12, (String)"schema.tables");
                        var33_58 = (CassTable)it.invoke(v12);
                        var31_56.setV((BasicModNamedElement)var33_58);
                        v11 = this_$iv$iv.getV();
                    }
                    var34_59 = (v13 = (ModNamingFamily<? extends CassIndex>)v11) != null && (v13 = v13.getIndices()) != null ? (CassIndex)it.invoke(v13) : null;
                    var19_44.setV((BasicModNamedElement)var34_59);
                    v9 = this_$iv$iv.getV();
                }
                v14 = c;
                Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"c");
                columns.add(v14);
            }
            table = (CassTable)tableCache.getV();
            index = (CassIndex)indexCache.getV();
            if (table != null && index != null) {
                this.processIndex(table, index, columns);
            }
        }

        /*
         * Unable to fully structure code
         */
        private final void processIndex(CassTable table, CassIndex index, List<CassIntroQueries.OneColumn2> columns) {
            v0 = (CassIntroQueries.OneColumn2)CollectionsKt.firstOrNull(columns);
            if (v0 == null) {
                return;
            }
            firstCol = v0;
            index.setCustom(this.isIndexCustom(firstCol.index_type));
            var5_5 = columns;
            var23_6 = index;
            $i$f$map = false;
            var7_8 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                block6: {
                    block7: {
                        var12_13 = (CassIntroQueries.OneColumn2)item$iv$iv;
                        var24_24 = destination$iv$iv;
                        $i$a$-map-CassIntrospector$CassSchemaRetriever$processIndex$1 = false;
                        if (c.name == null) {
                            Intrinsics.throwNpe();
                        }
                        options = c.index_options;
                        modifier = null;
                        if (options == null) break block6;
                        obj = CassIntrospectorHelperKt.parseObject(options, CassIntrospector.access$getLOG$p(CassIntrospector.this));
                        if (obj == null) break block7;
                        var19_20 = "index_keys_and_values";
                        var20_21 = false;
                        var21_22 = var18_19;
                        var22_23 = false;
                        if (!var21_22.containsKey(var19_20)) break block7;
                        modifier = "entries";
                        break block6;
                    }
                    if (obj == null) ** GOTO lbl-1000
                    var19_20 = "index_keys";
                    var20_21 = false;
                    var21_22 = var18_19;
                    var22_23 = false;
                    if (var21_22.containsKey(var19_20)) {
                        modifier = "keys";
                    } else if ((v1 = (CassTableColumn)table.getColumns().get(columnName)) != null && (v1 = v1.getDataType()) != null && (v1 = v1.typeName) != null ? StringsKt.startsWith$default((String)v1, (String)"frozen<", (boolean)false, (int)2, null) : false) {
                        modifier = "full";
                    }
                }
                var25_25 = new CassIndexColumn(columnName, modifier);
                var24_24.add(var25_25);
            }
            var24_24 = (List)destination$iv$iv;
            var23_6.setColumns(CollectionsKt.toList((Iterable)var24_24));
        }

        private final void retrieveIndices3(CassSchema schema) {
            this.getPreprocessor().setFreeParameters(schema.getName());
            boolean $i$f$cleanupFamilies = false;
            Function1 it = CassSchemaRetriever$retrieveIndices3$$inlined$cleanupFamilies$1.INSTANCE;
            boolean bl = false;
            ModNamingFamily<? extends CassTable> modNamingFamily = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"schema.tables");
            Iterable $this$forEach$iv = (Iterable)modNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CassTable t = (CassTable)element$iv;
                boolean bl2 = false;
                CassTable cassTable = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassTable, (String)"t");
                ModNamingFamily<? extends CassIndex> modNamingFamily2 = cassTable.getIndices();
                Intrinsics.checkExpressionValueIsNotNull(modNamingFamily2, (String)"t.indices");
                it.invoke(modNamingFamily2);
            }
            boolean bl3 = false;
            this.getPreprocessor().setFreeParameters(schema.getName());
            List<CassIntroQueries.OneIndex3> list = this.performQuery(CassIntroQueries.Companion.getQUERIES().getRetrieveIndices3());
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(QUERIES.retrieveIndices3)");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Object object;
                boolean bl4;
                boolean $i$f$castSafelyTo;
                Map<String, Object> $this$castSafelyTo$iv;
                CassIndex index2;
                CassTable table;
                CassIntroQueries.OneIndex3 i2 = (CassIntroQueries.OneIndex3)element$iv;
                boolean bl5 = false;
                ModNamingFamily<? extends CassTable> modNamingFamily3 = schema.getTables();
                String string = i2.table_name;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                if ((CassTable)modNamingFamily3.get(string) == null) {
                    continue;
                }
                ModNamingFamily<? extends CassIndex> modNamingFamily4 = table.getIndices();
                String string2 = i2.name;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                CassIndex cassIndex = index2 = (CassIndex)modNamingFamily4.createOrGet(string2);
                Intrinsics.checkExpressionValueIsNotNull((Object)cassIndex, (String)"index");
                cassIndex.setCustom(this.isIndexCustom(i2.kind));
                String options = i2.options;
                if (options == null) continue;
                Map<String, Object> obj2 = CassIntrospectorHelperKt.parseObject(options, CassIntrospector.this.LOG);
                Map<String, Object> map2 = obj2;
                if (map2 != null && (map2 = map2.get("target")) != null) {
                    $this$castSafelyTo$iv = map2;
                    $i$f$castSafelyTo = false;
                    Map<String, Object> map3 = $this$castSafelyTo$iv;
                    if (!(map3 instanceof String)) {
                        map3 = null;
                    }
                    if ((map2 = (String)((Object)map3)) != null) {
                        Map<String, Object> map4;
                        String modificator;
                        String string3;
                        int n;
                        $this$castSafelyTo$iv = map2;
                        $i$f$castSafelyTo = false;
                        bl4 = false;
                        Map<String, Object> target2 = $this$castSafelyTo$iv;
                        boolean bl6 = false;
                        int parenth = StringsKt.indexOf$default((CharSequence)((CharSequence)((Object)target2)), (String)"(", (int)0, (boolean)false, (int)6, null);
                        if (parenth != -1) {
                            Map<String, Object> map5 = target2;
                            int n2 = 0;
                            n = 0;
                            Map<String, Object> map6 = map5;
                            if (map6 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string4 = ((String)((Object)map6)).substring(n2, parenth);
                            string3 = string4;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        } else {
                            string3 = modificator = null;
                        }
                        if (modificator != null) {
                            Map<String, Object> map7 = target2;
                            n = parenth + 1;
                            int n3 = ((String)((Object)target2)).length() - 1;
                            boolean bl7 = false;
                            Map<String, Object> map8 = map7;
                            if (map8 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string5 = ((String)((Object)map8)).substring(n, n3);
                            map4 = string5;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        } else {
                            map4 = target2;
                        }
                        Map<String, Object> colName = map4;
                        index2.setColumns(CollectionsKt.listOf((Object)new CassIndexColumn((String)((Object)colName), StringUtil.toLowerCase(modificator))));
                    }
                }
                if ((object = obj2) != null && (object = object.get("class_name")) != null) {
                    $this$castSafelyTo$iv = object;
                    $i$f$castSafelyTo = false;
                    Map<String, Object> map9 = $this$castSafelyTo$iv;
                    if (!(map9 instanceof String)) {
                        map9 = null;
                    }
                    if ((object = (String)((Object)map9)) != null) {
                        Object object2 = object;
                        boolean bl8 = false;
                        bl4 = false;
                        Object it2 = object2;
                        boolean bl9 = false;
                        index2.setClassName((String)it2);
                    }
                }
                index2.setOptions(CassIntrospectorHelperKt.jsonToCassandraMapLiteral(options, CassIntrospector.this.LOG, (Function1<? super String, Boolean>)((Function1)retrieveIndices3.2.1.3.INSTANCE)));
            }
            it = CassSchemaRetriever$retrieveIndices3$$inlined$cleanupFamilies$2.INSTANCE;
            $i$a$-cleanupFamilies-CassIntrospector$CassSchemaRetriever$retrieveIndices3$1 = false;
            ModNamingFamily<? extends CassTable> modNamingFamily5 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily5, (String)"schema.tables");
            $this$forEach$iv = (Iterable)modNamingFamily5;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CassTable t = (CassTable)element$iv;
                boolean bl10 = false;
                CassTable cassTable = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassTable, (String)"t");
                ModNamingFamily<? extends CassIndex> modNamingFamily6 = cassTable.getIndices();
                Intrinsics.checkExpressionValueIsNotNull(modNamingFamily6, (String)"t.indices");
                it.invoke(modNamingFamily6);
            }
        }

        private final boolean isIndexCustom(String kind) {
            return StringUtil.equalsIgnoreCase((CharSequence)kind, (CharSequence)"custom");
        }

        private final void retrieveTriggers(CassSchema schema) {
            this.progress("triggers");
            boolean $i$f$cleanupFamilies = false;
            Function1 it = CassSchemaRetriever$retrieveTriggers$$inlined$cleanupFamilies$1.INSTANCE;
            boolean bl = false;
            ModNamingFamily<? extends CassTable> modNamingFamily = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"schema.tables");
            Iterable $this$forEach$iv = (Iterable)modNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CassTable t = (CassTable)element$iv;
                boolean bl2 = false;
                CassTable cassTable = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassTable, (String)"t");
                ModNamingFamily<? extends CassTrigger> modNamingFamily2 = cassTable.getTriggers();
                Intrinsics.checkExpressionValueIsNotNull(modNamingFamily2, (String)"t.triggers");
                it.invoke(modNamingFamily2);
            }
            boolean bl3 = false;
            this.getPreprocessor().setFreeParameters(schema.getName());
            List<CassIntroQueries.OneTrigger> list = this.performQuery(CassIntroQueries.Companion.getQUERIES().getRetrieveTriggers());
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(QUERIES.retrieveTriggers)");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                CassTable table;
                CassIntroQueries.OneTrigger t = (CassIntroQueries.OneTrigger)element$iv;
                boolean bl4 = false;
                ModNamingFamily<? extends CassTable> modNamingFamily3 = schema.getTables();
                String string = t.table_name;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                if ((CassTable)modNamingFamily3.get(string) == null) {
                    continue;
                }
                ModNamingFamily<? extends CassTrigger> modNamingFamily4 = table.getTriggers();
                String string2 = t.name;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                CassTrigger trigger = (CassTrigger)modNamingFamily4.createOrGet(string2);
                Object object = t.options;
                if (object == null) continue;
                Object object2 = object;
                boolean bl5 = false;
                boolean bl6 = false;
                Object it2 = object2;
                boolean bl7 = false;
                Map<String, Object> map2 = CassIntrospectorHelperKt.parseObject((String)it2, CassIntrospector.this.LOG);
                object = map2 != null ? map2.get("class") : null;
                if (object == null) continue;
                Object $this$castSafelyTo$iv = object;
                boolean $i$f$castSafelyTo = false;
                Object object3 = $this$castSafelyTo$iv;
                if (!(object3 instanceof String)) {
                    object3 = null;
                }
                if ((object = (String)object3) == null) continue;
                object2 = object;
                bl5 = false;
                bl6 = false;
                it2 = object2;
                boolean bl8 = false;
                CassTrigger cassTrigger = trigger;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassTrigger, (String)"trigger");
                cassTrigger.setClassName((String)it2);
            }
            it = CassSchemaRetriever$retrieveTriggers$$inlined$cleanupFamilies$2.INSTANCE;
            $i$a$-cleanupFamilies-CassIntrospector$CassSchemaRetriever$retrieveTriggers$1 = false;
            ModNamingFamily<? extends CassTable> modNamingFamily5 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily5, (String)"schema.tables");
            $this$forEach$iv = (Iterable)modNamingFamily5;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CassTable t = (CassTable)element$iv;
                boolean bl9 = false;
                CassTable cassTable = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassTable, (String)"t");
                ModNamingFamily<? extends CassTrigger> modNamingFamily6 = cassTable.getTriggers();
                Intrinsics.checkExpressionValueIsNotNull(modNamingFamily6, (String)"t.triggers");
                it.invoke(modNamingFamily6);
            }
        }

        private final void retrieveFunctions(CassSchema schema) {
            if (!CassIntrospector.this.getServerVersion().isOrGreater(new int[]{2, 2})) {
                return;
            }
            this.progress("functions");
            boolean $i$f$cleanupFamilies = false;
            Function1 it = CassSchemaRetriever$retrieveFunctions$$inlined$cleanupFamilies$1.INSTANCE;
            boolean bl = false;
            ModNamingFamily<? extends CassFunction> modNamingFamily = schema.getFunctions();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"schema.functions");
            it.invoke(modNamingFamily);
            boolean bl2 = false;
            it = CassSchemaRetriever$retrieveFunctions$$inlined$cleanupFamilies$2.INSTANCE;
            bl = false;
            ModNamingFamily<? extends CassFunction> modNamingFamily2 = schema.getFunctions();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily2, (String)"schema.functions");
            it.invoke(modNamingFamily2);
            this.getPreprocessor().setFreeParameters(schema.getName());
            List<CassIntroQueries.OneFunction> list = this.performQuery(CassIntroQueries.Companion.getQUERIES().getRetrieveFunctions());
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(QUERIES.retrieveFunctions)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CassFunction function;
                CassIntroQueries.OneFunction f = (CassIntroQueries.OneFunction)element$iv;
                boolean bl3 = false;
                CassFunction cassFunction = function = (CassFunction)schema.getFunctions().createNewOne();
                Intrinsics.checkExpressionValueIsNotNull((Object)cassFunction, (String)"function");
                String string = f.name;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                cassFunction.setName(string);
                CassIntroQueries.OneFunction oneFunction = f;
                Intrinsics.checkExpressionValueIsNotNull((Object)oneFunction, (String)"f");
                this.processFunction(oneFunction, function);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processFunction(CassIntroQueries.OneFunction f, CassFunction function) {
            String string = f.return_type;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            DataType dataType = this.getDataType(string, true);
            if (dataType != null) {
                DataType dataType2 = dataType;
                boolean bl = false;
                boolean bl2 = false;
                DataType it = dataType2;
                boolean bl3 = false;
                this.setReturnType(function, it);
            }
            if (f.argument_names == null) {
                Intrinsics.throwNpe();
            }
            String[] $this$forEachIndexed$iv = f.argument_names;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (String item$iv : $this$forEachIndexed$iv) {
                DataType dataType3;
                void argumentName;
                int n = index$iv++;
                String string2 = item$iv;
                int index2 = n;
                boolean bl = false;
                CassArgument argument = (CassArgument)function.getArguments().renewAt((short)(index2 + 2), (String)argumentName);
                if (f.argument_types == null) {
                    Intrinsics.throwNpe();
                }
                if (this.getDataType(f.argument_types[index2], true) == null) continue;
                boolean bl4 = false;
                boolean bl5 = false;
                DataType it = dataType3;
                boolean bl6 = false;
                CassArgument cassArgument = argument;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassArgument, (String)"argument");
                cassArgument.setDataType(it);
            }
            function.setCalledOnNullInput(f.called_on_null_input);
            function.setLanguage(f.language);
            ((BasicModModel)function.getModel()).writeSources(new Runnable(function, f){
                final /* synthetic */ CassFunction $function;
                final /* synthetic */ CassIntroQueries.OneFunction $f;

                public final void run() {
                    String string = this.$f.body;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$function.setSourceText((CompositeText)BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.ORIGINAL_TEXT));
                }
                {
                    this.$function = cassFunction;
                    this.$f = oneFunction;
                }
            });
        }

        private final void setReturnType(CassRoutine routine, DataType returnDataType) {
            CassArgument argument;
            CassArgument cassArgument = argument = (CassArgument)routine.getArguments().renewAt((short)1, "");
            Intrinsics.checkExpressionValueIsNotNull((Object)cassArgument, (String)"argument");
            cassArgument.setDataType(returnDataType);
            argument.setArgumentDirection(ArgumentDirection.RETURN);
        }

        private final DataType getDataType(String validator, boolean unwrapFrozen) {
            String string;
            if (CassIntrospector.this.getServerVersion().isOrGreater(new int[]{3, 0})) {
                string = validator;
            } else {
                string = CassIntrospectorHelperKt.parseDataType(validator);
                if (string == null) {
                    return null;
                }
            }
            String specification = string;
            return DataTypeFactory.of((String)(unwrapFrozen ? this.unwrapFrozen(specification) : specification));
        }

        static /* synthetic */ DataType getDataType$default(CassSchemaRetriever cassSchemaRetriever, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return cassSchemaRetriever.getDataType(string, bl);
        }

        private final String unwrapFrozen(String s) {
            if (StringsKt.startsWith$default((String)s, (String)"frozen<", (boolean)false, (int)2, null)) {
                String string = s;
                int n = "frozen<".length();
                int n2 = s.length() - 1;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return string3;
            }
            return s;
        }

        private final void retrieveAggregates(CassSchema schema) {
            if (!CassIntrospector.this.getServerVersion().isOrGreater(new int[]{2, 2})) {
                return;
            }
            this.progress("aggregates");
            boolean $i$f$cleanupFamilies = false;
            Function1 it = CassSchemaRetriever$retrieveAggregates$$inlined$cleanupFamilies$1.INSTANCE;
            boolean bl = false;
            ModNamingFamily<? extends CassAggregate> modNamingFamily = schema.getAggregates();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"schema.aggregates");
            it.invoke(modNamingFamily);
            boolean bl2 = false;
            it = CassSchemaRetriever$retrieveAggregates$$inlined$cleanupFamilies$2.INSTANCE;
            bl = false;
            ModNamingFamily<? extends CassAggregate> modNamingFamily2 = schema.getAggregates();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily2, (String)"schema.aggregates");
            it.invoke(modNamingFamily2);
            String string = schema.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"schema.name");
            Map<String, String> initConditions = this.getAggregateInitConditions(string);
            this.getPreprocessor().setFreeParameters(schema.getName());
            List<CassIntroQueries.OneAggregate> list = this.performQuery(CassIntroQueries.Companion.getQUERIES().getRetrieveAggregate());
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(QUERIES.retrieveAggregate)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CassAggregate aggregate;
                CassIntroQueries.OneAggregate a = (CassIntroQueries.OneAggregate)element$iv;
                boolean bl3 = false;
                CassAggregate cassAggregate = aggregate = (CassAggregate)schema.getAggregates().createNewOne();
                Intrinsics.checkExpressionValueIsNotNull((Object)cassAggregate, (String)"aggregate");
                String string2 = a.name;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                cassAggregate.setName(string2);
                CassIntroQueries.OneAggregate oneAggregate = a;
                Intrinsics.checkExpressionValueIsNotNull((Object)oneAggregate, (String)"a");
                this.processAggregate(oneAggregate, aggregate, initConditions);
            }
        }

        private final Map<String, String> getAggregateInitConditions(String keyspace) {
            RemoteConnection connection;
            DatabaseConnection databaseConnection = CassIntrospector.this.getDbConnection();
            Object object = connection = databaseConnection != null ? databaseConnection.getRemoteConnection() : null;
            if (connection == null || !(connection instanceof RemoteCassConnection)) {
                return null;
            }
            try {
                return ((RemoteCassConnection)connection).getAggregateInitConditions(keyspace);
            }
            catch (NoSuchObjectException e) {
                CassIntrospector.this.LOG.error((Throwable)e);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processAggregate(CassIntroQueries.OneAggregate a, CassAggregate aggregate, Map<String, String> initConditions) {
            block5: {
                DataType it;
                boolean bl;
                boolean bl2;
                DataType dataType;
                String string = a.return_type;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                DataType dataType2 = this.getDataType(string, true);
                if (dataType2 != null) {
                    dataType = dataType2;
                    bl2 = false;
                    bl = false;
                    it = dataType;
                    int n = 0;
                    this.setReturnType(aggregate, it);
                }
                DataType dataType3 = a.signature;
                if (dataType3 == null) {
                    Intrinsics.throwNpe();
                }
                DataType $this$forEachIndexed$iv = dataType3;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (String item$iv : $this$forEachIndexed$iv) {
                    void type;
                    CassArgument argument;
                    int n = index$iv++;
                    String string2 = item$iv;
                    int index2 = n;
                    boolean bl3 = false;
                    CassArgument cassArgument = argument = (CassArgument)aggregate.getArguments().renewAt((short)(index2 + 2), "");
                    Intrinsics.checkExpressionValueIsNotNull((Object)cassArgument, (String)"argument");
                    cassArgument.setDataType(DataTypeFactory.of((String)this.unwrapFrozen((String)type)));
                }
                aggregate.setFinalFunc(a.final_func);
                aggregate.setStateFunc(a.state_func);
                aggregate.setInitCond(this.getInitCondition(initConditions, a));
                String string3 = a.state_type;
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                DataType dataType4 = this.getDataType(string3, true);
                if (dataType4 == null) break block5;
                dataType = dataType4;
                bl2 = false;
                bl = false;
                it = dataType;
                boolean bl4 = false;
                aggregate.setStateType(it);
            }
        }

        private final String getInitCondition(Map<String, String> initConditions, CassIntroQueries.OneAggregate a) {
            if (initConditions == null) {
                return "???";
            }
            StringBuilder stringBuilder = new StringBuilder().append(a.name).append('(');
            if (a.signature == null) {
                Intrinsics.throwNpe();
            }
            String signature2 = stringBuilder.append(ArraysKt.joinToString$default((Object[])a.signature, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>(this){
                final /* synthetic */ CassSchemaRetriever this$0;

                @NotNull
                public final String invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return CassSchemaRetriever.access$unwrapFrozen(this.this$0, it);
                }
                {
                    this.this$0 = cassSchemaRetriever;
                    super(1);
                }
            }), (int)31, null)).append(')').toString();
            return initConditions.get(signature2);
        }

        private final void retrieveDefTypes(CassSchema schema) {
            this.progress("types");
            boolean $i$f$cleanupFamilies = false;
            Function1 it = CassSchemaRetriever$retrieveDefTypes$$inlined$cleanupFamilies$1.INSTANCE;
            boolean bl = false;
            ModNamingFamily<? extends CassDefType> modNamingFamily = schema.getDefTypes();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"schema.defTypes");
            it.invoke(modNamingFamily);
            ModNamingFamily<? extends CassDefType> modNamingFamily2 = schema.getDefTypes();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily2, (String)"schema.defTypes");
            Iterable $this$forEach$iv = (Iterable)modNamingFamily2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CassDefType d = (CassDefType)element$iv;
                boolean bl2 = false;
                CassDefType cassDefType = d;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassDefType, (String)"d");
                ModPositioningNamingFamily<? extends CassDefTypeAttribute> modPositioningNamingFamily = cassDefType.getAttributes();
                Intrinsics.checkExpressionValueIsNotNull(modPositioningNamingFamily, (String)"d.attributes");
                it.invoke(modPositioningNamingFamily);
            }
            boolean bl3 = false;
            this.getPreprocessor().setFreeParameters(schema.getName());
            List<CassIntroQueries.OneDefType> list = this.performQuery(CassIntroQueries.Companion.getQUERIES().getRetrieveDefTypes());
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(QUERIES.retrieveDefTypes)");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                CassIntroQueries.OneDefType t = (CassIntroQueries.OneDefType)element$iv;
                boolean bl4 = false;
                ModNamingFamily<? extends CassDefType> modNamingFamily3 = schema.getDefTypes();
                String string = t.name;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                CassDefType objectType = (CassDefType)modNamingFamily3.createOrGet(string);
                CassIntroQueries.OneDefType oneDefType = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)oneDefType, (String)"t");
                CassDefType cassDefType = objectType;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassDefType, (String)"objectType");
                this.processDefType(oneDefType, cassDefType);
            }
            it = CassSchemaRetriever$retrieveDefTypes$$inlined$cleanupFamilies$2.INSTANCE;
            $i$a$-cleanupFamilies-CassIntrospector$CassSchemaRetriever$retrieveDefTypes$1 = false;
            ModNamingFamily<? extends CassDefType> modNamingFamily4 = schema.getDefTypes();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily4, (String)"schema.defTypes");
            it.invoke(modNamingFamily4);
            ModNamingFamily<? extends CassDefType> modNamingFamily5 = schema.getDefTypes();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily5, (String)"schema.defTypes");
            $this$forEach$iv = (Iterable)modNamingFamily5;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CassDefType d = (CassDefType)element$iv;
                boolean bl5 = false;
                CassDefType cassDefType = d;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassDefType, (String)"d");
                ModPositioningNamingFamily<? extends CassDefTypeAttribute> modPositioningNamingFamily = cassDefType.getAttributes();
                Intrinsics.checkExpressionValueIsNotNull(modPositioningNamingFamily, (String)"d.attributes");
                it.invoke(modPositioningNamingFamily);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processDefType(CassIntroQueries.OneDefType t, CassDefType objectType) {
            if (t.field_names == null) {
                Intrinsics.throwNpe();
            }
            String[] $this$forEachIndexed$iv = t.field_names;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (String item$iv : $this$forEachIndexed$iv) {
                DataType dataType;
                void objectTypeName;
                int n = index$iv++;
                String string = item$iv;
                int index2 = n;
                boolean bl = false;
                CassDefTypeAttribute attribute = (CassDefTypeAttribute)objectType.getAttributes().renewAt((short)(index2 + 1), (String)objectTypeName);
                if (t.field_types == null) {
                    Intrinsics.throwNpe();
                }
                if (CassSchemaRetriever.getDataType$default(this, t.field_types[index2], false, 2, null) == null) continue;
                boolean bl2 = false;
                boolean bl3 = false;
                DataType it = dataType;
                boolean bl4 = false;
                CassDefTypeAttribute cassDefTypeAttribute = attribute;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassDefTypeAttribute, (String)"attribute");
                cassDefTypeAttribute.setDataType(it);
            }
        }

        public CassSchemaRetriever(@NotNull DBTransaction transaction, CassSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super((BaseIntrospector)CassIntrospector.this, transaction, (BasicModSchema)schema);
            this.setVersionParameters(this.getQueryParameters());
        }

        public static final /* synthetic */ void access$retrieveTables(CassSchemaRetriever $this, CassSchema schema) {
            $this.retrieveTables(schema);
        }

        public static final /* synthetic */ void access$retrieveMatViews(CassSchemaRetriever $this, CassSchema schema) {
            $this.retrieveMatViews(schema);
        }

        public static final /* synthetic */ void access$retrieveColumns(CassSchemaRetriever $this, CassSchema schema) {
            $this.retrieveColumns(schema);
        }

        public static final /* synthetic */ void access$retrieveIndices(CassSchemaRetriever $this, CassSchema schema) {
            $this.retrieveIndices(schema);
        }

        public static final /* synthetic */ void access$retrieveTriggers(CassSchemaRetriever $this, CassSchema schema) {
            $this.retrieveTriggers(schema);
        }

        public static final /* synthetic */ void access$retrieveFunctions(CassSchemaRetriever $this, CassSchema schema) {
            $this.retrieveFunctions(schema);
        }

        public static final /* synthetic */ void access$retrieveAggregates(CassSchemaRetriever $this, CassSchema schema) {
            $this.retrieveAggregates(schema);
        }

        public static final /* synthetic */ void access$retrieveDefTypes(CassSchemaRetriever $this, CassSchema schema) {
            $this.retrieveDefTypes(schema);
        }

        public static final /* synthetic */ void access$processColumns3(CassSchemaRetriever $this, CassLikeTable table, List columns) {
            $this.processColumns3(table, columns);
        }

        public static final /* synthetic */ void access$processColumns2(CassSchemaRetriever $this, CassLikeTable table, List columns) {
            $this.processColumns2(table, columns);
        }

        public static final /* synthetic */ void access$processIndex(CassSchemaRetriever $this, CassTable table, CassIndex index2, List columns) {
            $this.processIndex(table, index2, columns);
        }

        public static final /* synthetic */ String access$unwrapFrozen(CassSchemaRetriever $this, String s) {
            return $this.unwrapFrozen(s);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector$CassSchemaRetriever$ColumnSorter;", "", "columns", "", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneColumn;", "(Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector$CassSchemaRetriever;Ljava/util/List;)V", "clusteringColsCount", "", "partitionColsCount", "regularColumnsCount", "idx", "", "c", "intellij.database.dialects.cassandra"})
        private final class ColumnSorter {
            private final int partitionColsCount;
            private final int clusteringColsCount;
            private int regularColumnsCount;

            public final short idx(@NotNull CassIntroQueries.OneColumn c) {
                int n;
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                switch (CassIntrospector$CassSchemaRetriever$ColumnSorter$WhenMappings.$EnumSwitchMapping$0[c.getK().ordinal()]) {
                    case 1: {
                        n = c.getPos();
                        break;
                    }
                    case 2: {
                        n = c.getPos() + this.partitionColsCount;
                        break;
                    }
                    default: {
                        int n2 = this.regularColumnsCount;
                        this.regularColumnsCount = n2 + 1;
                        n = this.partitionColsCount + this.clusteringColsCount + n2;
                    }
                }
                return (short)(1 + n);
            }

            public ColumnSorter(List<? extends CassIntroQueries.OneColumn> columns) {
                int n;
                int n2;
                int count$iv;
                int n3;
                Iterable $this$count$iv;
                Intrinsics.checkParameterIsNotNull(columns, (String)"columns");
                Iterable iterable = columns;
                ColumnSorter columnSorter = this;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n3 = 0;
                } else {
                    count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        CassIntroQueries.OneColumn it22 = (CassIntroQueries.OneColumn)element$iv;
                        boolean bl = false;
                        if (!(it22.getK() == CassIntroQueries.ColumnKind.PARTITIONING)) continue;
                        int it22 = ++count$iv;
                        bl = false;
                        if (it22 >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n3 = count$iv;
                }
                columnSorter.partitionColsCount = n2 = n3;
                $this$count$iv = columns;
                columnSorter = this;
                $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        CassIntroQueries.OneColumn it = (CassIntroQueries.OneColumn)element$iv;
                        boolean bl = false;
                        if (!(it.getK() == CassIntroQueries.ColumnKind.CLUSTERING)) continue;
                        int n4 = ++count$iv;
                        boolean bl2 = false;
                        if (n4 >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                columnSorter.clusteringColsCount = n2 = n;
            }
        }
    }
}

