/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.css.descriptor.CssContextType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssFileType
extends LanguageFileType {
    @NonNls
    public static final String DEFAULT_EXTENSION = "css";
    public static final LanguageFileType INSTANCE = new CssFileType();
    @NonNls
    private static final String DESCRIPTION = "Cascading style sheet";

    public CssFileType() {
        super((Language)CSSLanguage.INSTANCE);
    }

    @NotNull
    public String getName() {
        return "CSS";
    }

    @NotNull
    public String getDescription() {
        return DESCRIPTION;
    }

    @NotNull
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.Css;
    }

    public String getCharset(@NotNull VirtualFile file, byte @NotNull [] content) {
        Charset charset;
        if (file == null) {
            CssFileType.$$$reportNull$$$0(0);
        }
        if (content == null) {
            CssFileType.$$$reportNull$$$0(1);
        }
        return (charset = CssFileType.getCharsetFromCssContent(content)) != null ? charset.name() : null;
    }

    public Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile file, @NotNull CharSequence content) {
        if (content == null) {
            CssFileType.$$$reportNull$$$0(2);
        }
        return CssFileType.getCharsetFromCssContent(content);
    }

    public static Charset getCharsetFromCssContent(byte[] content) {
        Charset fromBOM = CharsetToolkit.guessFromBOM((byte[])content);
        if (fromBOM != null) {
            return fromBOM;
        }
        String strContent = new String(content, StandardCharsets.ISO_8859_1);
        return CssFileType.getCharsetFromCssContent(strContent);
    }

    @Nullable
    public static Charset getCharsetFromCssContent(@NotNull CharSequence content) {
        if (content == null) {
            CssFileType.$$$reportNull$$$0(3);
        }
        int charsetKeywordLength = CssContextType.CHARSET.toString().length();
        if (StringUtil.startsWith((CharSequence)content, (CharSequence)CssContextType.CHARSET.toString()) && content.length() > charsetKeywordLength) {
            int i;
            char ch = content.charAt(i);
            for (i = charsetKeywordLength; i < content.length() && Character.isWhitespace(ch = content.charAt(i)); ++i) {
            }
            if (ch != '\"') {
                return null;
            }
            if (++i >= content.length()) {
                return null;
            }
            ch = content.charAt(i);
            StringBuilder name = new StringBuilder();
            while (i < content.length() && !Character.isWhitespace(ch) && ch != '\"') {
                name.append(ch);
                if (++i + 1 >= content.length()) continue;
                ch = content.charAt(i);
            }
            if (ch != '\"') {
                return null;
            }
            return CharsetToolkit.forName((String)name.toString());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/CssFileType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCharset";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "extractCharsetFromFileContent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCharsetFromCssContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

