/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.nbformat;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/NewLineProcessor;", "", "jsonArray", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "lineToInsert", "", "(Lcom/fasterxml/jackson/databind/node/ArrayNode;Ljava/lang/String;)V", "currentLine", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "modifyingLastLine", "", "nextCharPosition", "", "pendingCarriageReturn", "carriageReturn", "", "flushLine", "newLine", "putChar", "c", "", "putCharAndCheckForCarriage", "intellij.python.jupyter"})
public final class NewLineProcessor {
    private final StringBuilder currentLine;
    private int nextCharPosition;
    private boolean pendingCarriageReturn;
    private boolean modifyingLastLine;
    private final ArrayNode jsonArray;

    private final void putCharAndCheckForCarriage(char c) {
        if (this.pendingCarriageReturn) {
            this.nextCharPosition = 0;
            this.pendingCarriageReturn = false;
        }
        this.putChar(c);
    }

    private final void putChar(char c) {
        if (this.nextCharPosition < this.currentLine.length()) {
            StringBuilder stringBuilder = this.currentLine;
            int n = this.nextCharPosition;
            char c2 = c;
            boolean bl = false;
            stringBuilder.setCharAt(n, c2);
        } else {
            this.currentLine.append(c);
        }
        int n = this.nextCharPosition;
        this.nextCharPosition = n + 1;
    }

    private final void carriageReturn() {
        if (!this.pendingCarriageReturn) {
            this.pendingCarriageReturn = true;
        }
    }

    private final void newLine() {
        this.nextCharPosition = this.currentLine.length();
        if (this.pendingCarriageReturn) {
            this.pendingCarriageReturn = false;
            this.putChar('\r');
        }
        this.putChar('\n');
        this.flushLine();
    }

    private final void flushLine() {
        String string = this.currentLine.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"currentLine.toString()");
        String line2 = string;
        CharSequence charSequence = line2;
        boolean bl = false;
        if (charSequence.length() > 0) {
            if (!this.modifyingLastLine) {
                this.jsonArray.add(line2);
            } else {
                this.jsonArray.set(this.jsonArray.size() - 1, (JsonNode)TextNode.valueOf((String)line2));
            }
            StringsKt.clear((StringBuilder)this.currentLine);
        }
        this.modifyingLastLine = false;
    }

    /*
     * WARNING - void declaration
     */
    public NewLineProcessor(@NotNull ArrayNode jsonArray, @NotNull String lineToInsert) {
        Intrinsics.checkParameterIsNotNull((Object)jsonArray, (String)"jsonArray");
        Intrinsics.checkParameterIsNotNull((Object)lineToInsert, (String)"lineToInsert");
        this.jsonArray = jsonArray;
        this.currentLine = new StringBuilder();
        int size = this.jsonArray.size();
        if (size > 0) {
            Character lastChar;
            String lastLine;
            String string = lastLine = this.jsonArray.get(size - 1).asText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lastLine");
            Character c = lastChar = StringsKt.lastOrNull((CharSequence)string);
            if (c == null || c.charValue() != '\n') {
                this.modifyingLastLine = true;
                this.currentLine.append(lastLine);
                Character c2 = lastChar;
                if (c2 != null && c2.charValue() == '\r') {
                    this.pendingCarriageReturn = true;
                    this.currentLine.deleteCharAt(this.currentLine.length() - 1);
                } else {
                    this.nextCharPosition = this.currentLine.length();
                }
            }
        }
        int lastLine = 0;
        int n = ((CharSequence)lineToInsert).length();
        while (lastLine < n) {
            void i;
            char c = lineToInsert.charAt((int)i);
            if (c == '\n') {
                this.newLine();
            } else if (c == '\r') {
                this.carriageReturn();
            } else {
                this.putCharAndCheckForCarriage(c);
            }
            ++i;
        }
        if (this.pendingCarriageReturn) {
            this.putChar('\r');
        }
        this.flushLine();
    }
}

