/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MIME;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.JupyterJsonKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterErrorMessagesKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterServerErrorResponse;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.HttpSession;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.JupyterHttpSessionRestUtilsKt$get$;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.JupyterRestClientErrorResponseException;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.JupyterRestClientException;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.JupyterRestClientForbiddenException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u001c\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0000\u001a \u0010\t\u001a\u00020\u0007*\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00020\r\"\u00020\u000eH\u0000\u001a\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001c\u0010\u000f\u001a\u00020\u0011*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0000\u001a.\u0010\u0012\u001a\u0002H\u0013\"\u0006\b\u0000\u0010\u0013\u0018\u0001*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0080\b\u00a2\u0006\u0002\u0010\u0015\u001a \u0010\u0016\u001a\u00020\u0017*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00072\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0000\u001a&\u0010\u0019\u001a\u00020\u0007*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\b\b\u0002\u0010\u001b\u001a\u00020\u000eH\u0000\u001a(\u0010\u001c\u001a\u0004\u0018\u00010\u0011*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\b\b\u0002\u0010\u001b\u001a\u00020\u000eH\u0000\u001a*\u0010\u001d\u001a\u00020\u0007*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\f\b\u0002\u0010\u001b\u001a\u00020\r\"\u00020\u000eH\u0000\u001a\u0012\u0010\u001e\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "delete", "", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/http/HttpSession;", "endpoint", "", "id", "executeAndCheck", "request", "Lorg/apache/http/client/fluent/Request;", "status", "", "", "get", "", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "getObject", "T", "query", "(Lorg/jetbrains/plugins/notebooks/jupyter/connections/http/HttpSession;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;", "getRequestURI", "Ljava/net/URI;", "path", "patch", "body", "expectedStatus", "post", "put", "resolveURIPath", "child", "intellij.python.jupyter"})
public final class JupyterHttpSessionRestUtilsKt {
    private static final Logger LOG;

    @NotNull
    public static final URI getRequestURI(@NotNull HttpSession $this$getRequestURI, @NotNull String path, @Nullable String query) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getRequestURI, (String)"$this$getRequestURI");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String string = $this$getRequestURI.getBaseURI().getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"baseURI.path");
        String fullPath = JupyterHttpSessionRestUtilsKt.resolveURIPath(string, path);
        String string2 = $this$getRequestURI.getBaseURI().getScheme();
        String string3 = $this$getRequestURI.getBaseURI().getUserInfo();
        String string4 = $this$getRequestURI.getBaseURI().getHost();
        int n = $this$getRequestURI.getBaseURI().getPort();
        String string5 = query;
        if (string5 == null) {
            string5 = $this$getRequestURI.getBaseURI().getQuery();
        }
        return new URI(string2, string3, string4, n, fullPath, string5, $this$getRequestURI.getBaseURI().getFragment());
    }

    public static /* synthetic */ URI getRequestURI$default(HttpSession httpSession, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return JupyterHttpSessionRestUtilsKt.getRequestURI(httpSession, string, string2);
    }

    @NotNull
    public static final List<ObjectNode> get(@NotNull HttpSession $this$get, @NotNull String endpoint) {
        Intrinsics.checkParameterIsNotNull((Object)$this$get, (String)"$this$get");
        Intrinsics.checkParameterIsNotNull((Object)endpoint, (String)"endpoint");
        Request request = Request.Get((URI)JupyterHttpSessionRestUtilsKt.getRequestURI$default($this$get, endpoint, null, 2, null));
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"Request.Get(getRequestURI(endpoint))");
        String response = JupyterHttpSessionRestUtilsKt.executeAndCheck($this$get, request, 200);
        Object object = JupyterJsonKt.getJackson().readValue(response, ArrayNode.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"jackson.readValue(response, ArrayNode::class.java)");
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)((Iterable)object));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)get$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        return SequencesKt.toList((Sequence)sequence);
    }

    @NotNull
    public static final ObjectNode get(@NotNull HttpSession $this$get, @NotNull String endpoint, @NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)$this$get, (String)"$this$get");
        Intrinsics.checkParameterIsNotNull((Object)endpoint, (String)"endpoint");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Request request = Request.Get((URI)JupyterHttpSessionRestUtilsKt.getRequestURI$default($this$get, endpoint + '/' + id, null, 2, null));
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"Request.Get(getRequestURI(\"$endpoint/$id\"))");
        String response = JupyterHttpSessionRestUtilsKt.executeAndCheck($this$get, request, 200);
        Object object = JupyterJsonKt.getJackson().readValue(response, ObjectNode.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"jackson.readValue(respon\u2026, ObjectNode::class.java)");
        return (ObjectNode)object;
    }

    public static final /* synthetic */ <T> T getObject(@NotNull HttpSession $this$getObject, @NotNull String endpoint, @Nullable String query) {
        Object object;
        int $i$f$getObject = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$getObject, (String)"$this$getObject");
        Intrinsics.checkParameterIsNotNull((Object)endpoint, (String)"endpoint");
        URI requestURI = JupyterHttpSessionRestUtilsKt.getRequestURI($this$getObject, endpoint, query);
        Request request = Request.Get((URI)requestURI);
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"Request.Get(requestURI)");
        String response = JupyterHttpSessionRestUtilsKt.executeAndCheck($this$getObject, request, 200);
        ObjectMapper $this$readValueWrappingError$iv = JupyterJsonKt.getJackson();
        boolean $i$f$readValueWrappingError = false;
        try {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            object = $this$readValueWrappingError$iv.readValue(response, Object.class);
        }
        catch (JsonProcessingException err$iv) {
            String prettyJson$iv = $this$readValueWrappingError$iv.writerWithDefaultPrettyPrinter().writeValueAsString((Object)JupyterJsonKt.getJackson().readTree(response));
            boolean bl = false;
            String string = "GET " + requestURI;
            Attachment[] attachmentArray = new Attachment[]{new Attachment("response.json", prettyJson$iv)};
            Throwable throwable = err$iv;
            String string2 = string;
            throw (Throwable)new RuntimeExceptionWithAttachments(string2, throwable, attachmentArray);
        }
        return (T)object;
    }

    public static /* synthetic */ Object getObject$default(HttpSession $this$getObject, String endpoint, String query, int n, Object object) {
        Object object2;
        if ((n & 2) != 0) {
            query = null;
        }
        boolean $i$f$getObject = false;
        Intrinsics.checkParameterIsNotNull((Object)$this$getObject, (String)"$this$getObject");
        Intrinsics.checkParameterIsNotNull((Object)endpoint, (String)"endpoint");
        URI requestURI = JupyterHttpSessionRestUtilsKt.getRequestURI($this$getObject, endpoint, query);
        Request request = Request.Get((URI)requestURI);
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"Request.Get(requestURI)");
        String response = JupyterHttpSessionRestUtilsKt.executeAndCheck($this$getObject, request, 200);
        ObjectMapper $this$readValueWrappingError$iv = JupyterJsonKt.getJackson();
        boolean $i$f$readValueWrappingError = false;
        try {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            object2 = $this$readValueWrappingError$iv.readValue(response, Object.class);
        }
        catch (JsonProcessingException err$iv) {
            String prettyJson$iv = $this$readValueWrappingError$iv.writerWithDefaultPrettyPrinter().writeValueAsString((Object)JupyterJsonKt.getJackson().readTree(response));
            boolean bl = false;
            String string = "GET " + requestURI;
            Attachment[] attachmentArray = new Attachment[]{new Attachment("response.json", prettyJson$iv)};
            Throwable throwable = err$iv;
            String string2 = string;
            throw (Throwable)new RuntimeExceptionWithAttachments(string2, throwable, attachmentArray);
        }
        return object2;
    }

    @Nullable
    public static final ObjectNode post(@NotNull HttpSession $this$post, @NotNull String endpoint, @NotNull String body, int expectedStatus) {
        Intrinsics.checkParameterIsNotNull((Object)$this$post, (String)"$this$post");
        Intrinsics.checkParameterIsNotNull((Object)endpoint, (String)"endpoint");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Request request = Request.Post((URI)JupyterHttpSessionRestUtilsKt.getRequestURI$default($this$post, endpoint, null, 2, null)).bodyString(body, ContentType.APPLICATION_JSON);
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"Request.Post(getRequestU\u2026entType.APPLICATION_JSON)");
        String response = JupyterHttpSessionRestUtilsKt.executeAndCheck($this$post, request, expectedStatus);
        CharSequence charSequence = response;
        boolean bl = false;
        return charSequence.length() > 0 ? (ObjectNode)JupyterJsonKt.getJackson().readValue(response, ObjectNode.class) : null;
    }

    public static /* synthetic */ ObjectNode post$default(HttpSession httpSession, String string, String string2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 201;
        }
        return JupyterHttpSessionRestUtilsKt.post(httpSession, string, string2, n);
    }

    @NotNull
    public static final String put(@NotNull HttpSession $this$put, @NotNull String endpoint, @NotNull String body, int ... expectedStatus) {
        Intrinsics.checkParameterIsNotNull((Object)$this$put, (String)"$this$put");
        Intrinsics.checkParameterIsNotNull((Object)endpoint, (String)"endpoint");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Intrinsics.checkParameterIsNotNull((Object)expectedStatus, (String)"expectedStatus");
        Request request = Request.Put((URI)JupyterHttpSessionRestUtilsKt.getRequestURI$default($this$put, endpoint, null, 2, null)).bodyString(body, ContentType.APPLICATION_JSON);
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"Request.Put(getRequestUR\u2026entType.APPLICATION_JSON)");
        return JupyterHttpSessionRestUtilsKt.executeAndCheck($this$put, request, Arrays.copyOf(expectedStatus, expectedStatus.length));
    }

    public static /* synthetic */ String put$default(HttpSession httpSession, String string, String string2, int[] nArray, int n, Object object) {
        if ((n & 4) != 0) {
            nArray = new int[]{200, 201};
        }
        return JupyterHttpSessionRestUtilsKt.put(httpSession, string, string2, nArray);
    }

    @NotNull
    public static final String patch(@NotNull HttpSession $this$patch, @NotNull String endpoint, @NotNull String body, int expectedStatus) {
        Intrinsics.checkParameterIsNotNull((Object)$this$patch, (String)"$this$patch");
        Intrinsics.checkParameterIsNotNull((Object)endpoint, (String)"endpoint");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Request request = Request.Patch((URI)JupyterHttpSessionRestUtilsKt.getRequestURI$default($this$patch, endpoint, null, 2, null)).bodyString(body, ContentType.APPLICATION_JSON);
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"Request.Patch(getRequest\u2026entType.APPLICATION_JSON)");
        return JupyterHttpSessionRestUtilsKt.executeAndCheck($this$patch, request, expectedStatus);
    }

    public static /* synthetic */ String patch$default(HttpSession httpSession, String string, String string2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 200;
        }
        return JupyterHttpSessionRestUtilsKt.patch(httpSession, string, string2, n);
    }

    public static final void delete(@NotNull HttpSession $this$delete, @NotNull String endpoint, @NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)$this$delete, (String)"$this$delete");
        Intrinsics.checkParameterIsNotNull((Object)endpoint, (String)"endpoint");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Request request = Request.Delete((URI)JupyterHttpSessionRestUtilsKt.getRequestURI$default($this$delete, endpoint + '/' + id, null, 2, null));
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"Request.Delete(getRequestURI(\"$endpoint/$id\"))");
        JupyterHttpSessionRestUtilsKt.executeAndCheck($this$delete, request, 204);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final String executeAndCheck(@NotNull HttpSession $this$executeAndCheck, @NotNull Request request, int ... status) {
        boolean bl;
        int $this$forEach$iv2;
        Object $this$all$iv;
        int actualStatus;
        HttpResponse response;
        Object object;
        Executor executor;
        block11: {
            Intrinsics.checkParameterIsNotNull((Object)$this$executeAndCheck, (String)"$this$executeAndCheck");
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
            Request request2 = request;
            executor = $this$executeAndCheck.getHttpRequestsExecutor();
            boolean bl2 = false;
            boolean bl3 = false;
            Request $this$apply = request2;
            int n = 0;
            Map<String, String> $this$forEach$iv2 = $this$executeAndCheck.getHttpHeaders();
            boolean $i$f$forEach = false;
            Map<String, String> map2 = $this$forEach$iv2;
            boolean bl4 = false;
            Iterator<Map.Entry<String, String>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                void key;
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> $dstr$key$value = element$iv = iterator.next();
                boolean bl5 = false;
                Map.Entry<String, String> entry = $dstr$key$value;
                boolean bl6 = false;
                String string = entry.getKey();
                entry = $dstr$key$value;
                bl6 = false;
                String value2 = entry.getValue();
                $this$apply.addHeader((String)key, value2);
            }
            object = request2;
            HttpResponse httpResponse = response = executor.execute((Request)object).returnResponse();
            Intrinsics.checkExpressionValueIsNotNull((Object)httpResponse, (String)"response");
            StatusLine statusLine = httpResponse.getStatusLine();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"response.statusLine");
            actualStatus = statusLine.getStatusCode();
            if (actualStatus == 403) {
                throw (Throwable)new JupyterRestClientForbiddenException();
            }
            $this$all$iv = status;
            boolean $i$f$all = false;
            int[] nArray = $this$all$iv;
            n = nArray.length;
            for ($this$forEach$iv2 = 0; $this$forEach$iv2 < n; ++$this$forEach$iv2) {
                int element$iv;
                int it = element$iv = nArray[$this$forEach$iv2];
                boolean bl7 = false;
                if (it != actualStatus) continue;
                bl = false;
                break block11;
            }
            bl = true;
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder().append("Rest Client: HTTP response status ").append(actualStatus).append(" differs from the expected ").append(ArraysKt.joinToString$default((int[])status, (CharSequence)" or ", null, null, (int)0, null, null, (int)62, null)).append(", ").append("message: ");
            HttpEntity httpEntity = response.getEntity();
            Intrinsics.checkExpressionValueIsNotNull((Object)httpEntity, (String)"response.entity");
            InputStream inputStream = httpEntity.getContent();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"response.entity.content");
            $this$all$iv = inputStream;
            object = stringBuilder;
            executor = LOG;
            Charset charset = Charsets.UTF_8;
            boolean bl8 = false;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)$this$all$iv, charset);
            executor.warn(((StringBuilder)object).append(TextStreamsKt.readText((Reader)inputStreamReader)).toString());
            JupyterServerErrorResponse message = JupyterErrorMessagesKt.tryParseServerErrorResponseAsJson(response);
            if (message != null) {
                throw (Throwable)new JupyterRestClientErrorResponseException(actualStatus, message.getMessage(), message.getTraceback());
            }
            throw (Throwable)new JupyterRestClientException(actualStatus, "Error with connection to Jupyter: server responded with " + actualStatus + " on " + request + ". " + status + " was expected.");
        }
        if (response.getEntity() == null) {
            return "";
        }
        HttpEntity httpEntity = response.getEntity();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpEntity, (String)"response.entity");
        InputStream inputStream = httpEntity.getContent();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"response.entity.content");
        Closeable closeable = inputStream;
        Charset charset = MIME.UTF8_CHARSET;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"MIME.UTF8_CHARSET");
        Charset charset2 = charset;
        boolean bl9 = false;
        Closeable n = closeable;
        $this$forEach$iv2 = 0;
        n = new InputStreamReader((InputStream)n, charset2);
        $this$forEach$iv2 = 8192;
        boolean bl10 = false;
        closeable = n instanceof BufferedReader ? (BufferedReader)n : new BufferedReader((Reader)n, $this$forEach$iv2);
        boolean bl11 = false;
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl12 = false;
            String string = TextStreamsKt.readText((Reader)it);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final String resolveURIPath(@NotNull String $this$resolveURIPath, @NotNull String child) {
        Intrinsics.checkParameterIsNotNull((Object)$this$resolveURIPath, (String)"$this$resolveURIPath");
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        return StringsKt.trimEnd((String)$this$resolveURIPath, (char[])new char[]{'/'}) + '/' + StringsKt.trimStart((String)child, (char[])new char[]{'/'});
    }

    static {
        Logger logger = Logger.getInstance(HttpSession.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(HttpSession::class.java)");
        LOG = logger;
    }
}

