/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections.execution;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.apache.http.client.fluent.Request;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.JupyterJsonKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterConnectionParameters;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterRestClient$getKernelSpecs$;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.DefaultHttpSession;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.HttpSession;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.JupyterHttpSessionRestUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000bJ\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012J\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000bJ\u0016\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bJ\u000e\u0010\u001d\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterRestClient;", "", "connectionParameters", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterConnectionParameters;", "(Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterConnectionParameters;)V", "httpSession", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/http/HttpSession;", "(Lorg/jetbrains/plugins/notebooks/jupyter/connections/http/HttpSession;)V", "deleteKernel", "", "id", "", "deleteSession", "getKernel", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "getKernelSpec", "name", "getKernelSpecs", "", "getKernels", "getSession", "getSessions", "interruptKernel", "ping", "", "postKernel", "postSession", "kernelName", "notebookPath", "restartKernel", "intellij.python.jupyter"})
public final class JupyterRestClient {
    private final HttpSession httpSession;

    public final boolean ping() {
        boolean bl;
        try {
            HttpSession httpSession = this.httpSession;
            boolean bl2 = false;
            boolean bl3 = false;
            HttpSession $this$with = httpSession;
            boolean bl4 = false;
            Request request = Request.Get((URI)JupyterHttpSessionRestUtilsKt.getRequestURI$default($this$with, "/api/kernelspecs", null, 2, null));
            Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"Request.Get(getRequestURI(KERNELSPECS))");
            JupyterHttpSessionRestUtilsKt.executeAndCheck($this$with, request, 200);
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final List<ObjectNode> getSessions() {
        return JupyterHttpSessionRestUtilsKt.get(this.httpSession, "/api/sessions");
    }

    @NotNull
    public final ObjectNode getSession(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return JupyterHttpSessionRestUtilsKt.get(this.httpSession, "/api/sessions", id);
    }

    @NotNull
    public final ObjectNode postSession(@NotNull String kernelName, @NotNull String notebookPath) {
        Intrinsics.checkParameterIsNotNull((Object)kernelName, (String)"kernelName");
        Intrinsics.checkParameterIsNotNull((Object)notebookPath, (String)"notebookPath");
        ObjectNode objectNode = JupyterJsonKt.getJackson().createObjectNode();
        boolean bl = false;
        boolean bl2 = false;
        ObjectNode $this$apply = objectNode;
        boolean bl3 = false;
        $this$apply.put("path", notebookPath);
        $this$apply.put("type", "notebook");
        ObjectNode objectNode2 = $this$apply.putObject("kernel");
        boolean bl4 = false;
        boolean bl5 = false;
        ObjectNode $this$apply2 = objectNode2;
        boolean bl6 = false;
        $this$apply2.put("name", kernelName);
        ObjectNode body = objectNode;
        String string = body.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"body.toString()");
        ObjectNode objectNode3 = JupyterHttpSessionRestUtilsKt.post$default(this.httpSession, "/api/sessions", string, 0, 4, null);
        if (objectNode3 == null) {
            Intrinsics.throwNpe();
        }
        return objectNode3;
    }

    public final void deleteSession(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        JupyterHttpSessionRestUtilsKt.delete(this.httpSession, "/api/sessions", id);
    }

    @NotNull
    public final List<ObjectNode> getKernelSpecs() {
        JsonNode jsonNode = JupyterHttpSessionRestUtilsKt.get(this.httpSession, "/api/kernelspecs", "").get("kernelspecs");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonNode, (String)"(httpSession.get(KERNELSPECS, \"\")[\"kernelspecs\"])");
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)((Iterable)jsonNode));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getKernelSpecs$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        return SequencesKt.toList((Sequence)sequence);
    }

    @NotNull
    public final ObjectNode getKernelSpec(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return JupyterHttpSessionRestUtilsKt.get(this.httpSession, "/api/kernelspecs", name);
    }

    @NotNull
    public final List<ObjectNode> getKernels() {
        return JupyterHttpSessionRestUtilsKt.get(this.httpSession, "/api/kernels");
    }

    @NotNull
    public final ObjectNode getKernel(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return JupyterHttpSessionRestUtilsKt.get(this.httpSession, "/api/kernels", id);
    }

    @NotNull
    public final ObjectNode postKernel(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        ObjectNode body = JupyterJsonKt.getJackson().createObjectNode().put("name", name);
        String string = JupyterJsonKt.getJackson().writeValueAsString((Object)body);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jackson.writeValueAsString(body)");
        ObjectNode objectNode = JupyterHttpSessionRestUtilsKt.post$default(this.httpSession, "/api/kernels", string, 0, 4, null);
        if (objectNode == null) {
            Intrinsics.throwNpe();
        }
        return objectNode;
    }

    public final void deleteKernel(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        JupyterHttpSessionRestUtilsKt.delete(this.httpSession, "/api/kernels", id);
    }

    public final void interruptKernel(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        JupyterHttpSessionRestUtilsKt.post(this.httpSession, "/api/kernels/" + id + "/interrupt", "", 204);
    }

    public final void restartKernel(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        JupyterHttpSessionRestUtilsKt.post(this.httpSession, "/api/kernels/" + id + "/restart", "", 204);
    }

    public JupyterRestClient(@NotNull HttpSession httpSession) {
        Intrinsics.checkParameterIsNotNull((Object)httpSession, (String)"httpSession");
        this.httpSession = httpSession;
    }

    public JupyterRestClient(@NotNull JupyterConnectionParameters connectionParameters) {
        Intrinsics.checkParameterIsNotNull((Object)connectionParameters, (String)"connectionParameters");
        this(new DefaultHttpSession(connectionParameters));
    }
}

