/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.core.impl.file;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookOriginToSourceChangePropagator;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookVirtualFile;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookVirtualFileSystem;
import org.jetbrains.plugins.notebooks.jupyter.JupyterCustomizer;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterCellUtilKt;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterChangeListener;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterEvent;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebookBase;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.NotebookChanged;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0010\u0018\u0000 62\u00020\u0001:\u000267B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J*\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u000bH\u0014J\"\u0010\u001a\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u000bH\u0014J\"\u0010\u001d\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u000bH\u0014J\u001a\u0010\u001f\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010 \u001a\u00020\u0014H\u0014J\u0012\u0010!\u001a\u0004\u0018\u00010\u00072\u0006\u0010\"\u001a\u00020\u000bH\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\u000b2\u0006\u0010$\u001a\u00020\u0014H\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u00072\u0006\u0010$\u001a\u00020\u0014H\u0002J\b\u0010&\u001a\u00020\u000bH\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0015\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b+J\u0015\u0010,\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b-J\"\u0010.\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0014J\u0010\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020(H\u0016J\u0012\u00101\u001a\u0004\u0018\u00010\u00142\u0006\u0010\"\u001a\u00020\u000bH\u0016J\u0010\u00102\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\"\u00103\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010 \u001a\u00020\u00142\u0006\u00104\u001a\u00020\u000bH\u0014J\u0010\u00105\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0014H\u0002R/\u0010\u0003\u001a#\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\t\u001a#\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R:\u0010\f\u001a.\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000e0\u000e \u0006*\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000e0\u000e0\u000f\u00a2\u0006\u0002\b\b0\r\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFileSystem;", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "()V", "fileCache", "Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFile;", "Lorg/jetbrains/annotations/NotNull;", "modifiedFiles", "notImplementedReason", "", "vfsListeners", "", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "", "addVirtualFileListener", "", "listener", "copyFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "requestor", "", "virtualFile", "newParent", "copyName", "createChildDirectory", "vDir", "dirName", "createChildFile", "fileName", "deleteFile", "vFile", "findFileByPath", "path", "getCachedDocumentContent", "file", "getOrCreateNotebookFile", "getProtocol", "isReadOnly", "", "markModified", "notebookVirtualFile", "markModified$intellij_python_jupyter", "markUnmodified", "markUnmodified$intellij_python_jupyter", "moveFile", "refresh", "asynchronous", "refreshAndFindFileByPath", "removeVirtualFileListener", "renameFile", "newName", "setNotebookTemplateContent", "Companion", "NotebookFileEditorChangePropagator", "intellij.python.jupyter"})
public final class NotebookVirtualFileSystem
extends VirtualFileSystem {
    private final List<VirtualFileListener> vfsListeners;
    private final ConcurrentMap<Integer, NotebookVirtualFile> fileCache;
    private final ConcurrentMap<Integer, NotebookVirtualFile> modifiedFiles;
    private final String notImplementedReason = "Makes no sense for Notebook file system";
    private static final Logger LOG;
    public static final Companion Companion;

    public final void markModified$intellij_python_jupyter(@NotNull NotebookVirtualFile notebookVirtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)notebookVirtualFile), (String)"notebookVirtualFile");
        VirtualFile virtualFile2 = notebookVirtualFile.getOriginFile();
        if (virtualFile2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vfs.VirtualFileWithId");
        }
        ((Map)this.modifiedFiles).put(((VirtualFileWithId)virtualFile2).getId(), notebookVirtualFile);
    }

    public final void markUnmodified$intellij_python_jupyter(@NotNull NotebookVirtualFile notebookVirtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)notebookVirtualFile), (String)"notebookVirtualFile");
        VirtualFile virtualFile2 = notebookVirtualFile.getOriginFile();
        if (virtualFile2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vfs.VirtualFileWithId");
        }
        this.modifiedFiles.remove(((VirtualFileWithId)virtualFile2).getId());
    }

    @NotNull
    public String getProtocol() {
        return "notebook";
    }

    public boolean isReadOnly() {
        return false;
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.vfsListeners.add(listener2);
    }

    public void removeVirtualFileListener(@NotNull VirtualFileListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.vfsListeners.remove(listener2);
    }

    public void refresh(boolean asynchronous) {
    }

    @Nullable
    public NotebookVirtualFile findFileByPath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        VirtualFile virtualFile2 = JupyterCustomizer.Companion.getInstance().notebookFileSystemVirtualFileByPath(path);
        if (virtualFile2 == null) {
            virtualFile2 = LocalFileSystem.getInstance().findFileByPath(path);
        }
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        return this.getOrCreateNotebookFile(file2);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return this.findFileByPath(path);
    }

    /*
     * WARNING - void declaration
     */
    private final NotebookVirtualFile getOrCreateNotebookFile(VirtualFile file2) {
        void generatedFile;
        VirtualFile virtualFile2 = file2;
        if (virtualFile2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vfs.VirtualFileWithId");
        }
        int id = ((VirtualFileWithId)virtualFile2).getId();
        NotebookVirtualFile notebookVirtualFile = (NotebookVirtualFile)((Object)this.modifiedFiles.get(id));
        if (notebookVirtualFile != null) {
            NotebookVirtualFile notebookVirtualFile2 = notebookVirtualFile;
            boolean bl = false;
            boolean bl2 = false;
            NotebookVirtualFile it = notebookVirtualFile2;
            boolean bl3 = false;
            return it;
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        NotebookVirtualFile returnedFile2 = this.fileCache.computeIfAbsent(id, new Function<Integer, NotebookVirtualFile>(this, file2, (Ref.ObjectRef)generatedFile){
            final /* synthetic */ NotebookVirtualFileSystem this$0;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Ref.ObjectRef $generatedFile;

            @NotNull
            public final NotebookVirtualFile apply(Integer it) {
                Reader notebookContentReader2;
                NotebookVirtualFileSystem.access$setNotebookTemplateContent(this.this$0, this.$file);
                Reader reader = notebookContentReader2 = (Reader)ReadAction.compute((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<T, E>(this){
                    final /* synthetic */ getOrCreateNotebookFile.returnedFile.1 this$0;

                    @NotNull
                    public final Reader compute() {
                        Reader reader;
                        String string = NotebookVirtualFileSystem.access$getCachedDocumentContent(this.this$0.this$0, this.this$0.$file);
                        if (string != null) {
                            String string2 = string;
                            boolean bl = false;
                            reader = new StringReader(string2);
                        } else {
                            InputStream inputStream = this.this$0.$file.getInputStream();
                            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"file.inputStream");
                            InputStream inputStream2 = inputStream;
                            Charset charset = Charsets.UTF_8;
                            boolean bl = false;
                            reader = new InputStreamReader(inputStream2, charset);
                        }
                        return reader;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
                Intrinsics.checkExpressionValueIsNotNull((Object)reader, (String)"notebookContentReader");
                JupyterNotebookBase notebook = new JupyterNotebookBase(reader);
                NotebookVirtualFile result = new NotebookVirtualFile(this.$file, notebook);
                this.$generatedFile.element = result;
                return result;
            }
            {
                this.this$0 = notebookVirtualFileSystem;
                this.$file = virtualFile2;
                this.$generatedFile = objectRef;
            }
        });
        if (returnedFile2 == (NotebookVirtualFile)((Object)generatedFile.element)) {
            returnedFile2.getNotebook().addJupyterChangeListener(new JupyterChangeListener(this, returnedFile2){
                final /* synthetic */ NotebookVirtualFileSystem this$0;
                final /* synthetic */ NotebookVirtualFile $returnedFile;

                public void onEvent(@NotNull JupyterEvent event2) {
                    Intrinsics.checkParameterIsNotNull((Object)event2, (String)"event");
                    if (!(event2 instanceof NotebookChanged)) {
                        return;
                    }
                    NotebookVirtualFile notebookVirtualFile = this.$returnedFile;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)notebookVirtualFile), (String)"returnedFile");
                    this.this$0.markModified$intellij_python_jupyter(notebookVirtualFile);
                }
                {
                    this.this$0 = $outer;
                    this.$returnedFile = $captured_local_variable$1;
                }
            });
            file2.putUserData(JupyterCellUtilKt.getNOTEBOOK_VIRTUAL_FILE_KEY(), (Object)returnedFile2);
        }
        return returnedFile2;
    }

    private final void setNotebookTemplateContent(VirtualFile file2) {
        if (file2.getLength() == 0L) {
            FileTemplate fileTemplate = FileTemplateManager.getDefaultInstance().getInternalTemplate("Jupyter Notebook");
            Intrinsics.checkExpressionValueIsNotNull((Object)fileTemplate, (String)"FileTemplateManager.getD\u2026PYTER_FILE_TEMPLATE_NAME)");
            FileTemplate template = fileTemplate;
            WriteAction.runAndWait((ThrowableRunnable)new ThrowableRunnable<E>(file2, template){
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ FileTemplate $template;

                public final void run() {
                    String string = this.$template.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"template.text");
                    String string2 = string;
                    Charset charset = Charsets.UTF_8;
                    VirtualFile virtualFile2 = this.$file;
                    boolean bl = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray = string3.getBytes(charset);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    byte[] byArray2 = byArray;
                    virtualFile2.setBinaryContent(byArray2);
                }
                {
                    this.$file = virtualFile2;
                    this.$template = fileTemplate;
                }
            });
        }
    }

    private final String getCachedDocumentContent(VirtualFile file2) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileDocumentManager, (String)"FileDocumentManager.getInstance()");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        Document document = fileDocumentManager2.getDocument(file2);
        if (document == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"fileDocumentManager.getD\u2026ment(file) ?: return null");
        Document document2 = document;
        FileDocumentManagerImpl.registerDocument((Document)document2, (VirtualFile)file2);
        if (fileDocumentManager2.isPartialPreviewOfALargeFile(document2)) {
            return null;
        }
        return document2.getText();
    }

    protected void deleteFile(@Nullable Object requestor, @NotNull VirtualFile vFile) {
        Intrinsics.checkParameterIsNotNull((Object)vFile, (String)"vFile");
        if (requestor instanceof NotebookOriginToSourceChangePropagator) {
            this.modifiedFiles.remove(((NotebookVirtualFile)vFile).getId());
        } else {
            LOG.error("Notebook virtual files should be deleted only on origin file deletion");
        }
    }

    @NotNull
    protected VirtualFile createChildDirectory(@Nullable Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) {
        Intrinsics.checkParameterIsNotNull((Object)vDir, (String)"vDir");
        Intrinsics.checkParameterIsNotNull((Object)dirName, (String)"dirName");
        throw (Throwable)new NotImplementedError("The operation is not implemented: " + this.notImplementedReason);
    }

    @NotNull
    protected VirtualFile createChildFile(@Nullable Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)vDir, (String)"vDir");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        throw (Throwable)new NotImplementedError("The operation is not implemented: " + this.notImplementedReason);
    }

    @NotNull
    protected VirtualFile copyFile(@Nullable Object requestor, @NotNull VirtualFile virtualFile2, @NotNull VirtualFile newParent, @NotNull String copyName) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkParameterIsNotNull((Object)newParent, (String)"newParent");
        Intrinsics.checkParameterIsNotNull((Object)copyName, (String)"copyName");
        throw (Throwable)new NotImplementedError("The operation is not implemented: " + this.notImplementedReason);
    }

    protected void moveFile(@Nullable Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) {
        Intrinsics.checkParameterIsNotNull((Object)vFile, (String)"vFile");
        Intrinsics.checkParameterIsNotNull((Object)newParent, (String)"newParent");
        throw (Throwable)new NotImplementedError("The operation is not implemented: " + this.notImplementedReason);
    }

    protected void renameFile(@Nullable Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) {
        Intrinsics.checkParameterIsNotNull((Object)vFile, (String)"vFile");
        Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
        throw (Throwable)new NotImplementedError("The operation is not implemented: " + this.notImplementedReason);
    }

    public NotebookVirtualFileSystem() {
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ContainerUtil.createLock\u2026st<VirtualFileListener>()");
        this.vfsListeners = list;
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.createConc\u2026t, NotebookVirtualFile>()");
        this.fileCache = concurrentMap;
        ConcurrentMap concurrentMap2 = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap2, (String)"newConcurrentMap<Int, NotebookVirtualFile>()");
        this.modifiedFiles = concurrentMap2;
        this.notImplementedReason = "Makes no sense for Notebook file system";
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger;
    }

    public static final /* synthetic */ void access$setNotebookTemplateContent(NotebookVirtualFileSystem $this, VirtualFile file2) {
        $this.setNotebookTemplateContent(file2);
    }

    public static final /* synthetic */ String access$getCachedDocumentContent(NotebookVirtualFileSystem $this, VirtualFile file2) {
        return $this.getCachedDocumentContent(file2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFileSystem$NotebookFileEditorChangePropagator;", "Lcom/intellij/openapi/fileEditor/FileDocumentManagerListener;", "()V", "beforeAllDocumentsSaving", "", "intellij.python.jupyter"})
    public static final class NotebookFileEditorChangePropagator
    implements FileDocumentManagerListener {
        public void beforeAllDocumentsSaving() {
            Map $this$forEach$iv = Companion.getNotebookVirtualFileSystem().modifiedFiles;
            boolean $i$f$forEach = false;
            Map map2 = $this$forEach$iv;
            boolean bl = false;
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl2 = false;
                WriteAction.run((ThrowableRunnable)new ThrowableRunnable<E>(it){
                    final /* synthetic */ Map.Entry $it;

                    public final void run() {
                        ((NotebookVirtualFile)((Object)this.$it.getValue())).flush();
                    }
                    {
                        this.$it = entry;
                    }
                });
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFileSystem$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getNotebookVirtualFileSystem", "Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFileSystem;", "intellij.python.jupyter"})
    public static final class Companion {
        @NotNull
        public final NotebookVirtualFileSystem getNotebookVirtualFileSystem() {
            VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem("notebook");
            if (virtualFileSystem == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.notebooks.core.impl.file.NotebookVirtualFileSystem");
            }
            return (NotebookVirtualFileSystem)virtualFileSystem;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

