/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.scientific;

import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyCellUtil;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.scientific.PySciProjectComponent;
import com.jetbrains.scientific.PySciViewAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PySciViewAdvertiser
implements Annotator {
    private static final NotificationGroup BALLOON_NOTIFICATIONS = new NotificationGroup("Python Scientific View Advertiser", NotificationDisplayType.STICKY_BALLOON, false);
    private static final Key<Boolean> BALLOON_SHOWING = Key.create((String)"showingSciViewAdvertiserBalloon");

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            PySciViewAdvertiser.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PySciViewAdvertiser.$$$reportNull$$$0(1);
        }
        if (PySciProjectComponent.getInstance(element.getProject()).shouldUseSciView()) {
            return;
        }
        if (element instanceof PyFile) {
            PyFile pyFile = (PyFile)element;
            Project project = element.getProject();
            if (PySciProjectComponent.getInstance(project).isSciViewSuggested()) {
                return;
            }
            VirtualFile vFile = pyFile.getVirtualFile();
            if (vFile != null && FileIndexFacade.getInstance((Project)project).isInLibraryClasses(vFile)) {
                return;
            }
            if (!pyFile.getViewProvider().getBaseLanguage().isKindOf((Language)PythonLanguage.INSTANCE)) {
                return;
            }
            Boolean showingFlag = (Boolean)project.getUserData(BALLOON_SHOWING);
            if (showingFlag != null && showingFlag.booleanValue()) {
                return;
            }
            if (PyPsiUtils.containsImport(pyFile, PythonProBundle.message("python.sci.view.advertiser.usage.code.numpy"))) {
                PySciViewAdvertiser.showInspectionAdvertisement(project, PythonProBundle.message("python.sci.view.advertiser.usage.code.num.py"));
            }
            if (PyCellUtil.hasCells(pyFile)) {
                PySciViewAdvertiser.showInspectionAdvertisement(project, PythonProBundle.message("python.sci.view.advertiser.usage.code.cells"));
            }
        }
    }

    private static void showInspectionAdvertisement(@NotNull Project project, @NotNull String usage) {
        if (project == null) {
            PySciViewAdvertiser.$$$reportNull$$$0(2);
        }
        if (usage == null) {
            PySciViewAdvertiser.$$$reportNull$$$0(3);
        }
        String msg = String.format("%s<br/><a href=\"#yes\">%s</a>&nbsp;&nbsp;&nbsp;<a href=\"#no\">%s</a> <br/><br/>%s", PythonProBundle.message("python.sci.view.advertiser.content.question"), PythonProBundle.message("python.sci.view.advertiser.content.answer.yes"), PythonProBundle.message("python.sci.view.advertiser.content.answer.no"), PythonProBundle.message("python.sci.view.advertiser.content.description"));
        PySciViewAdvertiser.showSingletonNotification(project, usage, msg, NotificationType.INFORMATION, (notification2, event2) -> {
            AnAction action;
            boolean enabled = "#yes".equals(event2.getDescription());
            PySciProjectComponent.getInstance(project).setSciViewSuggested(true);
            if (enabled && (action = ActionManager.getInstance().getAction("PySciView")) instanceof PySciViewAction) {
                PySciProjectComponent.getInstance(project).isSciViewSuggested();
                AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)((DataContext)DataManager.getInstance().getDataContextFromFocus().getResult()));
                ((PySciViewAction)action).setSelected(anActionEvent, true);
            }
        });
    }

    private static void showSingletonNotification(@NotNull Project project, @NotNull String usage, @NotNull @Nls String htmlContent, @NotNull NotificationType type, @NotNull NotificationListener listener2) {
        if (project == null) {
            PySciViewAdvertiser.$$$reportNull$$$0(4);
        }
        if (usage == null) {
            PySciViewAdvertiser.$$$reportNull$$$0(5);
        }
        if (htmlContent == null) {
            PySciViewAdvertiser.$$$reportNull$$$0(6);
        }
        if (type == null) {
            PySciViewAdvertiser.$$$reportNull$$$0(7);
        }
        if (listener2 == null) {
            PySciViewAdvertiser.$$$reportNull$$$0(8);
        }
        project.putUserData(BALLOON_SHOWING, (Object)true);
        BALLOON_NOTIFICATIONS.createNotification(PythonProBundle.message("python.sci.view.advertiser.title", usage), htmlContent, type, (notification2, event2) -> {
            try {
                listener2.hyperlinkUpdate(notification2, event2);
            }
            finally {
                notification2.expire();
            }
        }).notify(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlContent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/scientific/PySciViewAdvertiser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showInspectionAdvertisement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "showSingletonNotification";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

