/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resourceRoots;

import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.module.PyContentEntriesEditor;
import com.jetbrains.python.resourceRoots.ResourceRootProvider;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class PyPluginResourceRootProvider
extends ResourceRootProvider {
    private final MultiMap<String, String> myResourceRoots = new MultiMap();

    @Override
    @Nullable
    protected MultiMap<String, String> getResourceRoots(@NotNull Module module) {
        ContentEntry[] entries;
        if (module == null) {
            PyPluginResourceRootProvider.$$$reportNull$$$0(0);
        }
        MultiMap roots = new MultiMap();
        for (ContentEntry entry : entries = ModuleRootManager.getInstance((Module)module).getContentEntries()) {
            SmartList resourceRoots = new SmartList();
            List folders = entry.getSourceFolders((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
            for (SourceFolder folder : folders) {
                resourceRoots.add(folder.getUrl());
            }
            if (resourceRoots.isEmpty()) continue;
            roots.put((Object)entry.getUrl(), (Collection)resourceRoots);
        }
        this.myResourceRoots.clear();
        this.myResourceRoots.putAllValues(roots);
        return roots;
    }

    @Override
    protected void setResourceRoots(MultiMap<String, String> roots, @NotNull Module module) {
        if (module == null) {
            PyPluginResourceRootProvider.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            ModuleRootManager moduleManager = ModuleRootManager.getInstance((Module)module);
            ModifiableRootModel model = moduleManager.getModifiableModel();
            this.myResourceRoots.clear();
            this.myResourceRoots.putAllValues(roots);
            for (String entryUrl : roots.keySet()) {
                ContentEntry entry = PyPluginResourceRootProvider.findContentEntry(entryUrl, model);
                if (entry == null) continue;
                Collection fileUrls = roots.get((Object)entryUrl);
                for (String fileUrl : fileUrls) {
                    for (SourceFolder folder : entry.getSourceFolders()) {
                        if (!folder.getUrl().equals(fileUrl)) continue;
                        entry.removeSourceFolder(folder);
                        break;
                    }
                    entry.addSourceFolder(fileUrl, (JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
                }
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                model.commit();
                if (model.isWritable()) {
                    model.dispose();
                }
                module.getProject().save();
                ProjectRootManagerEx.getInstanceEx((Project)module.getProject()).makeRootsChange(() -> {}, false, true);
            });
        });
    }

    @Nullable
    private static ContentEntry findContentEntry(String entryUrl, @NotNull ModifiableRootModel model) {
        if (model == null) {
            PyPluginResourceRootProvider.$$$reportNull$$$0(2);
        }
        for (ContentEntry entry : model.getContentEntries()) {
            if (!Comparing.equal((String)entryUrl, (String)entry.getUrl())) continue;
            return entry;
        }
        return null;
    }

    @Override
    protected void removeRoot(@NotNull VirtualFile selectedFile, @NotNull PyContentEntriesEditor editor2, @NotNull ModifiableRootModel model) {
        if (selectedFile == null) {
            PyPluginResourceRootProvider.$$$reportNull$$$0(3);
        }
        if (editor2 == null) {
            PyPluginResourceRootProvider.$$$reportNull$$$0(4);
        }
        if (model == null) {
            PyPluginResourceRootProvider.$$$reportNull$$$0(5);
        }
        super.removeRoot(selectedFile, editor2, model);
        PyPluginResourceRootProvider.removeFromModel(selectedFile, model);
    }

    private static void removeFromModel(@NotNull VirtualFile selectedFile, @NotNull ModifiableRootModel model) {
        if (selectedFile == null) {
            PyPluginResourceRootProvider.$$$reportNull$$$0(6);
        }
        if (model == null) {
            PyPluginResourceRootProvider.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            ContentEntry entry = MarkRootActionBase.findContentEntry((ModuleRootModel)model, (VirtualFile)selectedFile);
            if (entry == null) {
                return;
            }
            for (SourceFolder folder : entry.getSourceFolders()) {
                if (!folder.getUrl().equals(selectedFile.getUrl())) continue;
                entry.removeSourceFolder(folder);
                break;
            }
        });
    }

    @Override
    public void removeRoot(ContentEntry contentEntry, @NotNull VirtualFilePointer root, ModifiableRootModel model) {
        if (root == null) {
            PyPluginResourceRootProvider.$$$reportNull$$$0(8);
        }
        super.removeRoot(contentEntry, root, model);
        VirtualFile file2 = root.getFile();
        if (file2 != null) {
            PyPluginResourceRootProvider.removeFromModel(file2, model);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/resourceRoots/PyPluginResourceRootProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getResourceRoots";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setResourceRoots";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findContentEntry";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "removeRoot";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "removeFromModel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

