/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.templateLanguages;

import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.MultipleLangCommentProvider;
import com.jetbrains.django.lang.template.DjangoTemplateLanguage;
import com.jetbrains.jinja2.Jinja2Language;
import com.jetbrains.mako.MakoLanguage;
import com.jetbrains.python.PythonStringUtil;
import org.jetbrains.annotations.Nullable;

public class PyTemplatesCommentProvider
implements MultipleLangCommentProvider {
    @Nullable
    public Commenter getLineCommenter(PsiFile file2, Editor editor2, Language lineStartLanguage, Language lineEndLanguage) {
        Language javaScript;
        Language baseLanguage = file2.getViewProvider().getBaseLanguage();
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(baseLanguage);
        String extension = PythonStringUtil.getLastSuffix(file2.getName(), ".");
        FileType type = file2.getOriginalFile().getFileType();
        if (StringUtil.isNotEmpty((String)extension)) {
            type = FileTypeManager.getInstance().getFileTypeByExtension(extension);
        }
        if (StdFileTypes.JS == type && (javaScript = Language.findLanguageByID((String)"JavaScript")) != null) {
            return (Commenter)LanguageCommenters.INSTANCE.forLanguage(javaScript);
        }
        return commenter;
    }

    public boolean canProcess(PsiFile file2, FileViewProvider viewProvider) {
        Language baseLanguage = viewProvider.getBaseLanguage();
        return baseLanguage == MakoLanguage.INSTANCE || baseLanguage == DjangoTemplateLanguage.INSTANCE || baseLanguage == Jinja2Language.INSTANCE;
    }
}

