/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.scientific.figures;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.Tunnelable;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.PythonCommandLineEnvironmentProvider;
import com.jetbrains.python.run.PythonRunConfigurationExtension;
import com.jetbrains.python.run.PythonRunParams;
import com.jetbrains.python.scientific.PySciProjectComponent;
import com.jetbrains.python.scientific.figures.PyPlotToolWindow;
import com.jetbrains.python.sdk.PythonEnvUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

public class PySciEnvironmentProvider
extends PythonRunConfigurationExtension
implements PythonCommandLineEnvironmentProvider {
    private static final Logger LOG = Logger.getInstance(PySciEnvironmentProvider.class);

    public boolean isApplicableFor(@NotNull AbstractPythonRunConfiguration configuration) {
        Project project;
        if (configuration == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(0);
        }
        return !(project = configuration.getProject()).isDefault() && !PySciProjectComponent.getInstance(project).isPortForwarded();
    }

    public boolean isEnabledFor(@NotNull AbstractPythonRunConfiguration applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(1);
        }
        return PySciProjectComponent.getInstance(applicableConfiguration.getProject()).isMatplotlibInToolwindow();
    }

    protected void patchCommandLine(@NotNull AbstractPythonRunConfiguration configuration, @Nullable RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) {
        if (configuration == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(2);
        }
        if (cmdLine == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(3);
        }
        if (runnerId == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(4);
        }
    }

    protected void attachToProcess(@NotNull AbstractPythonRunConfiguration configuration, @NotNull ProcessHandler handler, @Nullable RunnerSettings runnerSettings) {
        if (configuration == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(5);
        }
        if (handler == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(6);
        }
        try {
            Process process2 = PySciEnvironmentProvider.tryGetProcess(handler);
            if (process2 instanceof Tunnelable && !PySciProjectComponent.getInstance(configuration.getProject()).isPortForwarded()) {
                int port = BuiltInServerManager.getInstance().getPort();
                ((Tunnelable)process2).addRemoteTunnel(port, "localhost", port);
                PySciProjectComponent.getInstance(configuration.getProject()).enablePortForwarding();
            }
        }
        catch (RemoteSdkException exception) {
            LOG.info("Failed to forward ports: " + (Object)((Object)exception));
        }
    }

    @Nullable
    private static Process tryGetProcess(@NotNull ProcessHandler processHandler2) {
        if (processHandler2 == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(7);
        }
        if (processHandler2 instanceof BaseProcessHandler) {
            return ((BaseProcessHandler)processHandler2).getProcess();
        }
        return null;
    }

    @Override
    public void extendEnvironment(@NotNull Project project, @NotNull GeneralCommandLine cmdLine, @NotNull PythonRunParams runParams) {
        int port;
        if (project == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(8);
        }
        if (cmdLine == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(9);
        }
        if (runParams == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(10);
        }
        Map envs = cmdLine.getEnvironment();
        if (runParams instanceof PydevConsoleRunnerImpl.PythonConsoleRunParams) {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                envs.put("PYCHARM_MATPLOTLIB_INTERACTIVE", "true");
                envs.put("PYCHARM_MATPLOTLIB_INDEX", String.valueOf(PyPlotToolWindow.getInstance(project).getLastPlotIndex()));
            });
        }
        if (PySciProjectComponent.getInstance(project).isMatplotlibInToolwindow() && (port = BuiltInServerManager.getInstance().getPort()) != -1) {
            envs.put("PYCHARM_DISPLAY_PORT", String.valueOf(port));
            LOG.info("Plots on port: " + port);
            String key = "PYTHONPATH";
            PythonEnvUtil.addPathToEnv(envs, "PYTHONPATH", PythonHelpersLocator.getHelperPath("pycharm_matplotlib_backend"));
            PythonEnvUtil.addPathToEnv(envs, "PYTHONPATH", PythonHelpersLocator.getHelperPath("pycharm_display"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableConfiguration";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runParams";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/scientific/figures/PySciEnvironmentProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableFor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledFor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "patchCommandLine";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "attachToProcess";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "tryGetProcess";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "extendEnvironment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

