/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.scientific;

import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.jetbrains.python.console.PyConsoleProcessHandler;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PythonConsoleToolWindow;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.containerview.PyDataView;
import com.jetbrains.python.scientific.PySciProjectComponent;
import com.jetbrains.python.scientific.PyScientificViewKt;
import com.jetbrains.python.scientific.figures.PyPlotToolWindow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyDataViewToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            PyDataViewToolWindowFactory.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            PyDataViewToolWindowFactory.$$$reportNull$$$0(1);
        }
        PyDataViewToolWindowFactory.initializeDataTab(project, toolWindow);
        PyPlotToolWindow.getInstance(project).init(toolWindow);
        PyDataViewToolWindowFactory.showDocsToolwindow(project);
    }

    private static void showDocsToolwindow(@NotNull Project project) {
        if (project == null) {
            PyDataViewToolWindowFactory.$$$reportNull$$$0(2);
        }
        if (PySciProjectComponent.getInstance(project).shouldUseSciView()) {
            VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
            if (projectDir == null) {
                return;
            }
            PsiDirectory directory2 = PsiManager.getInstance((Project)project).findDirectory(projectDir);
            PyScientificViewKt.showDocumentationToolwindow(project, (PsiElement)directory2);
        }
    }

    private static void initializeDataTab(final @NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            PyDataViewToolWindowFactory.$$$reportNull$$$0(3);
        }
        if (toolWindow == null) {
            PyDataViewToolWindowFactory.$$$reportNull$$$0(4);
        }
        PyDataView.getInstance(project).init(toolWindow);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(XDebuggerManager.TOPIC, (Object)new ChangeContentXDebuggerManagerListener(project));
        connection.subscribe(RunContentManager.TOPIC, (Object)new RunContentWithExecutorListener(){

            public void contentSelected(@Nullable RunContentDescriptor descriptor2, @NotNull Executor executor) {
                if (executor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(executor instanceof DefaultDebugExecutor)) {
                    return;
                }
                if (descriptor2 == null) {
                    return;
                }
                ProcessHandler handler = descriptor2.getProcessHandler();
                if (handler == null) {
                    return;
                }
                PyDataView.getInstance(project).updateTabs(handler);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/python/scientific/PyDataViewToolWindowFactory$1", "contentSelected"));
            }
        });
        PyDataViewToolWindowFactory.addPythonConsoleListener(project);
        PyDataViewToggleAction autoResizeAction = new PyDataViewToggleAction("Resize Automatically", "python.debugger.dataview.autoresize"){

            @Override
            public void setSelected(@NotNull AnActionEvent e, boolean state2) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.setSelected(e, state2);
                PyDataView.getInstance(project).changeAutoResize(state2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/scientific/PyDataViewToolWindowFactory$2", "setSelected"));
            }
        };
        DefaultActionGroup group2 = new DefaultActionGroup(new AnAction[]{new PyDataViewToggleAction("Colored by Default", "python.debugger.dataview.coloredbydefault"), autoResizeAction});
        ((ToolWindowEx)toolWindow).setAdditionalGearActions((ActionGroup)group2);
    }

    private static void addPythonConsoleListener(final @NotNull Project project) {
        ToolWindow pythonConsole;
        if (project == null) {
            PyDataViewToolWindowFactory.$$$reportNull$$$0(5);
        }
        if ((pythonConsole = ToolWindowManager.getInstance((Project)project).getToolWindow("Python Console")) == null) {
            return;
        }
        pythonConsole.getContentManager().addContentManagerListener(new ContentManagerListener(){

            public void contentRemoved(@NotNull ContentManagerEvent event2) {
                if (event2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                PyDataView.getInstance(project).closeDisconnectedFromConsoleTabs();
            }

            public void selectionChanged(@NotNull ContentManagerEvent event2) {
                if (event2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (!PyDataView.getInstance(project).getVisibleTabs().isEmpty()) {
                    return;
                }
                PyDataViewToolWindowFactory.addTabConnectedToConsole(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/jetbrains/python/scientific/PyDataViewToolWindowFactory$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentRemoved";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void addTabConnectedToConsole(@NotNull Project project) {
        PythonConsoleToolWindow toolWindow;
        if (project == null) {
            PyDataViewToolWindowFactory.$$$reportNull$$$0(6);
        }
        if ((toolWindow = PythonConsoleToolWindow.getInstance(project)) == null) {
            return;
        }
        RunContentDescriptor descriptor2 = toolWindow.getSelectedContentDescriptor();
        if (descriptor2 == null) {
            return;
        }
        ProcessHandler handler = descriptor2.getProcessHandler();
        if (handler == null) {
            return;
        }
        if (handler instanceof PyConsoleProcessHandler) {
            PydevConsoleCommunication communication = ((PyConsoleProcessHandler)handler).getPydevConsoleCommunication();
            PyDataView.getInstance(project).addTab(communication);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/scientific/PyDataViewToolWindowFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindowContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showDocsToolwindow";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "initializeDataTab";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addPythonConsoleListener";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addTabConnectedToConsole";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ChangeContentXDebuggerManagerListener
    implements XDebuggerManagerListener {
        private final Project myProject;

        ChangeContentXDebuggerManagerListener(Project project) {
            this.myProject = project;
        }

        public void processStarted(@NotNull XDebugProcess debugProcess) {
            if (debugProcess == null) {
                ChangeContentXDebuggerManagerListener.$$$reportNull$$$0(0);
            }
        }

        public void processStopped(@NotNull XDebugProcess debugProcess) {
            if (debugProcess == null) {
                ChangeContentXDebuggerManagerListener.$$$reportNull$$$0(1);
            }
            if (debugProcess instanceof PyDebugProcess) {
                PyDataView dataView = PyDataView.getInstance(this.myProject);
                ApplicationManager.getApplication().invokeLater(() -> {
                    dataView.closeTabs(frameAccessor -> frameAccessor instanceof PyDebugProcess && frameAccessor == debugProcess);
                    if (dataView.getVisibleTabs().isEmpty()) {
                        PyDataViewToolWindowFactory.addTabConnectedToConsole(this.myProject);
                    }
                }, this.myProject.getDisposed());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "debugProcess";
            objectArray2[1] = "com/jetbrains/python/scientific/PyDataViewToolWindowFactory$ChangeContentXDebuggerManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processStopped";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PyDataViewToggleAction
    extends ToggleAction {
        private final String myPropertyKey;

        PyDataViewToggleAction(String text2, String propertyKey) {
            super(text2);
            this.myPropertyKey = propertyKey;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                PyDataViewToggleAction.$$$reportNull$$$0(0);
            }
            if ((project = e.getProject()) == null) {
                return false;
            }
            return PropertiesComponent.getInstance((Project)project).getBoolean(this.myPropertyKey, true);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            Project project;
            if (e == null) {
                PyDataViewToggleAction.$$$reportNull$$$0(1);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            PropertiesComponent.getInstance((Project)project).setValue(this.myPropertyKey, state2, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/python/scientific/PyDataViewToolWindowFactory$PyDataViewToggleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

