/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote.sdk.add.wizard.ui;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.SshConnectionUtil;
import com.intellij.ssh.ui.SshUIUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.python.remote.PySshInterpreterBundle;
import com.jetbrains.python.remote.sdk.add.wizard.ui.ValidationAwareForm;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshAuthenticationForm
extends ValidationAwareForm {
    private JPanel myMainPanel;
    private JBLabel myConnectingLabel;
    private JBRadioButton myPasswordRadioButton;
    private JBPasswordField myPasswordField;
    private JBCheckBox mySavePasswordCheckBox;
    private JBRadioButton myKeyPairRadioButton;
    private TextFieldWithBrowseButton myPrivateKeyFileTextField;
    private JBPasswordField myPassphraseField;
    private JBCheckBox mySavePassphraseCheckBox;
    private boolean myPassphraseMightBeRequired;

    public SshAuthenticationForm(@NotNull String user, @NotNull String host, int port) {
        if (user == null) {
            SshAuthenticationForm.$$$reportNull$$$0(0);
        }
        if (host == null) {
            SshAuthenticationForm.$$$reportNull$$$0(1);
        }
        this.$$$setupUI$$$();
        this.myConnectingLabel.setText(PySshInterpreterBundle.message("ssh.connection.wizard.authentication.options.label.text", user, host, port));
        this.myPasswordRadioButton.addActionListener(e -> this.onPasswordOptionSelected());
        this.myKeyPairRadioButton.addActionListener(e -> this.onKeyPairOptionSelected());
        this.myPrivateKeyFileTextField.addActionListener((ActionListener)SshUIUtil.createBrowseListenerForPrivateKey((TextFieldWithBrowseButton)this.myPrivateKeyFileTextField));
        this.myPrivateKeyFileTextField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                SshAuthenticationForm.this.updatePassphraseMightBeRequired();
                SshAuthenticationForm.this.updateOptionsEnabled();
                SshAuthenticationForm.this.updateIsValid();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/remote/sdk/add/wizard/ui/SshAuthenticationForm$1", "textChanged"));
            }
        });
        DocumentListener listener2 = this.createUpdateIsValidDocumentListener();
        this.myPasswordField.getDocument().addDocumentListener(listener2);
        this.myPassphraseField.getDocument().addDocumentListener(listener2);
        this.myPasswordRadioButton.setSelected(true);
        this.onPasswordOptionSelected();
    }

    public void setPreviousConnectionErrorMessage(@NotNull String message) {
        if (message == null) {
            SshAuthenticationForm.$$$reportNull$$$0(2);
        }
        this.myConnectingLabel.setText(message);
        this.myConnectingLabel.setForeground((Color)JBColor.RED);
        this.myConnectingLabel.setIcon(AllIcons.General.ErrorDialog);
    }

    private void onPasswordOptionSelected() {
        this.updateOptionsEnabled();
        this.updateIsValid();
    }

    private void onKeyPairOptionSelected() {
        this.updatePassphraseMightBeRequired();
        this.updateOptionsEnabled();
        this.updateIsValid();
    }

    private void updateOptionsEnabled() {
        boolean passwordOptionEnabled = this.myPasswordRadioButton.isSelected();
        this.myPasswordField.setEnabled(passwordOptionEnabled);
        this.mySavePasswordCheckBox.setEnabled(passwordOptionEnabled);
        this.myPrivateKeyFileTextField.setEnabled(!passwordOptionEnabled);
        this.myPassphraseField.setEnabled(!passwordOptionEnabled && this.myPassphraseMightBeRequired);
        this.mySavePassphraseCheckBox.setEnabled(!passwordOptionEnabled && this.myPassphraseMightBeRequired);
    }

    private void updatePassphraseMightBeRequired() {
        if (this.myKeyPairRadioButton.isSelected()) {
            this.myPassphraseMightBeRequired = SshConnectionUtil.isPassphraseMayBeRequired((String)this.myPrivateKeyFileTextField.getText());
        }
    }

    @Override
    protected boolean computeIsValid() {
        if (this.myPasswordRadioButton.isSelected()) {
            return this.myPasswordField.getPassword().length > 0;
        }
        if (this.myKeyPairRadioButton.isSelected()) {
            return !StringUtil.isEmptyOrSpaces((String)this.myPrivateKeyFileTextField.getText());
        }
        return false;
    }

    @NotNull
    public JPanel getMainPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            SshAuthenticationForm.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @NotNull
    public <T> T accept(@NotNull OptionVisitor<T> visitor2) {
        if (visitor2 == null) {
            SshAuthenticationForm.$$$reportNull$$$0(4);
        }
        if (this.myPasswordRadioButton.isSelected()) {
            T t = visitor2.onPasswordOption(this.myPasswordField.getPassword(), this.mySavePasswordCheckBox.isSelected());
            if (t == null) {
                SshAuthenticationForm.$$$reportNull$$$0(5);
            }
            return t;
        }
        T t = visitor2.onKeyPairOption(this.myPrivateKeyFileTextField.getText(), this.myPassphraseField.isEnabled() ? SshAuthenticationForm.nullize(this.myPassphraseField.getPassword()) : null, this.mySavePassphraseCheckBox.isSelected());
        if (t == null) {
            SshAuthenticationForm.$$$reportNull$$$0(6);
        }
        return t;
    }

    private static char @Nullable [] nullize(char @Nullable [] array) {
        if (array == null || array.length == 0) {
            array = null;
        }
        return array;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBPasswordField jBPasswordField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBRadioButton jBRadioButton;
        JBCheckBox jBCheckBox2;
        JBPasswordField jBPasswordField2;
        JBRadioButton jBRadioButton2;
        JBLabel jBLabel;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myConnectingLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PySshInterpreterBundle", SshAuthenticationForm.class).getString("ssh.connection.wizard.authentication.options.label.text"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myPasswordRadioButton = jBRadioButton2 = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, DynamicBundle.getBundle((String)"messages/PySshInterpreterBundle", SshAuthenticationForm.class).getString("ssh.connection.wizard.password.label.text"));
        jPanel.add((Component)jBRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordField = jBPasswordField2 = new JBPasswordField();
        jBPasswordField2.setText("");
        jPanel.add((Component)jBPasswordField2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(150, -1), null));
        this.mySavePasswordCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/PySshInterpreterBundle", SshAuthenticationForm.class).getString("ssh.connection.wizard.save.password.checkbox.label.text"));
        jPanel.add((Component)jBCheckBox2, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myKeyPairRadioButton = jBRadioButton = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/PySshInterpreterBundle", SshAuthenticationForm.class).getString("ssh.connection.wizard.key.pair.label.text"));
        jPanel.add((Component)jBRadioButton, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/PySshInterpreterBundle", SshAuthenticationForm.class).getString("ssh.connection.wizard.private.key.file.label.text"));
        jPanel.add((Component)jBLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        this.myPrivateKeyFileTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/PySshInterpreterBundle", SshAuthenticationForm.class).getString("ssh.connection.wizard.passphrase.label.text"));
        jPanel.add((Component)jBLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        this.myPassphraseField = jBPasswordField = new JBPasswordField();
        jPanel.add((Component)jBPasswordField, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(150, -1), null));
        this.mySavePassphraseCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PySshInterpreterBundle", SshAuthenticationForm.class).getString("ssh.connection.wizard.save.passphrase.checkbox.label.text"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(4, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/sdk/add/wizard/ui/SshAuthenticationForm";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/sdk/add/wizard/ui/SshAuthenticationForm";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainPanel";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "accept";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPreviousConnectionErrorMessage";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface OptionVisitor<T> {
        @NotNull
        public T onPasswordOption(char @NotNull [] var1, boolean var2);

        @NotNull
        public T onKeyPairOption(@NotNull String var1, char @Nullable [] var2, boolean var3);
    }
}

