/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.remote.ColoredRemoteProcessHandler;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.Tunnelable;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.remote.vfs.PyRemotePositionConverter;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.remote.RemoteDebuggableProcessHandler;
import java.nio.charset.Charset;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteProcessHandler
extends ColoredRemoteProcessHandler<RemoteProcess>
implements RemoteDebuggableProcessHandler,
KillableProcess {
    private static final Logger LOG = Logger.getInstance(PyRemoteProcessHandler.class);
    public static final String LOG_PY_CHARM_FILE_MAPPING = "LOG: PyCharm: File mapping:";
    @NotNull
    private final PyRemotePathMapper myPathMapper;
    private final List<PathMappingSettings.PathMapping> myFileMappings;
    @NotNull
    private final PyRemoteSocketToLocalHostProvider myRemoteSocketProvider;

    private PyRemoteProcessHandler(@NotNull RemoteProcess process2, @NotNull String commandLine, @NotNull Charset charset, @Nullable PyRemotePathMapper pathMapper, @NotNull PyRemoteSocketToLocalHostProvider remoteSocketProvider) {
        if (process2 == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(1);
        }
        if (charset == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(2);
        }
        if (remoteSocketProvider == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(3);
        }
        super(process2, commandLine, charset);
        this.myFileMappings = Lists.newArrayList();
        this.myRemoteSocketProvider = remoteSocketProvider;
        this.myPathMapper = pathMapper != null ? pathMapper : new PyRemotePathMapper();
        this.putUserData(PythonRemoteInterpreterManager.PATH_MAPPING_SETTINGS_KEY, pathMapper);
    }

    @NotNull
    public PathMapper getMappingSettings() {
        PyRemotePathMapper pyRemotePathMapper = this.myPathMapper;
        if (pyRemotePathMapper == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(4);
        }
        return pyRemotePathMapper;
    }

    @Deprecated
    public void addRemoteForwarding(int remotePort, int localPort) {
        try {
            if (this.myProcess instanceof Tunnelable) {
                ((Tunnelable)this.myProcess).addRemoteTunnel(remotePort, "localhost", localPort);
            }
        }
        catch (RemoteSdkException e) {
            throw new RuntimeException(e);
        }
    }

    public Pair<String, Integer> getRemoteSocket(int localPort) throws RemoteSdkException {
        try {
            return this.myRemoteSocketProvider.getRemoteSocket(localPort);
        }
        catch (RemoteSdkException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public HostAndPort getLocalTunnel(int remotePort) {
        return ((RemoteProcess)this.myProcess).getLocalTunnel(remotePort);
    }

    public boolean canKillProcess() {
        return true;
    }

    public void killProcess() {
        this.destroyProcessImpl();
    }

    @NotNull
    public static PyRemoteProcessHandler createProcessHandler(@NotNull RemoteProcess remoteProcess, @NotNull RemoteSdkCredentials data, @NotNull GeneralCommandLine commandLine, @Nullable PyRemotePathMapper pathMapper, @NotNull PyRemoteSocketToLocalHostProvider remoteSocketProvider) throws RemoteSdkException {
        if (remoteProcess == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(5);
        }
        if (data == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(6);
        }
        if (commandLine == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(7);
        }
        if (remoteSocketProvider == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(8);
        }
        return PyRemoteProcessHandler.createProcessHandler(remoteProcess, data.getFullInterpreterPath(), commandLine, pathMapper, remoteSocketProvider);
    }

    @NotNull
    public static PyRemoteProcessHandler createProcessHandler(@NotNull RemoteProcess remoteProcess, @Nullable String fullInterpreterPath, @NotNull GeneralCommandLine commandLine, @Nullable PyRemotePathMapper pathMapper, @NotNull PyRemoteSocketToLocalHostProvider remoteSocketProvider) throws RemoteSdkException {
        if (remoteProcess == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(9);
        }
        if (commandLine == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(10);
        }
        if (remoteSocketProvider == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(11);
        }
        return new PyRemoteProcessHandler(remoteProcess, commandLine.getCommandLineString(fullInterpreterPath), commandLine.getCharset(), pathMapper, remoteSocketProvider);
    }

    public void coloredTextAvailable(@NotNull String text2, @NotNull Key outputType) {
        if (text2 == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(12);
        }
        if (outputType == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(13);
        }
        if (text2.startsWith(LOG_PY_CHARM_FILE_MAPPING)) {
            String[] paths = (text2 = text2.substring(LOG_PY_CHARM_FILE_MAPPING.length())).split("\t");
            if (paths.length == 2) {
                this.myFileMappings.add(new PathMappingSettings.PathMapping(paths[0].trim(), paths[1].trim()));
            } else {
                LOG.warn("Can't parse remote file mapping " + text2);
            }
        } else {
            super.coloredTextAvailable(text2, outputType);
        }
    }

    public List<PathMappingSettings.PathMapping> getFileMappings() {
        return this.myFileMappings;
    }

    @Override
    public PyPositionConverter createPositionConverter(@NotNull PyDebugProcess debugProcess) {
        if (debugProcess == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(14);
        }
        return new PyRemotePositionConverter(debugProcess, this.myPathMapper);
    }

    @Override
    public PyRemoteSocketToLocalHostProvider getRemoteSocketToLocalHostProvider() {
        return this.myRemoteSocketProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 3: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSocketProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyRemoteProcessHandler";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteProcess";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyRemoteProcessHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "coloredTextAvailable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createPositionConverter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

