/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.psi.resolve.PythonPathCache;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.sdk.PythonSdkUtil;
import org.jetbrains.annotations.NotNull;

public class PythonModulePathCache
extends PythonPathCache
implements Disposable {
    public static PythonPathCache getInstance(Module module) {
        return (PythonPathCache)module.getService(PythonPathCache.class);
    }

    public PythonModulePathCache(final Module module) {
        MessageBusConnection connection = module.getMessageBus().connect();
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event2) {
                if (event2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                PythonModulePathCache.updateCacheForSdk(module);
                PythonModulePathCache.this.clearCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/psi/resolve/PythonModulePathCache$1", "rootsChanged"));
            }
        });
        connection.subscribe(PyPackageManager.PACKAGE_MANAGER_TOPIC, sdk -> {
            Sdk moduleSdk = PythonSdkUtil.findPythonSdk(module);
            if (sdk == moduleSdk) {
                PythonModulePathCache.updateCacheForSdk(module);
                this.clearCache();
            }
        });
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new PythonPathCache.MyVirtualFileListener(this), (Disposable)this);
        PythonModulePathCache.updateCacheForSdk(module);
    }

    private static void updateCacheForSdk(Module module) {
        Sdk sdk = PythonSdkUtil.findPythonSdk(module);
        if (sdk != null) {
            PythonSdkPathCache.getInstance(module.getProject(), sdk);
        }
    }

    public void dispose() {
    }
}

