/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.lexer;

import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.FlexLexerEx;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002'(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u000eJ\u0006\u0010\u0012\u001a\u00020\u000eJ\u0006\u0010\u0013\u001a\u00020\u000eJ\u0006\u0010\u0014\u001a\u00020\u000eJ\u0006\u0010\u0015\u001a\u00020\u000eJ\u0006\u0010\u0016\u001a\u00020\u000eJ\u0006\u0010\u0017\u001a\u00020\u000eJ\u0006\u0010\u0018\u001a\u00020\u000eJ\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eJ\u0006\u0010\u001b\u001a\u00020\u000eJ\u0006\u0010\u001c\u001a\u00020\u000eJ\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eJ\u000e\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000eJ\u0018\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000bH\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0010H\u0002J\u0006\u0010&\u001a\u00020\tR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/python/lexer/PyLexerFStringHelper;", "", "myLexer", "Lcom/jetbrains/python/lexer/FlexLexerEx;", "(Lcom/jetbrains/python/lexer/FlexLexerEx;)V", "myFStringStates", "Lcom/intellij/util/containers/Stack;", "Lcom/jetbrains/python/lexer/PyLexerFStringHelper$FStringState;", "dropFStringStateWithAllNested", "", "fStringIndex", "", "findFStringTerminator", "Lkotlin/Pair;", "Lcom/intellij/psi/tree/IElementType;", "text", "", "getTextTokenType", "handleColonEqInFragment", "handleColonInFragment", "handleFStringEnd", "handleFStringStart", "handleFStringStartInFragment", "handleFragmentEnd", "handleFragmentStart", "handleLeftBracketInFragment", "type", "handleLineBreakInFragment", "handleLineBreakInLiteralText", "handleRightBracketInFragment", "handleStringLiteral", "stringLiteralType", "pushBackToOrConsumeMatch", "matchOffset", "matchSize", "pushFString", "Lcom/jetbrains/python/psi/PyElementType;", "prefixAndQuotes", "reset", "FStringState", "FragmentState", "intellij.python.psi.impl"})
public final class PyLexerFStringHelper {
    private final Stack<FStringState> myFStringStates;
    private final FlexLexerEx myLexer;

    @NotNull
    public final IElementType handleFStringStartInFragment() {
        String prefixAndQuotes = ((Object)this.myLexer.yytext()).toString();
        Pair<IElementType, Integer> pair = this.findFStringTerminator(prefixAndQuotes);
        int offset = ((Number)pair.component2()).intValue();
        if (offset == prefixAndQuotes.length()) {
            return this.pushFString(prefixAndQuotes);
        }
        PyElementType pyElementType = PyTokenTypes.IDENTIFIER;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyElementType), (String)"PyTokenTypes.IDENTIFIER");
        return pyElementType;
    }

    @NotNull
    public final IElementType handleFStringStart() {
        return this.pushFString(((Object)this.myLexer.yytext()).toString());
    }

    private final PyElementType pushFString(String prefixAndQuotes) {
        int prefixLength = PyStringLiteralUtil.getPrefixLength(prefixAndQuotes);
        String string = prefixAndQuotes;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(prefixLength);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String openingQuotes = string3;
        String string4 = prefixAndQuotes;
        int n = 0;
        boolean bl2 = false;
        String string5 = string4;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(n, prefixLength);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String prefix = string6;
        this.myFStringStates.push((Object)new FStringState(this.myLexer.yystate(), this.myLexer.getTokenStart(), prefix, openingQuotes));
        this.myLexer.yybegin(6);
        PyElementType pyElementType = PyTokenTypes.FSTRING_START;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyElementType), (String)"PyTokenTypes.FSTRING_START");
        return pyElementType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IElementType handleFStringEnd() {
        IElementType iElementType;
        IElementType textType = this.getTextTokenType();
        Pair<IElementType, Integer> pair = this.findFStringTerminator(((Object)this.myLexer.yytext()).toString());
        IElementType iElementType2 = (IElementType)pair.component1();
        int offset = ((Number)pair.component2()).intValue();
        if (offset == 0) {
            void type;
            iElementType = type;
            if (iElementType == null) {
                Intrinsics.throwNpe();
            }
        } else {
            iElementType = textType;
        }
        return iElementType;
    }

    @NotNull
    public final IElementType handleFragmentStart() {
        ((FStringState)this.myFStringStates.peek()).getFragmentStates().push((Object)new FragmentState(this.myLexer.yystate(), this.myLexer.getTokenStart()));
        this.myLexer.yybegin(8);
        PyElementType pyElementType = PyTokenTypes.FSTRING_FRAGMENT_START;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyElementType), (String)"PyTokenTypes.FSTRING_FRAGMENT_START");
        return pyElementType;
    }

    @NotNull
    public final IElementType handleFragmentEnd() {
        FragmentState state2 = (FragmentState)((FStringState)this.myFStringStates.peek()).getFragmentStates().pop();
        this.myLexer.yybegin(state2.getOldState());
        PyElementType pyElementType = PyTokenTypes.FSTRING_FRAGMENT_END;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyElementType), (String)"PyTokenTypes.FSTRING_FRAGMENT_END");
        return pyElementType;
    }

    @NotNull
    public final IElementType handleLeftBracketInFragment(@NotNull IElementType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        FragmentState fragmentState = (FragmentState)((FStringState)this.myFStringStates.peek()).getFragmentStates().peek();
        int n = fragmentState.getBraceBalance();
        fragmentState.setBraceBalance(n + 1);
        return type;
    }

    @NotNull
    public final IElementType handleRightBracketInFragment(@NotNull IElementType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        FragmentState activeFragmentState = (FragmentState)((FStringState)this.myFStringStates.peek()).getFragmentStates().peek();
        if (activeFragmentState.getBraceBalance() == 0 && Intrinsics.areEqual((Object)type, (Object)((Object)PyTokenTypes.RBRACE))) {
            return this.handleFragmentEnd();
        }
        FragmentState fragmentState = activeFragmentState;
        int n = fragmentState.getBraceBalance();
        fragmentState.setBraceBalance(n + -1);
        return type;
    }

    @NotNull
    public final IElementType handleColonInFragment() {
        if (((FragmentState)((FStringState)this.myFStringStates.peek()).getFragmentStates().peek()).getBraceBalance() == 0) {
            this.myLexer.yybegin(10);
            PyElementType pyElementType = PyTokenTypes.FSTRING_FRAGMENT_FORMAT_START;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyElementType), (String)"PyTokenTypes.FSTRING_FRAGMENT_FORMAT_START");
            return pyElementType;
        }
        PyElementType pyElementType = PyTokenTypes.COLON;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyElementType), (String)"PyTokenTypes.COLON");
        return pyElementType;
    }

    @NotNull
    public final IElementType handleColonEqInFragment() {
        if (((FragmentState)((FStringState)this.myFStringStates.peek()).getFragmentStates().peek()).getBraceBalance() == 0) {
            this.myLexer.yybegin(10);
            this.myLexer.yypushback(1);
            PyElementType pyElementType = PyTokenTypes.FSTRING_FRAGMENT_FORMAT_START;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyElementType), (String)"PyTokenTypes.FSTRING_FRAGMENT_FORMAT_START");
            return pyElementType;
        }
        PyElementType pyElementType = PyTokenTypes.COLONEQ;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyElementType), (String)"PyTokenTypes.COLONEQ");
        return pyElementType;
    }

    @NotNull
    public final IElementType handleLineBreakInFragment() {
        String text2 = ((Object)this.myLexer.yytext()).toString();
        this.findFStringTerminator(text2);
        PyElementType pyElementType = PyTokenTypes.LINE_BREAK;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyElementType), (String)"PyTokenTypes.LINE_BREAK");
        return pyElementType;
    }

    @NotNull
    public final IElementType handleLineBreakInLiteralText() {
        String text2 = ((Object)this.myLexer.yytext()).toString();
        Pair<IElementType, Integer> pair = this.findFStringTerminator(text2);
        int offset = ((Number)pair.component2()).intValue();
        if (offset == text2.length()) {
            return this.getTextTokenType();
        }
        PyElementType pyElementType = PyTokenTypes.LINE_BREAK;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyElementType), (String)"PyTokenTypes.LINE_BREAK");
        return pyElementType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IElementType handleStringLiteral(@NotNull IElementType stringLiteralType) {
        IElementType iElementType;
        int offset;
        Intrinsics.checkParameterIsNotNull((Object)stringLiteralType, (String)"stringLiteralType");
        String stringText = ((Object)this.myLexer.yytext()).toString();
        int prefixLength = PyStringLiteralUtil.getPrefixLength(stringText);
        Pair<IElementType, Integer> pair = this.findFStringTerminator(stringText);
        IElementType iElementType2 = (IElementType)pair.component1();
        int n = offset = ((Number)pair.component2()).intValue();
        if (n == 0) {
            void type;
            iElementType = type;
            if (iElementType == null) {
                Intrinsics.throwNpe();
            }
        } else if (n == prefixLength) {
            PyElementType pyElementType = PyTokenTypes.IDENTIFIER;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyElementType), (String)"PyTokenTypes.IDENTIFIER");
            iElementType = pyElementType;
        } else {
            iElementType = stringLiteralType;
        }
        return iElementType;
    }

    private final Pair<IElementType, Integer> findFStringTerminator(String text2) {
        int i = 0;
        while (i < text2.length()) {
            FStringState it;
            int $i$f$any;
            Object $this$any$iv;
            char c = text2.charAt(i);
            if (c == '\\') {
                i += 2;
                continue;
            }
            if (c == '\n') {
                boolean insideSingleQuoted;
                block13: {
                    boolean bl;
                    $this$any$iv = (Iterable)this.myFStringStates;
                    $i$f$any = 0;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        Iterator iterator = $this$any$iv.iterator();
                        while (iterator.hasNext()) {
                            Object element$iv = iterator.next();
                            it = (FStringState)element$iv;
                            boolean bl2 = false;
                            if (!(it.getOpeningQuotes().length() == 1)) continue;
                            bl = true;
                            break block13;
                        }
                        bl = insideSingleQuoted = false;
                    }
                }
                if (insideSingleQuoted) {
                    if (i == 0) {
                        this.dropFStringStateWithAllNested(0);
                    }
                    this.pushBackToOrConsumeMatch(i, 1);
                    return new Pair((Object)PyTokenTypes.LINE_BREAK, (Object)i);
                }
            } else {
                int lastWithMatchingQuotesIndex;
                block14: {
                    int n;
                    $this$any$iv = text2;
                    $i$f$any = Math.min(text2.length(), i + 3);
                    boolean bl = false;
                    Object object = $this$any$iv;
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)((String)object).substring(i, $i$f$any), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    List $this$indexOfLast$iv = (List)this.myFStringStates;
                    boolean $i$f$indexOfLast = false;
                    ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String nextThree;
                        it = (FStringState)iterator$iv.previous();
                        boolean bl3 = false;
                        if (!StringsKt.startsWith$default((String)nextThree, (String)it.getOpeningQuotes(), (boolean)false, (int)2, null)) continue;
                        n = iterator$iv.nextIndex();
                        break block14;
                    }
                    n = lastWithMatchingQuotesIndex = -1;
                }
                if (lastWithMatchingQuotesIndex >= 0) {
                    FStringState state2 = (FStringState)this.myFStringStates.get(lastWithMatchingQuotesIndex);
                    if (i == 0) {
                        this.dropFStringStateWithAllNested(lastWithMatchingQuotesIndex);
                    }
                    this.pushBackToOrConsumeMatch(i, state2.getOpeningQuotes().length());
                    return new Pair((Object)PyTokenTypes.FSTRING_END, (Object)i);
                }
            }
            ++i;
        }
        return new Pair(null, (Object)text2.length());
    }

    private final void dropFStringStateWithAllNested(int fStringIndex) {
        this.myLexer.yybegin(((FStringState)this.myFStringStates.get(fStringIndex)).getOldState());
        this.myFStringStates.subList(fStringIndex, this.myFStringStates.size()).clear();
    }

    private final void pushBackToOrConsumeMatch(int matchOffset, int matchSize) {
        if (matchOffset == 0) {
            this.myLexer.yypushback(this.myLexer.yylength() - matchSize);
        } else {
            this.myLexer.yypushback(this.myLexer.yylength() - matchOffset);
        }
    }

    public final void reset() {
        this.myFStringStates.clear();
    }

    @NotNull
    public final IElementType getTextTokenType() {
        Collection collection = (Collection)this.myFStringStates;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (PyStringLiteralUtil.isRawPrefix(((FStringState)this.myFStringStates.peek()).getPrefix())) {
            PyElementType pyElementType = PyTokenTypes.FSTRING_RAW_TEXT;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyElementType), (String)"PyTokenTypes.FSTRING_RAW_TEXT");
            return pyElementType;
        }
        PyElementType pyElementType = PyTokenTypes.FSTRING_TEXT;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyElementType), (String)"PyTokenTypes.FSTRING_TEXT");
        return pyElementType;
    }

    public PyLexerFStringHelper(@NotNull FlexLexerEx myLexer) {
        Intrinsics.checkParameterIsNotNull((Object)myLexer, (String)"myLexer");
        this.myLexer = myLexer;
        this.myFStringStates = new Stack();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/python/lexer/PyLexerFStringHelper$FStringState;", "", "oldState", "", "offset", "prefix", "", "openingQuotes", "(IILjava/lang/String;Ljava/lang/String;)V", "fragmentStates", "Lcom/intellij/util/containers/Stack;", "Lcom/jetbrains/python/lexer/PyLexerFStringHelper$FragmentState;", "getFragmentStates", "()Lcom/intellij/util/containers/Stack;", "getOffset", "()I", "getOldState", "getOpeningQuotes", "()Ljava/lang/String;", "getPrefix", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "intellij.python.psi.impl"})
    private static final class FStringState {
        @NotNull
        private final Stack<FragmentState> fragmentStates;
        private final int oldState;
        private final int offset;
        @NotNull
        private final String prefix;
        @NotNull
        private final String openingQuotes;

        @NotNull
        public final Stack<FragmentState> getFragmentStates() {
            return this.fragmentStates;
        }

        public final int getOldState() {
            return this.oldState;
        }

        public final int getOffset() {
            return this.offset;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getOpeningQuotes() {
            return this.openingQuotes;
        }

        public FStringState(int oldState, int offset, @NotNull String prefix, @NotNull String openingQuotes) {
            Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
            Intrinsics.checkParameterIsNotNull((Object)openingQuotes, (String)"openingQuotes");
            this.oldState = oldState;
            this.offset = offset;
            this.prefix = prefix;
            this.openingQuotes = openingQuotes;
            this.fragmentStates = new Stack();
        }

        public final int component1() {
            return this.oldState;
        }

        public final int component2() {
            return this.offset;
        }

        @NotNull
        public final String component3() {
            return this.prefix;
        }

        @NotNull
        public final String component4() {
            return this.openingQuotes;
        }

        @NotNull
        public final FStringState copy(int oldState, int offset, @NotNull String prefix, @NotNull String openingQuotes) {
            Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
            Intrinsics.checkParameterIsNotNull((Object)openingQuotes, (String)"openingQuotes");
            return new FStringState(oldState, offset, prefix, openingQuotes);
        }

        public static /* synthetic */ FStringState copy$default(FStringState fStringState, int n, int n2, String string, String string2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = fStringState.oldState;
            }
            if ((n3 & 2) != 0) {
                n2 = fStringState.offset;
            }
            if ((n3 & 4) != 0) {
                string = fStringState.prefix;
            }
            if ((n3 & 8) != 0) {
                string2 = fStringState.openingQuotes;
            }
            return fStringState.copy(n, n2, string, string2);
        }

        @NotNull
        public String toString() {
            return "FStringState(oldState=" + this.oldState + ", offset=" + this.offset + ", prefix=" + this.prefix + ", openingQuotes=" + this.openingQuotes + ")";
        }

        public int hashCode() {
            String string = this.prefix;
            String string2 = this.openingQuotes;
            return ((Integer.hashCode(this.oldState) * 31 + Integer.hashCode(this.offset)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FStringState)) break block3;
                    FStringState fStringState = (FStringState)object;
                    if (this.oldState != fStringState.oldState || this.offset != fStringState.offset || !Intrinsics.areEqual((Object)this.prefix, (Object)fStringState.prefix) || !Intrinsics.areEqual((Object)this.openingQuotes, (Object)fStringState.openingQuotes)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/python/lexer/PyLexerFStringHelper$FragmentState;", "", "oldState", "", "offset", "(II)V", "braceBalance", "getBraceBalance", "()I", "setBraceBalance", "(I)V", "getOffset", "getOldState", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.python.psi.impl"})
    private static final class FragmentState {
        private int braceBalance;
        private final int oldState;
        private final int offset;

        public final int getBraceBalance() {
            return this.braceBalance;
        }

        public final void setBraceBalance(int n) {
            this.braceBalance = n;
        }

        public final int getOldState() {
            return this.oldState;
        }

        public final int getOffset() {
            return this.offset;
        }

        public FragmentState(int oldState, int offset) {
            this.oldState = oldState;
            this.offset = offset;
        }

        public final int component1() {
            return this.oldState;
        }

        public final int component2() {
            return this.offset;
        }

        @NotNull
        public final FragmentState copy(int oldState, int offset) {
            return new FragmentState(oldState, offset);
        }

        public static /* synthetic */ FragmentState copy$default(FragmentState fragmentState, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = fragmentState.oldState;
            }
            if ((n3 & 2) != 0) {
                n2 = fragmentState.offset;
            }
            return fragmentState.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "FragmentState(oldState=" + this.oldState + ", offset=" + this.offset + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.oldState) * 31 + Integer.hashCode(this.offset);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FragmentState)) break block3;
                    FragmentState fragmentState = (FragmentState)object;
                    if (this.oldState != fragmentState.oldState || this.offset != fragmentState.offset) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

