/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.google.common.collect.Lists;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.psi.PsiReferenceEx;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocStringParameterReference
extends PsiReferenceBase<PyStringLiteralExpression>
implements PsiReferenceEx {
    private final ReferenceType myType;

    public DocStringParameterReference(PyStringLiteralExpression element, TextRange range, ReferenceType refType) {
        super((PsiElement)element, range);
        this.myType = refType;
    }

    public PsiElement resolve() {
        PyDocStringOwner owner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PyDocStringOwner.class);
        if (owner instanceof PyFunction) {
            return this.resolveParameter((PyFunction)owner);
        }
        if (owner instanceof PyClass) {
            PyFunction init2 = ((PyClass)owner).findMethodByName("__init__", false, null);
            if (init2 != null) {
                PsiElement element = this.resolveParameter(init2);
                if (element == null && (this.myType.equals((Object)ReferenceType.CLASS_VARIABLE) || this.myType.equals((Object)ReferenceType.PARAMETER_TYPE))) {
                    element = this.resolveClassVariable((PyClass)owner);
                }
                if (element == null && (this.myType.equals((Object)ReferenceType.INSTANCE_VARIABLE) || this.myType.equals((Object)ReferenceType.PARAMETER_TYPE))) {
                    element = this.resolveInstanceVariable((PyClass)owner);
                }
                return element;
            }
            PsiElement element = null;
            if (this.myType.equals((Object)ReferenceType.CLASS_VARIABLE) || this.myType.equals((Object)ReferenceType.PARAMETER_TYPE)) {
                element = this.resolveClassVariable((PyClass)owner);
            }
            if (element == null && (this.myType.equals((Object)ReferenceType.INSTANCE_VARIABLE) || this.myType.equals((Object)ReferenceType.PARAMETER_TYPE))) {
                element = this.resolveInstanceVariable((PyClass)owner);
            }
            return element;
        }
        if (owner instanceof PyFile && this.myType == ReferenceType.GLOBAL_VARIABLE) {
            return this.resolveGlobalVariable((PyFile)owner);
        }
        return null;
    }

    @Nullable
    private PsiElement resolveGlobalVariable(@NotNull PyFile owner) {
        if (owner == null) {
            DocStringParameterReference.$$$reportNull$$$0(0);
        }
        for (PyTargetExpression assignment : owner.getTopLevelAttributes()) {
            if (!this.getCanonicalText().equals(assignment.getName())) continue;
            return assignment;
        }
        return null;
    }

    @Nullable
    private PsiElement resolveInstanceVariable(PyClass owner) {
        List<PyTargetExpression> attributes = owner.getInstanceAttributes();
        for (PyTargetExpression element : attributes) {
            if (!this.getCanonicalText().equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private PsiElement resolveClassVariable(@NotNull PyClass owner) {
        if (owner == null) {
            DocStringParameterReference.$$$reportNull$$$0(1);
        }
        List<PyTargetExpression> attributes = owner.getClassAttributes();
        for (PyTargetExpression element : attributes) {
            if (!this.getCanonicalText().equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private PsiElement resolveParameter(PyFunction owner) {
        PyParameterList parameterList = owner.getParameterList();
        PyNamedParameter resolved = parameterList.findParameterByName(this.getCanonicalText());
        if (resolved != null) {
            return resolved;
        }
        for (PyParameter parameter : parameterList.getParameters()) {
            PyNamedParameter namedParameter;
            if (!(parameter instanceof PyNamedParameter) || !(namedParameter = (PyNamedParameter)parameter).isKeywordContainer() && !namedParameter.isPositionalContainer()) continue;
            return namedParameter;
        }
        return null;
    }

    public Object @NotNull [] getVariants() {
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            DocStringParameterReference.$$$reportNull$$$0(2);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    public List<PyNamedParameter> collectParameterVariants() {
        PyDocStringOwner owner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PyDocStringOwner.class);
        if (owner instanceof PyFunction) {
            ArrayList result = Lists.newArrayList();
            List<PyNamedParameter> namedParameters = ParamHelper.collectNamedParameters(((PyFunction)owner).getParameterList());
            HashSet<String> usedParameters = new HashSet<String>();
            PyStringLiteralExpression expression = (PyStringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PyStringLiteralExpression.class, (boolean)false);
            if (expression != null) {
                PsiReference[] references2;
                for (PsiReference ref : references2 = expression.getReferences()) {
                    if (!(ref instanceof DocStringParameterReference) || !((DocStringParameterReference)ref).getType().equals((Object)this.myType)) continue;
                    usedParameters.add(ref.getCanonicalText());
                }
            }
            for (PyNamedParameter param : namedParameters) {
                if (usedParameters.contains(param.getName())) continue;
                result.add(param);
            }
            ArrayList arrayList = result;
            if (arrayList == null) {
                DocStringParameterReference.$$$reportNull$$$0(3);
            }
            return arrayList;
        }
        List<PyNamedParameter> list = Collections.emptyList();
        if (list == null) {
            DocStringParameterReference.$$$reportNull$$$0(4);
        }
        return list;
    }

    public ReferenceType getType() {
        return this.myType;
    }

    @Override
    @Nullable
    public HighlightSeverity getUnresolvedHighlightSeverity(TypeEvalContext context) {
        return HighlightSeverity.WEAK_WARNING;
    }

    @Override
    @Nullable
    public String getUnresolvedDescription() {
        PyDocStringOwner owner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PyDocStringOwner.class);
        if (owner instanceof PyFunction) {
            PyFunction function = (PyFunction)owner;
            return "Function '" + function.getName() + "' does not have a parameter '" + this.getCanonicalText() + "'";
        }
        return null;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        TextRange range;
        Pair<String, String> quotes;
        if (newElementName == null) {
            DocStringParameterReference.$$$reportNull$$$0(5);
        }
        if ((quotes = PyStringLiteralUtil.getQuotes((range = this.getRangeInElement()).substring(((PyStringLiteralExpression)this.myElement).getText()))) != null) {
            range = TextRange.create((int)(range.getStartOffset() + ((String)quotes.first).length()), (int)(range.getEndOffset() - ((String)quotes.second).length()));
        }
        String newName = range.replace(((PyStringLiteralExpression)this.myElement).getText(), newElementName);
        ((PyStringLiteralExpression)this.myElement).replace(PyElementGenerator.getInstance(((PyStringLiteralExpression)this.myElement).getProject()).createStringLiteralAlreadyEscaped(newName));
        return this.myElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/DocStringParameterReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/DocStringParameterReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectParameterVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveGlobalVariable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveClassVariable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ReferenceType {
        PARAMETER,
        PARAMETER_TYPE,
        KEYWORD,
        VARIABLE,
        CLASS_VARIABLE,
        INSTANCE_VARIABLE,
        GLOBAL_VARIABLE;

    }
}

