/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.StructuredDocString;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStructuredDocstringFormatter {
    private PyStructuredDocstringFormatter() {
    }

    @Nullable
    public static List<String> formatDocstring(@NotNull PsiElement element, @NotNull String docstring) {
        Module module;
        if (element == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(0);
        }
        if (docstring == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            Module[] modules = ModuleManager.getInstance((Project)element.getProject()).getModules();
            if (modules.length == 0) {
                return Lists.newArrayList();
            }
            module = modules[0];
        }
        if (module == null) {
            return Lists.newArrayList();
        }
        ArrayList<String> result = new ArrayList<String>();
        String preparedDocstring = PyIndentUtil.removeCommonIndent(docstring, true).trim();
        DocStringFormat format = DocStringUtil.guessDocStringFormat(preparedDocstring, element);
        if (format == DocStringFormat.PLAIN) {
            return null;
        }
        StructuredDocString structuredDocString = DocStringUtil.parseDocStringContent(format, preparedDocstring);
        String output = PythonRuntimeService.getInstance().formatDocstring(module, format, preparedDocstring);
        if (output != null) {
            result.add(output);
        } else {
            result.add(structuredDocString.getDescription());
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "docstring";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/documentation/PyStructuredDocstringFormatter";
        objectArray[2] = "formatDocstring";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

