/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.docker.remote;

import com.google.common.net.HostAndPort;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.remote.RemoteProcessControl;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.Tunnelable;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.debugger.PositionConverterProvider;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.remote.vfs.PyRemotePositionConverter;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.run.PythonProcessHandler;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B1\b\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB!\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u000f\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0014J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010$\u001a\u00020%H\u0016J\u001c\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00190'2\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010(\u001a\u00020\u0017H\u0016R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/python/docker/remote/PyDockerComposeProcessHandler;", "Lcom/jetbrains/python/run/PythonProcessHandler;", "Lcom/intellij/remote/RemoteProcessControl;", "Lcom/jetbrains/python/debugger/PositionConverterProvider;", "process", "Ljava/lang/Process;", "commandLine", "", "charset", "Ljava/nio/charset/Charset;", "pathMapper", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "remoteSocketProvider", "Lcom/jetbrains/python/remote/PyRemoteSocketToLocalHostProvider;", "(Ljava/lang/Process;Ljava/lang/String;Ljava/nio/charset/Charset;Lcom/jetbrains/python/remote/PyRemotePathMapper;Lcom/jetbrains/python/remote/PyRemoteSocketToLocalHostProvider;)V", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "(Lcom/intellij/execution/configurations/GeneralCommandLine;Lcom/jetbrains/python/remote/PyRemotePathMapper;Lcom/jetbrains/python/remote/PyRemoteSocketToLocalHostProvider;)V", "fileMappings", "", "Lcom/intellij/util/PathMappingSettings$PathMapping;", "isFirstKillProcessInvocation", "Ljava/util/concurrent/atomic/AtomicBoolean;", "addRemoteForwarding", "", "remotePort", "", "localPort", "createPositionConverter", "Lcom/jetbrains/python/debugger/PyPositionConverter;", "debugProcess", "Lcom/jetbrains/python/debugger/PyDebugProcess;", "destroyProcessGracefully", "", "getFileMappings", "getLocalTunnel", "Lcom/google/common/net/HostAndPort;", "getMappingSettings", "Lcom/intellij/util/PathMapper;", "getRemoteSocket", "Lcom/intellij/openapi/util/Pair;", "killProcess", "intellij.python.docker"})
public final class PyDockerComposeProcessHandler
extends PythonProcessHandler
implements RemoteProcessControl,
PositionConverterProvider {
    private final PyRemoteSocketToLocalHostProvider remoteSocketProvider;
    private final PyRemotePathMapper pathMapper;
    private final List<PathMappingSettings.PathMapping> fileMappings;
    private final AtomicBoolean isFirstKillProcessInvocation;

    @NotNull
    public PathMapper getMappingSettings() {
        return (PathMapper)this.pathMapper;
    }

    public void addRemoteForwarding(int remotePort, int localPort) {
        try {
            if (this.getProcess() instanceof Tunnelable) {
                Process process2 = this.getProcess();
                if (process2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.remote.Tunnelable");
                }
                ((Tunnelable)process2).addRemoteTunnel(remotePort, "localhost", localPort);
            }
        }
        catch (RemoteSdkException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    @NotNull
    public Pair<String, Integer> getRemoteSocket(int localPort) {
        Pair<String, Integer> pair = this.remoteSocketProvider.getRemoteSocket(localPort);
        Intrinsics.checkExpressionValueIsNotNull(pair, (String)"remoteSocketProvider.getRemoteSocket(localPort)");
        return pair;
    }

    @NotNull
    public HostAndPort getLocalTunnel(int remotePort) {
        HostAndPort hostAndPort = HostAndPort.fromParts((String)"localhost", (int)remotePort);
        Intrinsics.checkExpressionValueIsNotNull((Object)hostAndPort, (String)"HostAndPort.fromParts(\"localhost\", remotePort)");
        return hostAndPort;
    }

    @NotNull
    public List<PathMappingSettings.PathMapping> getFileMappings() {
        return this.fileMappings;
    }

    @Override
    @NotNull
    public PyPositionConverter createPositionConverter(@NotNull PyDebugProcess debugProcess) {
        Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
        return new PyRemotePositionConverter(debugProcess, this.pathMapper);
    }

    protected boolean destroyProcessGracefully() {
        if (SystemInfo.isWindows) {
            return super.destroyProcessGracefully();
        }
        if (SystemInfo.isUnix) {
            UnixProcessManager.sendSignal((int)UnixProcessManager.getProcessId((Process)this.getProcess()), (int)2);
            return true;
        }
        return false;
    }

    public void killProcess() {
        if (this.isFirstKillProcessInvocation.compareAndSet(true, false)) {
            this.destroyProcessGracefully();
        } else {
            super.killProcess();
        }
    }

    @Deprecated(message="Use another constructor")
    public PyDockerComposeProcessHandler(@NotNull Process process2, @NotNull String commandLine, @NotNull Charset charset, @Nullable PyRemotePathMapper pathMapper, @NotNull PyRemoteSocketToLocalHostProvider remoteSocketProvider) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        Intrinsics.checkParameterIsNotNull((Object)remoteSocketProvider, (String)"remoteSocketProvider");
        super(process2, commandLine, charset);
        PyDockerComposeProcessHandler pyDockerComposeProcessHandler = this;
        boolean bl = false;
        pyDockerComposeProcessHandler.fileMappings = list = (List)new ArrayList();
        this.isFirstKillProcessInvocation = new AtomicBoolean(true);
        this.remoteSocketProvider = remoteSocketProvider;
        PyRemotePathMapper pyRemotePathMapper = pathMapper;
        if (pyRemotePathMapper == null) {
            pyRemotePathMapper = new PyRemotePathMapper();
        }
        this.pathMapper = pyRemotePathMapper;
    }

    public PyDockerComposeProcessHandler(@NotNull GeneralCommandLine commandLine, @Nullable PyRemotePathMapper pathMapper, @NotNull PyRemoteSocketToLocalHostProvider remoteSocketProvider) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Intrinsics.checkParameterIsNotNull((Object)remoteSocketProvider, (String)"remoteSocketProvider");
        super(commandLine, true);
        PyDockerComposeProcessHandler pyDockerComposeProcessHandler = this;
        boolean bl = false;
        pyDockerComposeProcessHandler.fileMappings = list = (List)new ArrayList();
        this.isFirstKillProcessInvocation = new AtomicBoolean(true);
        this.remoteSocketProvider = remoteSocketProvider;
        PyRemotePathMapper pyRemotePathMapper = pathMapper;
        if (pyRemotePathMapper == null) {
            pyRemotePathMapper = new PyRemotePathMapper();
        }
        this.pathMapper = pyRemotePathMapper;
    }
}

