/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.python.debugger.PyDebugSupportUtils;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySourcePosition;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyLocalPositionConverter
implements PyPositionConverter {
    private static final String[] EGG_EXTENSIONS = new String[]{".egg", ".zip"};

    @Override
    @NotNull
    public PySourcePosition create(@NotNull String file2, int line2) {
        if (file2 == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(0);
        }
        PySourcePosition pySourcePosition = this.convertPythonToFrame(file2, line2);
        if (pySourcePosition == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(1);
        }
        return pySourcePosition;
    }

    @Override
    @NotNull
    public PySourcePosition convertPythonToFrame(@NotNull String filePath, int line2) {
        File file2;
        if (filePath == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(2);
        }
        if ((file2 = new File(filePath)).exists()) {
            return new PyLocalSourcePosition(file2.getPath(), line2);
        }
        return new PyRemoteSourcePosition(filePath, line2);
    }

    @Override
    @NotNull
    public PySourcePosition convertFrameToPython(@NotNull PySourcePosition position) {
        if (position == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(3);
        }
        PySourcePosition pySourcePosition = position;
        if (pySourcePosition == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(4);
        }
        return pySourcePosition;
    }

    @Override
    @NotNull
    public PySourcePosition convertToPython(@NotNull XSourcePosition position) {
        if (position == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(5);
        }
        PySourcePosition pySourcePosition = this.convertToPython(PyLocalPositionConverter.convertFilePath(position.getFile().getPath()), PyLocalPositionConverter.convertLocalLineToRemote(position.getFile(), position.getLine()));
        if (pySourcePosition == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(6);
        }
        return pySourcePosition;
    }

    @NotNull
    protected PySourcePosition convertToPython(@NotNull String filePath, int line2) {
        if (filePath == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(7);
        }
        return new PyLocalSourcePosition(filePath, line2);
    }

    protected static int convertLocalLineToRemote(VirtualFile file2, int l) {
        return (Integer)ReadAction.compute(() -> {
            int line2 = l;
            Document document = FileDocumentManager.getInstance().getDocument(file2);
            if (document != null) {
                while (PyDebugSupportUtils.isContinuationLine(document, line2)) {
                    ++line2;
                }
            }
            return line2 + 1;
        });
    }

    @Override
    @Nullable
    public XSourcePosition convertFromPython(@NotNull PySourcePosition position, String frameName) {
        if (position == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(8);
        }
        return PyLocalPositionConverter.createXSourcePosition(this.getVirtualFile(position.getFile()), position.getLine());
    }

    @Override
    public PySignature convertSignature(PySignature signature) {
        return signature;
    }

    public VirtualFile getVirtualFile(String path) {
        VirtualFile vFile = this.getLocalFileSystem().findFileByPath(path);
        if (vFile == null) {
            vFile = this.findEggEntry(path);
        }
        return vFile;
    }

    protected VirtualFileSystem getLocalFileSystem() {
        return LocalFileSystem.getInstance();
    }

    private VirtualFile findEggEntry(String file2) {
        String ext;
        int ind = -1;
        String[] stringArray = EGG_EXTENSIONS;
        int n = stringArray.length;
        for (int i = 0; i < n && (ind = file2.indexOf(ext = stringArray[i])) == -1; ++i) {
        }
        if (ind != -1) {
            String jarPath = file2.substring(0, ind + 4);
            VirtualFile jarFile = this.getLocalFileSystem().findFileByPath(jarPath);
            if (jarFile != null) {
                String innerPath = file2.substring(ind + 4);
                VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(jarFile);
                if (jarRoot != null) {
                    return jarRoot.findFileByRelativePath(innerPath);
                }
            }
        }
        return null;
    }

    private static String convertFilePath(String file2) {
        String ext;
        int ind = -1;
        String[] stringArray = EGG_EXTENSIONS;
        int n = stringArray.length;
        for (int i = 0; i < n && (ind = file2.indexOf((ext = stringArray[i]) + "!")) == -1; ++i) {
        }
        if (ind != -1) {
            return file2.substring(0, ind + 4) + file2.substring(ind + 5);
        }
        return file2;
    }

    private static String winNormCase(String file2) {
        String ext;
        int ind = -1;
        String[] stringArray = EGG_EXTENSIONS;
        int n = stringArray.length;
        for (int i = 0; i < n && (ind = file2.indexOf(ext = stringArray[i])) == -1; ++i) {
        }
        if (ind != -1) {
            return StringUtil.toLowerCase((String)file2.substring(0, ind + 4)) + file2.substring(ind + 4);
        }
        return StringUtil.toLowerCase((String)file2);
    }

    @Nullable
    public static XSourcePosition createXSourcePosition(@Nullable VirtualFile vFile, int line2) {
        if (vFile != null) {
            return XDebuggerUtil.getInstance().createPosition(vFile, PyLocalPositionConverter.convertRemoteLineToLocal(vFile, line2));
        }
        return null;
    }

    private static int convertRemoteLineToLocal(VirtualFile vFile, int line2) {
        Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(vFile));
        --line2;
        if (document != null) {
            while (PyDebugSupportUtils.isContinuationLine(document, line2 - 1)) {
                --line2;
            }
        }
        return line2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyLocalPositionConverter";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyLocalPositionConverter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFrameToPython";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToPython";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertPythonToFrame";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertFrameToPython";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertToPython";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "convertFromPython";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class PyRemoteSourcePosition
    extends PySourcePosition {
        public PyRemoteSourcePosition(String file2, int line2) {
            super(file2, line2);
        }

        @Override
        protected String normalize(@Nullable String file2) {
            if (file2 == null) {
                return null;
            }
            if (SystemInfo.isWindows && PyRemoteSourcePosition.isWindowsPath(file2)) {
                file2 = PyLocalPositionConverter.winNormCase(file2);
            }
            return super.normalize(file2);
        }
    }

    protected static class PyLocalSourcePosition
    extends PySourcePosition {
        public PyLocalSourcePosition(String file2, int line2) {
            super(file2, line2);
        }

        @Override
        protected String normalize(@Nullable String file2) {
            if (file2 == null) {
                return null;
            }
            if (SystemInfo.isWindows) {
                file2 = PyLocalPositionConverter.winNormCase(file2);
            }
            return super.normalize(file2);
        }
    }
}

