/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.ui.SdkPathEditor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ListUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonPathEditor
extends SdkPathEditor {
    private final PathListModel myPathListModel;

    public PythonPathEditor(String displayName, @NotNull OrderRootType orderRootType, FileChooserDescriptor descriptor2) {
        if (orderRootType == null) {
            PythonPathEditor.$$$reportNull$$$0(0);
        }
        super(displayName, orderRootType, descriptor2);
        this.myPathListModel = new PathListModel(orderRootType, this.getListModel());
    }

    public void reset(@Nullable SdkModificator modificator) {
        if (modificator != null) {
            ArrayList list = Lists.newArrayList((Object[])modificator.getRoots(this.getOrderRootType()));
            this.resetPath(this.myPathListModel.reset(list, modificator));
        } else {
            this.setEnabled(false);
        }
    }

    public void reload(@Nullable SdkModificator sdkModificator) {
        if (sdkModificator != null) {
            ArrayList list = Lists.newArrayList((Object[])sdkModificator.getRoots(this.getOrderRootType()));
            this.resetPath(this.myPathListModel.reload(list));
            this.setModified(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void apply(SdkModificator sdkModificator) {
        sdkModificator.removeRoots(this.getOrderRootType());
        for (int i = 0; i < this.myPathListModel.getRowCount(); ++i) {
            VirtualFile path = this.myPathListModel.getValueAt(i);
            if (this.myPathListModel.isExcluded(path)) continue;
            sdkModificator.addRoot(path, this.getOrderRootType());
        }
        this.setModified(false);
        this.myPathListModel.apply(sdkModificator);
    }

    protected VirtualFile[] adjustAddedFileSet(Component component, VirtualFile[] files) {
        int filesLength = files.length;
        for (int i = 0; i < filesLength; ++i) {
            if (files[i].isDirectory() || !FileTypeRegistry.getInstance().isFileOfType(files[i], (FileType)ArchiveFileType.INSTANCE)) continue;
            files[i] = JarFileSystem.getInstance().getJarRootForLocalFile(files[i]);
        }
        if (this.myPathListModel.add(Lists.newArrayList((Object[])files))) {
            this.setModified(true);
        }
        return files;
    }

    protected void doRemoveItems(int[] indices, JList<VirtualFile> list) {
        ArrayList removed = Lists.newArrayList();
        for (int i : indices) {
            removed.add(Pair.create(this.getListModel().get(i), (Object)i));
        }
        ListUtil.removeIndices(list, (int[])this.myPathListModel.remove(removed));
        list.updateUI();
        this.setModified(true);
    }

    protected ListCellRenderer<VirtualFile> createListCellRenderer(JBList<VirtualFile> list) {
        return SimpleListCellRenderer.create((String)"", value2 -> {
            String suffix = this.myPathListModel.getPresentationSuffix((VirtualFile)value2);
            if (suffix.length() > 0) {
                suffix = "  " + suffix;
            }
            return this.getPresentablePath((VirtualFile)value2) + suffix;
        });
    }

    protected void addToolbarButtons(ToolbarDecorator toolbarDecorator) {
        toolbarDecorator.addExtraAction(new AnActionButton(PyBundle.message("sdk.paths.dialog.reload.paths", new Object[0]), AllIcons.Actions.Refresh){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                PythonPathEditor.this.onReloadButtonClicked();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/configuration/PythonPathEditor$1", "actionPerformed"));
            }
        });
    }

    protected void onReloadButtonClicked() {
    }

    protected String getPresentablePath(VirtualFile value2) {
        return value2.getPresentableUrl();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderRootType", "com/jetbrains/python/configuration/PythonPathEditor", "<init>"));
    }

    private static class PathListModel {
        private Set<VirtualFile> myAdded = Sets.newHashSet();
        private Set<VirtualFile> myExcluded = Sets.newHashSet();
        private final Set<VirtualFile> myFoundFiles = Sets.newHashSet();
        private final List<VirtualFile> myFilteredOut = Lists.newArrayList();
        private final DefaultListModel<VirtualFile> myListModel;
        private final OrderRootType myOrderRootType;
        private final Set<VirtualFile> myUserAddedToRemove = Sets.newHashSet();

        PathListModel(OrderRootType orderRootType, DefaultListModel<VirtualFile> listModel) {
            this.myOrderRootType = orderRootType;
            this.myListModel = listModel;
        }

        private int getRowCount() {
            return this.myListModel.getSize();
        }

        private VirtualFile getValueAt(int row) {
            return this.myListModel.get(row);
        }

        public boolean add(List<VirtualFile> files) {
            for (VirtualFile file2 : files) {
                if (!this.myFoundFiles.contains(file2)) {
                    if (!this.myExcluded.remove(file2)) {
                        this.myAdded.add(file2);
                        this.myUserAddedToRemove.remove(file2);
                        continue;
                    }
                    this.myFoundFiles.add(file2);
                    return true;
                }
                this.myExcluded.remove(file2);
            }
            return false;
        }

        public int[] remove(List<Pair<VirtualFile, Integer>> files) {
            ArrayList toRemove = Lists.newArrayList();
            for (Pair<VirtualFile, Integer> e : files) {
                if (this.myAdded.contains(e.first)) {
                    toRemove.add(e.second);
                    this.myAdded.remove(e.first);
                    this.myUserAddedToRemove.add((VirtualFile)e.first);
                    continue;
                }
                if (this.myExcluded.contains(e.first)) {
                    this.myExcluded.remove(e.first);
                    continue;
                }
                this.myExcluded.add((VirtualFile)e.first);
            }
            return ArrayUtil.toIntArray((Collection)toRemove);
        }

        public void apply(SdkModificator sdkModificator) {
            sdkModificator.setSdkAdditionalData(this.collectSdkAdditionalData(sdkModificator));
            this.addFilteredOutRoots(sdkModificator);
        }

        private void addFilteredOutRoots(SdkModificator sdkModificator) {
            for (VirtualFile file2 : this.myFilteredOut) {
                sdkModificator.addRoot(file2, this.myOrderRootType);
            }
        }

        private SdkAdditionalData collectSdkAdditionalData(SdkModificator sdkModificator) {
            PythonSdkAdditionalData data = (PythonSdkAdditionalData)sdkModificator.getSdkAdditionalData();
            if (data == null) {
                data = new PythonSdkAdditionalData(null);
            }
            data.setAddedPathsFromVirtualFiles(this.myAdded);
            data.setExcludedPathsFromVirtualFiles(this.myExcluded);
            return data;
        }

        public void setAdded(Set<VirtualFile> added) {
            this.myAdded = Sets.newHashSet(added);
        }

        public void setExcluded(Set<VirtualFile> excluded) {
            this.myExcluded = Sets.newHashSet(excluded);
        }

        public String getPresentationSuffix(VirtualFile file2) {
            if (this.myAdded.contains(file2)) {
                return PyBundle.message("sdk.paths.dialog.added.by.user.suffix", new Object[0]);
            }
            if (this.myExcluded.contains(file2)) {
                return PyBundle.message("sdk.paths.dialog.removed.by.user.suffix", new Object[0]);
            }
            return "";
        }

        public List<VirtualFile> reload(List<VirtualFile> list) {
            this.myFoundFiles.clear();
            this.myFoundFiles.addAll(list);
            List<VirtualFile> result = PathListModel.filterOutStubs(list, this.myFilteredOut);
            result.removeAll(this.myUserAddedToRemove);
            result.addAll(this.myAdded);
            return result;
        }

        public List<VirtualFile> reset(List<VirtualFile> list, SdkModificator modificator) {
            this.myFilteredOut.clear();
            List<VirtualFile> result = PathListModel.filterOutStubs(list, this.myFilteredOut);
            this.myFoundFiles.clear();
            this.myFoundFiles.addAll(list);
            this.myUserAddedToRemove.clear();
            if (modificator.getSdkAdditionalData() instanceof PythonSdkAdditionalData) {
                PythonSdkAdditionalData data = (PythonSdkAdditionalData)modificator.getSdkAdditionalData();
                this.setAdded(data.getAddedPathFiles());
                this.setExcluded(data.getExcludedPathFiles());
                result.addAll(this.myExcluded);
                result.addAll(this.myAdded);
            } else if (modificator.getSdkAdditionalData() == null) {
                this.myAdded.clear();
                this.myExcluded.clear();
            }
            return result;
        }

        private static List<VirtualFile> filterOutStubs(List<VirtualFile> list, List<VirtualFile> filteredOut) {
            ArrayList result = Lists.newArrayList();
            filteredOut.clear();
            for (VirtualFile file2 : list) {
                if (!PathListModel.isStubPath(file2)) {
                    result.add(file2);
                    continue;
                }
                filteredOut.add(file2);
            }
            return result;
        }

        private static boolean isStubPath(@NotNull VirtualFile file2) {
            if (file2 == null) {
                PathListModel.$$$reportNull$$$0(0);
            }
            String path = PythonSdkUtil.getSkeletonsRootPath(PathManager.getSystemPath());
            VirtualFile skeletonRoot = LocalFileSystem.getInstance().findFileByPath(path);
            if (skeletonRoot != null && file2.getPath().startsWith(skeletonRoot.getPath())) {
                return true;
            }
            if (file2.equals(PyUserSkeletonsUtil.getUserSkeletonsDirectory())) {
                return true;
            }
            return PyTypeShed.INSTANCE.isInside(file2);
        }

        public boolean isExcluded(VirtualFile path) {
            return this.myExcluded.contains(path);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/configuration/PythonPathEditor$PathListModel", "isStubPath"));
        }
    }
}

