/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pyramid.project;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.pyramid.run.PyramidRunConfiguration;
import com.jetbrains.pyramid.run.PyramidRunConfigurationType;
import com.jetbrains.python.run.PyRunConfigurationFactory;
import com.jetbrains.python.run.PyRunConfigurationFactoryEx;
import com.jetbrains.python.run.targetBasedConfiguration.PyRunTargetVariant;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.testing.PyUnitTestConfiguration;
import com.jetbrains.python.testing.PyUnitTestFactory;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class PyramidUtils {
    private PyramidUtils() {
    }

    public static boolean isPyramidProject(@NotNull PsiElement element) {
        Sdk sdk;
        if (element == null) {
            PyramidUtils.$$$reportNull$$$0(0);
        }
        if ((sdk = PythonSdkUtil.findPythonSdk(element)) == null) {
            return false;
        }
        VirtualFile baseDir = element.getProject().getBaseDir();
        if (baseDir == null) {
            return false;
        }
        VirtualFile app = baseDir.findChild(StringUtil.toLowerCase((String)baseDir.getName()));
        VirtualFile setup = baseDir.findChild("setup.py");
        VirtualFile developmentIni = baseDir.findChild("development.ini");
        if (app != null && setup != null && developmentIni != null) {
            VirtualFile aStatic = app.findChild("static");
            VirtualFile templates = app.findChild("templates");
            VirtualFile viewsFile = app.findChild("views.py");
            VirtualFile viewsDir = app.findChild("views");
            if (aStatic != null && templates != null && (viewsFile != null || viewsDir != null)) {
                return true;
            }
        }
        return false;
    }

    public static void createRunConfigurations(Module module, VirtualFile baseDir) {
        PyUnitTestFactory testFactory = new PyUnitTestFactory();
        Project project = module.getProject();
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings testSettings = runManager.createConfiguration(module.getName(), (ConfigurationFactory)testFactory);
        PyUnitTestConfiguration testConfiguration = (PyUnitTestConfiguration)testSettings.getConfiguration();
        testConfiguration.setName("Tests in setup.py");
        testConfiguration.getTarget().setTargetType(PyRunTargetVariant.PATH);
        testConfiguration.getTarget().setTarget(FileUtil.toSystemDependentName((String)baseDir.getPath()) + File.separator + "setup.py");
        testConfiguration.setWorkingDirectory(baseDir.getPath());
        testConfiguration.setUseModuleSdk(true);
        testConfiguration.setModule(module);
        runManager.addConfiguration(testSettings);
        PyramidRunConfigurationType.PyramidRunConfigurationFactory factory = PyramidRunConfigurationType.getInstance().PYRAMID_FACTORY;
        RunnerAndConfigurationSettings runSettings = ((PyRunConfigurationFactoryEx)PyRunConfigurationFactory.getInstance()).createRunConfiguration(module, factory);
        PyramidRunConfiguration runConfiguration = (PyramidRunConfiguration)runSettings.getConfiguration();
        runConfiguration.setConfFile(FileUtil.toSystemDependentName((String)baseDir.getPath()) + File.separator + "development.ini");
        runConfiguration.setWorkingDirectory(baseDir.getPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/pyramid/project/PyramidUtils", "isPyramidProject"));
    }
}

