/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pyramid.project;

import com.intellij.DynamicBundle;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.pyramid.project.PyramidNewProjectSettings;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PyramidProjectCreatePanel
extends JPanel {
    private JPanel myMainPanel;
    private JBTextField myProjectNameField;
    private ComboBox<String> myTemplateChooser;
    private ComboBox<String> myBackendChooser;
    private String myBaseDir;

    public PyramidProjectCreatePanel(@NonNls @NotNull String baseDir) {
        if (baseDir == null) {
            PyramidProjectCreatePanel.$$$reportNull$$$0(0);
        }
        super(true);
        this.myBaseDir = baseDir;
        this.$$$setupUI$$$();
        this.myProjectNameField.setText(this.myBaseDir);
        DefaultComboBoxModel<String> templateModel = new DefaultComboBoxModel<String>(new String[]{"Jinja2", "Chameleon", "Mako"});
        DefaultComboBoxModel<String> backendModel = new DefaultComboBoxModel<String>(new String[]{"None", "SQLAlchemy", "ZODB"});
        this.myTemplateChooser.setModel(templateModel);
        this.myBackendChooser.setModel(backendModel);
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public void saveSettings(PyramidNewProjectSettings settings) {
        settings.setProjectName(this.myProjectNameField.getText());
        settings.setBackend(this.myBackendChooser.getSelectedItem().toString());
        settings.setTemplateLanguage(this.myTemplateChooser.getSelectedItem().toString());
        settings.setTemplatesFolder(this.myBaseDir + File.separator + "templates");
    }

    @NotNull
    public String getTemplateLanguage() {
        String string = this.myTemplateChooser.getSelectedItem().toString();
        if (string == null) {
            PyramidProjectCreatePanel.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void locationChanged(String newLocation) {
        this.myBaseDir = newLocation;
        this.myProjectNameField.setText(newLocation);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        ComboBox comboBox2;
        JBTextField jBTextField;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myProjectNameField = jBTextField = new JBTextField();
        jPanel.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PythonProBundle", PyramidProjectCreatePanel.class).getString("pyramid.new.project.dialog.project.name"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTemplateChooser = comboBox2 = new ComboBox();
        jPanel.add((Component)comboBox2, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/PythonProBundle", PyramidProjectCreatePanel.class).getString("pyramid.new.project.dialog.template.language"));
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBackendChooser = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/PythonProBundle", PyramidProjectCreatePanel.class).getString("pyramid.new.project.dialog.backend"));
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor((Component)jBTextField);
        jBLabel2.setLabelFor((Component)comboBox2);
        jBLabel3.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/pyramid/project/PyramidProjectCreatePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/pyramid/project/PyramidProjectCreatePanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

