/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.util;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.django.lang.template.psi.impl.DjangoTemplateFileImpl;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.search.PySearchUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoPythonUtil {
    @Nullable
    public static String getCallName(PyCallExpression call) {
        PyExpression callee;
        if (call != null && (callee = call.getCallee()) != null) {
            return callee.getName();
        }
        return null;
    }

    @Nullable
    public static VirtualFile findLibraryFile(String path, Sdk sdk) {
        if (sdk == null) {
            return null;
        }
        RootProvider rootProvider = sdk.getRootProvider();
        for (VirtualFile root : rootProvider.getFiles(OrderRootType.CLASSES)) {
            VirtualFile result = root.findFileByRelativePath(path);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public static String toFilePath(String packageName) {
        return packageName != null ? packageName.replace(".", "/") + ".py" : null;
    }

    @Nullable
    public static String toFolderPath(String packageName) {
        return packageName != null ? packageName.replace(".", "/") : null;
    }

    public static boolean isVariable(PyExpression expr, String name) {
        return expr.getText().equals(name);
    }

    public static boolean isKeyAccess(PyExpression expr, String name) {
        if (expr instanceof PySubscriptionExpression) {
            PsiElement[] children2 = expr.getChildren();
            PyExpression child = children2.length > 0 && children2[0] instanceof PyExpression ? (PyExpression)children2[0] : null;
            return DjangoPythonUtil.isVariable(child, name);
        }
        return false;
    }

    @Nullable
    public static PyStringLiteralExpression getKey(PyExpression expr) {
        PsiElement[] children2;
        if (expr instanceof PySubscriptionExpression && (children2 = expr.getChildren()).length >= 2 && children2[1] instanceof PyStringLiteralExpression) {
            return (PyStringLiteralExpression)children2[1];
        }
        return null;
    }

    @NotNull
    public static Set<LookupElement> getKeys(PyDictLiteralExpression dictLiteral) {
        PyKeyValueExpression[] elems = dictLiteral.getElements();
        HashSet result = Sets.newHashSet();
        for (PyKeyValueExpression keyValue : elems) {
            PyExpression key = keyValue.getKey();
            if (!(key instanceof PyStringLiteralExpression)) continue;
            result.add(LookupElementBuilder.createWithSmartPointer((String)((PyStringLiteralExpression)key).getStringValue(), (PsiElement)key).withIcon(AllIcons.Nodes.Variable));
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            DjangoPythonUtil.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    public static List<Pair<PyExpression, PyExpression>> getTargetsToValuesMapping(PyAssignmentStatement assign) {
        PsiElement[] children2 = assign.getChildren();
        if (children2.length >= 2 && children2[0] instanceof PyExpression && children2[1] instanceof PyExpression) {
            return Collections.singletonList(Pair.create((Object)((PyExpression)children2[0]), (Object)((PyExpression)children2[1])));
        }
        return Collections.emptyList();
    }

    public static String computeElementNameForStringSearch(@NotNull PsiElement element) {
        if (element == null) {
            DjangoPythonUtil.$$$reportNull$$$0(1);
        }
        return (String)ReadAction.compute(() -> {
            if (element instanceof DjangoTemplateFileImpl) {
                return ((DjangoTemplateFileImpl)element).getName();
            }
            return PySearchUtil.computeElementNameForStringSearch(element);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/util/DjangoPythonUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/util/DjangoPythonUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "computeElementNameForStringSearch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

