/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.ref;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.jetbrains.django.ref.ViewParameters;
import com.jetbrains.python.BaseReference;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.psi.PsiReferenceEx;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewMethodReference
extends BaseReference
implements PsiReferenceEx {
    public ViewMethodReference(@NotNull PsiElement element) {
        if (element == null) {
            ViewMethodReference.$$$reportNull$$$0(0);
        }
        super(element);
    }

    public PsiElement resolve() {
        ViewParameters params = ViewParameters.fromElement(this.myElement);
        return ViewMethodReference.findFunction(params);
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            ViewMethodReference.$$$reportNull$$$0(1);
        }
        if (element instanceof PyFunction || element instanceof PyTargetExpression) {
            if (!this.getFunctionName().equals(((PsiNamedElement)element).getName())) {
                return false;
            }
            return this.resolve() == element;
        }
        return false;
    }

    @Override
    public HighlightSeverity getUnresolvedHighlightSeverity(TypeEvalContext context) {
        return HighlightSeverity.WEAK_WARNING;
    }

    @Override
    public String getUnresolvedDescription() {
        ViewParameters params = ViewParameters.fromElement(this.myElement);
        return "Can't resolve view method '" + params.getFullPath() + "'";
    }

    @Nullable
    private static PsiElement findFunction(ViewParameters parameters) {
        PyFile viewsFile = parameters.getViewsFile();
        if (viewsFile != null) {
            String name = parameters.getMethodName();
            PyFunction viewMethod = viewsFile.findTopLevelFunction(name);
            if (viewMethod != null) {
                return viewMethod;
            }
            return viewsFile.findTopLevelAttribute(name);
        }
        return null;
    }

    private String getFunctionName() {
        String text2 = this.myElement.getText();
        if (text2.contains(".")) {
            return text2.substring(text2.lastIndexOf(".") + 1);
        }
        return text2;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = PyStringLiteralUtil.getTextRange(this.myElement);
        if (textRange == null) {
            ViewMethodReference.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        if (this.myElement instanceof PyStringLiteralExpression) {
            String string = ((PyStringLiteralExpression)this.myElement).getStringValue();
            if (string == null) {
                ViewMethodReference.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = this.myElement.getText();
        if (string == null) {
            ViewMethodReference.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) {
        if (newElementName == null) {
            ViewMethodReference.$$$reportNull$$$0(5);
        }
        String fullName = PythonStringUtil.replaceLastSuffix(this.myElement.getText(), ".", newElementName);
        return this.myElement.replace((PsiElement)PyElementGenerator.getInstance(this.myElement.getProject()).createStringLiteralAlreadyEscaped(fullName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/ref/ViewMethodReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/ref/ViewMethodReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

