/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.ref;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.impl.VariableNode;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.django.codeInsight.DjangoTemplateVariablesMigrateProcessor;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.lang.template.psi.impl.DjangoTemplateFileImpl;
import com.jetbrains.django.model.DjangoTemplateManager;
import com.jetbrains.django.model.TemplateParametersEvaluator;
import com.jetbrains.django.ref.ViewMethodReferenceProvider;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoClassViewMigrationIntention
implements IntentionAction {
    public static final String INTENTION_NAME = "Convert function-based generic view to class-based.";
    private static final Map<String, String> FUNC_TO_CLASS = Maps.newHashMap();
    private static final String EXTRA__CONTEXT = "extra_context";
    private static final String MIMETYPE = "mimetype";
    private static final String CONTEXT__PROCESSORS = "context_processors";
    private static final String OBJECT_LIST = "django.views.generic.list_detail.object_list";
    private static final String TEMPLATE = "template";
    private static final Set<String> REMOVED_ARGS;

    private static void putFun(String funcBasedName, String classBasedName) {
        FUNC_TO_CLASS.put(funcBasedName, classBasedName);
        int ind = funcBasedName.lastIndexOf(".");
        if (ind >= 0) {
            FUNC_TO_CLASS.put(funcBasedName.substring(ind + 1), classBasedName);
        }
    }

    @NotNull
    public String getText() {
        return INTENTION_NAME;
    }

    @NotNull
    public String getFamilyName() {
        return INTENTION_NAME;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file2) {
        if (project == null) {
            DjangoClassViewMigrationIntention.$$$reportNull$$$0(0);
        }
        IntentionState state2 = DjangoClassViewMigrationIntention.getIntentionState(editor2, file2);
        return state2.isAvailable();
    }

    @NotNull
    public static IntentionState getIntentionState(Editor editor2, PsiFile file2) {
        IntentionState state2 = new IntentionState();
        if (file2 == null || !DjangoFacet.isPresent((PsiElement)file2)) {
            IntentionState intentionState = state2;
            if (intentionState == null) {
                DjangoClassViewMigrationIntention.$$$reportNull$$$0(1);
            }
            return intentionState;
        }
        PsiElement element = file2.findElementAt(editor2.getCaretModel().getOffset());
        PyCallExpression call = DjangoPsiUtil.getPatternCall(element);
        if (call == null) {
            IntentionState intentionState = state2;
            if (intentionState == null) {
                DjangoClassViewMigrationIntention.$$$reportNull$$$0(2);
            }
            return intentionState;
        }
        if (!(call.getParent() instanceof PyAssignmentStatement) && !(call.getParent() instanceof PyAugAssignmentStatement)) {
            IntentionState intentionState = state2;
            if (intentionState == null) {
                DjangoClassViewMigrationIntention.$$$reportNull$$$0(3);
            }
            return intentionState;
        }
        state2.myUrlsPatternAssignment = (PyStatement)call.getParent();
        state2.myFuncFullViewName = DjangoClassViewMigrationIntention.getGenericViewMethodName(element);
        if (state2.myFuncFullViewName != null) {
            state2.myFullClassName = FUNC_TO_CLASS.get(state2.myFuncFullViewName);
            state2.myFuncViewName = PythonStringUtil.getLastSuffix(state2.myFuncFullViewName, ".");
            state2.myAvailable = state2.myFullClassName != null && DjangoClassViewMigrationIntention.canFindClass(state2.myFullClassName, element);
            state2.myElement = PsiTreeUtil.getParentOfType((PsiElement)element, PyExpression.class);
        }
        IntentionState intentionState = state2;
        if (intentionState == null) {
            DjangoClassViewMigrationIntention.$$$reportNull$$$0(4);
        }
        return intentionState;
    }

    @Nullable
    private static String getGenericViewMethodName(PsiElement element) {
        PyStringLiteralExpression strLiteral = (PyStringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyStringLiteralExpression.class);
        if (strLiteral != null) {
            return ViewMethodReferenceProvider.getFullPath(strLiteral);
        }
        PyReferenceExpression refExpr = (PyReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyReferenceExpression.class);
        if (refExpr != null) {
            PsiReference[] refs;
            for (PsiReference ref : refs = refExpr.getReferences()) {
                PsiElement el = ref.resolve();
                if (!(el instanceof PyFunction)) continue;
                return DjangoClassViewMigrationIntention.getFullFunctionName((PyFunction)el);
            }
        }
        return element.getText();
    }

    @Nullable
    private static String getFullFunctionName(PyFunction function) {
        if (!PyUtil.isTopLevel(function)) {
            return null;
        }
        String importableName = QualifiedNameFinder.findShortestImportableName(function, function.getContainingFile().getVirtualFile());
        return importableName + "." + function.getName();
    }

    private static boolean canFindClass(String classFullName, PsiElement foot) {
        PsiFile file2 = DjangoUtil.searchProjectFile(PythonStringUtil.removeLastSuffix(classFullName, "."), foot);
        if (file2 instanceof PyFile) {
            return ((PyFile)file2).findTopLevelClass(DjangoClassViewMigrationIntention.getClassName(classFullName)) != null;
        }
        return false;
    }

    public void invoke(final @NotNull Project project, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        IntentionState state2;
        if (project == null) {
            DjangoClassViewMigrationIntention.$$$reportNull$$$0(5);
        }
        if (!(state2 = DjangoClassViewMigrationIntention.getIntentionState(editor2, file2)).isAvailable()) {
            return;
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        final Map<String, PyExpression> argValues = DjangoClassViewMigrationIntention.getArgValues(state2.myElement);
        LanguageLevel level = LanguageLevel.forElement((PsiElement)file2);
        String className = DjangoClassViewMigrationIntention.getClassName(state2.myFullClassName);
        PyExpression expr = elementGenerator.createExpressionFromText(level, className + ".as_view" + DjangoClassViewMigrationIntention.argumentsToString(className, argValues));
        DjangoClassViewMigrationIntention.removeArgumentDict(state2.myElement);
        expr = (PyExpression)state2.myElement.replace((PsiElement)expr);
        DjangoClassViewMigrationIntention.addImport(file2, state2.myFullClassName);
        if (DjangoClassViewMigrationIntention.shouldCreateSubClass(argValues)) {
            DjangoClassViewMigrationIntention.createSubClass(file2, expr, state2.myUrlsPatternAssignment, argValues);
            TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor2);
            if (templateState != null) {
                templateState.addTemplateStateListener((TemplateEditingListener)new TemplateEditingAdapter(){

                    public void templateFinished(@NotNull Template template, boolean brokenOff) {
                        if (template == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.doRenameVariables();
                    }

                    public void templateCancelled(Template template) {
                        this.doRenameVariables();
                    }

                    private void doRenameVariables() {
                        DjangoClassViewMigrationIntention.renameVariablesInTemplate(project, state2, argValues);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", DjangoClassViewMigrationIntention.TEMPLATE, "com/jetbrains/django/ref/DjangoClassViewMigrationIntention$1", "templateFinished"));
                    }
                });
            }
        } else {
            project.getMessageBus().connect().subscribe(CommandListener.TOPIC, (Object)new MyCommandListener(project, state2, argValues));
        }
    }

    private static void renameVariablesInTemplate(@NotNull Project project, IntentionState state2, Map<String, PyExpression> argValues) {
        if (project == null) {
            DjangoClassViewMigrationIntention.$$$reportNull$$$0(6);
        }
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> DjangoClassViewMigrationIntention.doRenameVariablesInTemplate(project, state2, argValues)), "", null);
    }

    private static void doRenameVariablesInTemplate(@NotNull Project project, IntentionState state2, Map<String, PyExpression> argValues) {
        if (project == null) {
            DjangoClassViewMigrationIntention.$$$reportNull$$$0(7);
        }
        if (DjangoClassViewMigrationIntention.shouldRenameVariablesInTemplate(state2.myFuncFullViewName, argValues)) {
            PsiFile templateFile;
            String name = DjangoClassViewMigrationIntention.getTemplateName(argValues);
            Module module = DjangoUtil.getDjangoModule(project);
            if (name != null && module != null && (templateFile = DjangoTemplateManager.getInstance(module).getTemplate(name)) instanceof DjangoTemplateFileImpl) {
                new DjangoTemplateVariablesMigrateProcessor(project, (DjangoTemplateFileImpl)templateFile).run();
            }
        }
    }

    @Nullable
    private static String getTemplateName(Map<String, PyExpression> argValues) {
        PyExpression expr = argValues.get("template_name");
        return expr != null ? PyStringLiteralUtil.getStringValue(expr.getText()) : null;
    }

    private static boolean shouldRenameVariablesInTemplate(String functionViewName, Map<String, PyExpression> argValues) {
        return OBJECT_LIST.equals(functionViewName) && argValues.containsKey("paginate_by");
    }

    private static void createSubClass(PsiFile file2, PyExpression expr, PyStatement urlPatternAssignment, Map<String, PyExpression> argValues) {
        PsiElement classElement = expr.getFirstChild().getFirstChild();
        String newClassName = "My" + classElement.getText();
        PyClass cls = DjangoClassViewMigrationIntention.generateClass(file2, expr, urlPatternAssignment, argValues, classElement, newClassName);
        DjangoClassViewMigrationIntention.runTemplateBuilder(classElement, newClassName, cls);
    }

    private static void runTemplateBuilder(PsiElement classElement, String newClassName, PyClass cls) {
        PsiElement parentScope = PsiTreeUtil.getParentOfType((PsiElement)cls, PyFile.class);
        TemplateBuilder templateBuilder = TemplateBuilderFactory.getInstance().createTemplateBuilder(parentScope);
        VariableNode node = new VariableNode("className", null);
        for (PsiElement el : PsiTreeUtil.collectElements((PsiElement)cls, element -> element.getNode().getElementType() == PyTokenTypes.IDENTIFIER && newClassName.equals(element.getText()))) {
            templateBuilder.replaceElement(el, (Expression)node);
        }
        templateBuilder.replaceElement(classElement.getFirstChild(), (Expression)node);
        templateBuilder.run();
    }

    private static PyClass generateClass(PsiFile file2, PyExpression expr, PyStatement urlPatternAssignment, Map<String, PyExpression> argValues, PsiElement classElement, String newClassName) {
        PyElementGenerator generator = PyElementGenerator.getInstance(expr.getProject());
        StringBuilder text2 = new StringBuilder();
        text2.append("class ").append(newClassName).append("(").append(classElement.getText()).append("):\n");
        if (argValues.containsKey(EXTRA__CONTEXT)) {
            text2.append(DjangoClassViewMigrationIntention.getContextDataFunction(argValues, newClassName));
        }
        if (argValues.containsKey(MIMETYPE)) {
            text2.append(DjangoClassViewMigrationIntention.getResponse(argValues, newClassName));
        }
        if (argValues.containsKey(CONTEXT__PROCESSORS)) {
            text2.append(DjangoClassViewMigrationIntention.getContextInstance(argValues));
        }
        text2.append("\n");
        PyClass cls = generator.createFromText(LanguageLevel.getDefault(), PyClass.class, text2.toString());
        cls = (PyClass)file2.addBefore((PsiElement)cls, (PsiElement)urlPatternAssignment);
        cls = (PyClass)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)cls);
        return cls;
    }

    private static String getContextDataFunction(Map<String, PyExpression> argValues, String newClassName) {
        StringBuilder content2 = new StringBuilder();
        content2.append("  def get_context_data(self, **kwargs):\n");
        content2.append("    context = super(").append(newClassName).append(", self).get_context_data(**kwargs)\n");
        content2.append("    context.update(").append(argValues.get(EXTRA__CONTEXT).getText()).append(")\n");
        content2.append("    return context\n");
        return content2.toString();
    }

    private static String getResponse(Map<String, PyExpression> argValues, String newClassName) {
        StringBuilder content2 = new StringBuilder();
        content2.append("  def get_response(self, content, **kwargs):\n");
        content2.append("    return super(").append(newClassName).append(", self).get_response(content, \n");
        content2.append("    content_type=").append(argValues.get(MIMETYPE).getText()).append(", **kwargs)\n");
        return content2.toString();
    }

    private static String getContextInstance(Map<String, PyExpression> argValues) {
        StringBuilder content2 = new StringBuilder();
        content2.append("  def get_context_instance(self, context):\n");
        content2.append("    return RequestContext(self.request, context, processors=[").append(argValues.get(CONTEXT__PROCESSORS).getText()).append("])\n");
        return content2.toString();
    }

    private static boolean shouldCreateSubClass(Map<String, PyExpression> argValues) {
        return argValues.containsKey(EXTRA__CONTEXT) || argValues.containsKey(MIMETYPE) || argValues.containsKey(CONTEXT__PROCESSORS);
    }

    private static void removeArgumentDict(PsiElement element) {
        PyDictLiteralExpression el = TemplateParametersEvaluator.getArgDict(element);
        if (el == null) {
            return;
        }
        ASTNode node = el.getNode();
        ASTNode parent = node.getTreeParent();
        boolean stop2 = false;
        while (!stop2 && node != null) {
            ASTNode toDel = node;
            node = node.getTreePrev();
            if (",".equals(toDel.getText())) {
                stop2 = true;
            }
            parent.removeChild(toDel);
        }
    }

    private static String argumentsToString(String className, Map<String, PyExpression> argValues) {
        StringBuilder builder = new StringBuilder("(");
        boolean flag = false;
        for (Map.Entry<String, PyExpression> arg : argValues.entrySet()) {
            String keyName = DjangoClassViewMigrationIntention.convertKeyName(className, arg.getKey());
            if (keyName == null) continue;
            if (flag) {
                builder.append(", ");
            }
            builder.append(keyName);
            builder.append("=");
            builder.append(DjangoClassViewMigrationIntention.convertValueText(className, arg.getKey(), arg.getValue().getText()));
            flag = true;
        }
        builder.append(")");
        return builder.toString();
    }

    private static String convertValueText(String className, String key, String value2) {
        if ("ListView".equals(className) && "template_object_name".equals(key)) {
            if (value2.endsWith("'")) {
                return value2.substring(0, value2.length() - 1) + "_list'";
            }
            return value2 + " + '_list'";
        }
        return value2;
    }

    @Nullable
    private static String convertKeyName(String className, String key) {
        if ("TemplateView".equals(className) && TEMPLATE.equals(key)) {
            return "template_name";
        }
        if ("DetailView".equals(className) && "object_id".equals(key)) {
            return "pk";
        }
        if ("template_object_name".equals(key)) {
            return "context_object_name";
        }
        if ("post_save_redirect".equals(key)) {
            return "success_url";
        }
        if (REMOVED_ARGS.contains(key)) {
            return null;
        }
        return key;
    }

    private static Map<String, PyExpression> getArgValues(PsiElement element) {
        PyDictLiteralExpression dict = TemplateParametersEvaluator.getArgDict(element);
        if (dict != null) {
            return PyUtil.dictValue(dict);
        }
        return Collections.emptyMap();
    }

    private static void addImport(PsiFile file2, String fullClassName) {
        String path = PythonStringUtil.removeLastSuffix(fullClassName, ".");
        AddImportHelper.addOrUpdateFromImportStatement(file2, path, DjangoClassViewMigrationIntention.getClassName(fullClassName), null, AddImportHelper.ImportPriority.THIRD_PARTY, null);
    }

    private static String getClassName(String classFullName) {
        return PythonStringUtil.getLastSuffix(classFullName, ".");
    }

    public boolean startInWriteAction() {
        return true;
    }

    static {
        DjangoClassViewMigrationIntention.putFun("django.views.generic.simple.direct_to_template", "django.views.generic.base.TemplateView");
        DjangoClassViewMigrationIntention.putFun("django.views.generic.simple.redirect_to", "django.views.generic.base.RedirectView");
        DjangoClassViewMigrationIntention.putFun(OBJECT_LIST, "django.views.generic.list.ListView");
        DjangoClassViewMigrationIntention.putFun("django.views.generic.list_detail.object_detail", "django.views.generic.detail.DetailView");
        DjangoClassViewMigrationIntention.putFun("django.views.generic.create_update.create_object", "django.views.generic.edit.CreateView");
        DjangoClassViewMigrationIntention.putFun("django.views.generic.create_update.update_object", "django.views.generic.edit.UpdateView");
        DjangoClassViewMigrationIntention.putFun("django.views.generic.create_update.delete_object", "django.views.generic.edit.DeleteView");
        DjangoClassViewMigrationIntention.putFun("django.views.generic.date_based.archive_index", "django.views.generic.dates.ArchiveIndexView");
        DjangoClassViewMigrationIntention.putFun("django.views.generic.date_based.archive_year", "django.views.generic.dates.YearArchiveView");
        DjangoClassViewMigrationIntention.putFun("django.views.generic.date_based.archive_month", "django.views.generic.dates.MonthArchiveView");
        DjangoClassViewMigrationIntention.putFun("django.views.generic.date_based.archive_week", "django.views.generic.dates.WeekArchiveView");
        DjangoClassViewMigrationIntention.putFun("django.views.generic.date_based.archive_day", "django.views.generic.dates.DayArchiveView");
        DjangoClassViewMigrationIntention.putFun("django.views.generic.date_based.archive_today", "django.views.generic.dates.TodayArchiveView");
        DjangoClassViewMigrationIntention.putFun("django.views.generic.date_based.object_detail", "django.views.generic.dates.DateDetailView");
        REMOVED_ARGS = Sets.newHashSet();
        REMOVED_ARGS.add(EXTRA__CONTEXT);
        REMOVED_ARGS.add(MIMETYPE);
        REMOVED_ARGS.add(CONTEXT__PROCESSORS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/ref/DjangoClassViewMigrationIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/ref/DjangoClassViewMigrationIntention";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentionState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renameVariablesInTemplate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doRenameVariablesInTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyCommandListener
    implements CommandListener {
        @NotNull
        private final Project myProject;
        @NotNull
        private final IntentionState myState;
        @NotNull
        private final Map<String, PyExpression> myArgValues;

        MyCommandListener(@NotNull Project project, @NotNull IntentionState state2, @NotNull Map<String, PyExpression> argValues) {
            if (project == null) {
                MyCommandListener.$$$reportNull$$$0(0);
            }
            if (state2 == null) {
                MyCommandListener.$$$reportNull$$$0(1);
            }
            if (argValues == null) {
                MyCommandListener.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myState = state2;
            this.myArgValues = argValues;
        }

        public void commandFinished(@NotNull CommandEvent event2) {
            if (event2 == null) {
                MyCommandListener.$$$reportNull$$$0(3);
            }
            if (DjangoClassViewMigrationIntention.INTENTION_NAME.equals(event2.getCommandName())) {
                DjangoClassViewMigrationIntention.renameVariablesInTemplate(this.myProject, this.myState, this.myArgValues);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argValues";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/django/ref/DjangoClassViewMigrationIntention$MyCommandListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "commandFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class IntentionState {
        PsiElement myElement = null;
        String myFuncViewName = null;
        String myFuncFullViewName = null;
        String myFullClassName = null;
        PyStatement myUrlsPatternAssignment = null;
        boolean myAvailable = false;

        private IntentionState() {
        }

        public boolean isAvailable() {
            return this.myAvailable;
        }
    }
}

