/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model.applications;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.django.DjangoFQNamesProvider;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.ref.DjangoItemReferenceSet;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.extensions.python.PyClassExtKt;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.psi.PsiQuery;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoAppConfigClassUtil {
    @NonNls
    private static final String DEFAULT_APP_CONFIG = "default_app_config";
    private static final PyRequirement MIN_APP_CFG_SPR_VER = DjangoUtil.createRequirementAtLeast(1, 7);
    private static final String APPLICATION_NAME_FIELD = "name";

    private DjangoAppConfigClassUtil() {
    }

    public static PsiReference[] getAppReferences(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(0);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        Boolean supportApplicationConfig = DjangoAppConfigClassUtil.supportApplicationConfig(module);
        if (supportApplicationConfig == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (supportApplicationConfig.booleanValue()) {
            return DjangoItemReferenceSet.createClassesReferenceSet(element).getAllReferences();
        }
        return DjangoAppConfigClassUtil.createPackageReferences(element);
    }

    static PsiReference @NotNull [] createPackageReferences(@NotNull PsiElement element) {
        if (element == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(1);
        }
        PsiReference[] psiReferenceArray = DjangoItemReferenceSet.createPackagesReferenceSet(element).getAllReferences();
        if (psiReferenceArray == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    @Nullable
    private static Boolean supportApplicationConfig(@NotNull Module module) {
        DjangoModelApi api;
        if (module == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(3);
        }
        if ((api = DjangoModelApi.create(module).getSuccessOrNull()) == null) {
            return null;
        }
        return api.isDjangoPackageMatches(MIN_APP_CFG_SPR_VER);
    }

    @Nullable
    public static String getApplicationNameByConfigClassName(@NotNull Module djangoModule, @NotNull String nameFromInstalledApps) {
        if (djangoModule == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(4);
        }
        if (nameFromInstalledApps == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(5);
        }
        return (String)ReadAction.compute(() -> DjangoAppConfigClassUtil.getApplicationNameByConfigClassNameInternal(djangoModule, nameFromInstalledApps));
    }

    @Nullable
    private static String getApplicationNameByConfigClassNameInternal(@NotNull Module djangoModule, @NotNull String nameFromInstalledApps) {
        if (djangoModule == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(6);
        }
        if (nameFromInstalledApps == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(7);
        }
        PyPsiUtils.assertValid(djangoModule);
        QualifiedName qNameFromInstalledApps = QualifiedName.fromDottedString((String)nameFromInstalledApps);
        Boolean supportApplicationConfig = DjangoAppConfigClassUtil.supportApplicationConfig(djangoModule);
        if (supportApplicationConfig == null || !supportApplicationConfig.booleanValue()) {
            return null;
        }
        PyClass appConfig = DjangoAppConfigClassUtil.getAppConfigClassFromQName(djangoModule, qNameFromInstalledApps);
        PyPsiUtils.assertValid((PsiElement)appConfig);
        if (appConfig == null) {
            return null;
        }
        if (!DjangoAppConfigClassUtil.isConfigClass(appConfig)) {
            return null;
        }
        PyTargetExpression nameExpression = appConfig.findClassAttribute(APPLICATION_NAME_FIELD, true, null);
        if (nameExpression == null) {
            return null;
        }
        PyPsiUtils.assertValid(nameExpression);
        PyExpression value2 = nameExpression.findAssignedValue();
        return PyEvaluator.evaluate(value2, String.class);
    }

    @Nullable
    private static PyClass getAppConfigClassFromQName(@NotNull Module djangoModule, @NotNull QualifiedName qNameFromInstalledApps) {
        PyFile file2;
        if (djangoModule == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(8);
        }
        if (qNameFromInstalledApps == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(9);
        }
        PyPsiUtils.assertValid(djangoModule);
        PyQualifiedNameResolveContext context = PyResolveImportUtil.fromModule(djangoModule);
        PyClass appConfig = PyUtil.as(PyResolveImportUtil.resolveTopLevelMember(qNameFromInstalledApps, context), PyClass.class);
        PyUtil.verboseOnly(() -> PyPsiUtils.assertValid((PsiElement)appConfig));
        if (appConfig != null) {
            return appConfig;
        }
        List<PsiElement> elements = PyResolveImportUtil.resolveQualifiedName(qNameFromInstalledApps, context);
        PsiElement element = !elements.isEmpty() ? elements.get(0) : null;
        PyUtil.verboseOnly(() -> PyPsiUtils.assertValid(element));
        if (element instanceof PyFile) {
            file2 = (PyFile)element;
        } else {
            PyFile pyFile = file2 = element instanceof PsiDirectory ? PyUtil.as(((PsiDirectory)element).findFile("__init__.py"), PyFile.class) : null;
        }
        if (file2 == null) {
            return null;
        }
        PyTargetExpression attribute = file2.findTopLevelAttribute(DEFAULT_APP_CONFIG);
        if (attribute == null) {
            return null;
        }
        String value2 = PyEvaluator.evaluate(attribute.findAssignedValue(), String.class);
        if (value2 == null) {
            return null;
        }
        PyClass result = PyUtil.as(PyResolveImportUtil.resolveTopLevelMember(QualifiedName.fromDottedString((String)value2), context), PyClass.class);
        PyUtil.verboseOnly(() -> PyPsiUtils.assertValid((PsiElement)result));
        return result;
    }

    private static boolean isConfigClass(@NotNull PyClass config) {
        if (config == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(10);
        }
        PyUtil.verboseOnly(() -> PyPsiUtils.assertValid((PsiElement)config));
        return PyClassExtKt.inherits(config, null, DjangoFQNamesProvider.APP_CONFIG);
    }

    static boolean isDjangoAppConfig(@NotNull PyTargetExpression attribute) {
        if (attribute == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(11);
        }
        if (!DEFAULT_APP_CONFIG.equals(attribute.getName())) {
            return false;
        }
        return new PsiQuery<PyTargetExpression>(attribute).ancestors(PyAssignmentStatement.class).filter(o -> o.getParent() instanceof PyFile).exists();
    }

    static boolean isNameAttribute(@NotNull PyTargetExpression attribute) {
        if (attribute == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(12);
        }
        PyClass aClass = attribute.getContainingClass();
        return APPLICATION_NAME_FIELD.equals(attribute.getName()) && aClass != null && DjangoAppConfigClassUtil.isConfigClass(aClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/applications/DjangoAppConfigClassUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoModule";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameFromInstalledApps";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qNameFromInstalledApps";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/applications/DjangoAppConfigClassUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackageReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAppReferences";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createPackageReferences";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "supportApplicationConfig";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getApplicationNameByConfigClassName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getApplicationNameByConfigClassNameInternal";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAppConfigClassFromQName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isConfigClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDjangoAppConfig";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isNameAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

