/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.ref;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.SyntheticFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.django.model.DjangoTemplateManager;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.templateLanguages.TemplateFileReference;
import com.jetbrains.python.templateLanguages.TemplateFileReferenceSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoStaticFileReferenceSet
extends TemplateFileReferenceSet {
    private static final String GET_STATIC_PREFIX = "get_static_prefix";
    private static final String GET_MEDIA_PREFIX = "get_media_prefix";
    private static final Set<String> PREFIXES = Sets.newHashSet((Object[])new String[]{"STATIC_URL", "MEDIA_URL", "get_static_prefix", "get_media_prefix"});
    private final String myPrefix;

    public DjangoStaticFileReferenceSet(String str, @NotNull PsiElement element) {
        if (element == null) {
            DjangoStaticFileReferenceSet.$$$reportNull$$$0(0);
        }
        this(str, "STATIC_URL", element, null);
    }

    public DjangoStaticFileReferenceSet(String str, String prefix, @NotNull PsiElement element, @Nullable PsiReferenceProvider provider) {
        if (element == null) {
            DjangoStaticFileReferenceSet.$$$reportNull$$$0(1);
        }
        super(str, element, provider);
        this.myPrefix = prefix;
    }

    @Override
    @Nullable
    protected PsiFileSystemItem getPsiDirectory(@NotNull Module module, @NotNull VirtualFile file2) {
        if (module == null) {
            DjangoStaticFileReferenceSet.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            DjangoStaticFileReferenceSet.$$$reportNull$$$0(3);
        }
        if (file2 instanceof DjangoTemplateManager.PrefixedVirtualDirectory) {
            DjangoTemplateManager.PrefixedVirtualDirectory prefixedDirectory = (DjangoTemplateManager.PrefixedVirtualDirectory)file2;
            PsiFileSystemItem item = super.getPsiDirectory(module, prefixedDirectory.getVirtualFile());
            if (!this.getPathString().startsWith(((DjangoTemplateManager.PrefixedVirtualDirectory)file2).getPrefix())) {
                return null;
            }
            List references2 = this.reparse(prefixedDirectory.getPrefix(), this.getStartInElement());
            if (!references2.isEmpty() && item != null) {
                return this.createPrefixSyntheticFileSystemItem(item, references2, prefixedDirectory.getPrefixElement());
            }
        }
        return super.getPsiDirectory(module, file2);
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        if (this.getPathString().startsWith(".")) {
            return new ArrayList<PsiFileSystemItem>();
        }
        Collection<PsiFileSystemItem> collection = super.computeDefaultContexts();
        if (collection == null) {
            DjangoStaticFileReferenceSet.$$$reportNull$$$0(4);
        }
        return collection;
    }

    private PsiFileSystemItem createPrefixSyntheticFileSystemItem(final @NotNull PsiFileSystemItem input, final @NotNull List<FileReference> references2, final @NotNull PyStringLiteralExpression navigationElement) {
        if (input == null) {
            DjangoStaticFileReferenceSet.$$$reportNull$$$0(5);
        }
        if (references2 == null) {
            DjangoStaticFileReferenceSet.$$$reportNull$$$0(6);
        }
        if (navigationElement == null) {
            DjangoStaticFileReferenceSet.$$$reportNull$$$0(7);
        }
        return new SyntheticFileSystemItem(input.getProject()){

            @Nullable
            public VirtualFile getVirtualFile() {
                return null;
            }

            public boolean processChildren(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2) {
                if (processor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return 1.processFileSystemItem(processor2, (PsiFileSystemItem)new DjangoStaticPrefix(input, (PsiFileSystemItem)this, references2, navigationElement));
            }

            public PsiFileSystemItem getParent() {
                return null;
            }

            @NotNull
            public String getName() {
                return "<wrapped DjangoStaticPrefix>";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/django/lang/template/ref/DjangoStaticFileReferenceSet$1", "processChildren"));
            }
        };
    }

    public static boolean isUrlPrefix(String prefix) {
        if (StringUtil.isEmpty((String)prefix)) {
            return false;
        }
        prefix = prefix.trim();
        return PREFIXES.contains(prefix);
    }

    @Override
    @NotNull
    protected List<VirtualFile> getRoots(@NotNull Module module) {
        String prefix;
        if (module == null) {
            DjangoStaticFileReferenceSet.$$$reportNull$$$0(8);
        }
        if ("STATIC_URL".equals(prefix = this.myPrefix.trim()) || GET_STATIC_PREFIX.equals(prefix)) {
            List<VirtualFile> list = DjangoTemplateManager.getInstance(module).getStaticFolderList();
            if (list == null) {
                DjangoStaticFileReferenceSet.$$$reportNull$$$0(9);
            }
            return list;
        }
        if ("MEDIA_URL".equals(prefix) || GET_MEDIA_PREFIX.equals(prefix)) {
            List<VirtualFile> list = DjangoTemplateManager.getInstance(module).getMediaFolderList();
            if (list == null) {
                DjangoStaticFileReferenceSet.$$$reportNull$$$0(10);
            }
            return list;
        }
        ArrayList arrayList = Lists.newArrayList();
        if (arrayList == null) {
            DjangoStaticFileReferenceSet.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    protected final boolean isSoft() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        if (module == null) {
            return true;
        }
        return DjangoTemplateManager.getInstance(module).isStaticFilesDirUnresolved();
    }

    @Override
    public FileReference createFileReference(TextRange range, int index, String text2) {
        return new DjangoStaticFileReference(this, range, index, text2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/lang/template/ref/DjangoStaticFileReferenceSet";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/lang/template/ref/DjangoStaticFileReferenceSet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPsiDirectory";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPrefixSyntheticFileSystemItem";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DjangoStaticFileReference
    extends TemplateFileReference {
        public DjangoStaticFileReference(@NotNull TemplateFileReferenceSet fileReferenceSet, TextRange range, int index, String text2) {
            if (fileReferenceSet == null) {
                DjangoStaticFileReference.$$$reportNull$$$0(0);
            }
            super(fileReferenceSet, range, index, text2);
        }

        @Override
        @Nullable
        public String getUnresolvedDescription() {
            return "Static file '" + this.getCanonicalText() + "' not found";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileReferenceSet", "com/jetbrains/django/lang/template/ref/DjangoStaticFileReferenceSet$DjangoStaticFileReference", "<init>"));
        }
    }

    public static class DjangoStaticPrefix
    extends SyntheticFileSystemItem {
        private final PsiFileSystemItem myRoot;
        private final PsiFileSystemItem myParent;
        private final List<FileReference> myReferences;
        private final String myName;
        private final PyStringLiteralExpression myNavigationElement;

        private DjangoStaticPrefix(PsiFileSystemItem root, PsiFileSystemItem parent, List<FileReference> references2, PyStringLiteralExpression element) {
            super(root.getProject());
            this.myRoot = root;
            this.myParent = parent;
            this.myReferences = references2;
            this.myName = references2.get(0).getText();
            this.myNavigationElement = element;
        }

        public boolean isValid() {
            return true;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PyStringLiteralExpression pyStringLiteralExpression = this.myNavigationElement;
            if (pyStringLiteralExpression == null) {
                DjangoStaticPrefix.$$$reportNull$$$0(0);
            }
            return pyStringLiteralExpression;
        }

        public boolean isDirectory() {
            return true;
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            if (this.myReferences.size() > 1) {
                return null;
            }
            return this.myRoot.getVirtualFile();
        }

        public boolean processChildren(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2) {
            if (processor2 == null) {
                DjangoStaticPrefix.$$$reportNull$$$0(1);
            }
            if (this.myReferences.size() > 1) {
                ArrayList list = Lists.newArrayList(this.myReferences);
                list.remove(0);
                return DjangoStaticPrefix.processFileSystemItem(processor2, (PsiFileSystemItem)new DjangoStaticPrefix(this.myRoot, (PsiFileSystemItem)this, list, this.myNavigationElement));
            }
            return this.myRoot.processChildren(processor2);
        }

        public PsiFileSystemItem getParent() {
            return this.myParent;
        }

        public String getText() {
            return this.myName;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                DjangoStaticPrefix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
            if (name == null) {
                DjangoStaticPrefix.$$$reportNull$$$0(3);
            }
            return this.myNavigationElement.replace(PyElementGenerator.getInstance(this.getProject()).createStringLiteral(this.myNavigationElement, name));
        }

        public void checkSetName(String name) throws IncorrectOperationException {
        }

        public boolean isEquivalentTo(PsiElement another) {
            if (another instanceof DjangoStaticPrefix) {
                return another.getNavigationElement().equals(this.getNavigationElement());
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/django/lang/template/ref/DjangoStaticFileReferenceSet$DjangoStaticPrefix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/django/lang/template/ref/DjangoStaticFileReferenceSet$DjangoStaticPrefix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "processChildren";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

